/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.pmml.Function;

public class BuiltInString
extends Function {
    private static final long serialVersionUID = -7391516909331728653L;
    protected StringFunc m_func;
    protected Attribute m_outputDef = null;

    BuiltInString(StringFunc func) {
        this.m_func = func;
        this.m_functionName = this.m_func.toString();
    }

    @Override
    public Attribute getOutputDef() {
        if (this.m_outputDef == null) {
            if (this.m_func == StringFunc.SUBSTRING) {
                this.m_outputDef = new Attribute("BuiltInStringResult:substring", (List<String>)null);
            }
            Attribute inputVals = (Attribute)this.m_parameterDefs.get(0);
            ArrayList<String> newVals = new ArrayList<String>();
            for (int i2 = 0; i2 < inputVals.numValues(); ++i2) {
                String inVal = inputVals.value(i2);
                newVals.add(this.m_func.eval(new Object[]{inVal}));
            }
            this.m_outputDef = new Attribute("BuiltInStringResult:" + this.m_func.toString(), newVals);
        }
        return this.m_outputDef;
    }

    @Override
    public String[] getParameterNames() {
        return this.m_func.getParameterNames();
    }

    private Object[] setUpArgs(double[] incoming) {
        Object[] args = new Object[incoming.length];
        Attribute input = (Attribute)this.m_parameterDefs.get(0);
        args[0] = input.value((int)incoming[0]);
        for (int i2 = 1; i2 < incoming.length; ++i2) {
            args[i2] = new Integer((int)incoming[i2]);
        }
        return args;
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[BuiltInString] incoming parameter structure has not been set");
        }
        if (!this.m_func.legalNumParams(incoming.length)) {
            throw new Exception("[BuiltInString] wrong number of parameters!");
        }
        Object[] args = this.setUpArgs(incoming);
        String result = this.m_func.eval(args);
        int resultI = this.m_outputDef.indexOfValue(result);
        if (resultI < 0) {
            if (this.m_outputDef.isString()) {
                resultI = this.m_outputDef.addStringValue(result);
            } else {
                throw new Exception("[BuiltInString] unable to find value " + result + " in nominal result type!");
            }
        }
        return resultI;
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> paramDefs) throws Exception {
        this.m_parameterDefs = paramDefs;
        if (!this.m_func.legalNumParams(this.m_parameterDefs.size())) {
            throw new Exception("[BuiltInMath] illegal number of parameters for function: " + this.m_functionName);
        }
    }

    @Override
    public String toString() {
        String result = this.m_func.toString() + "(";
        for (int i2 = 0; i2 < this.m_parameterDefs.size(); ++i2) {
            result = result + ((Attribute)this.m_parameterDefs.get(i2)).name();
            result = i2 != this.m_parameterDefs.size() - 1 ? result + ", " : result + ")";
        }
        return result;
    }

    static enum StringFunc {
        UPPERCASE("uppercase"){

            @Override
            String eval(Object[] args) {
                return ((String)args[0]).toUpperCase();
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"input"};
            }
        }
        ,
        SUBSTRING("substring"){

            @Override
            String eval(Object[] args) {
                String input = (String)args[0];
                int startPos = (Integer)args[1];
                int length = (Integer)args[2];
                return input.substring(startPos - 1, startPos + length);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 3;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"input", "startPos", "length"};
            }
        }
        ,
        TRIMBLANKS("trimBlanks"){

            @Override
            String eval(Object[] args) {
                return ((String)args[0]).trim();
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"input"};
            }
        };

        private String m_stringVal;

        abstract String eval(Object[] var1);

        abstract boolean legalNumParams(int var1);

        abstract String[] getParameterNames();

        private StringFunc(String funcName) {
            this.m_stringVal = funcName;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

