/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Utils;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

public class Discretize
extends Expression {
    private static final long serialVersionUID = -5809107997906180082L;
    protected String m_fieldName;
    protected int m_fieldIndex;
    protected boolean m_mapMissingDefined = false;
    protected String m_mapMissingTo;
    protected boolean m_defaultValueDefined = false;
    protected String m_defaultValue;
    protected ArrayList<DiscretizeBin> m_bins = new ArrayList();
    protected Attribute m_outputDef;

    public Discretize(Element discretize, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs) throws Exception {
        super(opType, fieldDefs);
        this.m_fieldName = discretize.getAttribute("field");
        this.m_mapMissingTo = discretize.getAttribute("mapMissingTo");
        if (this.m_mapMissingTo != null && this.m_mapMissingTo.length() > 0) {
            this.m_mapMissingDefined = true;
        }
        this.m_defaultValue = discretize.getAttribute("defaultValue");
        if (this.m_defaultValue != null && this.m_defaultValue.length() > 0) {
            this.m_defaultValueDefined = true;
        }
        NodeList dbL = discretize.getElementsByTagName("DiscretizeBin");
        for (int i2 = 0; i2 < dbL.getLength(); ++i2) {
            Node dbN = dbL.item(i2);
            if (dbN.getNodeType() != 1) continue;
            Element dbE = (Element)dbN;
            DiscretizeBin db = new DiscretizeBin(dbE, this.m_opType);
            this.m_bins.add(db);
        }
        if (fieldDefs != null) {
            this.setUpField();
        }
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        super.setFieldDefs(fieldDefs);
        this.setUpField();
    }

    private void setUpField() throws Exception {
        this.m_fieldIndex = -1;
        if (this.m_fieldDefs != null) {
            this.m_fieldIndex = this.getFieldDefIndex(this.m_fieldName);
            if (this.m_fieldIndex < 0) {
                throw new Exception("[Discretize] Can't find field " + this.m_fieldName + " in the supplied field definitions.");
            }
            Attribute field = (Attribute)this.m_fieldDefs.get(this.m_fieldIndex);
            if (!field.isNumeric()) {
                throw new Exception("[Discretize] reference field " + this.m_fieldName + " must be continuous.");
            }
        }
        Attribute tempAtt = null;
        boolean categorical = false;
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS || this.m_opType == FieldMetaInfo.Optype.ORDINAL) {
            for (DiscretizeBin d : this.m_bins) {
                if (!Utils.isMissingValue(d.getBinValueNumeric())) continue;
                categorical = true;
                break;
            }
        } else {
            categorical = true;
        }
        Attribute attribute = tempAtt = categorical ? new Attribute("temp", (List<String>)null) : new Attribute(this.m_fieldName + "_discretized(optype=continuous)");
        if (categorical) {
            for (DiscretizeBin d : this.m_bins) {
                tempAtt.addStringValue(d.getBinValue());
            }
            if (this.m_defaultValueDefined) {
                tempAtt.addStringValue(this.m_defaultValue);
            }
            if (this.m_mapMissingDefined) {
                tempAtt.addStringValue(this.m_mapMissingTo);
            }
            ArrayList<String> values = new ArrayList<String>();
            for (int i2 = 0; i2 < tempAtt.numValues(); ++i2) {
                values.add(tempAtt.value(i2));
            }
            this.m_outputDef = new Attribute(this.m_fieldName + "_discretized", values);
        } else {
            this.m_outputDef = tempAtt;
        }
    }

    @Override
    protected Attribute getOutputDef() {
        if (this.m_outputDef == null) {
            return this.m_opType == FieldMetaInfo.Optype.CATEGORICAL || this.m_opType == FieldMetaInfo.Optype.ORDINAL ? new Attribute(this.m_fieldName + "_discretized", new ArrayList<String>()) : new Attribute(this.m_fieldName + "_discretized(optype=continuous)");
        }
        return this.m_outputDef;
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        double result = Utils.missingValue();
        double value = incoming[this.m_fieldIndex];
        if (Utils.isMissingValue(value)) {
            if (this.m_mapMissingDefined) {
                if (this.m_outputDef.isNominal()) {
                    result = this.m_outputDef.indexOfValue(this.m_mapMissingTo);
                } else {
                    try {
                        result = Double.parseDouble(this.m_mapMissingTo);
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("[Discretize] Optype is continuous but value of mapMissingTo can not be parsed as a number!");
                    }
                }
            }
        } else {
            boolean found = false;
            for (DiscretizeBin b : this.m_bins) {
                if (!b.containsValue(value)) continue;
                found = true;
                if (this.m_outputDef.isNominal()) {
                    result = this.m_outputDef.indexOfValue(b.getBinValue());
                    break;
                }
                result = b.getBinValueNumeric();
                break;
            }
            if (!found && this.m_defaultValueDefined) {
                if (this.m_outputDef.isNominal()) {
                    result = this.m_outputDef.indexOfValue(this.m_defaultValue);
                } else {
                    try {
                        result = Double.parseDouble(this.m_defaultValue);
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("[Discretize] Optype is continuous but value of default value can not be parsed as a number!");
                    }
                }
            }
        }
        return result;
    }

    @Override
    public String getResultCategorical(double[] incoming) throws Exception {
        double index = this.getResult(incoming);
        if (Utils.isMissingValue(index)) {
            return "**Missing Value**";
        }
        return this.m_outputDef.value((int)index);
    }

    @Override
    public String toString(String pad) {
        StringBuffer buff = new StringBuffer();
        buff.append(pad + "Discretize (" + this.m_fieldName + "):");
        for (DiscretizeBin d : this.m_bins) {
            buff.append("\n" + pad + d.toString());
        }
        if (this.m_outputDef.isNumeric()) {
            buff.append("\n" + pad + "(bin values interpreted as numbers)");
        }
        if (this.m_mapMissingDefined) {
            buff.append("\n" + pad + "map missing values to: " + this.m_mapMissingTo);
        }
        if (this.m_defaultValueDefined) {
            buff.append("\n" + pad + "default value: " + this.m_defaultValue);
        }
        return buff.toString();
    }

    protected class DiscretizeBin
    implements Serializable {
        private static final long serialVersionUID = 5810063243316808400L;
        private final ArrayList<FieldMetaInfo.Interval> m_intervals = new ArrayList();
        private final String m_binValue;
        private double m_numericBinValue = Utils.missingValue();

        protected DiscretizeBin(Element bin, FieldMetaInfo.Optype opType) throws Exception {
            NodeList iL = bin.getElementsByTagName("Interval");
            for (int i2 = 0; i2 < iL.getLength(); ++i2) {
                Node iN = iL.item(i2);
                if (iN.getNodeType() != 1) continue;
                FieldMetaInfo.Interval tempInterval = new FieldMetaInfo.Interval((Element)iN);
                this.m_intervals.add(tempInterval);
            }
            this.m_binValue = bin.getAttribute("binValue");
            if (opType == FieldMetaInfo.Optype.CONTINUOUS || opType == FieldMetaInfo.Optype.ORDINAL) {
                try {
                    this.m_numericBinValue = Double.parseDouble(this.m_binValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        protected String getBinValue() {
            return this.m_binValue;
        }

        protected double getBinValueNumeric() {
            return this.m_numericBinValue;
        }

        protected boolean containsValue(double value) {
            boolean result = false;
            for (FieldMetaInfo.Interval i2 : this.m_intervals) {
                if (!i2.containsValue(value)) continue;
                result = true;
                break;
            }
            return result;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("\"" + this.m_binValue + "\" if value in: ");
            boolean first = true;
            for (FieldMetaInfo.Interval i2 : this.m_intervals) {
                if (!first) {
                    buff.append(", ");
                } else {
                    first = false;
                }
                buff.append(i2.toString());
            }
            return buff.toString();
        }
    }
}

