/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.net.BayesNetGenerator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;

public class BayesNet
extends ClassificationGenerator {
    static final long serialVersionUID = -796118162379901512L;
    protected BayesNetGenerator m_Generator;

    public BayesNet() {
        this.setNumAttributes(this.defaultNumAttributes());
        this.setNumArcs(this.defaultNumArcs());
        this.setCardinality(this.defaultCardinality());
    }

    public String globalInfo() {
        return "Generates random instances based on a Bayes network.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = this.enumToVector(super.listOptions());
        result.add(new Option("\tThe number of arcs to use. (default " + this.defaultNumArcs() + ")", "A", 1, "-A <num>"));
        result.add(new Option("\tThe number of attributes to generate. (default " + this.defaultNumAttributes() + ")", "N", 1, "-N <num>"));
        result.add(new Option("\tThe cardinality of the attributes and the class. (default " + this.defaultCardinality() + ")", "C", 1, "-C <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        Vector<String> list = new Vector<String>();
        list.add("-N");
        String tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            list.add(tmpStr);
        } else {
            list.add("" + this.defaultNumAttributes());
        }
        list.add("-M");
        list.add("" + this.getNumExamples());
        list.add("-S");
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            list.add(tmpStr);
        } else {
            list.add("" + this.defaultSeed());
        }
        list.add("-A");
        tmpStr = Utils.getOption('A', options);
        if (tmpStr.length() != 0) {
            list.add(tmpStr);
        } else {
            list.add("" + this.defaultNumArcs());
        }
        list.add("-C");
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            list.add(tmpStr);
        } else {
            list.add("" + this.defaultCardinality());
        }
        this.setGeneratorOptions(list);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = this.removeBlacklist(super.getOptions());
        Collections.addAll(result, options);
        options = this.getGenerator().getOptions();
        result.add("-N");
        result.add("" + this.getNumAttributes());
        result.add("-S");
        result.add("" + this.getSeed());
        try {
            result.add("-A");
            result.add(Utils.getOption('A', options));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            result.add("-C");
            result.add(Utils.getOption('C', options));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toArray(new String[result.size()]);
    }

    protected void setGeneratorOptions(BayesNetGenerator generator, Vector<String> options) {
        try {
            generator.setOptions(options.toArray(new String[options.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BayesNetGenerator getGenerator() {
        if (this.m_Generator == null) {
            this.m_Generator = new BayesNetGenerator();
        }
        return this.m_Generator;
    }

    protected void setGeneratorOptions(Vector<String> options) {
        this.setGeneratorOptions(this.getGenerator(), options);
    }

    protected void setGeneratorOption(BayesNetGenerator generator, String option, String value) {
        try {
            String[] options = generator.getOptions();
            Utils.getOption(option, options);
            Vector<String> list = new Vector<String>();
            for (int i2 = 0; i2 < options.length; ++i2) {
                if (options[i2].length() == 0) continue;
                list.add(options[i2]);
            }
            list.add("-" + option);
            list.add(value);
            this.setGeneratorOptions(generator, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setGeneratorOption(String option, String value) {
        this.setGeneratorOption(this.getGenerator(), option, value);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int numAttributes) {
        this.setGeneratorOption("N", "" + numAttributes);
    }

    public int getNumAttributes() {
        int result = -1;
        try {
            result = Integer.parseInt(Utils.getOption('N', this.getGenerator().getOptions()));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        return result;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain (including class attribute), ie the number of nodes in the bayesian net.";
    }

    protected int defaultCardinality() {
        return 2;
    }

    public void setCardinality(int value) {
        this.setGeneratorOption("C", "" + value);
    }

    public int getCardinality() {
        int result = -1;
        try {
            result = Integer.parseInt(Utils.getOption('C', this.getGenerator().getOptions()));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        return result;
    }

    public String cardinalityTipText() {
        return "The cardinality of the attributes, incl the class attribute.";
    }

    protected int defaultNumArcs() {
        return 20;
    }

    public void setNumArcs(int value) {
        int nodes = this.getNumAttributes();
        int minArcs = nodes - 1;
        int maxArcs = nodes * (nodes - 1) / 2;
        if (value > maxArcs) {
            throw new IllegalArgumentException("Number of arcs should be at most nodes * (nodes - 1) / 2 = " + maxArcs + " instead of " + value + " (nodes = numAttributes)!");
        }
        if (value < minArcs) {
            throw new IllegalArgumentException("Number of arcs should be at least (nodes - 1) = " + minArcs + " instead of " + value + " (nodes = numAttributes)!");
        }
        this.setGeneratorOption("A", "" + value);
    }

    public int getNumArcs() {
        int result = -1;
        try {
            result = Integer.parseInt(Utils.getOption('A', this.getGenerator().getOptions()));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        return result;
    }

    public String numArcsTipText() {
        return "The number of arcs in the bayesian net, at most: n * (n - 1) / 2 and at least: (n - 1); with n = numAttributes";
    }

    @Override
    public void setNumExamples(int numExamples) {
        super.setNumExamples(numExamples);
        this.setGeneratorOption("M", "" + numExamples);
    }

    @Override
    public int getNumExamples() {
        int result = -1;
        try {
            result = Integer.parseInt(Utils.getOption('M', this.getGenerator().getOptions()));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        return result;
    }

    @Override
    public int getSeed() {
        int result = -1;
        try {
            result = Integer.parseInt(Utils.getOption('S', this.getGenerator().getOptions()));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        return result;
    }

    @Override
    public void setSeed(int newSeed) {
        super.setSeed(newSeed);
        this.setGeneratorOption("S", "" + newSeed);
    }

    @Override
    public boolean getSingleModeFlag() throws Exception {
        return false;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        BayesNetGenerator bng = new BayesNetGenerator();
        bng.setOptions(this.getGenerator().getOptions());
        this.setGeneratorOption(bng, "M", "1");
        bng.generateRandomNetwork();
        bng.generateInstances();
        bng.m_Instances.renameAttribute(0, "class");
        bng.m_Instances.setRelationName(this.getRelationNameToUse());
        return bng.m_Instances;
    }

    @Override
    public Instance generateExample() throws Exception {
        throw new Exception("Cannot generate examples one-by-one!");
    }

    @Override
    public Instances generateExamples() throws Exception {
        this.getGenerator().setOptions(this.getGenerator().getOptions());
        this.getGenerator().generateRandomNetwork();
        this.getGenerator().generateInstances();
        this.getGenerator().m_Instances.renameAttribute(0, "class");
        this.getGenerator().m_Instances.setRelationName(this.getRelationNameToUse());
        return this.getGenerator().m_Instances;
    }

    @Override
    public String generateStart() {
        return "";
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11753 $");
    }

    public static void main(String[] args) {
        BayesNet.runDataGenerator(new BayesNet(), args);
    }
}

