/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Tag;
import weka.core.Utils;
import weka.datagenerators.ClusterDefinition;
import weka.datagenerators.ClusterGenerator;
import weka.datagenerators.clusterers.SubspaceClusterDefinition;

public class SubspaceCluster
extends ClusterGenerator {
    static final long serialVersionUID = -3454999858505621128L;
    protected double m_NoiseRate;
    protected ClusterDefinition[] m_Clusters;
    protected int[] m_numValues;
    public static final int UNIFORM_RANDOM = 0;
    public static final int TOTAL_UNIFORM = 1;
    public static final int GAUSSIAN = 2;
    public static final Tag[] TAGS_CLUSTERTYPE = new Tag[]{new Tag(0, "uniform/random"), new Tag(1, "total uniform"), new Tag(2, "gaussian")};
    public static final int CONTINUOUS = 0;
    public static final int INTEGER = 1;
    public static final Tag[] TAGS_CLUSTERSUBTYPE = new Tag[]{new Tag(0, "continuous"), new Tag(1, "integer")};

    public SubspaceCluster() {
        this.setNoiseRate(this.defaultNoiseRate());
    }

    public String globalInfo() {
        return "A data generator that produces data points in hyperrectangular subspace clusters.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe noise rate in percent (default " + this.defaultNoiseRate() + ").\n\tCan be between 0% and 30%. (Remark: The original \n\talgorithm only allows noise up to 10%.)", "P", 1, "-P <num>"));
        result.addElement(new Option("\tA cluster definition of class '" + SubspaceClusterDefinition.class.getName().replaceAll(".*\\.", "") + "'\n\t(definition needs to be quoted to be recognized as \n\ta single argument).", "C", 1, "-C <cluster-definition>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to " + SubspaceClusterDefinition.class.getName() + ":"));
        result.addAll(this.enumToVector(new SubspaceClusterDefinition(this).listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.m_numValues = new int[this.getNumAttributes()];
        for (int i2 = 0; i2 < this.getNumAttributes(); ++i2) {
            this.m_numValues[i2] = 1;
        }
        String tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setNoiseRate(Double.parseDouble(tmpStr));
        } else {
            this.setNoiseRate(this.defaultNoiseRate());
        }
        Vector<SubspaceClusterDefinition> list = new Vector<SubspaceClusterDefinition>();
        do {
            if ((tmpStr = Utils.getOption('C', options)).length() == 0) continue;
            SubspaceClusterDefinition cl = new SubspaceClusterDefinition(this);
            cl.setOptions(Utils.splitOptions(tmpStr));
            list.add(cl);
        } while (tmpStr.length() != 0);
        this.m_Clusters = list.toArray(new ClusterDefinition[list.size()]);
        this.getClusters();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        result.add("-P");
        result.add("" + this.getNoiseRate());
        for (int i2 = 0; i2 < this.getClusters().length; ++i2) {
            result.add("-C");
            result.add(Utils.joinOptions(this.getClusters()[i2].getOptions()));
        }
        return result.toArray(new String[result.size()]);
    }

    protected ClusterDefinition[] getClusters() {
        if (this.m_Clusters == null || this.m_Clusters.length == 0) {
            if (this.m_Clusters != null) {
                System.out.println("NOTE: at least 1 cluster definition is necessary, created default one.");
            }
            this.m_Clusters = new ClusterDefinition[]{new SubspaceClusterDefinition(this)};
        }
        return this.m_Clusters;
    }

    @Override
    protected int defaultNumAttributes() {
        return 1;
    }

    @Override
    public void setNumAttributes(int numAttributes) {
        super.setNumAttributes(numAttributes);
        this.m_numValues = new int[this.getNumAttributes()];
    }

    @Override
    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain (Note: they must be covered by the cluster definitions!)";
    }

    protected double defaultNoiseRate() {
        return 0.0;
    }

    public double getNoiseRate() {
        return this.m_NoiseRate;
    }

    public void setNoiseRate(double newNoiseRate) {
        this.m_NoiseRate = newNoiseRate;
    }

    public String noiseRateTipText() {
        return "The noise rate to use.";
    }

    public ClusterDefinition[] getClusterDefinitions() {
        return this.getClusters();
    }

    public void setClusterDefinitions(ClusterDefinition[] value) throws Exception {
        String indexStr = "";
        this.m_Clusters = value;
        for (int i2 = 0; i2 < this.getClusters().length; ++i2) {
            if (!(this.getClusters()[i2] instanceof SubspaceClusterDefinition)) {
                if (indexStr.length() != 0) {
                    indexStr = indexStr + ",";
                }
                indexStr = indexStr + "" + (i2 + 1);
            }
            this.getClusters()[i2].setParent(this);
            this.getClusters()[i2].setOptions(this.getClusters()[i2].getOptions());
        }
        if (indexStr.length() != 0) {
            throw new Exception("These cluster definitions are not '" + SubspaceClusterDefinition.class.getName() + "': " + indexStr);
        }
    }

    public String clusterDefinitionsTipText() {
        return "The clusters to use.";
    }

    protected boolean checkCoverage() {
        int i2;
        int[] count = new int[this.getNumAttributes()];
        for (i2 = 0; i2 < this.getNumAttributes(); ++i2) {
            if (this.m_nominalCols.isInRange(i2)) {
                int n = i2;
                count[n] = count[n] + 1;
            }
            if (this.m_booleanCols.isInRange(i2)) {
                int n = i2;
                count[n] = count[n] + 1;
            }
            for (int n = 0; n < this.getClusters().length; ++n) {
                SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[n];
                Range r = new Range(cl.getAttrIndexRange());
                r.setUpper(this.getNumAttributes());
                if (!r.isInRange(i2)) continue;
                int n2 = i2;
                count[n2] = count[n2] + 1;
            }
        }
        String attrIndex = "";
        for (i2 = 0; i2 < count.length; ++i2) {
            if (count[i2] != 0) continue;
            if (attrIndex.length() != 0) {
                attrIndex = attrIndex + ",";
            }
            attrIndex = attrIndex + (i2 + 1);
        }
        if (attrIndex.length() != 0) {
            throw new IllegalArgumentException("The following attributes are not covered by a cluster definition: " + attrIndex + "\n");
        }
        return true;
    }

    @Override
    public boolean getSingleModeFlag() {
        return false;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        Attribute attribute;
        int i2;
        this.setOptions(this.getOptions());
        this.checkCoverage();
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
        boolean classFlag = this.getClassFlag();
        ArrayList<String> classValues = null;
        if (classFlag) {
            classValues = new ArrayList<String>(this.getClusters().length);
        }
        ArrayList<String> boolValues = new ArrayList<String>(2);
        boolValues.add("false");
        boolValues.add("true");
        ArrayList<String> nomValues = null;
        for (i2 = 0; i2 < this.getNumAttributes(); ++i2) {
            if (this.m_booleanCols.isInRange(i2)) {
                attribute = new Attribute("B" + i2, boolValues);
            } else if (this.m_nominalCols.isInRange(i2)) {
                nomValues = new ArrayList<String>(this.m_numValues[i2]);
                for (int j = 0; j < this.m_numValues[i2]; ++j) {
                    nomValues.add("value-" + j);
                }
                attribute = new Attribute("N" + i2, nomValues);
            } else {
                attribute = new Attribute("X" + i2);
            }
            attributes.add(attribute);
        }
        if (classFlag) {
            for (i2 = 0; i2 < this.getClusters().length; ++i2) {
                classValues.add("c" + i2);
            }
            attribute = new Attribute("class", classValues);
            attributes.add(attribute);
        }
        Instances dataset = new Instances(this.getRelationNameToUse(), attributes, 0);
        if (classFlag) {
            dataset.setClassIndex(this.m_NumAttributes);
        }
        Instances format = new Instances(dataset, 0);
        this.setDatasetFormat(format);
        for (int i3 = 0; i3 < this.getClusters().length; ++i3) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[i3];
            cl.setNumInstances(random);
            cl.setParent(this);
        }
        return dataset;
    }

    public boolean isBoolean(int index) {
        return this.m_booleanCols.isInRange(index);
    }

    public boolean isNominal(int index) {
        return this.m_nominalCols.isInRange(index);
    }

    public int[] getNumValues() {
        return this.m_numValues;
    }

    @Override
    public Instance generateExample() throws Exception {
        throw new Exception("Examples cannot be generated one by one.");
    }

    @Override
    public Instances generateExamples() throws Exception {
        Instances format = this.getDatasetFormat();
        Instance example = null;
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        block5: for (int cNum = 0; cNum < this.getClusters().length; ++cNum) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[cNum];
            int instNum = cl.getNumInstances();
            String cName = "c" + cNum;
            switch (cl.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    for (int i2 = 0; i2 < instNum; ++i2) {
                        example = this.generateExample(format, this.getRandom(), cl, cName);
                        if (example == null) continue;
                        format.add(example);
                    }
                    continue block5;
                }
                case 1: {
                    if (!cl.isInteger()) {
                        this.generateUniformExamples(format, instNum, cl, cName);
                        continue block5;
                    }
                    this.generateUniformIntegerExamples(format, instNum, cl, cName);
                    continue block5;
                }
                case 2: {
                    this.generateGaussianExamples(format, instNum, this.getRandom(), cl, cName);
                }
            }
        }
        return format;
    }

    private Instance generateExample(Instances format, Random randomG, SubspaceClusterDefinition cl, String cName) {
        boolean makeInteger = cl.isInteger();
        int num = -1;
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        double[] values = new double[numAtts];
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        int clusterI = -1;
        for (int i2 = 0; i2 < this.m_NumAttributes; ++i2) {
            if (attributes[i2]) {
                double value;
                ++clusterI;
                ++num;
                if (this.isBoolean(i2) || this.isNominal(i2)) {
                    if (minValue[clusterI] == maxValue[clusterI]) {
                        value = minValue[clusterI];
                    } else {
                        int numValues = (int)(maxValue[clusterI] - minValue[clusterI] + 1.0);
                        value = randomG.nextInt(numValues);
                        value += minValue[clusterI];
                    }
                } else {
                    value = randomG.nextDouble() * (maxValue[num] - minValue[num]) + minValue[num];
                    if (makeInteger) {
                        value = Math.round(value);
                    }
                }
                values[i2] = value;
                continue;
            }
            values[i2] = Utils.missingValue();
        }
        if (this.getClassFlag()) {
            values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
        }
        DenseInstance example = new DenseInstance(1.0, values);
        example.setDataset(format);
        return example;
    }

    private void generateUniformExamples(Instances format, int numInstances, SubspaceClusterDefinition cl, String cName) {
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        double[] diff = new double[minValue.length];
        for (int i2 = 0; i2 < minValue.length; ++i2) {
            diff[i2] = maxValue[i2] - minValue[i2];
        }
        for (int j = 0; j < numInstances; ++j) {
            double[] values = new double[numAtts];
            int num = -1;
            for (int i3 = 0; i3 < this.m_NumAttributes; ++i3) {
                double value;
                values[i3] = attributes[i3] ? (value = minValue[++num] + diff[num] * ((double)j / (double)(numInstances - 1))) : Utils.missingValue();
            }
            if (this.getClassFlag()) {
                values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
            }
            DenseInstance example = new DenseInstance(1.0, values);
            example.setDataset(format);
            format.add(example);
        }
    }

    private void generateUniformIntegerExamples(Instances format, int numInstances, SubspaceClusterDefinition cl, String cName) {
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        double[] values = new double[numAtts];
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        int[] minInt = new int[minValue.length];
        int[] maxInt = new int[maxValue.length];
        int[] intValue = new int[maxValue.length];
        int[] numInt = new int[minValue.length];
        int num = 1;
        for (int i2 = 0; i2 < minValue.length; ++i2) {
            minInt[i2] = (int)Math.ceil(minValue[i2]);
            maxInt[i2] = (int)Math.floor(maxValue[i2]);
            numInt[i2] = maxInt[i2] - minInt[i2] + 1;
            num *= numInt[i2];
        }
        int numEach = numInstances / num;
        int rest = numInstances - numEach * num;
        for (int i3 = 0; i3 < this.m_NumAttributes; ++i3) {
            if (attributes[i3]) {
                values[i3] = minInt[i3];
                intValue[i3] = minInt[i3];
                continue;
            }
            values[i3] = Utils.missingValue();
        }
        if (this.getClassFlag()) {
            values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
        }
        DenseInstance example = new DenseInstance(1.0, values);
        example.setDataset(format);
        int added = 0;
        int attr = 0;
        do {
            for (int k = 0; k < numEach; ++k) {
                format.add(example);
                ++added;
            }
            if (rest > 0) {
                format.add(example);
                ++added;
                --rest;
            }
            if (added >= numInstances) break;
            boolean done = false;
            do {
                if (attributes[attr] && intValue[attr] + 1 <= maxInt[attr]) {
                    int n = attr;
                    intValue[n] = intValue[n] + 1;
                    done = true;
                    continue;
                }
                ++attr;
            } while (!done);
            example.setValue(attr, (double)intValue[attr]);
        } while (added < numInstances);
    }

    private void generateGaussianExamples(Instances format, int numInstances, Random random, SubspaceClusterDefinition cl, String cName) {
        boolean makeInteger = cl.isInteger();
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        boolean[] attributes = cl.getAttributes();
        double[] meanValue = cl.getMeanValue();
        double[] stddevValue = cl.getStddevValue();
        for (int j = 0; j < numInstances; ++j) {
            double[] values = new double[numAtts];
            int num = -1;
            for (int i2 = 0; i2 < this.m_NumAttributes; ++i2) {
                if (attributes[i2]) {
                    double value = meanValue[++num] + random.nextGaussian() * stddevValue[num];
                    if (makeInteger) {
                        value = Math.round(value);
                    }
                    values[i2] = value;
                    continue;
                }
                values[i2] = Utils.missingValue();
            }
            if (this.getClassFlag()) {
                values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
            }
            DenseInstance example = new DenseInstance(1.0, values);
            example.setDataset(format);
            format.add(example);
        }
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String generateStart() {
        StringBuffer docu = new StringBuffer();
        int sumInst = 0;
        for (int cNum = 0; cNum < this.getClusters().length; ++cNum) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[cNum];
            docu.append("%\n");
            docu.append("% Cluster: c" + cNum + "   ");
            switch (cl.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    docu.append("Uniform Random");
                    break;
                }
                case 1: {
                    docu.append("Total Random");
                    break;
                }
                case 2: {
                    docu.append("Gaussian");
                }
            }
            if (cl.isInteger()) {
                docu.append(" / INTEGER");
            }
            docu.append("\n% ----------------------------------------------\n");
            docu.append("%" + cl.attributesToString());
            docu.append("\n% Number of Instances:            " + cl.getInstNums() + "\n");
            docu.append("% Generated Number of Instances:  " + cl.getNumInstances() + "\n");
            sumInst += cl.getNumInstances();
        }
        docu.append("%\n% ----------------------------------------------\n");
        docu.append("% Total Number of Instances: " + sumInst + "\n");
        docu.append("%                            in " + this.getClusters().length + " Cluster(s)\n%");
        return docu.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12478 $");
    }

    public static void main(String[] args) {
        SubspaceCluster.runDataGenerator(new SubspaceCluster(), args);
    }
}

