/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.RevisionUtils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;

public class DDConditionalEstimator
implements ConditionalEstimator {
    private DiscreteEstimator[] m_Estimators;

    public DDConditionalEstimator(int numSymbols, int numCondSymbols, boolean laplace) {
        this.m_Estimators = new DiscreteEstimator[numCondSymbols];
        for (int i2 = 0; i2 < numCondSymbols; ++i2) {
            this.m_Estimators[i2] = new DiscreteEstimator(numSymbols, laplace);
        }
    }

    @Override
    public void addValue(double data, double given, double weight) {
        this.m_Estimators[(int)given].addValue(data, weight);
    }

    @Override
    public Estimator getEstimator(double given) {
        return this.m_Estimators[(int)given];
    }

    @Override
    public double getProbability(double data, double given) {
        return this.getEstimator(given).getProbability(data);
    }

    public String toString() {
        String result = "DD Conditional Estimator. " + this.m_Estimators.length + " sub-estimators:\n";
        for (int i2 = 0; i2 < this.m_Estimators.length; ++i2) {
            result = result + "Sub-estimator " + i2 + ": " + this.m_Estimators[i2];
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        try {
            int currentB;
            int currentA;
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int maxA = currentA = Integer.parseInt(argv[0]);
            int maxB = currentB = Integer.parseInt(argv[1]);
            for (int i2 = 2; i2 < argv.length - 1; i2 += 2) {
                currentA = Integer.parseInt(argv[i2]);
                currentB = Integer.parseInt(argv[i2 + 1]);
                if (currentA > maxA) {
                    maxA = currentA;
                }
                if (currentB <= maxB) continue;
                maxB = currentB;
            }
            DDConditionalEstimator newEst = new DDConditionalEstimator(maxA + 1, maxB + 1, true);
            for (int i3 = 0; i3 < argv.length - 1; i3 += 2) {
                currentA = Integer.parseInt(argv[i3]);
                currentB = Integer.parseInt(argv[i3 + 1]);
                System.out.println(newEst);
                System.out.println("Prediction for " + currentA + '|' + currentB + " = " + newEst.getProbability(currentA, currentB));
                newEst.addValue(currentA, currentB, 1.0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

