/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Random;
import weka.core.Aggregateable;
import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class KernelEstimator
extends Estimator
implements IncrementalEstimator,
Aggregateable<KernelEstimator> {
    private static final long serialVersionUID = 3646923563367683925L;
    private double[] m_Values = new double[50];
    private double[] m_Weights = new double[50];
    private int m_NumValues = 0;
    private double m_SumOfWeights = 0.0;
    private double m_StandardDev;
    private double m_Precision;
    private boolean m_AllWeightsOne = true;
    private static double MAX_ERROR = 0.01;

    private int findNearestValue(double key) {
        int low = 0;
        int high = this.m_NumValues;
        int middle = 0;
        while (low < high) {
            middle = (low + high) / 2;
            double current = this.m_Values[middle];
            if (current == key) {
                return middle;
            }
            if (current > key) {
                high = middle;
                continue;
            }
            if (!(current < key)) continue;
            low = middle + 1;
        }
        return low;
    }

    private double round(double data) {
        return Math.rint(data / this.m_Precision) * this.m_Precision;
    }

    public KernelEstimator(double precision) {
        this.m_Precision = precision;
        if (this.m_Precision < Utils.SMALL) {
            this.m_Precision = Utils.SMALL;
        }
        this.m_StandardDev = this.m_Precision / 6.0;
    }

    @Override
    public void addValue(double data, double weight) {
        if (weight == 0.0) {
            return;
        }
        int insertIndex = this.findNearestValue(data = this.round(data));
        if (this.m_NumValues <= insertIndex || this.m_Values[insertIndex] != data) {
            if (this.m_NumValues < this.m_Values.length) {
                int left = this.m_NumValues - insertIndex;
                System.arraycopy(this.m_Values, insertIndex, this.m_Values, insertIndex + 1, left);
                System.arraycopy(this.m_Weights, insertIndex, this.m_Weights, insertIndex + 1, left);
                this.m_Values[insertIndex] = data;
                this.m_Weights[insertIndex] = weight;
                ++this.m_NumValues;
            } else {
                double[] newValues = new double[this.m_Values.length * 2];
                double[] newWeights = new double[this.m_Values.length * 2];
                int left = this.m_NumValues - insertIndex;
                System.arraycopy(this.m_Values, 0, newValues, 0, insertIndex);
                System.arraycopy(this.m_Weights, 0, newWeights, 0, insertIndex);
                newValues[insertIndex] = data;
                newWeights[insertIndex] = weight;
                System.arraycopy(this.m_Values, insertIndex, newValues, insertIndex + 1, left);
                System.arraycopy(this.m_Weights, insertIndex, newWeights, insertIndex + 1, left);
                ++this.m_NumValues;
                this.m_Values = newValues;
                this.m_Weights = newWeights;
            }
            if (weight != 1.0) {
                this.m_AllWeightsOne = false;
            }
        } else {
            int n = insertIndex;
            this.m_Weights[n] = this.m_Weights[n] + weight;
            this.m_AllWeightsOne = false;
        }
        this.m_SumOfWeights += weight;
        double range = this.m_Values[this.m_NumValues - 1] - this.m_Values[0];
        if (range > 0.0) {
            this.m_StandardDev = Math.max(range / Math.sqrt(this.m_SumOfWeights), this.m_Precision / 6.0);
        }
    }

    @Override
    public double getProbability(double data) {
        int start;
        int i2;
        double delta = 0.0;
        double sum = 0.0;
        double currentProb = 0.0;
        double zLower = 0.0;
        double zUpper = 0.0;
        if (this.m_NumValues == 0) {
            zLower = (data - this.m_Precision / 2.0) / this.m_StandardDev;
            zUpper = (data + this.m_Precision / 2.0) / this.m_StandardDev;
            return Statistics.normalProbability(zUpper) - Statistics.normalProbability(zLower);
        }
        double weightSum = 0.0;
        for (i2 = start = this.findNearestValue(data); i2 < this.m_NumValues; ++i2) {
            delta = this.m_Values[i2] - data;
            zLower = (delta - this.m_Precision / 2.0) / this.m_StandardDev;
            zUpper = (delta + this.m_Precision / 2.0) / this.m_StandardDev;
            currentProb = Statistics.normalProbability(zUpper) - Statistics.normalProbability(zLower);
            if (currentProb * (this.m_SumOfWeights - (weightSum += this.m_Weights[i2])) < (sum += currentProb * this.m_Weights[i2]) * MAX_ERROR) break;
        }
        for (i2 = start - 1; i2 >= 0; --i2) {
            delta = this.m_Values[i2] - data;
            zLower = (delta - this.m_Precision / 2.0) / this.m_StandardDev;
            zUpper = (delta + this.m_Precision / 2.0) / this.m_StandardDev;
            currentProb = Statistics.normalProbability(zUpper) - Statistics.normalProbability(zLower);
            if (currentProb * (this.m_SumOfWeights - (weightSum += this.m_Weights[i2])) < (sum += currentProb * this.m_Weights[i2]) * MAX_ERROR) break;
        }
        return sum / this.m_SumOfWeights;
    }

    public String toString() {
        String result = this.m_NumValues + " Normal Kernels. \nStandardDev = " + Utils.doubleToString(this.m_StandardDev, 6, 4) + " Precision = " + this.m_Precision;
        if (this.m_NumValues == 0) {
            result = result + "  \nMean = 0";
        } else {
            int i2;
            result = result + "  \nMeans =";
            for (i2 = 0; i2 < this.m_NumValues; ++i2) {
                result = result + " " + this.m_Values[i2];
            }
            if (!this.m_AllWeightsOne) {
                result = result + "\nWeights = ";
                for (i2 = 0; i2 < this.m_NumValues; ++i2) {
                    result = result + " " + this.m_Weights[i2];
                }
            }
        }
        return result + "\n";
    }

    public int getNumKernels() {
        return this.m_NumValues;
    }

    public double[] getMeans() {
        return this.m_Values;
    }

    public double[] getWeights() {
        return this.m_Weights;
    }

    public double getPrecision() {
        return this.m_Precision;
    }

    public double getStdDev() {
        return this.m_StandardDev;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        if (!this.m_noClass) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        } else {
            result.enable(Capabilities.Capability.NO_CLASS);
        }
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9785 $");
    }

    @Override
    public KernelEstimator aggregate(KernelEstimator toAggregate) throws Exception {
        for (int i2 = 0; i2 < toAggregate.m_NumValues; ++i2) {
            this.addValue(toAggregate.m_Values[i2], toAggregate.m_Weights[i2]);
        }
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
    }

    public static void testAggregation() {
        KernelEstimator ke = new KernelEstimator(0.01);
        KernelEstimator one = new KernelEstimator(0.01);
        KernelEstimator two = new KernelEstimator(0.01);
        Random r = new Random(1L);
        for (int i2 = 0; i2 < 100; ++i2) {
            double z = r.nextDouble();
            ke.addValue(z, 1.0);
            if (i2 < 50) {
                one.addValue(z, 1.0);
                continue;
            }
            two.addValue(z, 1.0);
        }
        try {
            System.out.println("\n\nFull\n");
            System.out.println(ke.toString());
            System.out.println("Prob (0): " + ke.getProbability(0.0));
            System.out.println("\nOne\n" + one.toString());
            System.out.println("Prob (0): " + one.getProbability(0.0));
            System.out.println("\nTwo\n" + two.toString());
            System.out.println("Prob (0): " + two.getProbability(0.0));
            one = one.aggregate(two);
            System.out.println("Aggregated\n");
            System.out.println(one.toString());
            System.out.println("Prob (0): " + one.getProbability(0.0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        try {
            if (argv.length < 2) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            KernelEstimator newEst = new KernelEstimator(0.01);
            for (int i2 = 0; i2 < argv.length - 3; i2 += 2) {
                newEst.addValue(Double.valueOf(argv[i2]), Double.valueOf(argv[i2 + 1]));
            }
            System.out.println(newEst);
            double start = Double.valueOf(argv[argv.length - 2]);
            double finish = Double.valueOf(argv[argv.length - 1]);
            for (double current = start; current < finish; current += (finish - start) / 50.0) {
                System.out.println("Data: " + current + " " + newEst.getProbability(current));
            }
            KernelEstimator.testAggregation();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

