/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateNormalEstimator;
import weka.estimators.UnivariateQuantileEstimator;

public class UnivariateKernelEstimator
implements UnivariateDensityEstimator,
UnivariateIntervalEstimator,
UnivariateQuantileEstimator,
Serializable {
    private static final long serialVersionUID = -1163983347810498880L;
    protected TreeMap<Double, Double> m_TM = new TreeMap();
    protected double m_WeightedSum = 0.0;
    protected double m_WeightedSumSquared = 0.0;
    protected double m_SumOfWeights = 0.0;
    protected double m_Width = Double.MAX_VALUE;
    protected double m_Exponent = -0.25;
    protected double m_MinWidth = 1.0E-6;
    public static final double CONST = -0.5 * Math.log(Math.PI * 2);
    protected double m_Threshold = 1.0E-6;
    protected int m_NumIntervals = 1000;

    public String globalInfo() {
        return "Provides a univariate kernel estimator.";
    }

    @Override
    public void addValue(double value, double weight) {
        this.m_WeightedSum += value * weight;
        this.m_WeightedSumSquared += value * value * weight;
        this.m_SumOfWeights += weight;
        if (this.m_TM.get(value) == null) {
            this.m_TM.put(value, weight);
        } else {
            this.m_TM.put(value, this.m_TM.get(value) + weight);
        }
    }

    public void updateWidth() {
        if (this.m_SumOfWeights > 0.0) {
            double mean = this.m_WeightedSum / this.m_SumOfWeights;
            double variance = this.m_WeightedSumSquared / this.m_SumOfWeights - mean * mean;
            if (variance < 0.0) {
                variance = 0.0;
            }
            this.m_Width = Math.sqrt(variance) * Math.pow(this.m_SumOfWeights, this.m_Exponent);
            if (this.m_Width <= this.m_MinWidth) {
                this.m_Width = this.m_MinWidth;
            }
        } else {
            this.m_Width = Double.MAX_VALUE;
        }
    }

    @Override
    public double[][] predictIntervals(double conf) {
        this.updateWidth();
        double val = Statistics.normalInverse(1.0 - (1.0 - conf) / 2.0);
        double min = this.m_TM.firstKey() - val * this.m_Width;
        double max = this.m_TM.lastKey() + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double[] probabilities = new double[this.m_NumIntervals];
        double leftVal = Math.exp(this.logDensity(min));
        for (int i2 = 0; i2 < this.m_NumIntervals; ++i2) {
            double rightVal = Math.exp(this.logDensity(min + (double)(i2 + 1) * delta));
            probabilities[i2] = 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
        }
        int[] sortedIndices = Utils.sort(probabilities);
        double sum = 0.0;
        boolean[] toUse = new boolean[probabilities.length];
        for (int k = 0; sum < conf && k < toUse.length; sum += probabilities[sortedIndices[toUse.length - (k + 1)]], ++k) {
            toUse[sortedIndices[toUse.length - (k + 1)]] = true;
        }
        probabilities = null;
        ArrayList<double[]> intervals = new ArrayList<double[]>();
        double[] interval = null;
        boolean haveStartedInterval = false;
        for (int i3 = 0; i3 < this.m_NumIntervals; ++i3) {
            if (toUse[i3]) {
                if (!haveStartedInterval) {
                    haveStartedInterval = true;
                    interval = new double[]{min + (double)i3 * delta, min + (double)(i3 + 1) * delta};
                }
                continue;
            }
            if (!haveStartedInterval) continue;
            haveStartedInterval = false;
            intervals.add(interval);
        }
        if (haveStartedInterval) {
            intervals.add(interval);
        }
        return (double[][])intervals.toArray((T[])new double[0][0]);
    }

    @Override
    public double predictQuantile(double percentage) {
        this.updateWidth();
        double val = Statistics.normalInverse(0.975);
        double min = this.m_TM.firstKey() - val * this.m_Width;
        double max = this.m_TM.lastKey() + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double sum = 0.0;
        double leftVal = Math.exp(this.logDensity(min));
        for (int i2 = 0; i2 < this.m_NumIntervals; ++i2) {
            if (sum >= percentage) {
                return min + (double)i2 * delta;
            }
            double rightVal = Math.exp(this.logDensity(min + (double)(i2 + 1) * delta));
            sum += 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
        }
        return max;
    }

    protected double logOfSum(double logOfX, double logOfY) {
        if (Double.isNaN(logOfX)) {
            return logOfY;
        }
        if (Double.isNaN(logOfY)) {
            return logOfX;
        }
        if (logOfX > logOfY) {
            return logOfX + Math.log(1.0 + Math.exp(logOfY - logOfX));
        }
        return logOfY + Math.log(1.0 + Math.exp(logOfX - logOfY));
    }

    protected void runningSum(Set<Map.Entry<Double, Double>> c, double value, double[] sums) {
        double offset = CONST - Math.log(this.m_Width);
        double logFactor = Math.log(this.m_Threshold) - Math.log(1.0 - this.m_Threshold);
        double logSumOfWeights = Math.log(this.m_SumOfWeights);
        for (Map.Entry<Double, Double> entry : c) {
            if (!(entry.getValue() > 0.0)) continue;
            double diff = (entry.getKey() - value) / this.m_Width;
            double logDensity = offset - 0.5 * diff * diff;
            double logWeight = Math.log(entry.getValue());
            sums[0] = this.logOfSum(sums[0], logWeight + logDensity);
            sums[1] = this.logOfSum(sums[1], logWeight);
            if (!(logDensity + logSumOfWeights < this.logOfSum(logFactor + sums[0], logDensity + sums[1]))) continue;
            break;
        }
    }

    @Override
    public double logDensity(double value) {
        this.updateWidth();
        double[] sums = new double[]{Double.NaN, Double.NaN};
        this.runningSum(this.m_TM.tailMap(value, true).entrySet(), value, sums);
        this.runningSum(this.m_TM.headMap(value, false).descendingMap().entrySet(), value, sums);
        return sums[0] - Math.log(this.m_SumOfWeights);
    }

    public String toString() {
        return "Kernel estimator with bandwidth " + this.m_Width + " and total weight " + this.m_SumOfWeights + " based on\n" + this.m_TM.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11318 $");
    }

    public static void main(String[] args) {
        int i2;
        Random r = new Random();
        UnivariateKernelEstimator e = new UnivariateKernelEstimator();
        System.out.println(e);
        double sum = 0.0;
        for (i2 = 0; i2 < 1000; ++i2) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 1000.0);
        for (i2 = 0; i2 < 1000; ++i2) {
            e.addValue(0.1 * r.nextGaussian() - 3.0, 1.0);
            e.addValue(r.nextGaussian() * 0.25, 3.0);
        }
        sum = 0.0;
        int points = 10000;
        for (int i3 = 0; i3 < points; ++i3) {
            double value = r.nextDouble() * 10.0 - 5.0;
            sum += Math.exp(e.logDensity(value));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / (double)points);
        double[][] Intervals = e.predictIntervals(0.9);
        System.out.println("Printing kernel intervals ---------------------");
        for (double[] interval : Intervals) {
            System.out.println("Left: " + interval[0] + "\t Right: " + interval[1]);
        }
        System.out.println("Finished kernel printing intervals ---------------------");
        double Covered = 0.0;
        block4: for (int i4 = 0; i4 < 1000; ++i4) {
            double val = -1.0;
            val = r.nextDouble() < 0.25 ? 0.1 * r.nextGaussian() - 3.0 : r.nextGaussian() * 0.25;
            for (double[] interval : Intervals) {
                if (!(val >= interval[0]) || !(val <= interval[1])) continue;
                Covered += 1.0;
                continue block4;
            }
        }
        System.out.println("Coverage at 0.9 level for kernel intervals: " + Covered / 1000.0);
        UnivariateKernelEstimator eKernel = new UnivariateKernelEstimator();
        UnivariateNormalEstimator eNormal = new UnivariateNormalEstimator();
        for (int j = 1; j < 5; ++j) {
            double val;
            int i5;
            double numTrain = Math.pow(10.0, j);
            System.out.println("Number of training cases: " + numTrain);
            int i6 = 0;
            while ((double)i6 < numTrain) {
                double val2 = r.nextGaussian() * 1.5 + 0.5;
                eKernel.addValue(val2, 1.0);
                eNormal.addValue(val2, 1.0);
                ++i6;
            }
            sum = 0.0;
            points = 10000;
            for (i6 = 0; i6 < points; ++i6) {
                double value = r.nextDouble() * 20.0 - 10.0;
                sum += Math.exp(eKernel.logDensity(value));
            }
            System.out.println("Approximate integral for kernel estimator: " + 20.0 * sum / (double)points);
            double loglikelihoodKernel = 0.0;
            double loglikelihoodNormal = 0.0;
            for (int i7 = 0; i7 < 1000; ++i7) {
                double val3 = r.nextGaussian() * 1.5 + 0.5;
                loglikelihoodKernel += eKernel.logDensity(val3);
                loglikelihoodNormal += eNormal.logDensity(val3);
            }
            System.out.println("Loglikelihood for kernel estimator: " + loglikelihoodKernel / 1000.0);
            System.out.println("Loglikelihood for normal estimator: " + loglikelihoodNormal / 1000.0);
            double[][] kernelIntervals = eKernel.predictIntervals(0.95);
            double[][] normalIntervals = eNormal.predictIntervals(0.95);
            System.out.println("Printing kernel intervals ---------------------");
            for (double[] kernelInterval : kernelIntervals) {
                System.out.println("Left: " + kernelInterval[0] + "\t Right: " + kernelInterval[1]);
            }
            System.out.println("Finished kernel printing intervals ---------------------");
            System.out.println("Printing normal intervals ---------------------");
            for (double[] normalInterval : normalIntervals) {
                System.out.println("Left: " + normalInterval[0] + "\t Right: " + normalInterval[1]);
            }
            System.out.println("Finished normal printing intervals ---------------------");
            double kernelCovered = 0.0;
            double normalCovered = 0.0;
            block12: for (i5 = 0; i5 < 1000; ++i5) {
                val = r.nextGaussian() * 1.5 + 0.5;
                for (double[] kernelInterval : kernelIntervals) {
                    if (!(val >= kernelInterval[0]) || !(val <= kernelInterval[1])) continue;
                    kernelCovered += 1.0;
                    break;
                }
                for (double[] normalInterval : normalIntervals) {
                    if (!(val >= normalInterval[0]) || !(val <= normalInterval[1])) continue;
                    normalCovered += 1.0;
                    continue block12;
                }
            }
            System.out.println("Coverage at 0.95 level for kernel intervals: " + kernelCovered / 1000.0);
            System.out.println("Coverage at 0.95 level for normal intervals: " + normalCovered / 1000.0);
            kernelIntervals = eKernel.predictIntervals(0.8);
            normalIntervals = eNormal.predictIntervals(0.8);
            kernelCovered = 0.0;
            normalCovered = 0.0;
            block15: for (i5 = 0; i5 < 1000; ++i5) {
                val = r.nextGaussian() * 1.5 + 0.5;
                for (double[] kernelInterval : kernelIntervals) {
                    if (!(val >= kernelInterval[0]) || !(val <= kernelInterval[1])) continue;
                    kernelCovered += 1.0;
                    break;
                }
                for (double[] normalInterval : normalIntervals) {
                    if (!(val >= normalInterval[0]) || !(val <= normalInterval[1])) continue;
                    normalCovered += 1.0;
                    continue block15;
                }
            }
            System.out.println("Coverage at 0.8 level for kernel intervals: " + kernelCovered / 1000.0);
            System.out.println("Coverage at 0.8 level for normal intervals: " + normalCovered / 1000.0);
        }
    }
}

