/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.ResultProducer;

public class InstancesResultListener
extends CSVResultListener {
    static final long serialVersionUID = -2203808461809311178L;
    protected transient ArrayList<Instance> m_Instances;
    protected transient int[] m_AttributeTypes;
    protected transient Hashtable<String, Double>[] m_NominalIndexes;
    protected transient ArrayList<String>[] m_NominalStrings;

    public InstancesResultListener() {
        File resultsFile;
        try {
            resultsFile = File.createTempFile("weka_experiment", ".arff");
            resultsFile.deleteOnExit();
        }
        catch (Exception e) {
            System.err.println("Cannot create temp file, writing to standard out.");
            resultsFile = new File("-");
        }
        this.setOutputFile(resultsFile);
        this.setOutputFileName("");
    }

    @Override
    public String globalInfo() {
        return "Outputs the received results in arff format to a Writer. All results must be received before the instances can be written out.";
    }

    @Override
    public void preProcess(ResultProducer rp) throws Exception {
        this.m_RP = rp;
        this.m_Out = this.m_OutputFile == null || this.m_OutputFile.getName().equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.m_OutputFile)), true);
        Object[] keyTypes = this.m_RP.getKeyTypes();
        Object[] resultTypes = this.m_RP.getResultTypes();
        this.m_AttributeTypes = new int[keyTypes.length + resultTypes.length];
        this.m_NominalIndexes = new Hashtable[this.m_AttributeTypes.length];
        this.m_NominalStrings = new ArrayList[this.m_AttributeTypes.length];
        this.m_Instances = new ArrayList();
        for (int i2 = 0; i2 < this.m_AttributeTypes.length; ++i2) {
            Object attribute = null;
            attribute = i2 < keyTypes.length ? keyTypes[i2] : resultTypes[i2 - keyTypes.length];
            if (attribute instanceof String) {
                this.m_AttributeTypes[i2] = 1;
                this.m_NominalIndexes[i2] = new Hashtable();
                this.m_NominalStrings[i2] = new ArrayList();
                continue;
            }
            if (attribute instanceof Double) {
                this.m_AttributeTypes[i2] = 0;
                continue;
            }
            throw new Exception("Unknown attribute type in column " + (i2 + 1));
        }
    }

    @Override
    public void postProcess(ResultProducer rp) throws Exception {
        int i2;
        if (this.m_RP != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        String[] keyNames = this.m_RP.getKeyNames();
        String[] resultNames = this.m_RP.getResultNames();
        ArrayList<Attribute> attribInfo = new ArrayList<Attribute>();
        block5: for (int i3 = 0; i3 < this.m_AttributeTypes.length; ++i3) {
            String attribName = "Unknown";
            attribName = i3 < keyNames.length ? "Key_" + keyNames[i3] : resultNames[i3 - keyNames.length];
            switch (this.m_AttributeTypes[i3]) {
                case 1: {
                    if (this.m_NominalStrings[i3].size() > 0) {
                        attribInfo.add(new Attribute(attribName, this.m_NominalStrings[i3]));
                        continue block5;
                    }
                    attribInfo.add(new Attribute(attribName, (List<String>)null));
                    continue block5;
                }
                case 0: {
                    attribInfo.add(new Attribute(attribName));
                    continue block5;
                }
                case 2: {
                    attribInfo.add(new Attribute(attribName, (List<String>)null));
                    continue block5;
                }
                default: {
                    throw new Exception("Unknown attribute type");
                }
            }
        }
        Instances result = new Instances("InstanceResultListener", attribInfo, this.m_Instances.size());
        for (i2 = 0; i2 < this.m_Instances.size(); ++i2) {
            result.add(this.m_Instances.get(i2));
        }
        this.m_Out.println(new Instances(result, 0));
        for (i2 = 0; i2 < result.numInstances(); ++i2) {
            this.m_Out.println(result.instance(i2));
        }
        if (this.m_OutputFile != null && !this.m_OutputFile.getName().equals("-")) {
            this.m_Out.close();
        }
    }

    @Override
    public void acceptResult(ResultProducer rp, Object[] key, Object[] result) throws Exception {
        if (this.m_RP != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        DenseInstance newInst = new DenseInstance(this.m_AttributeTypes.length);
        block4: for (int i2 = 0; i2 < this.m_AttributeTypes.length; ++i2) {
            Object val = null;
            val = i2 < key.length ? key[i2] : result[i2 - key.length];
            if (val == null) {
                newInst.setValue(i2, Utils.missingValue());
                continue;
            }
            switch (this.m_AttributeTypes[i2]) {
                case 1: {
                    String str = (String)val;
                    Double index = this.m_NominalIndexes[i2].get(str);
                    if (index == null) {
                        index = new Double(this.m_NominalStrings[i2].size());
                        this.m_NominalIndexes[i2].put(str, index);
                        this.m_NominalStrings[i2].add(str);
                    }
                    newInst.setValue(i2, (double)index);
                    continue block4;
                }
                case 0: {
                    double dou = (Double)val;
                    newInst.setValue(i2, dou);
                    continue block4;
                }
                default: {
                    newInst.setValue(i2, Utils.missingValue());
                }
            }
        }
        this.m_Instances.add(newInst);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

