/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Enumeration;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.experiment.PairedStats;
import weka.experiment.PairedStatsCorrected;
import weka.experiment.PairedTTester;

public class PairedCorrectedTTester
extends PairedTTester
implements TechnicalInformationHandler {
    static final long serialVersionUID = -3105268939845653323L;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Claude Nadeau and Yoshua Bengio");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Inference for the Generalization Error");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.PDF, "http://www.iro.umontreal.ca/~lisa/bib/pub_subject/comparative/pointeurs/nadeau_MLJ1597.pdf");
        return result;
    }

    @Override
    public PairedStats calculateStatistics(Instance datasetSpecifier, int resultset1Index, int resultset2Index, int comparisonColumn) throws Exception {
        if (this.m_Instances.attribute(comparisonColumn).type() != 0) {
            throw new Exception("Comparison column " + (comparisonColumn + 1) + " (" + this.m_Instances.attribute(comparisonColumn).name() + ") is not numeric");
        }
        if (!this.m_ResultsetsValid) {
            this.prepareData();
        }
        PairedTTester.Resultset resultset1 = (PairedTTester.Resultset)this.m_Resultsets.get(resultset1Index);
        PairedTTester.Resultset resultset2 = (PairedTTester.Resultset)this.m_Resultsets.get(resultset2Index);
        ArrayList<Instance> dataset1 = resultset1.dataset(datasetSpecifier);
        ArrayList<Instance> dataset2 = resultset2.dataset(datasetSpecifier);
        String datasetName = this.templateString(datasetSpecifier);
        if (dataset1 == null) {
            throw new Exception("No results for dataset=" + datasetName + " for resultset=" + resultset1.templateString());
        }
        if (dataset2 == null) {
            throw new Exception("No results for dataset=" + datasetName + " for resultset=" + resultset2.templateString());
        }
        if (dataset1.size() != dataset2.size()) {
            throw new Exception("Results for dataset=" + datasetName + " differ in size for resultset=" + resultset1.templateString() + " and resultset=" + resultset2.templateString());
        }
        double testTrainRatio = 0.0;
        int trainSizeIndex = -1;
        int testSizeIndex = -1;
        for (int i2 = 0; i2 < this.m_Instances.numAttributes(); ++i2) {
            if (this.m_Instances.attribute(i2).name().toLowerCase().equals("number_of_training_instances")) {
                trainSizeIndex = i2;
                continue;
            }
            if (!this.m_Instances.attribute(i2).name().toLowerCase().equals("number_of_testing_instances")) continue;
            testSizeIndex = i2;
        }
        if (trainSizeIndex >= 0 && testSizeIndex >= 0) {
            double totalTrainSize = 0.0;
            double totalTestSize = 0.0;
            for (int k = 0; k < dataset1.size(); ++k) {
                Instance current = dataset1.get(k);
                totalTrainSize += current.value(trainSizeIndex);
                totalTestSize += current.value(testSizeIndex);
            }
            testTrainRatio = totalTestSize / totalTrainSize;
        }
        PairedStatsCorrected pairedStats = new PairedStatsCorrected(this.m_SignificanceLevel, testTrainRatio);
        for (int k = 0; k < dataset1.size(); ++k) {
            Instance current1 = dataset1.get(k);
            Instance current2 = dataset2.get(k);
            if (current1.isMissing(comparisonColumn)) {
                System.err.println("Instance has missing value in comparison column!\n" + current1);
                continue;
            }
            if (current2.isMissing(comparisonColumn)) {
                System.err.println("Instance has missing value in comparison column!\n" + current2);
                continue;
            }
            if (current1.value(this.m_RunColumn) != current2.value(this.m_RunColumn)) {
                System.err.println("Run numbers do not match!\n" + current1 + current2);
            }
            if (this.m_FoldColumn != -1 && current1.value(this.m_FoldColumn) != current2.value(this.m_FoldColumn)) {
                System.err.println("Fold numbers do not match!\n" + current1 + current2);
            }
            double value1 = current1.value(comparisonColumn);
            double value2 = current2.value(comparisonColumn);
            pairedStats.add(value1, value2);
        }
        ((PairedStats)pairedStats).calculateDerived();
        return pairedStats;
    }

    public static void main(String[] args) {
        try {
            PairedCorrectedTTester tt = new PairedCorrectedTTester();
            String datasetName = Utils.getOption('t', args);
            String compareColStr = Utils.getOption('c', args);
            String baseColStr = Utils.getOption('b', args);
            boolean summaryOnly = Utils.getFlag('s', args);
            boolean rankingOnly = Utils.getFlag('r', args);
            try {
                if (datasetName.length() == 0 || compareColStr.length() == 0) {
                    throw new Exception("-t and -c options are required");
                }
                tt.setOptions(args);
                Utils.checkForRemainingOptions(args);
            }
            catch (Exception ex) {
                String result = "";
                Enumeration<Option> enu = tt.listOptions();
                while (enu.hasMoreElements()) {
                    Option option = enu.nextElement();
                    result = result + option.synopsis() + '\n' + option.description() + '\n';
                }
                throw new Exception("Usage:\n\n-t <file>\n\tSet the dataset containing data to evaluate\n-b <index>\n\tSet the resultset to base comparisons against (optional)\n-c <index>\n\tSet the column to perform a comparison on\n-s\n\tSummarize wins over all resultset pairs\n\n-r\n\tGenerate a resultset ranking\n\n" + result);
            }
            Instances data = new Instances(new BufferedReader(new FileReader(datasetName)));
            tt.setInstances(data);
            int compareCol = Integer.parseInt(compareColStr) - 1;
            System.out.println(tt.header(compareCol));
            if (rankingOnly) {
                System.out.println(tt.multiResultsetRanking(compareCol));
            } else if (summaryOnly) {
                System.out.println(tt.multiResultsetSummary(compareCol));
            } else {
                System.out.println(tt.resultsetKey());
                if (baseColStr.length() == 0) {
                    for (int i2 = 0; i2 < tt.getNumResultsets(); ++i2) {
                        System.out.println(tt.multiResultsetFull(i2, compareCol));
                    }
                } else {
                    int baseCol = Integer.parseInt(baseColStr) - 1;
                    System.out.println(tt.multiResultsetFull(baseCol, compareCol));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
    }

    @Override
    public String getDisplayName() {
        return "Paired T-Tester (corrected)";
    }

    @Override
    public String getToolTipText() {
        return "Performs test using corrected resampled t-test statistic (Nadeau and Bengio)";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

