/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.Version;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixGnuPlot
extends ResultMatrix {
    private static final long serialVersionUID = -234648254944790097L;

    public ResultMatrixGnuPlot() {
        this(1, 1);
    }

    public ResultMatrixGnuPlot(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixGnuPlot(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates output for a data and script file for GnuPlot.";
    }

    @Override
    public String getDisplayName() {
        return "GNUPlot";
    }

    @Override
    public void clear() {
        super.clear();
        this.LEFT_PARENTHESES = "";
        this.RIGHT_PARENTHESES = "";
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 50;
    }

    @Override
    public int getDefaultColNameWidth() {
        return 50;
    }

    @Override
    public boolean getDefaultEnumerateColNames() {
        return false;
    }

    @Override
    public boolean getDefaultEnumerateRowNames() {
        return false;
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringMatrix() {
        int n;
        int i2;
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        String generated = "# generated by WEKA " + Version.VERSION + "\n";
        result.append("\n");
        result.append("##################\n");
        result.append("# file: plot.dat #\n");
        result.append("##################\n");
        result.append(generated);
        result.append("# contains the data for the plot\n");
        result.append("\n");
        result.append("# key for the x-axis\n");
        for (i2 = 1; i2 < cells.length - 1; ++i2) {
            result.append("# " + i2 + " - " + cells[i2][0] + "\n");
        }
        result.append("\n");
        result.append("# data for the plot\n");
        for (i2 = 1; i2 < cells.length - 1; ++i2) {
            result.append(Integer.toString(i2));
            for (n = 1; n < cells[i2].length; ++n) {
                if (this.isSignificance(n)) continue;
                result.append(" ");
                result.append(Utils.quote(cells[i2][n]));
            }
            result.append("\n");
        }
        result.append("#######\n");
        result.append("# end #\n");
        result.append("#######\n");
        result.append("\n");
        result.append("##################\n");
        result.append("# file: plot.scr #\n");
        result.append("##################\n");
        result.append(generated);
        result.append("# script to plot the data\n");
        result.append("\n");
        result.append("# display it in a window:\n");
        result.append("set terminal x11\n");
        result.append("set output\n");
        result.append("\n");
        result.append("# to display all data rows:\n");
        result.append("set xrange [0:" + (cells.length - 2 + 1) + "]\n");
        result.append("\n");
        result.append("# axis labels, e.g.:\n");
        result.append("#set xlabel \"Datasets\"\n");
        result.append("#set ylabel \"Accuracy in %\"\n");
        result.append("\n");
        result.append("# the plot commands\n");
        n = 1;
        i2 = 0;
        while (i2 < cells[0].length - 1) {
            if (this.isSignificance(++i2)) continue;
            String line = i2 == 1 ? "plot" : "replot";
            line = line + " \"plot.dat\"";
            String title = "title \"" + cells[0][i2] + "\"";
            line = line + " using 1:" + ++n;
            if (this.getShowStdDev()) {
                ++i2;
                line = line + ":" + ++n;
            }
            line = line + " with";
            line = this.getShowStdDev() ? line + " yerrorbars" : line + " lines";
            line = line + " " + title;
            result.append(line + "\n");
        }
        result.append("\n");
        result.append("# generate ps:\n");
        result.append("#set terminal postscript\n");
        result.append("#set output \"plot.ps\"\n");
        result.append("#replot\n");
        result.append("\n");
        result.append("# generate png:\n");
        result.append("#set terminal png size 800,600\n");
        result.append("#set output \"plot.png\"\n");
        result.append("#replot\n");
        result.append("\n");
        result.append("# wait for user to hit <Return>\n");
        result.append("pause -1\n");
        result.append("#######\n");
        result.append("# end #\n");
        result.append("#######\n");
        return result.toString();
    }

    @Override
    public String toStringKey() {
        return new ResultMatrixPlainText(this).toStringKey();
    }

    @Override
    public String toStringSummary() {
        return new ResultMatrixPlainText(this).toStringSummary();
    }

    @Override
    public String toStringRanking() {
        return new ResultMatrixPlainText(this).toStringRanking();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        ResultMatrixGnuPlot matrix = new ResultMatrixGnuPlot(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i2 = 0; i2 < matrix.getRowCount(); ++i2) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i2, (i2 + 1) * n);
                matrix.setStdDev(n, i2, (double)(i2 + 1) * (double)n / 100.0);
                if (i2 != n) continue;
                if (i2 % 2 == 1) {
                    matrix.setSignificance(n, i2, 1);
                    continue;
                }
                matrix.setSignificance(n, i2, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)matrix).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

