/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixHTML
extends ResultMatrix {
    private static final long serialVersionUID = 6672380422544799990L;

    public ResultMatrixHTML() {
        this(1, 1);
    }

    public ResultMatrixHTML(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixHTML(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates the matrix output as HTML.";
    }

    @Override
    public String getDisplayName() {
        return "HTML";
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 25;
    }

    @Override
    public boolean getDefaultPrintColNames() {
        return false;
    }

    @Override
    public boolean getDefaultEnumerateColNames() {
        return true;
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringMatrix() {
        int n;
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        result.append("<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n");
        result.append("   <tr>");
        for (n = 0; n < cells[0].length; ++n) {
            if (this.isRowName(n)) {
                result.append("<td><b>" + cells[0][n] + "</b></td>");
                continue;
            }
            if (!this.isMean(n)) continue;
            int cols = n == 1 ? 1 : 2;
            if (this.getShowStdDev()) {
                ++cols;
            }
            result.append("<td align=\"center\" colspan=\"" + cols + "\">");
            result.append("<b>" + cells[0][n] + "</b>");
            result.append("</td>");
        }
        result.append("</tr>\n");
        for (int i2 = 1; i2 < cells.length; ++i2) {
            result.append("   <tr>");
            for (n = 0; n < cells[i2].length; ++n) {
                if (this.isRowName(n)) {
                    result.append("<td>");
                } else if (this.isMean(n) || this.isStdDev(n)) {
                    result.append("<td align=\"right\">");
                } else if (this.isSignificance(n)) {
                    result.append("<td align=\"center\">");
                } else {
                    result.append("<td>");
                }
                if (cells[i2][n].trim().equals("")) {
                    result.append("&nbsp;");
                } else if (this.isStdDev(n)) {
                    result.append("&plusmn;&nbsp;" + cells[i2][n]);
                } else {
                    result.append(cells[i2][n]);
                }
                result.append("</td>");
            }
            result.append("</tr>\n");
        }
        result.append("</table>\n");
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n   <tr><td colspan=\"2\"><b>Key</b></td></tr>\n";
        for (int i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            result = result + "   <tr><td><b>(" + (i2 + 1) + ")</b></td><td>" + this.removeFilterName(this.m_ColNames[i2]) + "</td></tr>\n";
        }
        result = result + "</table>\n";
        return result;
    }

    @Override
    public String toStringSummary() {
        int i2;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String result = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
        String titles = "   <tr>";
        int resultsetLength = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        for (i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            titles = titles + "<td align=\"center\"><b>" + this.getSummaryTitle(i2) + "</b></td>";
        }
        result = result + titles + "<td><b>(No. of datasets where [col] &gt;&gt; [row])</b></td></tr>\n";
        for (i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            result = result + "   <tr>";
            for (int j = 0; j < this.getColCount(); ++j) {
                if (this.getColHidden(j)) continue;
                String content = j == i2 ? Utils.padLeft("-", resultsetLength * 2 + 3) : Utils.padLeft("" + this.m_NonSigWins[i2][j] + " (" + this.m_Wins[i2][j] + ")", resultsetLength * 2 + 3);
                result = result + "<td>" + content.replaceAll(" ", "&nbsp;") + "</td>";
            }
            result = result + "<td><b>" + this.getSummaryTitle(i2) + "</b> = " + this.removeFilterName(this.m_ColNames[i2]) + "</td></tr>\n";
        }
        result = result + "</table>\n";
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        String result = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
        result = result + "   <tr><td align=\"center\"><b>&gt;-&lt;</b></td><td align=\"center\"><b>&gt;</b></td><td align=\"center\"><b>&lt;</b></td><td><b>Resultset</b></td></tr>\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        for (int i2 = this.getColCount() - 1; i2 >= 0; --i2) {
            int curr = ranking[i2];
            if (this.getColHidden(curr)) continue;
            result = result + "   <tr><td align=\"right\">" + this.m_RankingDiff[curr] + "</td><td align=\"right\">" + this.m_RankingWins[curr] + "</td><td align=\"right\">" + this.m_RankingLosses[curr] + "</td><td>" + this.removeFilterName(this.m_ColNames[curr]) + "</td><tr>\n";
        }
        result = result + "</table>\n";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        ResultMatrixHTML matrix = new ResultMatrixHTML(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i2 = 0; i2 < matrix.getRowCount(); ++i2) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i2, (i2 + 1) * n);
                matrix.setStdDev(n, i2, (double)(i2 + 1) * (double)n / 100.0);
                if (i2 != n) continue;
                if (i2 % 2 == 1) {
                    matrix.setSignificance(n, i2, 1);
                    continue;
                }
                matrix.setSignificance(n, i2, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)matrix).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

