/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixLatex
extends ResultMatrix {
    private static final long serialVersionUID = 777690788447600978L;

    public ResultMatrixLatex() {
        this(1, 1);
    }

    public ResultMatrixLatex(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixLatex(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates the matrix output in LaTeX-syntax.";
    }

    @Override
    public String getDisplayName() {
        return "LaTeX";
    }

    @Override
    public void clear() {
        super.clear();
        this.TIE_STRING = " ";
        this.WIN_STRING = "$\\circ$";
        this.LOSS_STRING = "$\\bullet$";
    }

    @Override
    public boolean getDefaultPrintColNames() {
        return false;
    }

    @Override
    public boolean getDefaultEnumerateColNames() {
        return true;
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringMatrix() {
        int n;
        int i2;
        int j;
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        result.append("\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n");
        if (!this.getShowStdDev()) {
            result.append("\\footnotesize\n");
        } else {
            result.append("\\scriptsize\n");
        }
        if (!this.getShowStdDev()) {
            result.append("{\\centering \\begin{tabular}{lr");
        } else {
            result.append("{\\centering \\begin{tabular}{lr@{\\hspace{0cm}}c@{\\hspace{0cm}}r");
        }
        for (j = 1; j < this.getColCount(); ++j) {
            if (this.getColHidden(j)) continue;
            if (!this.getShowStdDev()) {
                result.append("r@{\\hspace{0.1cm}}c");
                continue;
            }
            result.append("r@{\\hspace{0cm}}c@{\\hspace{0cm}}r@{\\hspace{0.1cm}}c");
        }
        result.append("}\n\\\\\n\\hline\n");
        if (!this.getShowStdDev()) {
            result.append("Dataset & " + cells[0][1]);
        } else {
            result.append("Dataset & \\multicolumn{3}{c}{" + cells[0][1] + "}");
        }
        for (j = 2; j < cells[0].length; ++j) {
            if (!this.isMean(j)) continue;
            if (!this.getShowStdDev()) {
                result.append("& " + cells[0][j] + " & ");
                continue;
            }
            result.append("& \\multicolumn{4}{c}{" + cells[0][j] + "} ");
        }
        result.append("\\\\\n\\hline\n");
        for (i2 = 1; i2 < cells.length; ++i2) {
            cells[i2][0] = cells[i2][0].replace('_', '-');
        }
        for (n = 1; n < cells[0].length; ++n) {
            int size = this.getColSize(cells, n);
            for (i2 = 1; i2 < cells.length; ++i2) {
                cells[i2][n] = this.padString(cells[i2][n], size, true);
            }
        }
        for (i2 = 1; i2 < cells.length - 1; ++i2) {
            if (this.isAverage(i2)) {
                result.append("\\hline\n");
            }
            for (n = 0; n < cells[0].length; ++n) {
                if (n == 0) {
                    result.append(this.padString(cells[i2][n], this.getRowNameWidth()));
                    continue;
                }
                if (this.getShowStdDev()) {
                    if (this.isMean(n - 1)) {
                        if (!cells[i2][n].trim().equals("")) {
                            result.append(" & $\\pm$ & ");
                        } else {
                            result.append(" &       & ");
                        }
                    } else {
                        result.append(" & ");
                    }
                } else {
                    result.append(" & ");
                }
                result.append(cells[i2][n]);
            }
            result.append("\\\\\n");
        }
        result.append("\\hline\n\\multicolumn{" + cells[0].length + "}{c}{$\\circ$, $\\bullet$ statistically significant improvement or degradation}\\\\\n\\end{tabular} ");
        if (!this.getShowStdDev()) {
            result.append("\\footnotesize ");
        } else {
            result.append("\\scriptsize ");
        }
        result.append("\\par}\n\\end{table}\n");
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption (Key)}\n";
        result = result + "\\scriptsize\n";
        result = result + "{\\centering\n";
        result = result + "\\begin{tabular}{cl}\\\\\n";
        for (int i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            result = result + this.LEFT_PARENTHESES + (i2 + 1) + this.RIGHT_PARENTHESES + " & " + this.removeFilterName(this.m_ColNames[i2]).replace('_', '-').replaceAll("\\\\", "\\\\textbackslash") + " \\\\\n";
        }
        result = result + "\\end{tabular}\n";
        result = result + "}\n";
        result = result + "\\end{table}\n";
        return result;
    }

    @Override
    public String toStringSummary() {
        int i2;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        int resultsetLength = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        String result = "";
        String titles = "";
        result = result + "{\\centering\n";
        result = result + "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n";
        result = result + "\\footnotesize\n";
        result = result + "\\begin{tabular}{l";
        for (i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            titles = titles + " &";
            result = result + "c";
            titles = titles + ' ' + Utils.padLeft("" + this.getSummaryTitle(i2), resultsetLength * 2 + 3);
        }
        result = result + "}\\\\\n\\hline\n";
        result = result + titles + " \\\\\n\\hline\n";
        for (i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            for (int j = 0; j < this.getColCount(); ++j) {
                if (this.getColHidden(j)) continue;
                if (j == 0) {
                    result = result + (char)(97 + i2 % 26);
                }
                result = j == i2 ? result + " & - " : result + "& " + this.m_NonSigWins[i2][j] + " (" + this.m_Wins[i2][j] + ") ";
            }
            result = result + "\\\\\n";
        }
        result = result + "\\hline\n\\end{tabular} \\footnotesize \\par\n\\end{table}}";
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int biggest = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int width = Math.max(2 + (int)(Math.log(biggest) / Math.log(10.0)), ">-<".length());
        String result = "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n\\footnotesize\n{\\centering \\begin{tabular}{rlll}\\\\\n\\hline\n";
        result = result + "Resultset & Wins$-$ & Wins & Losses \\\\\n& Losses & & \\\\\n\\hline\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        for (int i2 = this.getColCount() - 1; i2 >= 0; --i2) {
            int curr = ranking[i2];
            if (this.getColHidden(curr)) continue;
            result = result + "(" + (curr + 1) + ") & " + Utils.padLeft("" + this.m_RankingDiff[curr], width) + " & " + Utils.padLeft("" + this.m_RankingWins[curr], width) + " & " + Utils.padLeft("" + this.m_RankingLosses[curr], width) + "\\\\\n";
        }
        result = result + "\\hline\n\\end{tabular} \\footnotesize \\par}\n\\end{table}";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        ResultMatrixLatex matrix = new ResultMatrixLatex(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i2 = 0; i2 < matrix.getRowCount(); ++i2) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i2, (i2 + 1) * n);
                matrix.setStdDev(n, i2, (double)(i2 + 1) * (double)n / 100.0);
                if (i2 != n) continue;
                if (i2 % 2 == 1) {
                    matrix.setSignificance(n, i2, 1);
                    continue;
                }
                matrix.setSignificance(n, i2, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)matrix).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

