/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;

public class ResultMatrixPlainText
extends ResultMatrix {
    private static final long serialVersionUID = 1502934525382357937L;

    public ResultMatrixPlainText() {
        this(1, 1);
    }

    public ResultMatrixPlainText(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixPlainText(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates the output as plain text (for fixed width fonts).";
    }

    @Override
    public String getDisplayName() {
        return "Plain Text";
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 25;
    }

    @Override
    public int getDefaultCountWidth() {
        return 5;
    }

    @Override
    public String toStringHeader() {
        int i2;
        String result = "";
        String[][] data = new String[this.m_HeaderKeys.size()][2];
        for (i2 = 0; i2 < this.m_HeaderKeys.size(); ++i2) {
            data[i2][0] = ((String)this.m_HeaderKeys.get(i2)).toString() + ":";
            data[i2][1] = ((String)this.m_HeaderValues.get(i2)).toString();
        }
        int size = this.getColSize(data, 0);
        for (i2 = 0; i2 < data.length; ++i2) {
            data[i2][0] = this.padString(data[i2][0], size);
        }
        for (i2 = 0; i2 < data.length; ++i2) {
            result = result + data[i2][0] + " " + data[i2][1] + "\n";
        }
        return result;
    }

    @Override
    public String toStringMatrix() {
        String line;
        int i2;
        int n;
        StringBuffer result = new StringBuffer();
        StringBuffer head = new StringBuffer();
        StringBuffer body = new StringBuffer();
        StringBuffer foot = new StringBuffer();
        String[][] cells = this.toArray();
        int[] startMeans = new int[this.getColCount()];
        int[] startSigs = new int[this.getColCount() - 1];
        int maxLength = 0;
        for (n = 1; n < cells[0].length; ++n) {
            int size = this.getColSize(cells, n, true, true);
            for (i2 = 1; i2 < cells.length - 1; ++i2) {
                cells[i2][n] = this.padString(cells[i2][n], size, true);
            }
        }
        int indexBase = 1;
        if (this.getShowStdDev()) {
            ++indexBase;
        }
        if (this.getShowStdDev()) {
            // empty if block
        }
        int j = 0;
        int k = 0;
        for (i2 = 1; i2 < cells.length - 1; ++i2) {
            if (this.isAverage(i2)) {
                body.append(this.padString("", maxLength).replaceAll(".", "-") + "\n");
            }
            line = "";
            for (n = 0; n < cells[0].length; ++n) {
                if (i2 == 1) {
                    if (this.isMean(n)) {
                        startMeans[j] = line.length();
                        ++j;
                    }
                    if (this.isSignificance(n)) {
                        startSigs[k] = line.length();
                        ++k;
                    }
                }
                if (n == 0) {
                    line = line + this.padString(cells[i2][n], this.getRowNameWidth());
                    line = !this.isAverage(i2) ? line + this.padString("(" + Utils.doubleToString(this.getCount(this.getDisplayRow(i2 - 1)), 0) + ")", this.getCountWidth(), true) : line + this.padString("", this.getCountWidth(), true);
                } else {
                    if (this.isMean(n)) {
                        line = line + "  ";
                    }
                    line = this.getShowStdDev() ? (this.isMean(n - 1) ? (!cells[i2][n].trim().equals("") ? line + "(" + cells[i2][n] + ")" : line + " " + cells[i2][n] + " ") : line + " " + cells[i2][n]) : line + " " + cells[i2][n];
                }
                if (n != indexBase) continue;
                line = line + " |";
            }
            if (i2 == 1) {
                maxLength = line.length();
            }
            body.append(line + "\n");
        }
        line = this.padString(cells[0][0], startMeans[0]);
        i2 = -1;
        for (n = 1; n < cells[0].length; ++n) {
            if (!this.isMean(n)) continue;
            if (++i2 == 0) {
                line = this.padString(line, startMeans[i2] - this.getCountWidth());
            } else if (i2 == 1) {
                line = this.padString(line, startMeans[i2] - " |".length());
            } else if (i2 > 1) {
                line = this.padString(line, startMeans[i2]);
            }
            if (i2 == 1) {
                line = line + " |";
            }
            line = line + " " + cells[0][n];
        }
        line = this.padString(line, maxLength);
        head.append(line + "\n");
        head.append(line.replaceAll(".", "-") + "\n");
        body.append(line.replaceAll(".", "-") + "\n");
        if (this.getColCount() > 1) {
            line = this.padString(cells[cells.length - 1][0], startMeans[1] - 2, true) + " |";
            i2 = 0;
            for (n = 1; n < cells[cells.length - 1].length; ++n) {
                if (!this.isSignificance(n)) continue;
                line = this.padString(line, startSigs[i2] + 1 - cells[cells.length - 1][n].length());
                line = line + " " + cells[cells.length - 1][n];
                ++i2;
            }
            line = this.padString(line, maxLength);
        } else {
            line = this.padString(cells[cells.length - 1][0], line.length() - 2) + " |";
        }
        foot.append(line + "\n");
        result.append(head.toString());
        result.append(body.toString());
        result.append(foot.toString());
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "Key:\n";
        for (int i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            result = result + this.LEFT_PARENTHESES + (i2 + 1) + this.RIGHT_PARENTHESES + " " + this.removeFilterName(this.m_ColNames[i2]) + "\n";
        }
        return result;
    }

    @Override
    public String toStringSummary() {
        int i2;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String result = "";
        String titles = "";
        int resultsetLength = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        for (i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            titles = titles + " " + Utils.padLeft("" + this.getSummaryTitle(i2), resultsetLength * 2 + 3);
        }
        result = result + titles + "  (No. of datasets where [col] >> [row])\n";
        for (i2 = 0; i2 < this.getColCount(); ++i2) {
            if (this.getColHidden(i2)) continue;
            for (int j = 0; j < this.getColCount(); ++j) {
                if (this.getColHidden(j)) continue;
                result = result + " ";
                result = j == i2 ? result + Utils.padLeft("-", resultsetLength * 2 + 3) : result + Utils.padLeft("" + this.m_NonSigWins[i2][j] + " (" + this.m_Wins[i2][j] + ")", resultsetLength * 2 + 3);
            }
            result = result + " | " + this.getSummaryTitle(i2) + " = " + this.getColName(i2) + '\n';
        }
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int biggest = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int width = Math.max(2 + (int)(Math.log(biggest) / Math.log(10.0)), ">-<".length());
        String result = Utils.padLeft(">-<", width) + ' ' + Utils.padLeft(">", width) + ' ' + Utils.padLeft("<", width) + " Resultset\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        for (int i2 = this.getColCount() - 1; i2 >= 0; --i2) {
            int curr = ranking[i2];
            if (this.getColHidden(curr)) continue;
            result = result + Utils.padLeft("" + this.m_RankingDiff[curr], width) + ' ' + Utils.padLeft("" + this.m_RankingWins[curr], width) + ' ' + Utils.padLeft("" + this.m_RankingLosses[curr], width) + ' ' + this.removeFilterName(this.m_ColNames[curr]) + '\n';
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10204 $");
    }

    public static void main(String[] args) {
        ResultMatrixPlainText matrix = new ResultMatrixPlainText(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i2 = 0; i2 < matrix.getRowCount(); ++i2) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i2, (i2 + 1) * n);
                matrix.setStdDev(n, i2, (double)(i2 + 1) * (double)n / 100.0);
                if (i2 != n) continue;
                if (i2 % 2 == 1) {
                    matrix.setSignificance(n, i2, 1);
                    continue;
                }
                matrix.setSignificance(n, i2, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)matrix).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

