/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.SupervisedFilter;
import weka.filters.unsupervised.attribute.Discretize;

public class ClassBalancer
extends SimpleBatchFilter
implements SupervisedFilter,
WeightedInstancesHandler {
    static final long serialVersionUID = 6237337831221353842L;
    protected int m_NumIntervals = 10;

    @OptionMetadata(displayName="Number of discretization intervals", description="The number of discretization intervals to use when the class is numeric.", displayOrder=1, commandLineParamName="num-intervals", commandLineParamSynopsis="-num-intervals <int>", commandLineParamIsFlag=false)
    public int getNumIntervals() {
        return this.m_NumIntervals;
    }

    public void setNumIntervals(int num) {
        this.m_NumIntervals = num;
    }

    @Override
    public String globalInfo() {
        return "Reweights the instances in the data so that each class has the same total weight. The total sum of weights across all instances will be maintained. Only the weights in the first batch of data received by this filter are changed, so it can be used with the FilteredClassifier. If the class is numeric, the class is discretized using equal-width discretization to establish pseudo classes for weighting.";
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        return new Instances(inputFormat, 0);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (this.isFirstBatchDone()) {
            return new Instances(instances);
        }
        Instances dataToUseForMakingWeights = instances;
        if (instances.classAttribute().isNumeric()) {
            Discretize discretizer = new Discretize();
            discretizer.setBins(this.m_NumIntervals);
            discretizer.setIgnoreClass(true);
            int[] indices = new int[]{instances.classIndex()};
            discretizer.setAttributeIndicesArray(indices);
            discretizer.setInputFormat(instances);
            dataToUseForMakingWeights = Filter.useFilter(instances, discretizer);
        }
        double[] sumOfWeightsPerClass = new double[dataToUseForMakingWeights.numClasses()];
        for (int i2 = 0; i2 < dataToUseForMakingWeights.numInstances(); ++i2) {
            Instance inst = dataToUseForMakingWeights.instance(i2);
            int n = (int)inst.classValue();
            sumOfWeightsPerClass[n] = sumOfWeightsPerClass[n] + inst.weight();
        }
        double sumOfWeights = Utils.sum(sumOfWeightsPerClass);
        Instances result = new Instances(instances);
        double factor = sumOfWeights / (double)dataToUseForMakingWeights.numClasses();
        for (int i3 = 0; i3 < result.numInstances(); ++i3) {
            result.instance(i3).setWeight(factor * result.instance(i3).weight() / sumOfWeightsPerClass[(int)dataToUseForMakingWeights.instance(i3).classValue()]);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] args) {
        ClassBalancer.runFilter(new ClassBalancer(), args);
    }
}

