/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class Resample
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 7079064953548300681L;
    protected double m_SampleSizePercent = 100.0;
    protected int m_RandomSeed = 1;
    protected double m_BiasToUniformClass = 0.0;
    protected boolean m_NoReplacement = false;
    protected boolean m_InvertSelection = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset using either sampling with replacement or without replacement.\nThe original dataset must fit entirely in memory. The number of instances in the generated dataset may be specified. The dataset must have a nominal class attribute. If not, use the unsupervised version. The filter can be made to maintain the class distribution in the subsample, or to bias the class distribution toward a uniform distribution. When used in batch mode (i.e. in the FilteredClassifier), subsequent batches are NOT resampled.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>(5);
        result.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        result.addElement(new Option("\tThe size of the output dataset, as a percentage of\n\tthe input dataset (default 100)", "Z", 1, "-Z <num>"));
        result.addElement(new Option("\tBias factor towards uniform class distribution.\n\t0 = distribution in input data -- 1 = uniform distribution.\n\t(default 0)", "B", 1, "-B <num>"));
        result.addElement(new Option("\tDisables replacement of instances\n\t(default: with replacement)", "no-replacement", 0, "-no-replacement"));
        result.addElement(new Option("\tInverts the selection - only available with '-no-replacement'.", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setRandomSeed(Integer.parseInt(tmpStr));
        } else {
            this.setRandomSeed(1);
        }
        tmpStr = Utils.getOption('B', options);
        if (tmpStr.length() != 0) {
            this.setBiasToUniformClass(Double.parseDouble(tmpStr));
        } else {
            this.setBiasToUniformClass(0.0);
        }
        tmpStr = Utils.getOption('Z', options);
        if (tmpStr.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(tmpStr));
        } else {
            this.setSampleSizePercent(100.0);
        }
        this.setNoReplacement(Utils.getFlag("no-replacement", options));
        if (this.getNoReplacement()) {
            this.setInvertSelection(Utils.getFlag('V', options));
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-B");
        result.add("" + this.getBiasToUniformClass());
        result.add("-S");
        result.add("" + this.getRandomSeed());
        result.add("-Z");
        result.add("" + this.getSampleSizePercent());
        if (this.getNoReplacement()) {
            result.add("-no-replacement");
            if (this.getInvertSelection()) {
                result.add("-V");
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String biasToUniformClassTipText() {
        return "Whether to use bias towards a uniform class. A value of 0 leaves the class distribution as-is, a value of 1 ensures the class distribution is uniform in the output data.";
    }

    public double getBiasToUniformClass() {
        return this.m_BiasToUniformClass;
    }

    public void setBiasToUniformClass(double newBiasToUniformClass) {
        this.m_BiasToUniformClass = newBiasToUniformClass;
    }

    public String randomSeedTipText() {
        return "Sets the random number seed for subsampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int newSeed) {
        this.m_RandomSeed = newSeed;
    }

    public String sampleSizePercentTipText() {
        return "The subsample size as a percentage of the original set.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double newSampleSizePercent) {
        this.m_SampleSizePercent = newSampleSizePercent;
    }

    public String noReplacementTipText() {
        return "Disables the replacement of instances.";
    }

    public boolean getNoReplacement() {
        return this.m_NoReplacement;
    }

    public void setNoReplacement(boolean value) {
        this.m_NoReplacement = value;
    }

    public String invertSelectionTipText() {
        return "Inverts the selection (only if instances are drawn WITHOUT replacement).";
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public void setInvertSelection(boolean value) {
        this.m_InvertSelection = value;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected void createSubsample() {
        int i2;
        Instances data = this.getInputFormat();
        double[] numInstancesPerClass = new double[data.numClasses()];
        for (Instance instance : data) {
            int n = (int)instance.classValue();
            numInstancesPerClass[n] = numInstancesPerClass[n] + 1.0;
        }
        Instance[][] instancesPerClass = new Instance[data.numClasses()][];
        int numActualClasses = 0;
        for (int i3 = 0; i3 < data.numClasses(); ++i3) {
            instancesPerClass[i3] = new Instance[(int)numInstancesPerClass[i3]];
            if (!(numInstancesPerClass[i3] > 0.0)) continue;
            ++numActualClasses;
        }
        int[] counterPerClass = new int[data.numClasses()];
        for (Instance instance : data) {
            int classValue;
            int n = classValue = (int)instance.classValue();
            int n2 = counterPerClass[n];
            counterPerClass[n] = n2 + 1;
            instancesPerClass[classValue][n2] = instance;
        }
        int[] numInstancesToSample = new int[data.numClasses()];
        for (int i4 = 0; i4 < data.numClasses(); ++i4) {
            if (numInstancesPerClass[i4] == 0.0) continue;
            int sampleSize = (int)(this.m_SampleSizePercent / 100.0 * ((1.0 - this.m_BiasToUniformClass) * numInstancesPerClass[i4] + this.m_BiasToUniformClass * (double)data.numInstances() / (double)numActualClasses));
            if (this.getNoReplacement() && (double)sampleSize > numInstancesPerClass[i4]) {
                System.err.println("WARNING: Not enough instances of " + data.classAttribute().value(i4) + " for selected value of bias parameter in supervised Resample filter when sampling without replacement.");
                sampleSize = (int)numInstancesPerClass[i4];
            }
            numInstancesToSample[i4] = sampleSize;
        }
        Random random = new Random(this.m_RandomSeed);
        if (!this.getNoReplacement()) {
            for (i2 = 0; i2 < data.numClasses(); ++i2) {
                int numEligible = (int)numInstancesPerClass[i2];
                for (int j = 0; j < numInstancesToSample[i2]; ++j) {
                    this.push(instancesPerClass[i2][random.nextInt(numEligible)]);
                }
            }
        } else {
            for (i2 = 0; i2 < data.numClasses(); ++i2) {
                int j;
                int numEligible = (int)numInstancesPerClass[i2];
                int[] selected = new int[numEligible];
                for (j = 0; j < numEligible; ++j) {
                    selected[j] = j;
                }
                for (j = 0; j < numInstancesToSample[i2]; ++j) {
                    int chosenLocation = random.nextInt(numEligible);
                    int chosen = selected[chosenLocation];
                    selected[chosenLocation] = selected[--numEligible];
                    selected[numEligible] = chosen;
                }
                if (this.getInvertSelection()) {
                    for (j = 0; j < numEligible; ++j) {
                        this.push(instancesPerClass[i2][selected[j]]);
                    }
                    continue;
                }
                for (j = numEligible; j < (int)numInstancesPerClass[i2]; ++j) {
                    this.push(instancesPerClass[i2][selected[j]]);
                }
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11310 $");
    }

    public static void main(String[] argv) {
        Resample.runFilter(new Resample(), argv);
    }
}

