/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class Center
extends PotentialClassIgnorer
implements UnsupervisedFilter,
Sourcable {
    private static final long serialVersionUID = -9101338448900581023L;
    private double[] m_Means;

    public String globalInfo() {
        return "Centers all numeric attributes in the given dataset to have zero mean (apart from the class attribute, if set).";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_Means = null;
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Means == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Means == null) {
            int i2;
            Instances input = this.getInputFormat();
            this.m_Means = new double[input.numAttributes()];
            for (i2 = 0; i2 < input.numAttributes(); ++i2) {
                if (!input.attribute(i2).isNumeric() || input.classIndex() == i2) continue;
                this.m_Means[i2] = input.meanOrMode(i2);
            }
            for (i2 = 0; i2 < input.numInstances(); ++i2) {
                this.convertInstance(input.instance(i2));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) {
        AbstractInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] newVals = new double[instance.numAttributes()];
            int[] newIndices = new int[instance.numAttributes()];
            double[] vals = instance.toDoubleArray();
            int ind = 0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                double value;
                if (instance.attribute(j).isNumeric() && !Utils.isMissingValue(vals[j]) && this.getInputFormat().classIndex() != j) {
                    value = vals[j] - this.m_Means[j];
                    if (value == 0.0) continue;
                    newVals[ind] = value;
                    newIndices[ind] = j;
                    ++ind;
                    continue;
                }
                value = vals[j];
                if (value == 0.0) continue;
                newVals[ind] = value;
                newIndices[ind] = j;
                ++ind;
            }
            double[] tempVals = new double[ind];
            int[] tempInd = new int[ind];
            System.arraycopy(newVals, 0, tempVals, 0, ind);
            System.arraycopy(newIndices, 0, tempInd, 0, ind);
            inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
        } else {
            double[] vals = instance.toDoubleArray();
            for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
                if (!instance.attribute(j).isNumeric() || Utils.isMissingValue(vals[j]) || this.getInputFormat().classIndex() == j) continue;
                vals[j] = vals[j] - this.m_Means[j];
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst, false);
    }

    @Override
    public String toSource(String className, Instances data) throws Exception {
        StringBuffer result = new StringBuffer();
        boolean[] process = new boolean[data.numAttributes()];
        for (int i2 = 0; i2 < data.numAttributes(); ++i2) {
            process[i2] = data.attribute(i2).isNumeric() && i2 != data.classIndex();
        }
        result.append("class " + className + " {\n");
        result.append("\n");
        result.append("  /** lists which attributes will be processed */\n");
        result.append("  protected final static boolean[] PROCESS = new boolean[]{" + Utils.arrayToString(process) + "};\n");
        result.append("\n");
        result.append("  /** the computed means */\n");
        result.append("  protected final static double[] MEANS = new double[]{" + Utils.arrayToString(this.m_Means) + "};\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters a single row\n");
        result.append("   * \n");
        result.append("   * @param i the row to process\n");
        result.append("   * @return the processed row\n");
        result.append("   */\n");
        result.append("  public static Object[] filter(Object[] i) {\n");
        result.append("    Object[] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      if (PROCESS[n] && (i[n] != null))\n");
        result.append("        result[n] = ((Double) i[n]) - MEANS[n];\n");
        result.append("      else\n");
        result.append("        result[n] = i[n];\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters multiple rows\n");
        result.append("   * \n");
        result.append("   * @param i the rows to process\n");
        result.append("   * @return the processed rows\n");
        result.append("   */\n");
        result.append("  public static Object[][] filter(Object[][] i) {\n");
        result.append("    Object[][] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length][];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      result[n] = filter(i[n]);\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("}\n");
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] args) {
        Center.runFilter(new Center(), args);
    }
}

