/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.expressionlanguage.common.IfElseMacro;
import weka.core.expressionlanguage.common.JavaMacro;
import weka.core.expressionlanguage.common.MacroDeclarationsCompositor;
import weka.core.expressionlanguage.common.MathFunctions;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.common.SimpleVariableDeclarations;
import weka.core.expressionlanguage.common.VariableDeclarationsCompositor;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.parser.Parser;
import weka.core.expressionlanguage.weka.InstancesHelper;
import weka.core.expressionlanguage.weka.StatsHelper;
import weka.experiment.Stats;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class MathExpression
extends PotentialClassIgnorer
implements UnsupervisedFilter {
    static final long serialVersionUID = -3713222714671997901L;
    protected Range m_SelectCols = new Range();
    public static final String m_defaultExpression = "(A-MIN)/(MAX-MIN)";
    private String m_expression = "(A-MIN)/(MAX-MIN)";
    private Primitives.DoubleExpression m_CompiledExpression;
    private Stats[] m_attStats;
    private InstancesHelper m_InstancesHelper;
    private StatsHelper m_StatsHelper;
    private SimpleVariableDeclarations.VariableInitializer m_CurrentValue;

    public MathExpression() {
        this.setInvertSelection(false);
    }

    public String globalInfo() {
        return "Modify numeric attributes according to a given expression ";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        this.m_SelectCols.setUpper(instanceInfo.numAttributes() - 1);
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_attStats = new Stats[instanceInfo.numAttributes()];
        for (int i2 = 0; i2 < instanceInfo.numAttributes(); ++i2) {
            if (!this.m_SelectCols.isInRange(i2) || !instanceInfo.attribute(i2).isNumeric() || instanceInfo.classIndex() == i2) continue;
            this.m_attStats[i2] = new Stats();
        }
        if (instanceInfo != null) {
            this.compile();
        }
        return true;
    }

    private void compile() throws Exception {
        this.m_InstancesHelper = new InstancesHelper(this.getInputFormat());
        this.m_StatsHelper = new StatsHelper();
        SimpleVariableDeclarations currentValueDeclaration = new SimpleVariableDeclarations();
        currentValueDeclaration.addDouble("A");
        Node node = Parser.parse(this.m_expression, new VariableDeclarationsCompositor(this.m_InstancesHelper, this.m_StatsHelper, currentValueDeclaration), new MacroDeclarationsCompositor(this.m_InstancesHelper, new MathFunctions(), new IfElseMacro(), new JavaMacro()));
        if (!(node instanceof Primitives.DoubleExpression)) {
            throw new Exception("Expression must be of type double!");
        }
        this.m_CurrentValue = currentValueDeclaration.getInitializer();
        this.m_CompiledExpression = (Primitives.DoubleExpression)node;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!this.m_FirstBatchDone) {
            for (int i2 = 0; i2 < instance.numAttributes(); ++i2) {
                if (!this.m_SelectCols.isInRange(i2) || !instance.attribute(i2).isNumeric() || this.getInputFormat().classIndex() == i2 || instance.isMissing(i2)) continue;
                this.m_attStats[i2].add(instance.value(i2), instance.weight());
            }
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.m_FirstBatchDone) {
            int i2;
            Instances input = this.getInputFormat();
            for (i2 = 0; i2 < input.numAttributes(); ++i2) {
                if (!this.m_SelectCols.isInRange(i2) || !input.attribute(i2).isNumeric() || input.classIndex() == i2) continue;
                this.m_attStats[i2].calculateDerived();
            }
            for (i2 = 0; i2 < input.numInstances(); ++i2) {
                this.convertInstance(input.instance(i2));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) throws Exception {
        double[] vals = instance.toDoubleArray();
        for (int i2 = 0; i2 < instance.numAttributes(); ++i2) {
            double value;
            if (!this.m_SelectCols.isInRange(i2) || !instance.attribute(i2).isNumeric() || Utils.isMissingValue(vals[i2]) || this.getInputFormat().classIndex() == i2) continue;
            this.m_InstancesHelper.setInstance(instance);
            this.m_StatsHelper.setStats(this.m_attStats[i2]);
            if (this.m_CurrentValue.hasVariable("A")) {
                this.m_CurrentValue.setDouble("A", vals[i2]);
            }
            if (Double.isNaN(value = this.m_CompiledExpression.evaluate()) || Double.isInfinite(value) || this.m_InstancesHelper.missingAccessed()) {
                System.err.println("WARNING:Error in evaluating the expression: missing value set");
                vals[i2] = Utils.missingValue();
                continue;
            }
            vals[i2] = value;
        }
        AbstractInstance outInstance = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        outInstance.setDataset(instance.dataset());
        this.push(outInstance, false);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String expString = Utils.getOption('E', options);
        if (expString.length() != 0) {
            this.setExpression(expString);
        } else {
            this.setExpression(m_defaultExpression);
        }
        String ignoreList = Utils.getOption('R', options);
        if (ignoreList.length() != 0) {
            this.setIgnoreRange(ignoreList);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-E");
        result.add(this.getExpression());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        if (!this.getIgnoreRange().equals("")) {
            result.add("-R");
            result.add(this.getIgnoreRange());
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecify the expression to apply. Eg. pow(A,6)/(MEAN+MAX)\n\tSupported operators are +, -, *, /, pow, log,\n\tabs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ), \n\tMEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse. The 'A'\n\tletter refers to the value of the attribute being processed.\n\tOther attribute values (numeric only) can be accessed through\n\tthe variables A1, A2, A3, ...", "E", 1, "-E <expression>"));
        result.addElement(new Option("\tSpecify list of columns to ignore. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        result.addElement(new Option("\tInvert matching sense (i.e. only modify specified columns)", "V", 0, "-V"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public String expressionTipText() {
        return "Specify the expression to apply. The 'A' letterrefers to the value of the attribute being processed. MIN,MAX,MEAN,SDrefer respectively to minimum, maximum, mean andstandard deviation of the attribute being processed. Other attribute values (numeric only) can be accessed through the variables A1, A2, A3, ...\n\tSupported operators are +, -, *, /, pow, log,abs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ),A,MEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse\n\tEg. pow(A,6)/(MEAN+MAX)*ifelse(A<0,0,sqrt(A))+ifelse(![A>9 && A<15])";
    }

    public void setExpression(String expr) throws Exception {
        this.m_expression = expr;
        if (this.getInputFormat() != null) {
            this.compile();
        }
    }

    public String getExpression() {
        return this.m_expression;
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or unselect. If set to true, only the specified attributes will be modified; If set to false, specified attributes will not be modified.";
    }

    public boolean getInvertSelection() {
        return !this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_SelectCols.setInvert(!invert);
    }

    public String ignoreRangeTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getIgnoreRange() {
        return this.m_SelectCols.getRanges();
    }

    public void setIgnoreRange(String rangeList) {
        this.m_SelectCols.setRanges(rangeList);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] argv) {
        MathExpression.runFilter(new MathExpression(), argv);
    }
}

