/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class Normalize
extends PotentialClassIgnorer
implements UnsupervisedFilter,
Sourcable,
OptionHandler {
    static final long serialVersionUID = -8158531150984362898L;
    protected double[] m_MinArray;
    protected double[] m_MaxArray;
    protected double m_Translation = 0.0;
    protected double m_Scale = 1.0;

    public String globalInfo() {
        return "Normalizes all numeric values in the given dataset (apart from the class attribute, if set). The resulting values are by default in [0,1] for the data used to compute the normalization intervals. But with the scale and translation parameters one can change that, e.g., with scale = 2.0 and translation = -1.0 you get values in the range [-1,+1].";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe scaling factor for the output range.\n\t(default: 1.0)", "S", 1, "-S <num>"));
        result.addElement(new Option("\tThe translation of the output range.\n\t(default: 0.0)", "T", 1, "-T <num>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setScale(Double.parseDouble(tmpStr));
        } else {
            this.setScale(1.0);
        }
        tmpStr = Utils.getOption('T', options);
        if (tmpStr.length() != 0) {
            this.setTranslation(Double.parseDouble(tmpStr));
        } else {
            this.setTranslation(0.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-S");
        result.add("" + this.getScale());
        result.add("-T");
        result.add("" + this.getTranslation());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_MaxArray = null;
        this.m_MinArray = null;
        return true;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_MinArray == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_MinArray == null) {
            int i2;
            Instances input = this.getInputFormat();
            this.m_MinArray = new double[input.numAttributes()];
            this.m_MaxArray = new double[input.numAttributes()];
            for (i2 = 0; i2 < input.numAttributes(); ++i2) {
                this.m_MinArray[i2] = Double.NaN;
            }
            for (int j = 0; j < input.numInstances(); ++j) {
                double[] value = input.instance(j).toDoubleArray();
                for (int i3 = 0; i3 < input.numAttributes(); ++i3) {
                    if (!input.attribute(i3).isNumeric() || input.classIndex() == i3 || Utils.isMissingValue(value[i3])) continue;
                    if (Double.isNaN(this.m_MinArray[i3])) {
                        this.m_MinArray[i3] = this.m_MaxArray[i3] = value[i3];
                        continue;
                    }
                    if (value[i3] < this.m_MinArray[i3]) {
                        this.m_MinArray[i3] = value[i3];
                    }
                    if (!(value[i3] > this.m_MaxArray[i3])) continue;
                    this.m_MaxArray[i3] = value[i3];
                }
            }
            for (i2 = 0; i2 < input.numInstances(); ++i2) {
                this.convertInstance(input.instance(i2));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected void convertInstance(Instance instance) throws Exception {
        AbstractInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] newVals = new double[instance.numAttributes()];
            int[] newIndices = new int[instance.numAttributes()];
            double[] vals = instance.toDoubleArray();
            int ind = 0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                double value;
                if (instance.attribute(j).isNumeric() && !Utils.isMissingValue(vals[j]) && this.getInputFormat().classIndex() != j) {
                    if (Double.isNaN(this.m_MinArray[j]) || this.m_MaxArray[j] == this.m_MinArray[j]) {
                        value = 0.0;
                    } else {
                        value = (vals[j] - this.m_MinArray[j]) / (this.m_MaxArray[j] - this.m_MinArray[j]) * this.m_Scale + this.m_Translation;
                        if (Double.isNaN(value)) {
                            throw new Exception("A NaN value was generated while normalizing " + instance.attribute(j).name());
                        }
                    }
                    if (value == 0.0) continue;
                    newVals[ind] = value;
                    newIndices[ind] = j;
                    ++ind;
                    continue;
                }
                value = vals[j];
                if (value == 0.0) continue;
                newVals[ind] = value;
                newIndices[ind] = j;
                ++ind;
            }
            double[] tempVals = new double[ind];
            int[] tempInd = new int[ind];
            System.arraycopy(newVals, 0, tempVals, 0, ind);
            System.arraycopy(newIndices, 0, tempInd, 0, ind);
            inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
        } else {
            double[] vals = instance.toDoubleArray();
            for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
                if (!instance.attribute(j).isNumeric() || Utils.isMissingValue(vals[j]) || this.getInputFormat().classIndex() == j) continue;
                if (Double.isNaN(this.m_MinArray[j]) || this.m_MaxArray[j] == this.m_MinArray[j]) {
                    vals[j] = 0.0;
                    continue;
                }
                vals[j] = (vals[j] - this.m_MinArray[j]) / (this.m_MaxArray[j] - this.m_MinArray[j]) * this.m_Scale + this.m_Translation;
                if (!Double.isNaN(vals[j])) continue;
                throw new Exception("A NaN value was generated while normalizing " + instance.attribute(j).name());
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst, false);
    }

    @Override
    public String toSource(String className, Instances data) throws Exception {
        StringBuffer result = new StringBuffer();
        boolean[] process = new boolean[data.numAttributes()];
        for (int i2 = 0; i2 < data.numAttributes(); ++i2) {
            process[i2] = data.attribute(i2).isNumeric() && i2 != data.classIndex();
        }
        result.append("class " + className + " {\n");
        result.append("\n");
        result.append("  /** lists which attributes will be processed */\n");
        result.append("  protected final static boolean[] PROCESS = new boolean[]{" + Utils.arrayToString(process) + "};\n");
        result.append("\n");
        result.append("  /** the minimum values for numeric values */\n");
        result.append("  protected final static double[] MIN = new double[]{" + Utils.arrayToString(this.m_MinArray).replaceAll("NaN", "Double.NaN") + "};\n");
        result.append("\n");
        result.append("  /** the maximum values for numeric values */\n");
        result.append("  protected final static double[] MAX = new double[]{" + Utils.arrayToString(this.m_MaxArray) + "};\n");
        result.append("\n");
        result.append("  /** the scale factor */\n");
        result.append("  protected final static double SCALE = " + this.m_Scale + ";\n");
        result.append("\n");
        result.append("  /** the translation */\n");
        result.append("  protected final static double TRANSLATION = " + this.m_Translation + ";\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters a single row\n");
        result.append("   * \n");
        result.append("   * @param i the row to process\n");
        result.append("   * @return the processed row\n");
        result.append("   */\n");
        result.append("  public static Object[] filter(Object[] i) {\n");
        result.append("    Object[] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      if (PROCESS[n] && (i[n] != null)) {\n");
        result.append("        if (Double.isNaN(MIN[n]) || (MIN[n] == MAX[n]))\n");
        result.append("          result[n] = 0;\n");
        result.append("        else\n");
        result.append("          result[n] = (((Double) i[n]) - MIN[n]) / (MAX[n] - MIN[n]) * SCALE + TRANSLATION;\n");
        result.append("      }\n");
        result.append("      else {\n");
        result.append("        result[n] = i[n];\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters multiple rows\n");
        result.append("   * \n");
        result.append("   * @param i the rows to process\n");
        result.append("   * @return the processed rows\n");
        result.append("   */\n");
        result.append("  public static Object[][] filter(Object[][] i) {\n");
        result.append("    Object[][] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length][];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      result[n] = filter(i[n]);\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("}\n");
        return result.toString();
    }

    public double[] getMinArray() {
        return this.m_MinArray;
    }

    public double[] getMaxArray() {
        return this.m_MaxArray;
    }

    public String scaleTipText() {
        return "The factor for scaling the output range (default: 1).";
    }

    public double getScale() {
        return this.m_Scale;
    }

    public void setScale(double value) {
        this.m_Scale = value;
    }

    public String translationTipText() {
        return "The translation of the output range (default: 0).";
    }

    public double getTranslation() {
        return this.m_Translation;
    }

    public void setTranslation(double value) {
        this.m_Translation = value;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] args) {
        Normalize.runFilter(new Normalize(), args);
    }
}

