/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class NumericToNominal
extends SimpleBatchFilter {
    private static final long serialVersionUID = -6614630932899796239L;
    protected static final int MAX_DECIMALS = 6;
    protected Range m_Cols = new Range("first-last");
    protected String m_DefaultCols = "first-last";

    @Override
    public String globalInfo() {
        return "A filter for turning numeric attributes into nominal ones. Unlike discretization, it just takes all numeric values and adds them to the list of nominal values of that attribute. Useful after CSV imports, to enforce certain attributes to become nominal, e.g., the class attribute, containing values from 1 to 5.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>(2);
        result.addElement(new Option("\tSpecifies list of columns to Discretize. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setInvertSelection(Utils.getFlag('V', options));
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices(this.m_DefaultCols);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (!this.getAttributeIndices().equals("")) {
            result.add("-R");
            result.add(this.getAttributeIndices());
        }
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected (numeric) attributes in the range will be 'nominalized'; if true, only non-selected attributes will be 'nominalized'.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean value) {
        this.m_Cols.setInvert(value);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String value) {
        this.m_Cols.setRanges(value);
    }

    public void setAttributeIndicesArray(int[] value) {
        this.setAttributeIndices(Range.indicesToRangeList(value));
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_Cols.setUpper(inputFormat.numAttributes() - 1);
        Instances data = new Instances(inputFormat);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i2 = 0; i2 < data.numAttributes(); ++i2) {
            if (!this.m_Cols.isInRange(i2) || !data.attribute(i2).isNumeric()) {
                atts.add(data.attribute(i2));
                continue;
            }
            boolean isDate = data.attribute(i2).type() == 3;
            HashSet<Double> hash = new HashSet<Double>();
            for (int n = 0; n < data.numInstances(); ++n) {
                Instance inst = data.instance(n);
                if (inst.isMissing(i2)) continue;
                hash.add(new Double(inst.value(i2)));
            }
            Vector<Double> sorted = new Vector<Double>();
            for (Double o : hash) {
                sorted.add(o);
            }
            Collections.sort(sorted);
            ArrayList<String> values = new ArrayList<String>();
            for (Double o : sorted) {
                if (isDate) {
                    values.add(data.attribute(i2).formatDate(o));
                    continue;
                }
                values.add(Utils.doubleToString(o, 6));
            }
            Attribute newAtt = new Attribute(data.attribute(i2).name(), values);
            newAtt.setWeight(data.attribute(i2).weight());
            atts.add(newAtt);
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.setOutputFormat(this.determineOutputFormat(this.getInputFormat()));
        }
        Instances result = new Instances(this.getOutputFormat());
        for (int i2 = 0; i2 < instances.numInstances(); ++i2) {
            Instance inst = instances.instance(i2);
            double[] values = inst.toDoubleArray();
            for (int n = 0; n < values.length; ++n) {
                if (!this.m_Cols.isInRange(n) || !instances.attribute(n).isNumeric() || inst.isMissing(n)) continue;
                String value = instances.attribute(n).type() == 3 ? inst.stringValue(n) : Utils.doubleToString(inst.value(n), 6);
                int index = result.attribute(n).indexOfValue(value);
                values[n] = index == -1 ? Utils.missingValue() : (double)index;
            }
            AbstractInstance newInst = inst instanceof SparseInstance ? new SparseInstance(inst.weight(), values) : new DenseInstance(inst.weight(), values);
            this.copyValues(newInst, false, inst.dataset(), this.outputFormatPeek());
            result.add(newInst);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] args) {
        NumericToNominal.runFilter(new NumericToNominal(), args);
    }
}

