/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.Remove;

public class PartitionedMultiFilter
extends SimpleBatchFilter {
    private static final long serialVersionUID = -6293720886005713120L;
    protected Filter[] m_Filters = new Filter[]{new AllFilter()};
    protected Range[] m_Ranges = new Range[]{new Range("first-last")};
    protected boolean m_RemoveUnused = false;
    protected int[] m_IndicesUnused = new int[0];

    @Override
    public String globalInfo() {
        return "A filter that applies filters on subsets of attributes and assembles the output into a new dataset. Attributes that are not covered by any of the ranges can be either retained or removed from the output.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tA filter to apply (can be specified multiple times).", "F", 1, "-F <classname [options]>"));
        result.addElement(new Option("\tAn attribute range (can be specified multiple times).\n\tFor each filter a range must be supplied. 'first' and 'last'\n\tare valid indices. 'inv(...)' around the range denotes an\n\tinverted range.", "R", 1, "-R <range>"));
        result.addElement(new Option("\tFlag for leaving unused attributes out of the output, by default\n\tthese are included in the filter output.", "U", 0, "-U"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        this.setRemoveUnused(Utils.getFlag("U", options));
        Vector<Object> objects = new Vector<Object>();
        while ((tmpStr = Utils.getOption("F", options)).length() != 0) {
            String[] options2 = Utils.splitOptions(tmpStr);
            String classname = options2[0];
            options2[0] = "";
            objects.add(Utils.forName(Filter.class, classname, options2));
        }
        if (objects.size() == 0) {
            objects.add(new AllFilter());
        }
        this.setFilters(objects.toArray(new Filter[objects.size()]));
        objects = new Vector();
        while ((tmpStr = Utils.getOption("R", options)).length() != 0) {
            Range range;
            if (tmpStr.startsWith("inv(") && tmpStr.endsWith(")")) {
                range = new Range(tmpStr.substring(4, tmpStr.length() - 1));
                range.setInvert(true);
            } else {
                range = new Range(tmpStr);
            }
            objects.add(range);
        }
        if (objects.size() == 0) {
            objects.add(new Range("first-last"));
        }
        this.setRanges(objects.toArray(new Range[objects.size()]));
        this.checkDimensions();
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        int i2;
        Vector<String> result = new Vector<String>();
        if (this.getRemoveUnused()) {
            result.add("-U");
        }
        for (i2 = 0; i2 < this.getFilters().length; ++i2) {
            result.add("-F");
            result.add(this.getFilterSpec(this.getFilter(i2)));
        }
        for (i2 = 0; i2 < this.getRanges().length; ++i2) {
            String tmpStr = this.getRange(i2).getRanges();
            if (this.getRange(i2).getInvert()) {
                tmpStr = "inv(" + tmpStr + ")";
            }
            result.add("-R");
            result.add(tmpStr);
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    protected void checkDimensions() throws Exception {
        if (this.getFilters().length != this.getRanges().length) {
            throw new IllegalArgumentException("Number of filters (= " + this.getFilters().length + ") and ranges (= " + this.getRanges().length + ") don't match!");
        }
    }

    @Override
    protected void testInputFormat(Instances instanceInfo) throws Exception {
        for (int i2 = 0; i2 < this.getRanges().length; ++i2) {
            Instances newi = new Instances(instanceInfo, 0);
            if (instanceInfo.size() > 0) {
                newi.add((Instance)instanceInfo.get(0).copy());
            }
            Range range = this.getRanges()[i2];
            range.setUpper(instanceInfo.numAttributes() - 1);
            Instances subset = this.generateSubset(newi, range);
            this.getFilters()[i2].setInputFormat(subset);
        }
    }

    public void setRemoveUnused(boolean value) {
        this.m_RemoveUnused = value;
    }

    public boolean getRemoveUnused() {
        return this.m_RemoveUnused;
    }

    public String removeUnusedTipText() {
        return "If true then unused attributes (ones that are not covered by any of the ranges) will be removed from the output.";
    }

    public void setFilters(Filter[] filters) {
        this.m_Filters = filters;
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The base filters to be used.";
    }

    public Filter getFilter(int index) {
        return this.m_Filters[index];
    }

    protected String getFilterSpec(Filter filter) {
        String result;
        if (filter == null) {
            result = "";
        } else {
            result = filter.getClass().getName();
            if (filter instanceof OptionHandler) {
                result = result + " " + Utils.joinOptions(filter.getOptions());
            }
        }
        return result;
    }

    public void setRanges(Range[] Ranges) {
        this.m_Ranges = Ranges;
        this.reset();
    }

    public Range[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The attribute ranges to be used; 'inv(...)' denotes an inverted range.";
    }

    public Range getRange(int index) {
        return this.m_Ranges[index];
    }

    protected void determineUnusedIndices(Instances data) {
        int i2;
        Vector<Integer> indices = new Vector<Integer>();
        for (i2 = 0; i2 < data.numAttributes(); ++i2) {
            if (i2 == data.classIndex()) continue;
            boolean covered = false;
            for (int n = 0; n < this.getRanges().length; ++n) {
                if (!this.getRanges()[n].isInRange(i2)) continue;
                covered = true;
                break;
            }
            if (covered) continue;
            indices.add(new Integer(i2));
        }
        this.m_IndicesUnused = new int[indices.size()];
        for (i2 = 0; i2 < indices.size(); ++i2) {
            this.m_IndicesUnused[i2] = (Integer)indices.get(i2);
        }
        if (this.getDebug()) {
            System.out.println("Unused indices: " + Utils.arrayToString(this.m_IndicesUnused));
        }
    }

    protected Instances generateSubset(Instances data, Range range) throws Exception {
        int[] indices = range.getSelection();
        StringBuilder atts = new StringBuilder();
        for (int i2 = 0; i2 < indices.length; ++i2) {
            if (i2 > 0) {
                atts.append(",");
            }
            atts.append("" + (indices[i2] + 1));
        }
        if (data.classIndex() > -1 && !range.isInRange(data.classIndex())) {
            atts.append("," + (data.classIndex() + 1));
        }
        Remove filter = new Remove();
        filter.setAttributeIndices(atts.toString());
        filter.setInvertSelection(true);
        filter.setInputFormat(data);
        Instances result = Filter.useFilter(data, filter);
        return result;
    }

    protected Instances renameAttributes(Instances data, String prefix) throws Exception {
        int i2;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i2 = 0; i2 < data.numAttributes(); ++i2) {
            if (i2 == data.classIndex()) {
                atts.add((Attribute)data.attribute(i2).copy());
                continue;
            }
            atts.add(data.attribute(i2).copy(prefix + data.attribute(i2).name()));
        }
        Instances result = new Instances(data.relationName(), atts, data.numInstances());
        for (i2 = 0; i2 < data.numInstances(); ++i2) {
            result.add((Instance)data.instance(i2).copy());
        }
        if (data.classIndex() > -1) {
            result.setClassIndex(data.classIndex());
        }
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Instances result;
        if (!this.isFirstBatchDone()) {
            int i2;
            if (inputFormat.numInstances() == 0) {
                return null;
            }
            this.checkDimensions();
            this.determineUnusedIndices(inputFormat);
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (i2 = 0; i2 < this.getFilters().length; ++i2) {
                Instances processed;
                if (!this.isFirstBatchDone()) {
                    processed = this.generateSubset(inputFormat, this.getRange(i2));
                    if (!this.getFilter(i2).setInputFormat(processed)) {
                        Filter.useFilter(processed, this.getFilter(i2));
                    }
                }
                processed = this.getFilter(i2).getOutputFormat();
                processed = this.renameAttributes(processed, "filtered-" + i2 + "-");
                for (int n = 0; n < processed.numAttributes(); ++n) {
                    if (n == processed.classIndex()) continue;
                    atts.add((Attribute)processed.attribute(n).copy());
                }
            }
            if (!this.getRemoveUnused()) {
                for (i2 = 0; i2 < this.m_IndicesUnused.length; ++i2) {
                    Attribute att = inputFormat.attribute(this.m_IndicesUnused[i2]);
                    atts.add(att.copy("unfiltered-" + att.name()));
                }
            }
            if (inputFormat.classIndex() > -1) {
                atts.add((Attribute)inputFormat.classAttribute().copy());
            }
            result = new Instances(inputFormat.relationName(), atts, 0);
            if (inputFormat.classIndex() > -1) {
                result.setClassIndex(result.numAttributes() - 1);
            }
        } else {
            result = this.getOutputFormat();
        }
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        Instances result;
        int i2;
        if (!this.isFirstBatchDone()) {
            this.checkDimensions();
            for (i2 = 0; i2 < this.m_Ranges.length; ++i2) {
                this.m_Ranges[i2].setUpper(instances.numAttributes() - 1);
            }
            this.determineUnusedIndices(instances);
        }
        Instances[] processed = new Instances[this.getFilters().length];
        for (i2 = 0; i2 < this.getFilters().length; ++i2) {
            processed[i2] = this.generateSubset(instances, this.getRange(i2));
            if (!this.isFirstBatchDone()) {
                this.getFilter(i2).setInputFormat(processed[i2]);
            }
            processed[i2] = Filter.useFilter(processed[i2], this.getFilter(i2));
        }
        if (!this.isFirstBatchDone()) {
            result = this.determineOutputFormat(instances);
            this.setOutputFormat(result);
        } else {
            result = this.getOutputFormat();
        }
        Vector<Integer> errors = new Vector<Integer>();
        for (i2 = 0; i2 < processed.length; ++i2) {
            if (processed[i2].numInstances() == instances.numInstances()) continue;
            errors.add(new Integer(i2));
        }
        if (errors.size() > 0) {
            throw new IllegalStateException("The following filter(s) changed the number of instances: " + errors);
        }
        for (i2 = 0; i2 < instances.numInstances(); ++i2) {
            int n;
            Instance inst = instances.instance(i2);
            double[] values = new double[result.numAttributes()];
            int index = 0;
            for (n = 0; n < processed.length; ++n) {
                for (int m = 0; m < processed[n].numAttributes(); ++m) {
                    if (m == processed[n].classIndex()) continue;
                    values[index] = processed[n].instance(i2).isMissing(m) ? Utils.missingValue() : (result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(processed[n].instance(i2).stringValue(m)) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(processed[n].instance(i2).relationalValue(m)) : processed[n].instance(i2).value(m)));
                    ++index;
                }
            }
            if (!this.getRemoveUnused()) {
                for (n = 0; n < this.m_IndicesUnused.length; ++n) {
                    values[index] = inst.isMissing(this.m_IndicesUnused[n]) ? Utils.missingValue() : (result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(inst.stringValue(this.m_IndicesUnused[n])) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(inst.relationalValue(this.m_IndicesUnused[n])) : inst.value(this.m_IndicesUnused[n])));
                    ++index;
                }
            }
            if (instances.classIndex() > -1) {
                index = values.length - 1;
                values[index] = inst.classIsMissing() ? Utils.missingValue() : (result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(inst.stringValue(instances.classIndex())) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(inst.relationalValue(instances.classIndex())) : inst.value(instances.classIndex())));
            }
            AbstractInstance newInst = inst instanceof SparseInstance ? new SparseInstance(instances.instance(i2).weight(), values) : new DenseInstance(instances.instance(i2).weight(), values);
            result.add(newInst);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 13630 $");
    }

    public static void main(String[] args) {
        PartitionedMultiFilter.runFilter(new PartitionedMultiFilter(), args);
    }
}

