/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.AbstractTimeSeries;

public class TimeSeriesTranslate
extends AbstractTimeSeries {
    static final long serialVersionUID = -8901621509691785705L;

    public String globalInfo() {
        return "An instance filter that assumes instances form time-series data and replaces attribute values in the current instance with the equivalent attribute values of some previous (or future) instance. For instances where the desired value is unknown either the instance may be dropped, or missing values used. Skips the class attribute if it is set.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (instanceInfo.classIndex() > 0 && !this.getFillWithMissing()) {
            throw new IllegalArgumentException("TimeSeriesTranslate: Need to fill in missing values using appropriate option when class index is set.");
        }
        super.setInputFormat(instanceInfo);
        Instances outputFormat = new Instances(instanceInfo, 0);
        for (int i2 = 0; i2 < instanceInfo.numAttributes(); ++i2) {
            if (i2 == instanceInfo.classIndex() || !this.m_SelectedCols.isInRange(i2)) continue;
            if (outputFormat.attribute(i2).isNominal() || outputFormat.attribute(i2).isNumeric()) {
                outputFormat.renameAttribute(i2, outputFormat.attribute(i2).name() + (this.m_InstanceRange < 0 ? (char)'-' : '+') + Math.abs(this.m_InstanceRange));
                continue;
            }
            throw new UnsupportedAttributeTypeException("Only numeric and nominal attributes may be  manipulated in time series.");
        }
        outputFormat.setClassIndex(instanceInfo.classIndex());
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    protected Instance mergeInstances(Instance source, Instance dest) {
        Instances outputFormat = this.outputFormatPeek();
        double[] vals = new double[outputFormat.numAttributes()];
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (i2 != outputFormat.classIndex() && this.m_SelectedCols.isInRange(i2)) {
                if (source != null) {
                    vals[i2] = source.value(i2);
                    continue;
                }
                vals[i2] = Utils.missingValue();
                continue;
            }
            vals[i2] = dest.value(i2);
        }
        AbstractInstance inst = null;
        inst = dest instanceof SparseInstance ? new SparseInstance(dest.weight(), vals) : new DenseInstance(dest.weight(), vals);
        inst.setDataset(dest.dataset());
        return inst;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        TimeSeriesTranslate.runFilter(new TimeSeriesTranslate(), argv);
    }
}

