/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemoveFolds
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 8220373305559055700L;
    private boolean m_Inverse = false;
    private int m_NumFolds = 10;
    private int m_Fold = 1;
    private long m_Seed = 0L;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecifies if inverse of selection is to be output.\n", "V", 0, "-V"));
        newVector.addElement(new Option("\tSpecifies number of folds dataset is split into. \n\t(default 10)\n", "N", 1, "-N <number of folds>"));
        newVector.addElement(new Option("\tSpecifies which fold is selected. (default 1)\n", "F", 1, "-F <fold>"));
        newVector.addElement(new Option("\tSpecifies random number seed. (default 0, no randomizing)\n", "S", 1, "-S <seed>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setInvertSelection(Utils.getFlag('V', options));
        String numFolds = Utils.getOption('N', options);
        if (numFolds.length() != 0) {
            this.setNumFolds(Integer.parseInt(numFolds));
        } else {
            this.setNumFolds(10);
        }
        String fold = Utils.getOption('F', options);
        if (fold.length() != 0) {
            this.setFold(Integer.parseInt(fold));
        } else {
            this.setFold(1);
        }
        String seed = Utils.getOption('S', options);
        if (seed.length() != 0) {
            this.setSeed(Integer.parseInt(seed));
        } else {
            this.setSeed(0L);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-S");
        options.add("" + this.getSeed());
        if (this.getInvertSelection()) {
            options.add("-V");
        }
        options.add("-N");
        options.add("" + this.getNumFolds());
        options.add("-F");
        options.add("" + this.getFold());
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "This filter takes a dataset and outputs a specified fold for cross validation. If you want the folds to be stratified use the supervised version.";
    }

    public String invertSelectionTipText() {
        return "Whether to invert the selection.";
    }

    public boolean getInvertSelection() {
        return this.m_Inverse;
    }

    public void setInvertSelection(boolean inverse) {
        this.m_Inverse = inverse;
    }

    public String numFoldsTipText() {
        return "The number of folds to split the dataset into.";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int numFolds) {
        if (numFolds < 0) {
            throw new IllegalArgumentException("Number of folds has to be positive or zero.");
        }
        this.m_NumFolds = numFolds;
    }

    public String foldTipText() {
        return "The fold which is selected.";
    }

    public int getFold() {
        return this.m_Fold;
    }

    public void setFold(int fold) {
        if (fold < 1) {
            throw new IllegalArgumentException("Fold's index has to be greater than 0.");
        }
        this.m_Fold = fold;
    }

    public String seedTipText() {
        return "the random number seed for shuffling the dataset. If seed is negative, shuffling will not be performed.";
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public void setSeed(long seed) {
        this.m_Seed = seed;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (this.m_NumFolds > 0 && this.m_NumFolds < this.m_Fold) {
            throw new IllegalArgumentException("Fold has to be smaller or equal to number of folds.");
        }
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        Instances instances;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            if (this.m_Seed > 0L) {
                this.getInputFormat().randomize(new Random(this.m_Seed));
            }
            instances = !this.m_Inverse ? this.getInputFormat().testCV(this.m_NumFolds, this.m_Fold - 1) : this.getInputFormat().trainCV(this.m_NumFolds, this.m_Fold - 1);
        } else {
            instances = this.getInputFormat();
        }
        this.flushInput();
        for (int i2 = 0; i2 < instances.numInstances(); ++i2) {
            this.push(instances.instance(i2), false);
        }
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] argv) {
        RemoveFolds.runFilter(new RemoveFolds(), argv);
    }
}

