/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import weka.classifiers.evaluation.Evaluation;
import weka.core.Attribute;
import weka.core.Instances;
import weka.gui.AttributeSelectionPanel;

public class EvaluationMetricSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 4451184027143094270L;
    protected List<String> m_selectedEvalMetrics;

    public EvaluationMetricSelectionDialog(Dialog parent, List<String> evalMetrics) {
        super((Window)parent, "Manage evaluation metrics", Dialog.ModalityType.DOCUMENT_MODAL);
        this.m_selectedEvalMetrics = evalMetrics;
        this.init();
    }

    public EvaluationMetricSelectionDialog(Window parent, List<String> evalMetrics) {
        super(parent, "Manage evaluation metrics", Dialog.ModalityType.DOCUMENT_MODAL);
        this.m_selectedEvalMetrics = evalMetrics;
        this.init();
    }

    public EvaluationMetricSelectionDialog(Frame parent, List<String> evalMetrics) {
        super((Window)parent, "Manage evaluation metrics", Dialog.ModalityType.DOCUMENT_MODAL);
        this.m_selectedEvalMetrics = evalMetrics;
        this.init();
    }

    public List<String> getSelectedEvalMetrics() {
        return this.m_selectedEvalMetrics;
    }

    private void init() {
        int i2;
        final AttributeSelectionPanel evalConfigurer = new AttributeSelectionPanel(true, true, true, true);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        List<String> allEvalMetrics = Evaluation.getAllEvaluationMetricNames();
        for (String s : allEvalMetrics) {
            atts.add(new Attribute(s));
        }
        final Instances metricInstances = new Instances("Metrics", atts, 1);
        boolean[] selectedMetrics = new boolean[metricInstances.numAttributes()];
        if (this.m_selectedEvalMetrics == null) {
            this.m_selectedEvalMetrics = new ArrayList<String>();
            for (i2 = 0; i2 < metricInstances.numAttributes(); ++i2) {
                this.m_selectedEvalMetrics.add(metricInstances.attribute(i2).name());
            }
        }
        for (i2 = 0; i2 < selectedMetrics.length; ++i2) {
            if (!this.m_selectedEvalMetrics.contains(metricInstances.attribute(i2).name())) continue;
            selectedMetrics[i2] = true;
        }
        try {
            evalConfigurer.setInstances(metricInstances);
            evalConfigurer.setSelectedAttributes(selectedMetrics);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.setLayout(new BorderLayout());
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        holder.add((Component)evalConfigurer, "Center");
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        holder.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = evalConfigurer.getSelectedAttributes();
                EvaluationMetricSelectionDialog.this.m_selectedEvalMetrics.clear();
                for (int i2 = 0; i2 < selected.length; ++i2) {
                    EvaluationMetricSelectionDialog.this.m_selectedEvalMetrics.add(metricInstances.attribute(selected[i2]).name());
                }
                EvaluationMetricSelectionDialog.this.dispose();
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvaluationMetricSelectionDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)holder, "Center");
        this.pack();
    }
}

