/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Permission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import weka.classifiers.bayes.net.GUI;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Defaults;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.PluginManager;
import weka.core.Settings;
import weka.core.SystemInfo;
import weka.core.Utils;
import weka.core.Version;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageLibIsolatingClassLoader;
import weka.core.WekaPackageManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.logging.Logger;
import weka.core.scripting.Groovy;
import weka.core.scripting.Jython;
import weka.gui.BrowserHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.GUIChooser;
import weka.gui.GenericObjectEditor;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MainMenuExtension;
import weka.gui.MemoryUsagePanel;
import weka.gui.PackageManager;
import weka.gui.SettingsEditor;
import weka.gui.SimpleCLI;
import weka.gui.WorkbenchApp;
import weka.gui.arffviewer.ArffViewer;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.knowledgeflow.KnowledgeFlowApp;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.gui.scripting.JythonPanel;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class GUIChooserApp
extends JFrame {
    private static final long serialVersionUID = 9001529425230247914L;
    private Settings m_settings;
    protected GUIChooserApp m_Self;
    private JMenuBar m_jMenuBar;
    private JMenu m_jMenuProgram;
    private JMenu m_jMenuVisualization;
    private JMenu m_jMenuTools;
    private JMenu m_jMenuHelp;
    protected Vector<JFrame> m_Frames = new Vector();
    protected JPanel m_PanelApplications = new JPanel();
    protected JButton m_WorkbenchBut = new JButton("Workbench");
    protected JButton m_ExplorerBut = new JButton("Explorer");
    protected JButton m_ExperimenterBut = new JButton("Experimenter");
    protected JButton m_KnowledgeFlowBut = new JButton("KnowledgeFlow");
    protected JButton m_SimpleBut = new JButton("Simple CLI");
    protected static LogWindow m_LogWindow = new LogWindow();
    Image m_weka = Toolkit.getDefaultToolkit().getImage(GUIChooserApp.class.getClassLoader().getResource("weka/gui/images/weka_background.gif"));
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    protected Image m_Icon;
    protected HashSet<Container> m_ChildFrames = new HashSet();
    private static GUIChooserApp m_chooser;
    private static Memory m_Memory;

    public static synchronized void createSingleton() {
        if (m_chooser == null) {
            m_chooser = new GUIChooserApp();
        }
    }

    public static GUIChooserApp getSingleton() {
        return m_chooser;
    }

    public GUIChooserApp() {
        super("Weka GUI Chooser");
        Set<String> pluginNames;
        this.m_Self = this;
        this.m_settings = new Settings("weka", "guichooser");
        GUIChooserDefaults guiChooserDefaults = new GUIChooserDefaults();
        Defaults pmDefaults = WekaPackageManager.getUnderlyingPackageManager().getDefaultSettings();
        guiChooserDefaults.add(pmDefaults);
        this.m_settings.applyDefaults(guiChooserDefaults);
        WekaPackageManager.getUnderlyingPackageManager().applySettings(this.m_settings);
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", "BIF Files (*.bif)"));
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", "XML Files (*.xml)"));
        this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_FileChooserPlot.setMultiSelectionEnabled(true);
        this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_Icon = Toolkit.getDefaultToolkit().getImage(GUIChooserApp.class.getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
        this.setIconImage(this.m_Icon);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_PanelApplications, "East");
        this.m_PanelApplications.setBorder(BorderFactory.createTitledBorder("Applications"));
        this.m_PanelApplications.setLayout(new GridLayout(0, 1));
        this.m_PanelApplications.add(this.m_ExplorerBut);
        this.m_PanelApplications.add(this.m_ExperimenterBut);
        this.m_PanelApplications.add(this.m_KnowledgeFlowBut);
        this.m_PanelApplications.add(this.m_WorkbenchBut);
        this.m_PanelApplications.add(this.m_SimpleBut);
        JPanel wekaPan = new JPanel();
        wekaPan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wekaPan.setLayout(new BorderLayout());
        wekaPan.setToolTipText("Weka, a native bird of New Zealand");
        ImageIcon wii = new ImageIcon(this.m_weka);
        JLabel wekaLab = new JLabel(wii);
        wekaPan.add((Component)wekaLab, "Center");
        String infoString = "<html><font size=-2>Waikato Environment for Knowledge Analysis<br>Version " + Version.VERSION + "<br>(c) " + Copyright.getFromYear() + " - " + Copyright.getToYear() + "<br>" + Copyright.getOwner() + "<br>" + Copyright.getAddress() + "</font></html>";
        JLabel infoLab = new JLabel(infoString);
        infoLab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wekaPan.add((Component)infoLab, "South");
        this.getContentPane().add((Component)wekaPan, "Center");
        this.m_jMenuBar = new JMenuBar();
        this.m_jMenuProgram = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuProgram);
        this.m_jMenuProgram.setText("Program");
        this.m_jMenuProgram.setMnemonic('P');
        JMenuItem jMenuItemProgramLogWindow = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramLogWindow);
        jMenuItemProgramLogWindow.setText("LogWindow");
        jMenuItemProgramLogWindow.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        m_LogWindow.setIconImage(this.m_Icon);
        jMenuItemProgramLogWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m_LogWindow.setVisible(true);
            }
        });
        JMenuItem jMenuItemProgramMemUsage = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramMemUsage);
        jMenuItemProgramMemUsage.setText("Memory usage");
        jMenuItemProgramMemUsage.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        jMenuItemProgramMemUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final MemoryUsagePanel panel = new MemoryUsagePanel();
                final JFrame frame = new JFrame("Memory usage");
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        panel.stopMonitoring();
                        frame.dispose();
                        GUIChooserApp.this.m_Frames.remove(frame);
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(400, 50);
                Point l = panel.getFrameLocation();
                if (l.x != -1 && l.y != -1) {
                    frame.setLocation(l);
                }
                frame.setVisible(true);
                Dimension size = frame.getPreferredSize();
                frame.setSize(new Dimension((int)size.getWidth(), (int)size.getHeight()));
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        JMenuItem jMenuItemSettings = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemSettings);
        jMenuItemSettings.setText("Settings");
        jMenuItemSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int result = SettingsEditor.showSingleSettingsEditor(GUIChooserApp.this.m_settings, "guichooser", "GUIChooser", (JComponent)GUIChooserApp.this.getContentPane().getComponent(0), 550, 100);
                    if (result == 0) {
                        WekaPackageManager.getUnderlyingPackageManager().applySettings(GUIChooserApp.this.m_settings);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.m_jMenuProgram.add(new JSeparator());
        JMenuItem jMenuItemProgramExit = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramExit);
        jMenuItemProgramExit.setText("Exit");
        jMenuItemProgramExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItemProgramExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIChooserApp.this.dispose();
                GUIChooserApp.this.checkExit();
            }
        });
        this.m_jMenuVisualization = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuVisualization);
        this.m_jMenuVisualization.setText("Visualization");
        this.m_jMenuVisualization.setMnemonic('V');
        JMenuItem jMenuItemVisualizationPlot = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationPlot);
        jMenuItemVisualizationPlot.setText("Plot");
        jMenuItemVisualizationPlot.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItemVisualizationPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooserApp.this.m_FileChooserPlot.showOpenDialog(GUIChooserApp.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                VisualizePanel panel = new VisualizePanel();
                String filenames = "";
                File[] files = GUIChooserApp.this.m_FileChooserPlot.getSelectedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String filename = files[j].getAbsolutePath();
                    if (j > 0) {
                        filenames = filenames + ", ";
                    }
                    filenames = filenames + filename;
                    System.err.println("Loading instances from " + filename);
                    try {
                        BufferedReader r = new BufferedReader(new FileReader(filename));
                        Instances i2 = new Instances(r);
                        i2.setClassIndex(i2.numAttributes() - 1);
                        PlotData2D pd1 = new PlotData2D(i2);
                        if (j == 0) {
                            pd1.setPlotName("Master plot");
                            panel.setMasterPlot(pd1);
                            continue;
                        }
                        pd1.setPlotName("Plot " + (j + 1));
                        pd1.m_useCustomColour = true;
                        pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                        panel.addPlot(pd1);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(GUIChooserApp.this.m_Self, "Error loading file '" + files[j] + "':\n" + ex.getMessage());
                        return;
                    }
                }
                final JFrame frame = new JFrame("Plot - " + filenames);
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        GUIChooserApp.this.m_Frames.remove(frame);
                        frame.dispose();
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationROC = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationROC);
        jMenuItemVisualizationROC.setText("ROC");
        jMenuItemVisualizationROC.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItemVisualizationROC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooserApp.this.m_FileChooserROC.showOpenDialog(GUIChooserApp.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooserApp.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                Instances result = null;
                try {
                    result = new Instances(new BufferedReader(new FileReader(filename)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooserApp.this.m_Self, "Error loading file '" + filename + "':\n" + ex.getMessage());
                    return;
                }
                result.setClassIndex(result.numAttributes() - 1);
                ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
                vmc.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(result), 4) + ")");
                vmc.setName(result.relationName());
                PlotData2D tempd = new PlotData2D(result);
                tempd.setPlotName(result.relationName());
                tempd.addInstanceNumberAttribute();
                try {
                    vmc.addPlot(tempd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooserApp.this.m_Self, "Error adding plot:\n" + ex.getMessage());
                    return;
                }
                final JFrame frame = new JFrame("ROC - " + filename);
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)vmc, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        GUIChooserApp.this.m_Frames.remove(frame);
                        frame.dispose();
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationTree = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationTree);
        jMenuItemVisualizationTree.setText("TreeVisualizer");
        jMenuItemVisualizationTree.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItemVisualizationTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooserApp.this.m_FileChooserTreeVisualizer.showOpenDialog(GUIChooserApp.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooserApp.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                TreeBuild builder = new TreeBuild();
                Node top = null;
                PlaceNode2 arrange = new PlaceNode2();
                try {
                    top = builder.create(new FileReader(filename));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooserApp.this.m_Self, "Error loading file '" + filename + "':\n" + ex.getMessage());
                    return;
                }
                final JFrame frame = new JFrame("TreeVisualizer - " + filename);
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)new TreeVisualizer(null, top, (NodePlace)arrange), "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        GUIChooserApp.this.m_Frames.remove(frame);
                        frame.dispose();
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationGraph = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationGraph);
        jMenuItemVisualizationGraph.setText("GraphVisualizer");
        jMenuItemVisualizationGraph.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenuItemVisualizationGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooserApp.this.m_FileChooserGraphVisualizer.showOpenDialog(GUIChooserApp.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooserApp.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                GraphVisualizer panel = new GraphVisualizer();
                try {
                    if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                        panel.readBIF(new FileInputStream(filename));
                    } else {
                        panel.readDOT(new FileReader(filename));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooserApp.this.m_Self, "Error loading file '" + filename + "':\n" + ex.getMessage());
                    return;
                }
                final JFrame frame = new JFrame("GraphVisualizer - " + filename);
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        GUIChooserApp.this.m_Frames.remove(frame);
                        frame.dispose();
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationBoundary = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationBoundary);
        jMenuItemVisualizationBoundary.setText("BoundaryVisualizer");
        jMenuItemVisualizationBoundary.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenuItemVisualizationBoundary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JFrame frame = new JFrame("BoundaryVisualizer");
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                final BoundaryVisualizer bv = new BoundaryVisualizer();
                frame.getContentPane().add((Component)bv, "Center");
                frame.setSize(bv.getMinimumSize());
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        bv.stopPlotting();
                        frame.dispose();
                        GUIChooserApp.this.m_Frames.remove(frame);
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setResizable(false);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
                BoundaryVisualizer.setExitIfNoWindowsOpen(false);
            }
        });
        JMenu jMenuExtensions = new JMenu("Extensions");
        jMenuExtensions.setMnemonic(69);
        this.m_jMenuBar.add(jMenuExtensions);
        jMenuExtensions.setVisible(false);
        String extensions = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "");
        if (extensions.length() > 0) {
            jMenuExtensions.setVisible(true);
            String[] classnames = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "").split(",");
            Hashtable<String, JMenu> submenus = new Hashtable<String, JMenu>();
            for (String classname : classnames) {
                try {
                    MainMenuExtension ext = (MainMenuExtension)Class.forName(classname).newInstance();
                    JMenu submenu = null;
                    if (ext.getSubmenuTitle() != null && (submenu = (JMenu)submenus.get(ext.getSubmenuTitle())) == null) {
                        submenu = new JMenu(ext.getSubmenuTitle());
                        submenus.put(ext.getSubmenuTitle(), submenu);
                        this.insertMenuItem(jMenuExtensions, submenu);
                    }
                    JMenuItem menuitem = new JMenuItem();
                    menuitem.setText(ext.getMenuTitle());
                    ActionListener listener = ext.getActionListener(this.m_Self);
                    if (listener != null) {
                        menuitem.addActionListener(listener);
                    } else {
                        final JMenuItem finalMenuitem = menuitem;
                        final MainMenuExtension finalExt = ext;
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Container frame = GUIChooserApp.this.createFrame(GUIChooserApp.this.m_Self, finalMenuitem.getText(), null, null, null, -1, -1, null, false, false);
                                finalExt.fillFrame(frame);
                                frame.setVisible(true);
                            }
                        });
                    }
                    if (submenu != null) {
                        this.insertMenuItem(submenu, menuitem);
                        continue;
                    }
                    this.insertMenuItem(jMenuExtensions, menuitem);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.m_jMenuTools = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuTools);
        this.m_jMenuTools.setText("Tools");
        this.m_jMenuTools.setMnemonic('T');
        JMenuItem jMenuItemToolsPackageManager = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemToolsPackageManager);
        final String offline = WekaPackageManager.m_offline ? " (offline)" : "";
        jMenuItemToolsPackageManager.setText("Package manager" + offline);
        jMenuItemToolsPackageManager.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenuItemToolsPackageManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread temp = new Thread(){

                    @Override
                    public void run() {
                        PackageManager pm = new PackageManager();
                        if (!WekaPackageManager.m_noPackageMetaDataAvailable) {
                            final JFrame frame = new JFrame("Package Manager" + offline);
                            frame.setIconImage(GUIChooserApp.this.m_Icon);
                            frame.getContentPane().setLayout(new BorderLayout());
                            frame.getContentPane().add((Component)pm, "Center");
                            frame.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent w) {
                                    frame.dispose();
                                    GUIChooserApp.this.m_Frames.remove(frame);
                                    GUIChooserApp.this.checkExit();
                                }
                            });
                            Dimension screenSize = frame.getToolkit().getScreenSize();
                            int width = screenSize.width * 8 / 10;
                            int height = screenSize.height * 8 / 10;
                            frame.setBounds(width / 8, height / 8, width, height);
                            frame.setVisible(true);
                            pm.setInitialSplitPaneDividerLocation();
                            GUIChooserApp.this.m_Frames.add(frame);
                        }
                    }
                };
                temp.start();
            }
        });
        JMenuItem jMenuItemToolsArffViewer = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemToolsArffViewer);
        jMenuItemToolsArffViewer.setText("ArffViewer");
        jMenuItemToolsArffViewer.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItemToolsArffViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ArffViewer av = new ArffViewer();
                av.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        GUIChooserApp.this.m_Frames.remove(av);
                        GUIChooserApp.this.checkExit();
                    }
                });
                av.setVisible(true);
                GUIChooserApp.this.m_Frames.add(av);
            }
        });
        JMenuItem jMenuItemToolsSql = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemToolsSql);
        jMenuItemToolsSql.setText("SqlViewer");
        jMenuItemToolsSql.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItemToolsSql.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SqlViewer sql = new SqlViewer(null);
                final JFrame frame = new JFrame("SqlViewer");
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)sql, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        sql.saveSize();
                        frame.dispose();
                        GUIChooserApp.this.m_Frames.remove(frame);
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        JMenuItem jMenuItemBayesNet = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemBayesNet);
        jMenuItemBayesNet.setText("Bayes net editor");
        jMenuItemBayesNet.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItemBayesNet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI bayesNetGUI = new GUI();
                JMenuBar bayesBar = bayesNetGUI.getMenuBar();
                final JFrame frame = new JFrame("Bayes Network Editor");
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.setJMenuBar(bayesBar);
                frame.getContentPane().add((Component)bayesNetGUI, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        frame.dispose();
                        GUIChooserApp.this.m_Frames.remove(frame);
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        if (Groovy.isPresent()) {
            JMenuItem jMenuItemGroovyConsole = new JMenuItem();
            this.m_jMenuTools.add(jMenuItemGroovyConsole);
            jMenuItemGroovyConsole.setText("Groovy console");
            jMenuItemGroovyConsole.setAccelerator(KeyStroke.getKeyStroke(71, 2));
            jMenuItemGroovyConsole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Class<?> groovyConsoleClass = WekaPackageClassLoaderManager.forName("groovy.ui.Console");
                        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
                            String realOS = System.getProperty("os.name");
                            System.setProperty("os.name", "pretending_not_to_be_an_apple");
                            groovyConsoleClass.getMethod("run", new Class[0]).invoke(groovyConsoleClass.newInstance(), new Object[0]);
                            System.setProperty("os.name", realOS);
                        } else {
                            groovyConsoleClass.getMethod("run", new Class[0]).invoke(groovyConsoleClass.newInstance(), new Object[0]);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to start Groovy console.");
                    }
                }
            });
        }
        if (Jython.isPresent() || WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader("tigerjython") != null) {
            JMenuItem jMenuItemJythonConsole = new JMenuItem();
            this.m_jMenuTools.add(jMenuItemJythonConsole);
            jMenuItemJythonConsole.setText("Jython console");
            jMenuItemJythonConsole.setAccelerator(KeyStroke.getKeyStroke(74, 2));
            jMenuItemJythonConsole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        WekaPackageLibIsolatingClassLoader tigerLoader = WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader("tigerjython");
                        if (tigerLoader == null) {
                            throw new Exception("no tigerjython");
                        }
                        Class<?> tigerJythonClass = Class.forName("tigerjython.core.TigerJython", true, tigerLoader);
                        Object[] args = new Object[]{new String[0]};
                        tigerJythonClass.getMethod("main", String[].class).invoke(null, args);
                    }
                    catch (Exception ex) {
                        JythonPanel jythonPanel = new JythonPanel();
                        final JFrame frame = new JFrame(jythonPanel.getPlainTitle());
                        frame.setIconImage(GUIChooserApp.this.m_Icon);
                        frame.setDefaultCloseOperation(2);
                        frame.setJMenuBar(jythonPanel.getMenuBar());
                        frame.getContentPane().add((Component)jythonPanel, "Center");
                        frame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent w) {
                                GUIChooserApp.this.m_Frames.remove(frame);
                                GUIChooserApp.this.checkExit();
                            }
                        });
                        frame.setSize(800, 600);
                        frame.setVisible(true);
                        GUIChooserApp.this.m_Frames.add(frame);
                    }
                }
            });
        }
        if ((pluginNames = PluginManager.getPluginNamesOfType("weka.gui.GUIChooser.GUIChooserMenuPlugin")) != null) {
            boolean firstVis = true;
            boolean firstTools = true;
            for (String name : pluginNames) {
                try {
                    final GUIChooser.GUIChooserMenuPlugin p = (GUIChooser.GUIChooserMenuPlugin)PluginManager.getPluginInstance("weka.gui.GUIChooser.GUIChooserMenuPlugin", name);
                    if (!(p instanceof JComponent)) continue;
                    JMenuItem mItem = new JMenuItem(p.getMenuEntryText());
                    mItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            final JFrame appFrame = new JFrame(p.getApplicationName());
                            appFrame.setIconImage(GUIChooserApp.this.m_Icon);
                            appFrame.setDefaultCloseOperation(2);
                            JMenuBar appMenu = p.getMenuBar();
                            if (appMenu != null) {
                                appFrame.setJMenuBar(appMenu);
                            }
                            appFrame.getContentPane().add((Component)((JComponent)((Object)p)), "Center");
                            appFrame.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosed(WindowEvent e) {
                                    GUIChooserApp.this.m_Frames.remove(appFrame);
                                    GUIChooserApp.this.checkExit();
                                }
                            });
                            appFrame.setSize(800, 600);
                            appFrame.setVisible(true);
                            GUIChooserApp.this.m_Frames.add(appFrame);
                        }
                    });
                    if (p.getMenuToDisplayIn() == GUIChooser.GUIChooserMenuPlugin.Menu.VISUALIZATION) {
                        if (firstVis) {
                            this.m_jMenuVisualization.add(new JSeparator());
                            firstVis = false;
                        }
                        this.m_jMenuVisualization.add(mItem);
                        continue;
                    }
                    if (firstTools) {
                        this.m_jMenuTools.add(new JSeparator());
                        firstTools = false;
                    }
                    this.m_jMenuTools.add(mItem);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.m_jMenuHelp = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuHelp);
        this.m_jMenuHelp.setText("Help");
        this.m_jMenuHelp.setMnemonic('H');
        JMenuItem jMenuItemHelpHomepage = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpHomepage);
        jMenuItemHelpHomepage.setText("Weka homepage");
        jMenuItemHelpHomepage.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        jMenuItemHelpHomepage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL("http://www.cs.waikato.ac.nz/~ml/weka/");
            }
        });
        this.m_jMenuHelp.add(new JSeparator());
        JMenuItem jMenuItemHelpWekaWiki = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpWekaWiki);
        jMenuItemHelpWekaWiki.setText("HOWTOs, code snippets, etc.");
        jMenuItemHelpWekaWiki.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenuItemHelpWekaWiki.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL("http://weka.wikispaces.com/");
            }
        });
        JMenuItem jMenuItemHelpSourceforge = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpSourceforge);
        jMenuItemHelpSourceforge.setText("Weka on Sourceforge");
        jMenuItemHelpSourceforge.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItemHelpSourceforge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL("http://sourceforge.net/projects/weka/");
            }
        });
        JMenuItem jMenuItemHelpSysInfo = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpSysInfo);
        jMenuItemHelpSysInfo.setText("SystemInfo");
        jMenuItemHelpSysInfo.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenuItemHelpSysInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JFrame frame = new JFrame("SystemInfo");
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                Hashtable<String, String> info = new SystemInfo().getSystemInfo();
                Vector<String> names = new Vector<String>();
                Enumeration<String> enm = info.keys();
                while (enm.hasMoreElements()) {
                    names.add(enm.nextElement());
                }
                Collections.sort(names);
                Object[][] data = new String[info.size()][2];
                for (int i2 = 0; i2 < names.size(); ++i2) {
                    data[i2][0] = ((String)names.get(i2)).toString();
                    data[i2][1] = info.get(data[i2][0]).toString();
                }
                Object[] titles = new String[]{"Key", "Value"};
                JTable table = new JTable(data, titles);
                frame.getContentPane().add((Component)new JScrollPane(table), "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        frame.dispose();
                        GUIChooserApp.this.m_Frames.remove(frame);
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        this.m_ExplorerBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIChooserApp.this.showExplorer(null);
            }
        });
        this.m_ExperimenterBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JFrame frame = new JFrame("Weka Experiment Environment");
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)new Experimenter(false), "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        frame.dispose();
                        GUIChooserApp.this.m_Frames.remove(frame);
                        GUIChooserApp.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        this.m_KnowledgeFlowBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIChooserApp.this.showKnowledgeFlow(null);
            }
        });
        this.m_WorkbenchBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkbenchApp app = new WorkbenchApp();
                final JFrame frame = new JFrame("Weka Workbench");
                frame.setIconImage(GUIChooserApp.this.m_Icon);
                frame.add((Component)app, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        frame.dispose();
                        GUIChooserApp.this.m_Frames.remove(frame);
                        GUIChooserApp.this.checkExit();
                    }
                });
                app.showMenuBar(frame);
                frame.pack();
                frame.setSize(1024, 768);
                frame.setVisible(true);
                GUIChooserApp.this.m_Frames.add(frame);
            }
        });
        this.m_SimpleBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    final SimpleCLI frame = new SimpleCLI();
                    frame.setIconImage(GUIChooserApp.this.m_Icon);
                    frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            frame.dispose();
                            GUIChooserApp.this.m_Frames.remove(frame);
                            GUIChooserApp.this.checkExit();
                        }
                    });
                    frame.setVisible(true);
                    GUIChooserApp.this.m_Frames.add(frame);
                }
                catch (Exception ex) {
                    throw new Error("Could not start SimpleCLI!");
                }
            }
        });
        this.setJMenuBar(this.m_jMenuBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                GUIChooserApp.this.dispose();
                GUIChooserApp.this.checkExit();
            }
        });
        this.pack();
        if (!Utils.getDontShowDialog("weka.gui.GUIChooser.HowToFindPackageManager")) {
            Thread tipThread = new Thread(){

                @Override
                public void run() {
                    JCheckBox dontShow = new JCheckBox("Do not show this message again");
                    Object[] stuff = new Object[]{"Weka has a package manager that you\ncan use to install many learning schemes and tools.\nThe package manager can be found under the \"Tools\" menu.\n", dontShow};
                    JOptionPane.showMessageDialog(GUIChooserApp.this, stuff, "Weka GUIChooser", 0);
                    if (dontShow.isSelected()) {
                        try {
                            Utils.setDontShowDialog("weka.gui.GUIChooser.HowToFindPackageManager");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            tipThread.setPriority(1);
            tipThread.start();
        }
    }

    public void showKnowledgeFlow(String fileToLoad) {
        final JFrame frame = new JFrame("Weka KnowledgeFlow Environment");
        frame.setIconImage(this.m_Icon);
        frame.getContentPane().setLayout(new BorderLayout());
        final KnowledgeFlowApp knowledgeFlow = new KnowledgeFlowApp();
        frame.getContentPane().add((Component)knowledgeFlow, "Center");
        knowledgeFlow.showMenuBar(frame);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                ((MainKFPerspective)knowledgeFlow.getMainPerspective()).closeAllTabs();
                ((MainKFPerspective)knowledgeFlow.getMainPerspective()).addUntitledTab();
                frame.dispose();
                GUIChooserApp.this.m_Frames.remove(frame);
                GUIChooserApp.this.checkExit();
            }
        });
        frame.pack();
        frame.setSize(1024, 768);
        frame.setVisible(true);
        this.m_Frames.add(frame);
    }

    public void showExplorer(String fileToLoad) {
        final JFrame frame = new JFrame("Weka Explorer");
        frame.setIconImage(this.m_Icon);
        frame.getContentPane().setLayout(new BorderLayout());
        Explorer expl = new Explorer();
        frame.getContentPane().add((Component)expl, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                frame.dispose();
                GUIChooserApp.this.m_Frames.remove(frame);
                GUIChooserApp.this.checkExit();
            }
        });
        frame.pack();
        frame.setSize(800, 600);
        frame.setVisible(true);
        this.m_Frames.add(frame);
        if (fileToLoad != null) {
            try {
                AbstractFileLoader loader = ConverterUtils.getLoaderForFile(fileToLoad);
                loader.setFile(new File(fileToLoad));
                expl.getPreprocessPanel().setInstancesFromFile(loader);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem) {
        this.insertMenuItem(menu, menuitem, 0);
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem, int startIndex) {
        boolean inserted = false;
        String newStr = menuitem.getText().toLowerCase();
        for (int i2 = startIndex; i2 < menu.getMenuComponentCount(); ++i2) {
            JMenuItem current;
            String currentStr;
            if (!(menu.getMenuComponent(i2) instanceof JMenuItem) || (currentStr = (current = (JMenuItem)menu.getMenuComponent(i2)).getText().toLowerCase()).compareTo(newStr) <= 0) continue;
            inserted = true;
            menu.insert(menuitem, i2);
            break;
        }
        if (!inserted) {
            menu.add(menuitem);
        }
    }

    protected Container createFrame(GUIChooserApp parent, String title, Component c, LayoutManager layout, Object layoutConstraints, int width, int height, JMenuBar menu, boolean listener, boolean visible) {
        ChildFrameSDI result = null;
        final ChildFrameSDI frame = new ChildFrameSDI(parent, title);
        frame.setLayout(layout);
        if (c != null) {
            frame.getContentPane().add(c, layoutConstraints);
        }
        frame.setJMenuBar(menu);
        frame.pack();
        if (width > -1 && height > -1) {
            frame.setSize(width, height);
        }
        frame.validate();
        int screenHeight = this.getGraphicsConfiguration().getBounds().height;
        int screenWidth = this.getGraphicsConfiguration().getBounds().width;
        frame.setLocation((screenWidth - frame.getBounds().width) / 2, (screenHeight - frame.getBounds().height) / 2);
        if (listener) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    frame.dispose();
                }
            });
        }
        if (visible) {
            frame.setVisible(true);
        }
        result = frame;
        return result;
    }

    protected void createTitle(String title) {
        String newTitle = "Weka " + new Version();
        if (title.length() != 0) {
            newTitle = newTitle + " - " + title;
        }
        this.setTitle(newTitle);
    }

    public void addChildFrame(Container c) {
        this.m_ChildFrames.add(c);
    }

    public boolean removeChildFrame(Container c) {
        boolean result = this.m_ChildFrames.remove(c);
        return result;
    }

    private void checkExit() {
        if (!this.isVisible() && this.m_Frames.size() == 0) {
            System.setSecurityManager(null);
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        try {
            LookAndFeel.setLookAndFeel("guichooser", "guichooser.lookAndFeel", "javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        final PrintStream savedStdOut = System.out;
        final PrintStream savedStdErr = System.err;
        final SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkExit(int status) {
                if (sm != null) {
                    sm.checkExit(status);
                }
                for (Class<?> cl : this.getClassContext()) {
                    if (!cl.getName().equals("tigerjython.gui.MainWindow")) continue;
                    for (Frame frame : Frame.getFrames()) {
                        if (!frame.getTitle().toLowerCase().startsWith("tigerjython")) continue;
                        frame.dispose();
                    }
                    System.setOut(savedStdOut);
                    System.setErr(savedStdErr);
                }
                Logger.log(Logger.Level.INFO, "Intercepted System.exit() from a class other than the GUIChooser. Please ignore.");
                throw new SecurityException("Intercepted System.exit() from a class other than the GUIChooser. Please ignore.");
            }

            @Override
            public void checkPermission(Permission perm) {
                if (sm != null) {
                    sm.checkPermission(perm);
                }
            }

            @Override
            public void checkPermission(Permission perm, Object context) {
                if (sm != null) {
                    sm.checkPermission(perm, context);
                }
            }
        });
        try {
            GUIChooserApp.createSingleton();
            m_chooser.setVisible(true);
            if (args != null && args.length > 0) {
                m_chooser.showExplorer(args[0]);
            }
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        m_chooser.dispose();
                        if (m_chooser.m_Frames.size() > 0) {
                            for (int i2 = 0; i2 < m_chooser.m_Frames.size(); ++i2) {
                                JFrame av = m_chooser.m_Frames.get(i2);
                                av.dispose();
                            }
                            m_chooser.m_Frames.clear();
                        }
                        m_chooser = null;
                        System.gc();
                        m_chooser;
                        m_LogWindow.setVisible(true);
                        m_chooser;
                        m_LogWindow.toFront();
                        System.err.println("\ndisplayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting...");
                        System.setSecurityManager(null);
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(5);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }

    public static final class GUIChooserDefaults
    extends Defaults {
        public static final String APP_NAME = "GUIChooser";
        public static final String APP_ID = "guichooser";
        protected static final Settings.SettingKey LAF_KEY = new Settings.SettingKey("guichooser.lookAndFeel", "Look and feel for UI", "Note: a restart is required for this setting to come into effect");
        protected static final String LAF = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
        private static final long serialVersionUID = -8524894440289936685L;

        public GUIChooserDefaults() {
            super(APP_ID);
            List<String> lafs = LookAndFeel.getAvailableLookAndFeelClasses();
            lafs.add(0, "<use platform default>");
            LAF_KEY.setPickList(lafs);
            this.m_defaults.put(LAF_KEY, LAF);
        }
    }

    public static class ChildFrameSDI
    extends JFrame {
        private static final long serialVersionUID = 8588293938686425618L;
        protected GUIChooserApp m_Parent;

        public ChildFrameSDI(GUIChooserApp parent, String title) {
            super(title);
            this.m_Parent = parent;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (ChildFrameSDI.this.getParentFrame() != null) {
                        ChildFrameSDI.this.getParentFrame().createTitle(ChildFrameSDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.setIconImage(this.getParentFrame().getIconImage());
            }
        }

        public GUIChooserApp getParentFrame() {
            return this.m_Parent;
        }

        @Override
        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }
}

