/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import javax.swing.DefaultListModel;
import javax.swing.JList;

public class JListHelper {
    public static final int MOVE_UP = 0;
    public static final int MOVE_DOWN = 1;

    protected static void moveItems(JList list, int moveby, int direction) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        switch (direction) {
            case 0: {
                int[] indices = list.getSelectedIndices();
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    if (indices[i2] == 0) continue;
                    Object o = model.remove(indices[i2]);
                    int n = i2;
                    indices[n] = indices[n] - moveby;
                    model.insertElementAt(o, indices[i2]);
                }
                list.setSelectedIndices(indices);
                break;
            }
            case 1: {
                int[] indices = list.getSelectedIndices();
                for (int i3 = indices.length - 1; i3 >= 0; --i3) {
                    if (indices[i3] == model.getSize() - 1) continue;
                    Object o = model.remove(indices[i3]);
                    int n = i3;
                    indices[n] = indices[n] + moveby;
                    model.insertElementAt(o, indices[i3]);
                }
                list.setSelectedIndices(indices);
                break;
            }
            default: {
                System.err.println(JListHelper.class.getName() + ": direction '" + direction + "' is unknown!");
            }
        }
    }

    public static void moveUp(JList list) {
        if (JListHelper.canMoveUp(list)) {
            JListHelper.moveItems(list, 1, 0);
        }
    }

    public static void moveDown(JList list) {
        if (JListHelper.canMoveDown(list)) {
            JListHelper.moveItems(list, 1, 1);
        }
    }

    public static void moveTop(JList list) {
        if (JListHelper.canMoveUp(list)) {
            int[] indices = list.getSelectedIndices();
            int diff = indices[0];
            JListHelper.moveItems(list, diff, 0);
        }
    }

    public static void moveBottom(JList list) {
        if (JListHelper.canMoveDown(list)) {
            int[] indices = list.getSelectedIndices();
            int diff = list.getModel().getSize() - 1 - indices[indices.length - 1];
            JListHelper.moveItems(list, diff, 1);
        }
    }

    public static boolean canMoveUp(JList list) {
        boolean result = false;
        int[] indices = list.getSelectedIndices();
        if (indices.length > 0 && indices[0] > 0) {
            result = true;
        }
        return result;
    }

    public static boolean canMoveDown(JList list) {
        boolean result = false;
        int[] indices = list.getSelectedIndices();
        if (indices.length > 0 && indices[indices.length - 1] < list.getModel().getSize() - 1) {
            result = true;
        }
        return result;
    }
}

