/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import weka.core.Environment;
import weka.core.Settings;
import weka.core.Utils;

public class LookAndFeel {
    public static String PROPERTY_FILE = "weka/gui/LookAndFeel.props";
    protected static Properties LOOKANDFEEL_PROPERTIES;

    public static List<String> getAvailableLookAndFeelClasses() {
        LinkedList<String> lafs = new LinkedList<String>();
        for (UIManager.LookAndFeelInfo i2 : UIManager.getInstalledLookAndFeels()) {
            lafs.add(i2.getClassName());
        }
        return lafs;
    }

    public static boolean setLookAndFeel(String classname) {
        boolean result;
        try {
            UIManager.setLookAndFeel(classname);
            result = true;
            if (System.getProperty("os.name").toLowerCase().contains("mac os x") && !classname.contains("com.apple.laf")) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                    @Override
                    public boolean dispatchKeyEvent(KeyEvent e) {
                        if (!e.isConsumed() && e.isMetaDown() && (e.getKeyCode() == 86 || e.getKeyCode() == 65 || e.getKeyCode() == 67 || e.getKeyCode() == 88)) {
                            e.setModifiers(128);
                        }
                        return false;
                    }
                });
            }
            if (classname.toLowerCase().contains("nimbus")) {
                javax.swing.LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                UIDefaults defaults = lookAndFeel.getDefaults();
                defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static void setLookAndFeel(String appID, String lookAndFeelKey, String defaultLookAndFeel) throws IOException {
        Settings forLookAndFeelOnly = new Settings("weka", appID);
        String laf = forLookAndFeelOnly.getSetting(appID, lookAndFeelKey, defaultLookAndFeel, Environment.getSystemWide());
        if (laf.length() <= 0 || !laf.contains(".") || !LookAndFeel.setLookAndFeel(laf)) {
            LookAndFeel.setLookAndFeel();
        }
    }

    public static boolean setLookAndFeel() {
        String classname = LOOKANDFEEL_PROPERTIES.getProperty("Theme", "");
        if (classname.equals("")) {
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                return true;
            }
            classname = LookAndFeel.getSystemLookAndFeel();
        }
        return LookAndFeel.setLookAndFeel(classname);
    }

    public static String getSystemLookAndFeel() {
        return UIManager.getSystemLookAndFeelClassName();
    }

    public static String[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
        String[] result = new String[laf.length];
        for (int i2 = 0; i2 < laf.length; ++i2) {
            result[i2] = laf[i2].getClassName();
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("\nInstalled Look and Feel themes:");
        String[] list = LookAndFeel.getInstalledLookAndFeels();
        for (int i2 = 0; i2 < list.length; ++i2) {
            System.out.println(i2 + 1 + ". " + list[i2]);
        }
        System.out.println("\nNote: a theme can be set in '" + PROPERTY_FILE + "'.");
    }

    static {
        try {
            LOOKANDFEEL_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "LookAndFeel: Could not read a LookAndFeel configuration file.\nAn example file is included in the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\"  and\nshould be placed either in your user home (which is set\nto \"" + System.getProperties().getProperty("user.home") + "\")\nor the directory that java was started from\n", "LookAndFeel", 0);
        }
    }
}

