/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.ClassDiscovery;

public class SortedTableModel
extends AbstractTableModel
implements TableModelListener {
    static final long serialVersionUID = 4030907921461127548L;
    protected TableModel mModel;
    protected int[] mIndices;
    protected int mSortColumn;
    protected boolean mAscending;

    public SortedTableModel() {
        this(null);
    }

    public SortedTableModel(TableModel model) {
        this.setModel(model);
    }

    public void setModel(TableModel value) {
        this.mModel = value;
        if (this.mModel == null) {
            this.mIndices = null;
        } else {
            this.initializeIndices();
            this.mSortColumn = -1;
            this.mAscending = true;
            this.mModel.addTableModelListener(this);
        }
    }

    protected void initializeIndices() {
        this.mIndices = new int[this.mModel.getRowCount()];
        for (int i2 = 0; i2 < this.mIndices.length; ++i2) {
            this.mIndices[i2] = i2;
        }
    }

    public TableModel getModel() {
        return this.mModel;
    }

    public boolean isSorted() {
        return this.mSortColumn > -1;
    }

    protected boolean isInitialized() {
        return this.getModel() != null;
    }

    public int getActualRow(int visibleRow) {
        if (!this.isInitialized()) {
            return -1;
        }
        return this.mIndices[visibleRow];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        return this.getModel().getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        return this.getModel().getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getValueAt(this.mIndices[rowIndex], columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.getModel().isCellEditable(this.mIndices[rowIndex], columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.isInitialized()) {
            this.getModel().setValueAt(aValue, this.mIndices[rowIndex], columnIndex);
        }
    }

    public void sort(int columnIndex) {
        this.sort(columnIndex, true);
    }

    public void sort(int columnIndex, boolean ascending) {
        int i2;
        if (!this.isInitialized() || this.getModel().getRowCount() != this.mIndices.length) {
            System.out.println(this.getClass().getName() + ": Table model not initialized!");
            return;
        }
        this.mSortColumn = columnIndex;
        this.mAscending = ascending;
        this.initializeIndices();
        boolean columnType = ClassDiscovery.hasInterface(Comparable.class, this.getColumnClass(this.mSortColumn));
        ArrayList<SortContainer> sorted = new ArrayList<SortContainer>();
        for (i2 = 0; i2 < this.getRowCount(); ++i2) {
            Object value = this.mModel.getValueAt(this.mIndices[i2], this.mSortColumn);
            SortContainer cont = !columnType ? new SortContainer((Comparable<?>)((Object)(value == null ? null : value.toString())), this.mIndices[i2]) : new SortContainer((Comparable)value, this.mIndices[i2]);
            sorted.add(cont);
        }
        Collections.sort(sorted);
        for (i2 = 0; i2 < sorted.size(); ++i2) {
            this.mIndices[i2] = this.mAscending ? ((SortContainer)sorted.get(i2)).getIndex() : ((SortContainer)sorted.get(sorted.size() - 1 - i2)).getIndex();
        }
        sorted.clear();
        sorted = null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.initializeIndices();
        if (this.isSorted()) {
            this.sort(this.mSortColumn, this.mAscending);
        }
        this.fireTableChanged(e);
    }

    public void addMouseListenerToHeader(JTable table) {
        final SortedTableModel modelFinal = this;
        final JTable tableFinal = table;
        tableFinal.setColumnSelectionAllowed(false);
        JTableHeader header = tableFinal.getTableHeader();
        if (header != null) {
            MouseAdapter listMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableColumnModel columnModel = tableFinal.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = tableFinal.convertColumnIndexToModel(viewColumn);
                    if (e.getButton() == 1 && e.getClickCount() == 1 && !e.isAltDown() && column != -1) {
                        int shiftPressed = e.getModifiers() & 1;
                        boolean ascending = shiftPressed == 0;
                        modelFinal.sort(column, ascending);
                    }
                }
            };
            header.addMouseListener(listMouseListener);
        }
    }

    public static class SortContainer
    implements Comparable<SortContainer> {
        protected Comparable<?> m_Value;
        protected int m_Index;

        public SortContainer(Comparable<?> value, int index) {
            this.m_Value = value;
            this.m_Index = index;
        }

        public Comparable<?> getValue() {
            return this.m_Value;
        }

        public int getIndex() {
            return this.m_Index;
        }

        @Override
        public int compareTo(SortContainer o) {
            if (this.m_Value == null || o.getValue() == null) {
                if (this.m_Value == o.getValue()) {
                    return 0;
                }
                if (this.m_Value == null) {
                    return -1;
                }
                return 1;
            }
            return this.m_Value.compareTo(o.getValue());
        }

        public boolean equals(Object obj) {
            return this.compareTo((SortContainer)obj) == 0;
        }

        public String toString() {
            return "value=" + this.m_Value + ", index=" + this.m_Index;
        }
    }
}

