/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

public class ClassAssigner
extends JPanel
implements Visible,
DataSourceListener,
TrainingSetListener,
TestSetListener,
DataSource,
TrainingSetProducer,
TestSetProducer,
BeanCommon,
EventConstraints,
Serializable,
InstanceListener,
StructureProducer {
    private static final long serialVersionUID = 4011131665025817924L;
    private String m_classColumn = "last";
    private Instances m_connectedFormat;
    private Object m_trainingProvider;
    private Object m_testProvider;
    private Object m_dataProvider;
    private Object m_instanceProvider;
    private final Vector<TrainingSetListener> m_trainingListeners = new Vector();
    private final Vector<TestSetListener> m_testListeners = new Vector();
    private final Vector<DataSourceListener> m_dataListeners = new Vector();
    private final Vector<InstanceListener> m_instanceListeners = new Vector();
    private final Vector<DataFormatListener> m_dataFormatListeners = new Vector();
    protected transient Logger m_logger = null;
    protected BeanVisual m_visual = new BeanVisual("ClassAssigner", "weka/gui/beans/icons/ClassAssigner.gif", "weka/gui/beans/icons/ClassAssigner_animated.gif");

    public String globalInfo() {
        return "Designate which column is to be considered the class column in incoming data.";
    }

    public ClassAssigner() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String classColumnTipText() {
        return "Specify the number of the column that contains the class attribute";
    }

    private Instances getUpstreamStructure() {
        if (this.m_dataProvider != null && this.m_dataProvider instanceof StructureProducer) {
            return ((StructureProducer)this.m_dataProvider).getStructure("dataSet");
        }
        if (this.m_trainingProvider != null && this.m_trainingProvider instanceof StructureProducer) {
            return ((StructureProducer)this.m_trainingProvider).getStructure("trainingSet");
        }
        if (this.m_testProvider != null && this.m_testProvider instanceof StructureProducer) {
            return ((StructureProducer)this.m_testProvider).getStructure("testSet");
        }
        if (this.m_instanceProvider != null && this.m_instanceProvider instanceof StructureProducer) {
            return ((StructureProducer)this.m_instanceProvider).getStructure("instance");
        }
        return null;
    }

    @Override
    public Instances getStructure(String eventName) {
        if (!(eventName.equals("trainingSet") || eventName.equals("testSet") || eventName.equals("dataSet") || eventName.equals("instance"))) {
            return null;
        }
        if (this.m_trainingProvider == null && this.m_testProvider == null && this.m_dataProvider == null && this.m_instanceProvider == null) {
            return null;
        }
        if (eventName.equals("dataSet") && this.m_dataListeners.size() == 0) {
            return null;
        }
        if (eventName.equals("trainingSet") && this.m_trainingListeners.size() == 0) {
            return null;
        }
        if (eventName.equals("testSet") && this.m_testListeners.size() == 0) {
            return null;
        }
        if (eventName.equals("instance") && this.m_instanceListeners.size() == 0) {
            return null;
        }
        if (this.m_connectedFormat == null) {
            this.m_connectedFormat = this.getUpstreamStructure();
        }
        if (this.m_connectedFormat != null) {
            this.assignClass(this.m_connectedFormat);
        }
        return this.m_connectedFormat;
    }

    public Instances getConnectedFormat() {
        if (this.m_connectedFormat == null) {
            this.m_connectedFormat = this.getUpstreamStructure();
        }
        return this.m_connectedFormat;
    }

    public void setClassColumn(String col) {
        this.m_classColumn = col;
        if (this.m_connectedFormat != null) {
            this.assignClass(this.m_connectedFormat);
        }
    }

    public String getClassColumn() {
        return this.m_classColumn;
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        Instances dataSet = e.getDataSet();
        this.assignClass(dataSet);
        this.notifyDataListeners(e);
        if (e.isStructureOnly()) {
            this.m_connectedFormat = e.getDataSet();
            this.notifyDataFormatListeners();
        }
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances trainingSet = e.getTrainingSet();
        this.assignClass(trainingSet);
        this.notifyTrainingListeners(e);
        if (e.isStructureOnly()) {
            this.m_connectedFormat = e.getTrainingSet();
            this.notifyDataFormatListeners();
        }
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances testSet = e.getTestSet();
        this.assignClass(testSet);
        this.notifyTestListeners(e);
        if (e.isStructureOnly()) {
            this.m_connectedFormat = e.getTestSet();
            this.notifyDataFormatListeners();
        }
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        if (e.getStatus() == 0) {
            this.m_connectedFormat = e.getStructure();
            this.assignClass(this.m_connectedFormat);
            this.notifyInstanceListeners(e);
            System.err.println("Notifying customizer...");
            this.notifyDataFormatListeners();
        } else {
            this.notifyInstanceListeners(e);
        }
    }

    private void assignClass(Instances dataSet) {
        int classCol = -1;
        if (this.m_classColumn.trim().toLowerCase().compareTo("last") == 0 || this.m_classColumn.equalsIgnoreCase("/last")) {
            dataSet.setClassIndex(dataSet.numAttributes() - 1);
        } else if (this.m_classColumn.trim().toLowerCase().compareTo("first") == 0 || this.m_classColumn.equalsIgnoreCase("/first")) {
            dataSet.setClassIndex(0);
        } else {
            Attribute classAtt = dataSet.attribute(this.m_classColumn.trim());
            if (classAtt != null) {
                dataSet.setClass(classAtt);
            } else {
                block11: {
                    try {
                        classCol = Integer.parseInt(this.m_classColumn.trim()) - 1;
                    }
                    catch (NumberFormatException ex) {
                        if (this.m_logger == null) break block11;
                        this.m_logger.logMessage("Warning : can't parse '" + this.m_classColumn.trim() + "' as a number  or find it as an attribute in the incoming data (ClassAssigner)");
                    }
                }
                if (classCol > dataSet.numAttributes() - 1) {
                    if (this.m_logger != null) {
                        this.m_logger.logMessage("Class column outside range of data (ClassAssigner)");
                    }
                } else {
                    dataSet.setClassIndex(classCol);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestListeners(TestSetEvent tse) {
        Vector l;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            l = (Vector)this.m_testListeners.clone();
        }
        if (l.size() > 0) {
            for (int i2 = 0; i2 < l.size(); ++i2) {
                System.err.println("Notifying test listeners (ClassAssigner)");
                ((TestSetListener)l.elementAt(i2)).acceptTestSet(tse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingListeners(TrainingSetEvent tse) {
        Vector l;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            l = (Vector)this.m_trainingListeners.clone();
        }
        if (l.size() > 0) {
            for (int i2 = 0; i2 < l.size(); ++i2) {
                System.err.println("Notifying training listeners (ClassAssigner)");
                ((TrainingSetListener)l.elementAt(i2)).acceptTrainingSet(tse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataListeners(DataSetEvent tse) {
        Vector l;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            l = (Vector)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            for (int i2 = 0; i2 < l.size(); ++i2) {
                System.err.println("Notifying data listeners (ClassAssigner)");
                ((DataSourceListener)l.elementAt(i2)).acceptDataSet(tse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceListeners(InstanceEvent tse) {
        Vector l;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            l = (Vector)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (int i2 = 0; i2 < l.size(); ++i2) {
                ((InstanceListener)l.elementAt(i2)).acceptInstance(tse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataFormatListeners() {
        Vector l;
        ClassAssigner classAssigner = this;
        synchronized (classAssigner) {
            l = (Vector)this.m_dataFormatListeners.clone();
        }
        if (l.size() > 0) {
            DataSetEvent dse = new DataSetEvent(this, this.m_connectedFormat);
            for (int i2 = 0; i2 < l.size(); ++i2) {
                ((DataFormatListener)l.elementAt(i2)).newDataFormat(dse);
            }
        }
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.addElement(tsl);
        if (this.m_connectedFormat != null) {
            InstanceEvent e = new InstanceEvent(this, this.m_connectedFormat);
            tsl.acceptInstance(e);
        }
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.removeElement(tsl);
    }

    @Override
    public synchronized void addDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.addElement(tsl);
        if (this.m_connectedFormat != null) {
            DataSetEvent e = new DataSetEvent(this, this.m_connectedFormat);
            tsl.acceptDataSet(e);
        }
    }

    @Override
    public synchronized void removeDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.removeElement(tsl);
    }

    @Override
    public synchronized void addTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingListeners.addElement(tsl);
        if (this.m_connectedFormat != null) {
            TrainingSetEvent e = new TrainingSetEvent(this, this.m_connectedFormat);
            tsl.acceptTrainingSet(e);
        }
    }

    @Override
    public synchronized void removeTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingListeners.removeElement(tsl);
    }

    @Override
    public synchronized void addTestSetListener(TestSetListener tsl) {
        this.m_testListeners.addElement(tsl);
        if (this.m_connectedFormat != null) {
            TestSetEvent e = new TestSetEvent(this, this.m_connectedFormat);
            tsl.acceptTestSet(e);
        }
    }

    @Override
    public synchronized void removeTestSetListener(TestSetListener tsl) {
        this.m_testListeners.removeElement(tsl);
    }

    public synchronized void addDataFormatListener(DataFormatListener dfl) {
        this.m_dataFormatListeners.addElement(dfl);
    }

    public synchronized void removeDataFormatListener(DataFormatListener dfl) {
        this.m_dataFormatListeners.removeElement(dfl);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassAssigner.gif", "weka/gui/beans/icons/ClassAssigner_animated.gif");
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        if (eventName.compareTo("trainingSet") == 0 && (this.m_trainingProvider != null || this.m_dataProvider != null || this.m_instanceProvider != null)) {
            return false;
        }
        if (eventName.compareTo("testSet") == 0 && this.m_testProvider != null) {
            return false;
        }
        return (eventName.compareTo("instance") != 0 || this.m_instanceProvider == null) && this.m_trainingProvider == null && this.m_dataProvider == null;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            if (eventName.compareTo("trainingSet") == 0) {
                this.m_trainingProvider = source;
            } else if (eventName.compareTo("testSet") == 0) {
                this.m_testProvider = source;
            } else if (eventName.compareTo("dataSet") == 0) {
                this.m_dataProvider = source;
            } else if (eventName.compareTo("instance") == 0) {
                this.m_instanceProvider = source;
            }
            this.m_connectedFormat = null;
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        if (eventName.compareTo("trainingSet") == 0 && this.m_trainingProvider == source) {
            this.m_trainingProvider = null;
        }
        if (eventName.compareTo("testSet") == 0 && this.m_testProvider == source) {
            this.m_testProvider = null;
        }
        if (eventName.compareTo("dataSet") == 0 && this.m_dataProvider == source) {
            this.m_dataProvider = null;
        }
        if (eventName.compareTo("instance") == 0 && this.m_instanceProvider == source) {
            this.m_instanceProvider = null;
        }
        this.m_connectedFormat = null;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void stop() {
        if (this.m_trainingProvider != null && this.m_trainingProvider instanceof BeanCommon) {
            ((BeanCommon)this.m_trainingProvider).stop();
        }
        if (this.m_testProvider != null && this.m_testProvider instanceof BeanCommon) {
            ((BeanCommon)this.m_testProvider).stop();
        }
        if (this.m_dataProvider != null && this.m_dataProvider instanceof BeanCommon) {
            ((BeanCommon)this.m_dataProvider).stop();
        }
        if (this.m_instanceProvider != null && this.m_instanceProvider instanceof BeanCommon) {
            ((BeanCommon)this.m_instanceProvider).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (eventName.compareTo("trainingSet") == 0) {
            if (this.m_trainingProvider == null) {
                return false;
            }
            if (this.m_trainingProvider instanceof EventConstraints && !((EventConstraints)this.m_trainingProvider).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (eventName.compareTo("dataSet") == 0) {
            if (this.m_dataProvider == null) {
                if (this.m_instanceProvider == null) {
                    this.m_connectedFormat = null;
                    this.notifyDataFormatListeners();
                }
                return false;
            }
            if (this.m_dataProvider instanceof EventConstraints && !((EventConstraints)this.m_dataProvider).eventGeneratable("dataSet")) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
        }
        if (eventName.compareTo("instance") == 0) {
            if (this.m_instanceProvider == null) {
                if (this.m_dataProvider == null) {
                    this.m_connectedFormat = null;
                    this.notifyDataFormatListeners();
                }
                return false;
            }
            if (this.m_instanceProvider instanceof EventConstraints && !((EventConstraints)this.m_instanceProvider).eventGeneratable("instance")) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
        }
        if (eventName.compareTo("testSet") == 0) {
            if (this.m_testProvider == null) {
                return false;
            }
            if (this.m_testProvider instanceof EventConstraints && !((EventConstraints)this.m_testProvider).eventGeneratable("testSet")) {
                return false;
            }
        }
        return true;
    }
}

