/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    private static final long serialVersionUID = -2117842133475125463L;
    private int m_width = 3;
    private Color m_color = Color.BLACK;

    public ShadowBorder() {
        this(2);
    }

    public ShadowBorder(int width) {
        this(width, Color.BLACK);
    }

    public ShadowBorder(int width, Color color) {
        this.m_width = width;
        this.m_color = color;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, this.m_width + 1, this.m_width + 1);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 1;
        insets.left = 1;
        insets.bottom = this.m_width + 1;
        insets.right = this.m_width + 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int y2;
        int x2;
        int y1;
        int x1;
        int i2;
        Color old_color = g.getColor();
        g.setColor(this.m_color);
        g.drawRect(x, y, width - this.m_width - 1, height - this.m_width - 1);
        for (i2 = 0; i2 <= this.m_width; ++i2) {
            x1 = x + this.m_width;
            y1 = y + height - i2;
            x2 = x + width;
            y2 = y1;
            g.drawLine(x1, y1, x2, y2);
            x1 = x + width - this.m_width + i2;
            y1 = y + this.m_width;
            x2 = x1;
            y2 = y + height;
            g.drawLine(x1, y1, x2, y2);
        }
        if (c.getParent() != null) {
            g.setColor(c.getParent().getBackground());
            for (i2 = 0; i2 <= this.m_width; ++i2) {
                x1 = x;
                y1 = y + height - i2;
                x2 = x + this.m_width;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
                x1 = x + width - this.m_width;
                y1 = y + i2;
                x2 = x + width;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
            }
            g.setColor(g.getColor().darker());
            for (i2 = 0; i2 < this.m_width; ++i2) {
                x1 = x + i2 + 1;
                y1 = y + height - this.m_width + i2;
                x2 = x + this.m_width;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
                x1 = x + width - this.m_width;
                y1 = y + i2 + 1;
                x2 = x1 + i2;
                y2 = y1;
                g.drawLine(x1, y1, x2, y2);
            }
        }
        g.setColor(old_color);
    }
}

