/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventSetDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.BeansProperties;
import weka.gui.beans.ChartEvent;
import weka.gui.beans.ChartListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.visualize.PrintableComponent;
import weka.gui.visualize.VisualizeUtils;

public class StripChart
extends JPanel
implements ChartListener,
InstanceListener,
Visible,
BeanCommon,
UserRequestAcceptor {
    private static final long serialVersionUID = 1483649041577695019L;
    protected Color[] m_colorList = new Color[]{Color.green, Color.red, Color.blue, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected Color m_BackgroundColor;
    protected Color m_LegendPanelBorderColor;
    private transient JFrame m_outputFrame = null;
    private transient StripPlotter m_plotPanel = null;
    private transient Image m_osi = null;
    private int m_iheight;
    private int m_iwidth;
    private double m_max = 1.0;
    private double m_min = 0.0;
    private boolean m_yScaleUpdate = false;
    private double m_oldMax;
    private double m_oldMin;
    private final Font m_labelFont = new Font("Monospaced", 0, 10);
    private FontMetrics m_labelMetrics;
    private Vector<String> m_legendText = new Vector();
    private final ScalePanel m_scalePanel = new ScalePanel();
    private final LegendPanel m_legendPanel = new LegendPanel();
    private LinkedList<double[]> m_dataList = new LinkedList();
    private double[] m_previousY = new double[1];
    private transient Thread m_updateHandler;
    protected BeanVisual m_visual = new BeanVisual("StripChart", "weka/gui/beans/icons/StripChart.gif", "weka/gui/beans/icons/StripChart_animated.gif");
    private Object m_listenee = null;
    private int m_xValFreq = 500;
    private int m_xCount = 0;
    private int m_refreshWidth = 1;
    private int m_userRefreshWidth = 1;
    private int m_refreshFrequency = 5;
    protected PrintableComponent m_Printer = null;
    ChartEvent m_ce = new ChartEvent(this);
    double[] m_dataPoint = null;

    public StripChart() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.initPlot();
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Visualize incremental classifier performance as a scrolling plot.";
    }

    public String xLabelFreqTipText() {
        return "Show x axis labels this often";
    }

    public void setXLabelFreq(int freq) {
        this.m_xValFreq = freq;
        if (this.getGraphics() != null) {
            this.setRefreshGap();
        }
    }

    public int getXLabelFreq() {
        return this.m_xValFreq;
    }

    public String refreshFreqTipText() {
        return "Plot every x'th data point";
    }

    public void setRefreshFreq(int freq) {
        this.m_refreshFrequency = freq;
        if (this.getGraphics() != null) {
            this.setRefreshGap();
        }
    }

    public int getRefreshFreq() {
        return this.m_refreshFrequency;
    }

    public String refreshWidthTipText() {
        return "The number of pixels to shift the plot by every time a point is plotted.";
    }

    public void setRefreshWidth(int width) {
        if (width > 0) {
            this.m_userRefreshWidth = width;
        }
    }

    public int getRefreshWidth() {
        return this.m_userRefreshWidth;
    }

    private void setRefreshGap() {
        this.m_refreshWidth = this.m_userRefreshWidth;
        if (this.m_labelMetrics == null) {
            this.getGraphics().setFont(this.m_labelFont);
            this.m_labelMetrics = this.getGraphics().getFontMetrics(this.m_labelFont);
        }
        int refWidth = this.m_labelMetrics.stringWidth("99000");
        int z = this.getXLabelFreq() / this.getRefreshFreq();
        if (z < 1) {
            z = 1;
        }
        if (z * this.m_refreshWidth < refWidth + 5) {
            this.m_refreshWidth *= (refWidth + 5) / z + 1;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            ois.defaultReadObject();
            this.initPlot();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setProperties() {
        String key = this.getClass().getName() + ".backgroundColour";
        String color = BeansProperties.BEAN_PROPERTIES.getProperty(key);
        this.m_BackgroundColor = Color.BLACK;
        if (color != null) {
            this.m_BackgroundColor = VisualizeUtils.processColour(color, this.m_BackgroundColor);
        }
        key = this.m_legendPanel.getClass().getName() + ".borderColour";
        color = BeansProperties.BEAN_PROPERTIES.getProperty(key);
        this.m_LegendPanelBorderColor = Color.BLUE;
        if (color != null) {
            this.m_LegendPanelBorderColor = VisualizeUtils.processColour(color, this.m_LegendPanelBorderColor);
        }
    }

    private void initPlot() {
        this.setProperties();
        this.m_plotPanel = new StripPlotter();
        this.m_plotPanel.setBackground(this.m_BackgroundColor);
        this.m_scalePanel.setBackground(this.m_BackgroundColor);
        this.m_legendPanel.setBackground(this.m_BackgroundColor);
        this.m_xCount = 0;
    }

    private void startHandler() {
        if (this.m_updateHandler == null) {
            this.m_updateHandler = new Thread(){
                private double[] dataPoint;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (StripChart.this.m_outputFrame == null) {
                            continue;
                        }
                        LinkedList linkedList = StripChart.this.m_dataList;
                        synchronized (linkedList) {
                            while (StripChart.this.m_dataList.isEmpty()) {
                                try {
                                    StripChart.this.m_dataList.wait();
                                }
                                catch (InterruptedException ex) {
                                    return;
                                }
                            }
                            this.dataPoint = (double[])StripChart.this.m_dataList.remove(0);
                        }
                        if (StripChart.this.m_outputFrame == null) continue;
                        StripChart.this.updateChart(this.dataPoint);
                    }
                }
            };
            this.m_updateHandler.start();
        }
    }

    public void showChart() {
        if (this.m_outputFrame == null) {
            this.m_outputFrame = new JFrame("Strip Chart");
            this.m_outputFrame.getContentPane().setLayout(new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout());
            new PrintableComponent(panel);
            this.m_outputFrame.getContentPane().add((Component)panel, "Center");
            panel.add((Component)this.m_legendPanel, "West");
            panel.add((Component)this.m_plotPanel, "Center");
            panel.add((Component)this.m_scalePanel, "East");
            this.m_legendPanel.setMinimumSize(new Dimension(100, this.getHeight()));
            this.m_legendPanel.setPreferredSize(new Dimension(100, this.getHeight()));
            this.m_scalePanel.setMinimumSize(new Dimension(30, this.getHeight()));
            this.m_scalePanel.setPreferredSize(new Dimension(30, this.getHeight()));
            Font lf = new Font("Monospaced", 0, 12);
            this.m_legendPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.gray, Color.darkGray), "Legend", 2, 0, lf, this.m_LegendPanelBorderColor));
            this.m_outputFrame.addWindowListener(new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosing(WindowEvent e) {
                    if (StripChart.this.m_updateHandler != null) {
                        System.err.println("Interrupting");
                        StripChart.this.m_updateHandler.interrupt();
                        StripChart.this.m_updateHandler = null;
                    }
                    LinkedList linkedList = StripChart.this.m_dataList;
                    synchronized (linkedList) {
                        StripChart.this.m_dataList = new LinkedList();
                    }
                    StripChart.this.m_outputFrame.dispose();
                    StripChart.this.m_outputFrame = null;
                }
            });
            this.m_outputFrame.pack();
            this.m_outputFrame.setSize(600, 150);
            this.m_outputFrame.setResizable(false);
            this.m_outputFrame.setVisible(true);
            this.m_outputFrame.setAlwaysOnTop(true);
            int iwidth = this.m_plotPanel.getWidth();
            int iheight = this.m_plotPanel.getHeight();
            this.m_osi = this.m_plotPanel.createImage(iwidth, iheight);
            Graphics m = this.m_osi.getGraphics();
            m.setColor(this.m_BackgroundColor);
            m.fillRect(0, 0, iwidth, iheight);
            this.m_previousY[0] = -1.0;
            this.setRefreshGap();
            if (this.m_updateHandler == null) {
                System.err.println("Starting handler");
                this.startHandler();
            }
        } else {
            this.m_outputFrame.toFront();
        }
    }

    private int convertToPanelY(double yval) {
        int height = this.m_plotPanel.getHeight();
        double temp = (yval - this.m_min) / (this.m_max - this.m_min);
        temp *= (double)height;
        temp = (double)height - temp;
        return (int)temp;
    }

    protected void updateChart(double[] dataPoint) {
        if (this.m_previousY[0] == -1.0) {
            int iw = this.m_plotPanel.getWidth();
            int ih = this.m_plotPanel.getHeight();
            this.m_osi = this.m_plotPanel.createImage(iw, ih);
            Graphics m = this.m_osi.getGraphics();
            m.setColor(this.m_BackgroundColor);
            m.fillRect(0, 0, iw, ih);
            this.m_previousY[0] = this.convertToPanelY(0.0);
            this.m_iheight = ih;
            this.m_iwidth = iw;
        }
        if (dataPoint.length - 1 != this.m_previousY.length) {
            this.m_previousY = new double[dataPoint.length - 1];
            for (int i2 = 0; i2 < dataPoint.length - 1; ++i2) {
                this.m_previousY[i2] = this.convertToPanelY(0.0);
            }
        }
        Graphics osg = this.m_osi.getGraphics();
        Graphics g = this.m_plotPanel.getGraphics();
        osg.copyArea(this.m_refreshWidth, 0, this.m_iwidth - this.m_refreshWidth, this.m_iheight, -this.m_refreshWidth, 0);
        osg.setColor(this.m_BackgroundColor);
        osg.fillRect(this.m_iwidth - this.m_refreshWidth, 0, this.m_iwidth, this.m_iheight);
        if (this.m_yScaleUpdate) {
            String maxVal = StripChart.numToString(this.m_oldMax);
            String minVal = StripChart.numToString(this.m_oldMin);
            String midVal = StripChart.numToString((this.m_oldMax - this.m_oldMin) / 2.0);
            if (this.m_labelMetrics == null) {
                this.m_labelMetrics = g.getFontMetrics(this.m_labelFont);
            }
            osg.setFont(this.m_labelFont);
            int wmx = this.m_labelMetrics.stringWidth(maxVal);
            int wmn = this.m_labelMetrics.stringWidth(minVal);
            int wmd = this.m_labelMetrics.stringWidth(midVal);
            int hf = this.m_labelMetrics.getAscent();
            osg.setColor(this.m_colorList[this.m_colorList.length - 1]);
            osg.drawString(maxVal, this.m_iwidth - wmx, hf - 2);
            osg.drawString(midVal, this.m_iwidth - wmd, this.m_iheight / 2 + hf / 2);
            osg.drawString(minVal, this.m_iwidth - wmn, this.m_iheight - 1);
            this.m_yScaleUpdate = false;
        }
        for (int i3 = 0; i3 < dataPoint.length - 1; ++i3) {
            int hf;
            if (Utils.isMissingValue(dataPoint[i3])) continue;
            osg.setColor(this.m_colorList[i3 % this.m_colorList.length]);
            double pos = this.convertToPanelY(dataPoint[i3]);
            osg.drawLine(this.m_iwidth - this.m_refreshWidth, (int)this.m_previousY[i3], this.m_iwidth - 1, (int)pos);
            this.m_previousY[i3] = pos;
            if (dataPoint[dataPoint.length - 1] % (double)this.m_xValFreq != 0.0) continue;
            String val = StripChart.numToString(dataPoint[i3]);
            if (this.m_labelMetrics == null) {
                this.m_labelMetrics = g.getFontMetrics(this.m_labelFont);
            }
            if (pos - (double)(hf = this.m_labelMetrics.getAscent()) < 0.0) {
                pos += (double)hf;
            }
            int w = this.m_labelMetrics.stringWidth(val);
            osg.setFont(this.m_labelFont);
            osg.drawString(val, this.m_iwidth - w, (int)pos);
        }
        if (dataPoint[dataPoint.length - 1] % (double)this.m_xValFreq == 0.0) {
            String xVal = "" + (int)dataPoint[dataPoint.length - 1];
            osg.setColor(this.m_colorList[this.m_colorList.length - 1]);
            int w = this.m_labelMetrics.stringWidth(xVal);
            osg.setFont(this.m_labelFont);
            osg.drawString(xVal, this.m_iwidth - w, this.m_iheight - 1);
        }
        g.drawImage(this.m_osi, 0, 0, this.m_plotPanel);
    }

    private static String numToString(double num) {
        int precision = 1;
        int whole = (int)Math.abs(num);
        double decimal = Math.abs(num) - (double)whole;
        int nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
        int n = precision = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(num)) / Math.log(10.0)) + 2 : 1;
        if (precision > 5) {
            precision = 1;
        }
        String numString = Utils.doubleToString(num, nondecimal + 1 + precision, precision);
        return numString;
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        if (e.getStatus() == 0) {
            Instances structure = e.getStructure();
            this.m_legendText = new Vector();
            this.m_max = 1.0;
            this.m_min = 0.0;
            int i2 = 0;
            for (i2 = 0; i2 < structure.numAttributes(); ++i2) {
                if (i2 > 10) {
                    --i2;
                    break;
                }
                this.m_legendText.addElement(structure.attribute(i2).name());
                this.m_legendPanel.repaint();
                this.m_scalePanel.repaint();
            }
            this.m_dataPoint = new double[i2];
            this.m_xCount = 0;
            return;
        }
        Instance inst = e.getInstance();
        for (int i3 = 0; i3 < this.m_dataPoint.length; ++i3) {
            if (inst.isMissing(i3)) continue;
            this.m_dataPoint[i3] = inst.value(i3);
        }
        this.acceptDataPoint(this.m_dataPoint);
        ++this.m_xCount;
    }

    @Override
    public void acceptDataPoint(ChartEvent e) {
        if (e.getReset()) {
            this.m_xCount = 0;
            this.m_max = 1.0;
            this.m_min = 0.0;
        }
        if (this.m_outputFrame != null) {
            boolean refresh = false;
            if (e.getLegendText() != null & e.getLegendText() != this.m_legendText) {
                this.m_legendText = e.getLegendText();
                refresh = true;
            }
            if (e.getMin() != this.m_min || e.getMax() != this.m_max) {
                this.m_oldMax = this.m_max;
                this.m_oldMin = this.m_min;
                this.m_max = e.getMax();
                this.m_min = e.getMin();
                refresh = true;
                this.m_yScaleUpdate = true;
            }
            if (refresh) {
                this.m_legendPanel.repaint();
                this.m_scalePanel.repaint();
            }
            this.acceptDataPoint(e.getDataPoint());
        }
        ++this.m_xCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDataPoint(double[] dataPoint) {
        if (this.m_outputFrame != null && this.m_xCount % this.m_refreshFrequency == 0) {
            double[] dp = new double[dataPoint.length + 1];
            dp[dp.length - 1] = this.m_xCount;
            System.arraycopy(dataPoint, 0, dp, 0, dataPoint.length);
            for (double element : dataPoint) {
                if (element < this.m_min) {
                    this.m_oldMin = this.m_min;
                    this.m_min = element;
                    this.m_yScaleUpdate = true;
                }
                if (!(element > this.m_max)) continue;
                this.m_oldMax = this.m_max;
                this.m_max = element;
                this.m_yScaleUpdate = true;
            }
            if (this.m_yScaleUpdate) {
                this.m_scalePanel.repaint();
                this.m_yScaleUpdate = false;
            }
            LinkedList<double[]> linkedList = this.m_dataList;
            synchronized (linkedList) {
                this.m_dataList.add(this.m_dataList.size(), dp);
                this.m_dataList.notifyAll();
            }
        }
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/StripChart.gif", "weka/gui/beans/icons/StripChart_animated.gif");
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void setLog(Logger logger) {
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return this.m_listenee == null;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        this.m_listenee = null;
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        newVector.addElement("Show chart");
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Show chart") != 0) {
            throw new IllegalArgumentException(request + " not supported (StripChart)");
        }
        this.showChart();
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Knowledge Flow : StipChart");
            jf.getContentPane().setLayout(new BorderLayout());
            StripChart jd = new StripChart();
            jf.getContentPane().add((Component)jd, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            jd.showChart();
            Random r = new Random(1L);
            for (int i2 = 0; i2 < 1020; ++i2) {
                double[] pos = new double[]{r.nextDouble()};
                jd.acceptDataPoint(pos);
            }
            System.err.println("Done sending data");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    private class LegendPanel
    extends JPanel {
        private static final long serialVersionUID = 7713986576833797583L;

        private LegendPanel() {
        }

        @Override
        public void paintComponent(Graphics gx) {
            super.paintComponent(gx);
            if (StripChart.this.m_labelMetrics == null) {
                StripChart.this.m_labelMetrics = gx.getFontMetrics(StripChart.this.m_labelFont);
            }
            int hf = StripChart.this.m_labelMetrics.getAscent();
            int x = 10;
            int y = hf + 15;
            gx.setFont(StripChart.this.m_labelFont);
            for (int i2 = 0; i2 < StripChart.this.m_legendText.size(); ++i2) {
                String temp = (String)StripChart.this.m_legendText.elementAt(i2);
                gx.setColor(StripChart.this.m_colorList[i2 % StripChart.this.m_colorList.length]);
                gx.drawString(temp, x, y);
                y += hf;
            }
            StripChart.this.revalidate();
        }
    }

    private class ScalePanel
    extends JPanel {
        private static final long serialVersionUID = 6416998474984829434L;

        private ScalePanel() {
        }

        @Override
        public void paintComponent(Graphics gx) {
            super.paintComponent(gx);
            if (StripChart.this.m_labelMetrics == null) {
                StripChart.this.m_labelMetrics = gx.getFontMetrics(StripChart.this.m_labelFont);
            }
            gx.setFont(StripChart.this.m_labelFont);
            int hf = StripChart.this.m_labelMetrics.getAscent();
            String temp = "" + StripChart.this.m_max;
            gx.setColor(StripChart.this.m_colorList[StripChart.this.m_colorList.length - 1]);
            gx.drawString(temp, 1, hf - 2);
            temp = "" + (StripChart.this.m_min + (StripChart.this.m_max - StripChart.this.m_min) / 2.0);
            gx.drawString(temp, 1, this.getHeight() / 2 + hf / 2);
            temp = "" + StripChart.this.m_min;
            gx.drawString(temp, 1, this.getHeight() - 1);
        }
    }

    private class StripPlotter
    extends JPanel {
        private static final long serialVersionUID = -7056271598761675879L;

        private StripPlotter() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (StripChart.this.m_osi != null) {
                g.drawImage(StripChart.this.m_osi, 0, 0, this);
            }
        }
    }
}

