/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.beans.AbstractOffscreenChartRenderer;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.PlotData2D;

public class WekaOffscreenChartRenderer
extends AbstractOffscreenChartRenderer {
    @Override
    public String rendererName() {
        return "Weka Chart Renderer";
    }

    @Override
    public String optionsTipTextHTML() {
        return "<html><ul><li>-title=[chart title]</li><li>-color=[coloring/class attribute name]</li></html>";
    }

    @Override
    public BufferedImage renderXYLineChart(int width, int height, List<Instances> series, String xAxis, String yAxis, List<String> optionalArgs) throws Exception {
        BufferedImage osi = new BufferedImage(width, height, 1);
        String plotTitle = "Line chart";
        String userTitle = this.getOption(optionalArgs, "-title");
        plotTitle = userTitle != null ? userTitle : plotTitle;
        Plot2D offScreenPlot = new Plot2D();
        offScreenPlot.setSize(width, height);
        PlotData2D master = new PlotData2D(series.get(0));
        master.setPlotName(plotTitle);
        boolean[] connectPoints = new boolean[series.get(0).numInstances()];
        for (int i2 = 0; i2 < connectPoints.length; ++i2) {
            connectPoints[i2] = true;
        }
        master.setConnectPoints(connectPoints);
        offScreenPlot.setMasterPlot(master);
        Instances masterInstances = series.get(0);
        int xAx = this.getIndexOfAttribute(masterInstances, xAxis);
        int yAx = this.getIndexOfAttribute(masterInstances, yAxis);
        if (xAx < 0) {
            xAx = 0;
        }
        if (yAx < 0) {
            yAx = 0;
        }
        offScreenPlot.setXindex(xAx);
        offScreenPlot.setYindex(yAx);
        offScreenPlot.setCindex(masterInstances.numAttributes() - 1);
        String colorAtt = this.getOption(optionalArgs, "-color");
        int tempC = this.getIndexOfAttribute(masterInstances, colorAtt);
        if (tempC >= 0) {
            offScreenPlot.setCindex(tempC);
        }
        if (series.size() > 1) {
            for (Instances plotI : series) {
                PlotData2D plotD = new PlotData2D(plotI);
                connectPoints = new boolean[plotI.numInstances()];
                for (int i3 = 0; i3 < connectPoints.length; ++i3) {
                    connectPoints[i3] = true;
                }
                plotD.setConnectPoints(connectPoints);
                offScreenPlot.addPlot(plotD);
            }
        }
        Graphics g = osi.getGraphics();
        offScreenPlot.paintComponent(g);
        return osi;
    }

    @Override
    public BufferedImage renderXYScatterPlot(int width, int height, List<Instances> series, String xAxis, String yAxis, List<String> optionalArgs) throws Exception {
        int shapeSizeI;
        String shapeSize;
        String hasErrors;
        BufferedImage osi = new BufferedImage(width, height, 1);
        String plotTitle = "Scatter plot";
        String userTitle = this.getOption(optionalArgs, "-title");
        plotTitle = userTitle != null ? userTitle : plotTitle;
        Plot2D offScreenPlot = new Plot2D();
        offScreenPlot.setSize(width, height);
        PlotData2D master = new PlotData2D(series.get(0));
        master.setPlotName(plotTitle);
        master.m_displayAllPoints = true;
        offScreenPlot.setMasterPlot(master);
        Instances masterInstances = series.get(0);
        int xAx = this.getIndexOfAttribute(masterInstances, xAxis);
        int yAx = this.getIndexOfAttribute(masterInstances, yAxis);
        if (xAx < 0) {
            xAx = 0;
        }
        if (yAx < 0) {
            yAx = 0;
        }
        offScreenPlot.setXindex(xAx);
        offScreenPlot.setYindex(yAx);
        offScreenPlot.setCindex(masterInstances.numAttributes() - 1);
        String colorAtt = this.getOption(optionalArgs, "-color");
        int tempC = this.getIndexOfAttribute(masterInstances, colorAtt);
        if (tempC >= 0) {
            offScreenPlot.setCindex(tempC);
        }
        if ((hasErrors = this.getOption(optionalArgs, "-hasErrors")) != null) {
            int[] plotShapes = new int[masterInstances.numInstances()];
            for (int i2 = 0; i2 < plotShapes.length; ++i2) {
                plotShapes[i2] = 1000;
            }
            master.setShapeType(plotShapes);
        }
        if ((shapeSize = this.getOption(optionalArgs, "-shapeSize")) != null && shapeSize.length() > 0 && (shapeSizeI = this.getIndexOfAttribute(masterInstances, shapeSize)) >= 0) {
            int[] plotSizes = new int[masterInstances.numInstances()];
            for (int i3 = 0; i3 < masterInstances.numInstances(); ++i3) {
                plotSizes[i3] = (int)masterInstances.instance(i3).value(shapeSizeI);
            }
            master.setShapeSize(plotSizes);
        }
        if (series.size() > 1) {
            for (Instances plotI : series) {
                int shapeSizeI2;
                PlotData2D plotD = new PlotData2D(plotI);
                plotD.m_displayAllPoints = true;
                offScreenPlot.addPlot(plotD);
                if (shapeSize != null && shapeSize.length() > 0 && (shapeSizeI2 = this.getIndexOfAttribute(plotI, shapeSize)) >= 0) {
                    int[] plotSizes = new int[plotI.numInstances()];
                    for (int i4 = 0; i4 < plotI.numInstances(); ++i4) {
                        plotSizes[i4] = (int)plotI.instance(i4).value(shapeSizeI2);
                    }
                    plotD.setShapeSize(plotSizes);
                }
                if (hasErrors == null) continue;
                int[] plotShapes = new int[plotI.numInstances()];
                for (int i5 = 0; i5 < plotShapes.length; ++i5) {
                    plotShapes[i5] = 0;
                }
                plotD.setShapeType(plotShapes);
            }
        }
        Graphics g = osi.getGraphics();
        offScreenPlot.paintComponent(g);
        return osi;
    }

    @Override
    public BufferedImage renderHistogram(int width, int height, List<Instances> series, String attToPlot, List<String> optionalArgs) throws Exception {
        BufferedImage osi = new BufferedImage(width, height, 1);
        Instances toPlot = new Instances(series.get(0));
        for (int i2 = 1; i2 < series.size(); ++i2) {
            Instances additional = series.get(i2);
            for (Instance temp : additional) {
                toPlot.add(temp);
            }
        }
        int attIndex = this.getIndexOfAttribute(toPlot, attToPlot);
        if (attIndex < 0) {
            attIndex = 0;
        }
        String colorAtt = this.getOption(optionalArgs, "-color");
        int tempC = this.getIndexOfAttribute(toPlot, colorAtt);
        AttributeVisualizationPanel offScreenPlot = new AttributeVisualizationPanel();
        offScreenPlot.setSize(width, height);
        offScreenPlot.setInstances(toPlot);
        offScreenPlot.setAttribute(attIndex);
        if (tempC >= 0) {
            offScreenPlot.setColoringIndex(tempC);
        }
        Graphics g = osi.getGraphics();
        offScreenPlot.paintComponent(g);
        Thread.sleep(2000L);
        offScreenPlot.paintComponent(g);
        return osi;
    }
}

