/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.boundaryvisualizer.DataGenerator;
import weka.gui.boundaryvisualizer.KDDataGenerator;

public class BoundaryPanel
extends JPanel {
    private static final long serialVersionUID = -8499445518744770458L;
    public static final Color[] DEFAULT_COLORS = new Color[]{Color.red, Color.green, Color.blue, new Color(0, 255, 255), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255), new Color(0, 0, 0)};
    public static final double REMOVE_POINT_RADIUS = 7.0;
    protected ArrayList<Color> m_Colors = new ArrayList();
    protected Instances m_trainingData;
    protected Classifier m_classifier;
    protected DataGenerator m_dataGenerator;
    private int m_classIndex = -1;
    protected int m_xAttribute;
    protected int m_yAttribute;
    protected double m_minX;
    protected double m_minY;
    protected double m_maxX;
    protected double m_maxY;
    private double m_rangeX;
    private double m_rangeY;
    protected double m_pixHeight;
    protected double m_pixWidth;
    protected Image m_osi = null;
    protected int m_panelWidth;
    protected int m_panelHeight;
    protected int m_numOfSamplesPerRegion = 2;
    protected int m_numOfSamplesPerGenerator;
    protected double m_samplesBase = 2.0;
    private final Vector<ActionListener> m_listeners = new Vector();
    private final PlotPanel m_plotPanel = new PlotPanel();
    private Thread m_plotThread = null;
    protected boolean m_stopPlotting = false;
    protected boolean m_stopReplotting = false;
    private final Double m_dummy = new Double(1.0);
    private boolean m_pausePlotting = false;
    private int m_size = 1;
    private boolean m_initialTiling;
    private Random m_random = null;
    protected double[][][] m_probabilityCache;
    protected boolean m_plotTrainingData = true;

    public BoundaryPanel(int panelWidth, int panelHeight) {
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.m_panelWidth = panelWidth;
        this.m_panelHeight = panelHeight;
        this.setLayout(new BorderLayout());
        this.m_plotPanel.setMinimumSize(new Dimension(this.m_panelWidth, this.m_panelHeight));
        this.m_plotPanel.setPreferredSize(new Dimension(this.m_panelWidth, this.m_panelHeight));
        this.m_plotPanel.setMaximumSize(new Dimension(this.m_panelWidth, this.m_panelHeight));
        this.add((Component)this.m_plotPanel, "Center");
        this.setPreferredSize(this.m_plotPanel.getPreferredSize());
        this.setMaximumSize(this.m_plotPanel.getMaximumSize());
        this.setMinimumSize(this.m_plotPanel.getMinimumSize());
        this.m_random = new Random(1L);
        for (Color element : DEFAULT_COLORS) {
            this.m_Colors.add(new Color(element.getRed(), element.getGreen(), element.getBlue()));
        }
        this.m_probabilityCache = new double[this.m_panelHeight][this.m_panelWidth][];
    }

    public void setNumSamplesPerRegion(int num) {
        this.m_numOfSamplesPerRegion = num;
    }

    public int getNumSamplesPerRegion() {
        return this.m_numOfSamplesPerRegion;
    }

    public void setGeneratorSamplesBase(double ksb) {
        this.m_samplesBase = ksb;
    }

    public double getGeneratorSamplesBase() {
        return this.m_samplesBase;
    }

    protected void initialize() {
        int iwidth = this.m_plotPanel.getWidth();
        int iheight = this.m_plotPanel.getHeight();
        this.m_osi = this.m_plotPanel.createImage(iwidth, iheight);
        Graphics m = this.m_osi.getGraphics();
        m.fillRect(0, 0, iwidth, iheight);
    }

    public void stopPlotting() {
        this.m_stopPlotting = true;
        try {
            this.m_plotThread.join(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void computeMinMaxAtts() {
        this.m_minX = Double.MAX_VALUE;
        this.m_minY = Double.MAX_VALUE;
        this.m_maxX = Double.MIN_VALUE;
        this.m_maxY = Double.MIN_VALUE;
        boolean allPointsLessThanOne = true;
        if (this.m_trainingData.numInstances() == 0) {
            this.m_minY = 0.0;
            this.m_minX = 0.0;
            this.m_maxY = 1.0;
            this.m_maxX = 1.0;
        } else {
            for (int i2 = 0; i2 < this.m_trainingData.numInstances(); ++i2) {
                Instance inst = this.m_trainingData.instance(i2);
                double x = inst.value(this.m_xAttribute);
                double y = inst.value(this.m_yAttribute);
                if (Utils.isMissingValue(x) || Utils.isMissingValue(y)) continue;
                if (x < this.m_minX) {
                    this.m_minX = x;
                }
                if (x > this.m_maxX) {
                    this.m_maxX = x;
                }
                if (y < this.m_minY) {
                    this.m_minY = y;
                }
                if (y > this.m_maxY) {
                    this.m_maxY = y;
                }
                if (!(x > 1.0) && !(y > 1.0)) continue;
                allPointsLessThanOne = false;
            }
        }
        if (this.m_minX == this.m_maxX) {
            this.m_minX = 0.0;
        }
        if (this.m_minY == this.m_maxY) {
            this.m_minY = 0.0;
        }
        if (this.m_minX == Double.MAX_VALUE) {
            this.m_minX = 0.0;
        }
        if (this.m_minY == Double.MAX_VALUE) {
            this.m_minY = 0.0;
        }
        if (this.m_maxX == Double.MIN_VALUE) {
            this.m_maxX = 1.0;
        }
        if (this.m_maxY == Double.MIN_VALUE) {
            this.m_maxY = 1.0;
        }
        if (allPointsLessThanOne) {
            this.m_maxY = 1.0;
            this.m_maxX = 1.0;
        }
        this.m_rangeX = this.m_maxX - this.m_minX;
        this.m_rangeY = this.m_maxY - this.m_minY;
        this.m_pixWidth = this.m_rangeX / (double)this.m_panelWidth;
        this.m_pixHeight = this.m_rangeY / (double)this.m_panelHeight;
    }

    private double getRandomX(int pix) {
        double minPix = this.m_minX + (double)pix * this.m_pixWidth;
        return minPix + this.m_random.nextDouble() * this.m_pixWidth;
    }

    private double getRandomY(int pix) {
        double minPix = this.m_minY + (double)pix * this.m_pixHeight;
        return minPix + this.m_random.nextDouble() * this.m_pixHeight;
    }

    public void start() throws Exception {
        this.m_numOfSamplesPerGenerator = (int)Math.pow(this.m_samplesBase, this.m_trainingData.numAttributes() - 3);
        this.m_stopReplotting = true;
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (this.m_classifier == null) {
            throw new Exception("No classifier set (BoundaryPanel)");
        }
        if (this.m_dataGenerator == null) {
            throw new Exception("No data generator set (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(this.m_xAttribute).isNominal() || this.m_trainingData.attribute(this.m_yAttribute).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.computeMinMaxAtts();
        this.startPlotThread();
    }

    public void plotTrainingData() {
        Graphics2D osg = (Graphics2D)this.m_osi.getGraphics();
        Graphics g = this.m_plotPanel.getGraphics();
        osg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double xval = 0.0;
        double yval = 0.0;
        for (int i2 = 0; i2 < this.m_trainingData.numInstances(); ++i2) {
            if (this.m_trainingData.instance(i2).isMissing(this.m_xAttribute) || this.m_trainingData.instance(i2).isMissing(this.m_yAttribute) || this.m_trainingData.instance(i2).isMissing(this.m_classIndex)) continue;
            xval = this.m_trainingData.instance(i2).value(this.m_xAttribute);
            yval = this.m_trainingData.instance(i2).value(this.m_yAttribute);
            int panelX = this.convertToPanelX(xval);
            int panelY = this.convertToPanelY(yval);
            Color ColorToPlotWith = this.m_Colors.get((int)this.m_trainingData.instance(i2).value(this.m_classIndex) % this.m_Colors.size());
            if (ColorToPlotWith.equals(Color.white)) {
                osg.setColor(Color.black);
            } else {
                osg.setColor(Color.white);
            }
            osg.fillOval(panelX - 3, panelY - 3, 7, 7);
            osg.setColor(ColorToPlotWith);
            osg.fillOval(panelX - 2, panelY - 2, 5, 5);
        }
        g.drawImage(this.m_osi, 0, 0, this.m_plotPanel);
    }

    private int convertToPanelX(double xval) {
        double temp = (xval - this.m_minX) / this.m_rangeX;
        return (int)(temp *= (double)this.m_panelWidth);
    }

    private int convertToPanelY(double yval) {
        double temp = (yval - this.m_minY) / this.m_rangeY;
        temp *= (double)this.m_panelHeight;
        temp = (double)this.m_panelHeight - temp;
        return (int)temp;
    }

    private double convertFromPanelX(double pX) {
        pX /= (double)this.m_panelWidth;
        return (pX *= this.m_rangeX) + this.m_minX;
    }

    private double convertFromPanelY(double pY) {
        pY = (double)this.m_panelHeight - pY;
        pY /= (double)this.m_panelHeight;
        return (pY *= this.m_rangeY) + this.m_minY;
    }

    protected void plotPoint(int x, int y, double[] probs, boolean update) {
        this.plotPoint(x, y, 1, 1, probs, update);
    }

    private void plotPoint(int x, int y, int width, int height, double[] probs, boolean update) {
        Graphics osg = this.m_osi.getGraphics();
        if (update) {
            osg.setXORMode(Color.white);
            osg.drawLine(0, y, this.m_panelWidth - 1, y);
            this.update();
            osg.drawLine(0, y, this.m_panelWidth - 1, y);
        }
        osg.setPaintMode();
        float[] colVal = new float[3];
        float[] tempCols = new float[3];
        for (int k = 0; k < probs.length; ++k) {
            Color curr = this.m_Colors.get(k % this.m_Colors.size());
            curr.getRGBColorComponents(tempCols);
            for (int z = 0; z < 3; ++z) {
                int n = z;
                colVal[n] = (float)((double)colVal[n] + probs[k] * (double)tempCols[z]);
            }
        }
        for (int z = 0; z < 3; ++z) {
            if (colVal[z] < 0.0f) {
                colVal[z] = 0.0f;
                continue;
            }
            if (!(colVal[z] > 1.0f)) continue;
            colVal[z] = 1.0f;
        }
        osg.setColor(new Color(colVal[0], colVal[1], colVal[2]));
        osg.fillRect(x, y, width, height);
    }

    private void update() {
        Graphics g = this.m_plotPanel.getGraphics();
        g.drawImage(this.m_osi, 0, 0, this.m_plotPanel);
    }

    public void setTrainingData(Instances trainingData) throws Exception {
        this.m_trainingData = trainingData;
        if (this.m_trainingData.classIndex() < 0) {
            throw new Exception("No class attribute set (BoundaryPanel)");
        }
        this.m_classIndex = this.m_trainingData.classIndex();
    }

    public void addTrainingInstance(Instance instance) {
        if (this.m_trainingData == null) {
            System.err.println("Trying to add to a null training set (BoundaryPanel)");
        } else {
            this.m_trainingData.add(instance);
        }
    }

    public void addActionListener(ActionListener newListener) {
        this.m_listeners.add(newListener);
    }

    public void removeActionListener(ActionListener removeListener) {
        this.m_listeners.removeElement(removeListener);
    }

    public void setClassifier(Classifier classifier) {
        this.m_classifier = classifier;
    }

    public void setDataGenerator(DataGenerator dataGenerator) {
        this.m_dataGenerator = dataGenerator;
    }

    public void setXAttribute(int xatt) throws Exception {
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (xatt < 0 || xatt > this.m_trainingData.numAttributes()) {
            throw new Exception("X attribute out of range (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(xatt).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.m_xAttribute = xatt;
    }

    public void setYAttribute(int yatt) throws Exception {
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (yatt < 0 || yatt > this.m_trainingData.numAttributes()) {
            throw new Exception("X attribute out of range (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(yatt).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.m_yAttribute = yatt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColors(ArrayList<Color> colors) {
        ArrayList<Color> arrayList = this.m_Colors;
        synchronized (arrayList) {
            this.m_Colors = colors;
        }
        this.update();
    }

    public void setPlotTrainingData(boolean pg) {
        this.m_plotTrainingData = pg;
    }

    public boolean getPlotTrainingData() {
        return this.m_plotTrainingData;
    }

    public ArrayList<Color> getColors() {
        return this.m_Colors;
    }

    public void replot() {
        if (this.m_probabilityCache[0][0] == null) {
            return;
        }
        this.m_stopReplotting = true;
        this.m_pausePlotting = true;
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread replotThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BoundaryPanel.this.m_stopReplotting = false;
                int size2 = BoundaryPanel.this.m_size / 2;
                block3: for (int i2 = 0; i2 < BoundaryPanel.this.m_panelHeight; i2 += BoundaryPanel.this.m_size) {
                    for (int j = 0; j < BoundaryPanel.this.m_panelWidth; j += BoundaryPanel.this.m_size) {
                        boolean update;
                        if (BoundaryPanel.this.m_probabilityCache[i2][j] == null || BoundaryPanel.this.m_stopReplotting) break block3;
                        boolean bl = update = j == 0 && i2 % 2 == 0;
                        if (i2 >= BoundaryPanel.this.m_panelHeight || j >= BoundaryPanel.this.m_panelWidth) continue;
                        if (BoundaryPanel.this.m_initialTiling || BoundaryPanel.this.m_size == 1) {
                            if (BoundaryPanel.this.m_probabilityCache[i2][j] == null) break block3;
                            BoundaryPanel.this.plotPoint(j, i2, BoundaryPanel.this.m_size, BoundaryPanel.this.m_size, BoundaryPanel.this.m_probabilityCache[i2][j], update);
                            continue;
                        }
                        if (BoundaryPanel.this.m_probabilityCache[i2 + size2][j] == null) break block3;
                        BoundaryPanel.this.plotPoint(j, i2 + size2, size2, size2, BoundaryPanel.this.m_probabilityCache[i2 + size2][j], update);
                        if (BoundaryPanel.this.m_probabilityCache[i2 + size2][j + size2] == null) break block3;
                        BoundaryPanel.this.plotPoint(j + size2, i2 + size2, size2, size2, BoundaryPanel.this.m_probabilityCache[i2 + size2][j + size2], update);
                        if (BoundaryPanel.this.m_probabilityCache[i2][j + size2] == null) break block3;
                        BoundaryPanel.this.plotPoint(j + size2, i2, size2, size2, BoundaryPanel.this.m_probabilityCache[i2 + size2][j], update);
                    }
                }
                BoundaryPanel.this.update();
                if (BoundaryPanel.this.m_plotTrainingData) {
                    BoundaryPanel.this.plotTrainingData();
                }
                BoundaryPanel.this.m_pausePlotting = false;
                if (!BoundaryPanel.this.m_stopPlotting) {
                    Double d = BoundaryPanel.this.m_dummy;
                    synchronized (d) {
                        BoundaryPanel.this.m_dummy.notifyAll();
                    }
                }
            }
        };
        replotThread.start();
    }

    protected void saveImage(String fileName) {
        try {
            BufferedImage bi = new BufferedImage(this.m_panelWidth, this.m_panelHeight, 1);
            Graphics2D gr2 = bi.createGraphics();
            gr2.drawImage(this.m_osi, 0, 0, this.m_panelWidth, this.m_panelHeight, null);
            ImageWriter writer = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
            if (!iter.hasNext()) {
                throw new Exception("No JPEG writer available!");
            }
            writer = iter.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(fileName));
            writer.setOutput(ios);
            JPEGImageWriteParam param = new JPEGImageWriteParam(Locale.getDefault());
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
            writer.write(null, new IIOImage(bi, null, null), param);
            ios.flush();
            writer.dispose();
            ios.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTrainingInstanceFromMouseLocation(int mouseX, int mouseY, int classAttIndex, double classValue) {
        double x = this.convertFromPanelX(mouseX);
        double y = this.convertFromPanelY(mouseY);
        DenseInstance newInstance = new DenseInstance(this.m_trainingData.numAttributes());
        for (int i2 = 0; i2 < newInstance.numAttributes(); ++i2) {
            if (i2 == classAttIndex) {
                newInstance.setValue(i2, classValue);
                continue;
            }
            if (i2 == this.m_xAttribute) {
                newInstance.setValue(i2, x);
                continue;
            }
            if (i2 == this.m_yAttribute) {
                newInstance.setValue(i2, y);
                continue;
            }
            newInstance.setMissing(i2);
        }
        this.addTrainingInstance(newInstance);
    }

    public void removeAllInstances() {
        if (this.m_trainingData != null) {
            this.m_trainingData.delete();
            try {
                this.initialize();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeTrainingInstanceFromMouseLocation(int mouseX, int mouseY) {
        double x = this.convertFromPanelX(mouseX);
        double y = this.convertFromPanelY(mouseY);
        int bestIndex = -1;
        double bestDistanceBetween = 2.147483647E9;
        for (int i2 = 0; i2 < this.m_trainingData.numInstances(); ++i2) {
            Instance current = this.m_trainingData.instance(i2);
            double distanceBetween = (current.value(this.m_xAttribute) - x) * (current.value(this.m_xAttribute) - x) + (current.value(this.m_yAttribute) - y) * (current.value(this.m_yAttribute) - y);
            if (!(distanceBetween < bestDistanceBetween)) continue;
            bestIndex = i2;
            bestDistanceBetween = distanceBetween;
        }
        if (bestIndex == -1) {
            return;
        }
        Instance best = this.m_trainingData.instance(bestIndex);
        double panelDistance = (this.convertToPanelX(best.value(this.m_xAttribute)) - mouseX) * (this.convertToPanelX(best.value(this.m_xAttribute)) - mouseX) + (this.convertToPanelY(best.value(this.m_yAttribute)) - mouseY) * (this.convertToPanelY(best.value(this.m_yAttribute)) - mouseY);
        if (panelDistance < 49.0) {
            this.m_trainingData.delete(bestIndex);
        }
    }

    public void startPlotThread() {
        if (this.m_plotThread == null) {
            this.m_plotThread = new PlotThread();
            this.m_plotThread.setPriority(1);
            this.m_plotThread.start();
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.m_plotPanel.addMouseListener(l);
    }

    public double getMinXBound() {
        return this.m_minX;
    }

    public double getMinYBound() {
        return this.m_minY;
    }

    public double getMaxXBound() {
        return this.m_maxX;
    }

    public double getMaxYBound() {
        return this.m_maxY;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 8) {
                System.err.println("Usage : BoundaryPanel <dataset> <class col> <xAtt> <yAtt> <base> <# loc/pixel> <kernel bandwidth> <display width> <display height> <classifier [classifier options]>");
                System.exit(1);
            }
            final JFrame jf = new JFrame("Weka classification boundary visualizer");
            jf.getContentPane().setLayout(new BorderLayout());
            System.err.println("Loading instances from : " + args[0]);
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            final Instances i2 = new Instances(r);
            i2.setClassIndex(Integer.parseInt(args[1]));
            final int xatt = Integer.parseInt(args[2]);
            final int yatt = Integer.parseInt(args[3]);
            int base = Integer.parseInt(args[4]);
            int loc = Integer.parseInt(args[5]);
            int bandWidth = Integer.parseInt(args[6]);
            int panelWidth = Integer.parseInt(args[7]);
            int panelHeight = Integer.parseInt(args[8]);
            final String classifierName = args[9];
            final BoundaryPanel bv = new BoundaryPanel(panelWidth, panelHeight);
            bv.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String classifierNameNew = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
                    bv.saveImage(classifierNameNew + "_" + i2.relationName() + "_X" + xatt + "_Y" + yatt + ".jpg");
                }
            });
            jf.getContentPane().add((Component)bv, "Center");
            jf.setSize(bv.getMinimumSize());
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            bv.repaint();
            String[] argsR = null;
            if (args.length > 10) {
                argsR = new String[args.length - 10];
                for (int j = 10; j < args.length; ++j) {
                    argsR[j - 10] = args[j];
                }
            }
            Classifier c = AbstractClassifier.forName(args[9], argsR);
            KDDataGenerator dataGen = new KDDataGenerator();
            dataGen.setKernelBandwidth(bandWidth);
            bv.setDataGenerator(dataGen);
            bv.setNumSamplesPerRegion(loc);
            bv.setGeneratorSamplesBase(base);
            bv.setClassifier(c);
            bv.setTrainingData(i2);
            bv.setXAttribute(xatt);
            bv.setYAttribute(yatt);
            try {
                FileInputStream fis = new FileInputStream("colors.ser");
                ObjectInputStream ois = new ObjectInputStream(fis);
                ArrayList colors = (ArrayList)ois.readObject();
                bv.setColors(colors);
                ois.close();
            }
            catch (Exception ex) {
                System.err.println("No color map file");
            }
            bv.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected class PlotThread
    extends Thread {
        double[] m_weightingAttsValues;
        boolean[] m_attsToWeightOn;
        double[] m_vals;
        double[] m_dist;
        Instance m_predInst;

        protected PlotThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block33: {
                BoundaryPanel.this.m_stopPlotting = false;
                try {
                    BoundaryPanel.this.initialize();
                    BoundaryPanel.this.repaint();
                    BoundaryPanel.this.m_probabilityCache = new double[BoundaryPanel.this.m_panelHeight][BoundaryPanel.this.m_panelWidth][];
                    BoundaryPanel.this.m_classifier.buildClassifier(BoundaryPanel.this.m_trainingData);
                    this.m_attsToWeightOn = new boolean[BoundaryPanel.this.m_trainingData.numAttributes()];
                    this.m_attsToWeightOn[BoundaryPanel.this.m_xAttribute] = true;
                    this.m_attsToWeightOn[BoundaryPanel.this.m_yAttribute] = true;
                    BoundaryPanel.this.m_dataGenerator.setWeightingDimensions(this.m_attsToWeightOn);
                    BoundaryPanel.this.m_dataGenerator.buildGenerator(BoundaryPanel.this.m_trainingData);
                    this.m_weightingAttsValues = new double[this.m_attsToWeightOn.length];
                    this.m_vals = new double[BoundaryPanel.this.m_trainingData.numAttributes()];
                    this.m_predInst = new DenseInstance(1.0, this.m_vals);
                    this.m_predInst.setDataset(BoundaryPanel.this.m_trainingData);
                    BoundaryPanel.this.m_size = 16;
                    BoundaryPanel.this.m_initialTiling = true;
                    block24: for (int i2 = 0; i2 <= BoundaryPanel.this.m_panelHeight; i2 += BoundaryPanel.this.m_size) {
                        for (int j = 0; j <= BoundaryPanel.this.m_panelWidth; j += BoundaryPanel.this.m_size) {
                            if (BoundaryPanel.this.m_stopPlotting) break block24;
                            if (BoundaryPanel.this.m_pausePlotting) {
                                Double d = BoundaryPanel.this.m_dummy;
                                synchronized (d) {
                                    try {
                                        BoundaryPanel.this.m_dummy.wait();
                                    }
                                    catch (InterruptedException ex) {
                                        BoundaryPanel.this.m_pausePlotting = false;
                                    }
                                }
                            }
                            BoundaryPanel.this.plotPoint(j, i2, BoundaryPanel.this.m_size, BoundaryPanel.this.m_size, this.calculateRegionProbs(j, i2), j == 0);
                        }
                    }
                    if (!BoundaryPanel.this.m_stopPlotting) {
                        BoundaryPanel.this.m_initialTiling = false;
                    }
                    int size2 = BoundaryPanel.this.m_size / 2;
                    block26: while (BoundaryPanel.this.m_size > 1) {
                        for (int i3 = 0; i3 <= BoundaryPanel.this.m_panelHeight; i3 += BoundaryPanel.this.m_size) {
                            for (int j = 0; j <= BoundaryPanel.this.m_panelWidth; j += BoundaryPanel.this.m_size) {
                                if (BoundaryPanel.this.m_stopPlotting) break block26;
                                if (BoundaryPanel.this.m_pausePlotting) {
                                    Double ex = BoundaryPanel.this.m_dummy;
                                    synchronized (ex) {
                                        try {
                                            BoundaryPanel.this.m_dummy.wait();
                                        }
                                        catch (InterruptedException ex2) {
                                            BoundaryPanel.this.m_pausePlotting = false;
                                        }
                                    }
                                }
                                boolean update = j == 0 && i3 % 2 == 0;
                                BoundaryPanel.this.plotPoint(j, i3 + size2, size2, size2, this.calculateRegionProbs(j, i3 + size2), update);
                                BoundaryPanel.this.plotPoint(j + size2, i3 + size2, size2, size2, this.calculateRegionProbs(j + size2, i3 + size2), update);
                                BoundaryPanel.this.plotPoint(j + size2, i3, size2, size2, this.calculateRegionProbs(j + size2, i3), update);
                            }
                        }
                        BoundaryPanel.this.m_size = size2;
                        size2 /= 2;
                    }
                    BoundaryPanel.this.update();
                    if (!BoundaryPanel.this.m_plotTrainingData) break block33;
                    BoundaryPanel.this.plotTrainingData();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error while plotting: \"" + ex.getMessage() + "\"");
                }
                finally {
                    Vector l;
                    BoundaryPanel.this.m_plotThread = null;
                    ActionEvent e = new ActionEvent(this, 0, "");
                    PlotThread i4 = this;
                    synchronized (i4) {
                        l = (Vector)BoundaryPanel.this.m_listeners.clone();
                    }
                    for (int i5 = 0; i5 < l.size(); ++i5) {
                        ActionListener al = (ActionListener)l.elementAt(i5);
                        al.actionPerformed(e);
                    }
                }
            }
        }

        private double[] calculateRegionProbs(int j, int i2) throws Exception {
            double[] sumOfProbsForRegion = new double[BoundaryPanel.this.m_trainingData.classAttribute().numValues()];
            double sumOfSums = 0.0;
            for (int u = 0; u < BoundaryPanel.this.m_numOfSamplesPerRegion; ++u) {
                int z;
                double[] sumOfProbsForLocation = new double[BoundaryPanel.this.m_trainingData.classAttribute().numValues()];
                this.m_weightingAttsValues[BoundaryPanel.this.m_xAttribute] = BoundaryPanel.this.getRandomX(j);
                this.m_weightingAttsValues[BoundaryPanel.this.m_yAttribute] = BoundaryPanel.this.getRandomY(BoundaryPanel.this.m_panelHeight - i2 - 1);
                BoundaryPanel.this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                double[] weights = BoundaryPanel.this.m_dataGenerator.getWeights();
                double sumOfWeights = Utils.sum(weights);
                sumOfSums += sumOfWeights;
                int[] indices = Utils.sort(weights);
                int[] newIndices = new int[indices.length];
                double sumSoFar = 0.0;
                double criticalMass = 0.99 * sumOfWeights;
                int index = weights.length - 1;
                int counter = 0;
                for (z = weights.length - 1; z >= 0; --z) {
                    newIndices[index--] = indices[z];
                    ++counter;
                    if ((sumSoFar += weights[indices[z]]) > criticalMass) break;
                }
                indices = new int[counter];
                System.arraycopy(newIndices, index + 1, indices, 0, counter);
                for (z = 0; z < BoundaryPanel.this.m_numOfSamplesPerGenerator; ++z) {
                    BoundaryPanel.this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                    double[][] values = BoundaryPanel.this.m_dataGenerator.generateInstances(indices);
                    for (int q = 0; q < values.length; ++q) {
                        if (values[q] == null) continue;
                        System.arraycopy(values[q], 0, this.m_vals, 0, this.m_vals.length);
                        this.m_vals[BoundaryPanel.this.m_xAttribute] = this.m_weightingAttsValues[BoundaryPanel.this.m_xAttribute];
                        this.m_vals[BoundaryPanel.this.m_yAttribute] = this.m_weightingAttsValues[BoundaryPanel.this.m_yAttribute];
                        this.m_dist = BoundaryPanel.this.m_classifier.distributionForInstance(this.m_predInst);
                        for (int k = 0; k < sumOfProbsForLocation.length; ++k) {
                            int n = k;
                            sumOfProbsForLocation[n] = sumOfProbsForLocation[n] + this.m_dist[k] * weights[q];
                        }
                    }
                }
                for (int k = 0; k < sumOfProbsForRegion.length; ++k) {
                    int n = k;
                    sumOfProbsForRegion[n] = sumOfProbsForRegion[n] + sumOfProbsForLocation[k] / (double)BoundaryPanel.this.m_numOfSamplesPerGenerator;
                }
            }
            if (!(sumOfSums > 0.0)) {
                throw new Exception("Arithmetic underflow. Please increase value of kernel bandwidth parameter (k).");
            }
            Utils.normalize(sumOfProbsForRegion, sumOfSums);
            if (i2 < BoundaryPanel.this.m_panelHeight && j < BoundaryPanel.this.m_panelWidth) {
                BoundaryPanel.this.m_probabilityCache[i2][j] = new double[sumOfProbsForRegion.length];
                System.arraycopy(sumOfProbsForRegion, 0, BoundaryPanel.this.m_probabilityCache[i2][j], 0, sumOfProbsForRegion.length);
            }
            return sumOfProbsForRegion;
        }
    }

    private class PlotPanel
    extends JPanel {
        private static final long serialVersionUID = 743629498352235060L;

        public PlotPanel() {
            this.setToolTipText("");
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (BoundaryPanel.this.m_osi != null) {
                g.drawImage(BoundaryPanel.this.m_osi, 0, 0, this);
            }
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (BoundaryPanel.this.m_probabilityCache == null) {
                return null;
            }
            if (BoundaryPanel.this.m_probabilityCache[event.getY()][event.getX()] == null) {
                return null;
            }
            String pVec = "(X: " + Utils.doubleToString(BoundaryPanel.this.convertFromPanelX(event.getX()), 2) + " Y: " + Utils.doubleToString(BoundaryPanel.this.convertFromPanelY(event.getY()), 2) + ") ";
            for (int i2 = 0; i2 < BoundaryPanel.this.m_trainingData.classAttribute().numValues(); ++i2) {
                pVec = pVec + Utils.doubleToString(BoundaryPanel.this.m_probabilityCache[event.getY()][event.getX()][i2], 3) + " ";
            }
            return pVec;
        }
    }
}

