/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.util.ArrayList;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.explorer.AbstractPlotInstances;
import weka.gui.visualize.PlotData2D;

public class ClustererAssignmentsPlotInstances
extends AbstractPlotInstances {
    private static final long serialVersionUID = -4748134272046520423L;
    protected int[] m_PlotShapes;
    protected Clusterer m_Clusterer;
    protected ClusterEvaluation m_Evaluation;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PlotShapes = null;
        this.m_Clusterer = null;
        this.m_Evaluation = null;
    }

    public void setClusterer(Clusterer value) {
        this.m_Clusterer = value;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public void setClusterEvaluation(ClusterEvaluation value) {
        this.m_Evaluation = value;
    }

    public ClusterEvaluation getClusterEvaluation() {
        return this.m_Evaluation;
    }

    @Override
    protected void check() {
        super.check();
        if (this.m_Clusterer == null) {
            throw new IllegalStateException("No clusterer set!");
        }
        if (this.m_Evaluation == null) {
            throw new IllegalStateException("No cluster evaluation set!");
        }
    }

    @Override
    protected void determineFormat() {
        int i2;
        int numClusters = this.m_Evaluation.getNumClusters();
        ArrayList<Attribute> hv = new ArrayList<Attribute>();
        ArrayList<String> clustVals = new ArrayList<String>();
        for (i2 = 0; i2 < numClusters; ++i2) {
            clustVals.add("cluster" + i2);
        }
        Attribute predictedCluster = new Attribute("Cluster", clustVals);
        for (i2 = 0; i2 < this.m_Instances.numAttributes(); ++i2) {
            hv.add((Attribute)this.m_Instances.attribute(i2).copy());
        }
        hv.add(predictedCluster);
        this.m_PlotInstances = new Instances(this.m_Instances.relationName() + "_clustered", hv, this.m_Instances.numInstances());
    }

    protected void process() {
        int i2;
        double[] clusterAssignments = this.m_Evaluation.getClusterAssignments();
        int[] classAssignments = null;
        if (this.m_Instances.classIndex() >= 0) {
            classAssignments = this.m_Evaluation.getClassesToClusters();
            this.m_PlotShapes = new int[this.m_Instances.numInstances()];
            for (i2 = 0; i2 < this.m_Instances.numInstances(); ++i2) {
                this.m_PlotShapes[i2] = -1;
            }
        }
        for (i2 = 0; i2 < this.m_Instances.numInstances(); ++i2) {
            double[] values = new double[this.m_PlotInstances.numAttributes()];
            for (int j = 0; j < this.m_Instances.numAttributes(); ++j) {
                values[j] = this.m_Instances.instance(i2).value(j);
            }
            values[j] = clusterAssignments[i2] < 0.0 ? Utils.missingValue() : clusterAssignments[i2];
            this.m_PlotInstances.add(new DenseInstance(1.0, values));
            if (this.m_PlotShapes == null) continue;
            if (clusterAssignments[i2] >= 0.0) {
                if ((int)this.m_Instances.instance(i2).classValue() == classAssignments[(int)clusterAssignments[i2]]) continue;
                this.m_PlotShapes[i2] = 1000;
                continue;
            }
            this.m_PlotShapes[i2] = 2000;
        }
    }

    @Override
    protected void finishUp() {
        super.finishUp();
        this.process();
    }

    @Override
    protected PlotData2D createPlotData(String name) throws Exception {
        PlotData2D result = new PlotData2D(this.m_PlotInstances);
        if (this.m_PlotShapes != null) {
            result.setShapeType(this.m_PlotShapes);
        }
        result.addInstanceNumberAttribute();
        result.setPlotName(name + " (" + this.m_Instances.relationName() + ")");
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Clusterer = null;
        this.m_Evaluation = null;
        this.m_PlotShapes = null;
    }
}

