/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;

public class DotParser
implements GraphConstants {
    protected ArrayList<GraphNode> m_nodes;
    protected ArrayList<GraphEdge> m_edges;
    protected Reader m_input;
    protected String m_graphName;

    public DotParser(Reader input, ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_input = input;
    }

    public String parse() {
        StreamTokenizer tk = new StreamTokenizer(new BufferedReader(this.m_input));
        this.setSyntax(tk);
        this.graph(tk);
        return this.m_graphName;
    }

    protected void setSyntax(StreamTokenizer tk) {
        tk.resetSyntax();
        tk.eolIsSignificant(false);
        tk.slashStarComments(true);
        tk.slashSlashComments(true);
        tk.whitespaceChars(0, 32);
        tk.wordChars(33, 255);
        tk.ordinaryChar(91);
        tk.ordinaryChar(93);
        tk.ordinaryChar(123);
        tk.ordinaryChar(125);
        tk.ordinaryChar(45);
        tk.ordinaryChar(62);
        tk.ordinaryChar(47);
        tk.ordinaryChar(42);
        tk.quoteChar(34);
        tk.whitespaceChars(59, 59);
        tk.ordinaryChar(61);
    }

    protected void graph(StreamTokenizer tk) {
        GraphEdge e;
        int i2;
        try {
            tk.nextToken();
            if (tk.ttype == -3) {
                if (tk.sval.equalsIgnoreCase("digraph")) {
                    tk.nextToken();
                    if (tk.ttype == -3) {
                        this.m_graphName = tk.sval;
                        tk.nextToken();
                    }
                    while (tk.ttype != 123) {
                        System.err.println("Error at line " + tk.lineno() + " ignoring token " + tk.sval);
                        tk.nextToken();
                        if (tk.ttype != -1) continue;
                        return;
                    }
                    this.stmtList(tk);
                } else if (tk.sval.equalsIgnoreCase("graph")) {
                    System.err.println("Error. Undirected graphs cannot be used");
                } else {
                    System.err.println("Error. Expected graph or digraph at line " + tk.lineno());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int[] noOfEdgesOfNode = new int[this.m_nodes.size()];
        int[] noOfPrntsOfNode = new int[this.m_nodes.size()];
        for (i2 = 0; i2 < this.m_edges.size(); ++i2) {
            e = this.m_edges.get(i2);
            int n = e.src;
            noOfEdgesOfNode[n] = noOfEdgesOfNode[n] + 1;
            int n2 = e.dest;
            noOfPrntsOfNode[n2] = noOfPrntsOfNode[n2] + 1;
        }
        for (i2 = 0; i2 < this.m_edges.size(); ++i2) {
            int k;
            e = this.m_edges.get(i2);
            GraphNode n = this.m_nodes.get(e.src);
            GraphNode n2 = this.m_nodes.get(e.dest);
            if (n.edges == null) {
                n.edges = new int[noOfEdgesOfNode[e.src]][2];
                for (k = 0; k < n.edges.length; ++k) {
                    n.edges[k][1] = 0;
                }
            }
            if (n2.prnts == null) {
                n2.prnts = new int[noOfPrntsOfNode[e.dest]];
                for (k = 0; k < n2.prnts.length; ++k) {
                    n2.prnts[k] = -1;
                }
            }
            k = 0;
            while (n.edges[k][1] != 0) {
                ++k;
            }
            n.edges[k][0] = e.dest;
            n.edges[k][1] = e.type;
            k = 0;
            while (n2.prnts[k] != -1) {
                ++k;
            }
            n2.prnts[k] = e.src;
        }
    }

    protected void stmtList(StreamTokenizer tk) throws Exception {
        tk.nextToken();
        if (tk.ttype == 125 || tk.ttype == -1) {
            return;
        }
        this.stmt(tk);
        this.stmtList(tk);
    }

    protected void stmt(StreamTokenizer tk) {
        if (!(tk.sval.equalsIgnoreCase("graph") || tk.sval.equalsIgnoreCase("node") || tk.sval.equalsIgnoreCase("edge"))) {
            try {
                this.nodeID(tk);
                int nodeindex = this.m_nodes.indexOf(new GraphNode(tk.sval, null));
                tk.nextToken();
                if (tk.ttype == 91) {
                    this.nodeStmt(tk, nodeindex);
                } else if (tk.ttype == 45) {
                    this.edgeStmt(tk, nodeindex);
                } else {
                    System.err.println("error at lineno " + tk.lineno() + " in stmt");
                }
            }
            catch (Exception ex) {
                System.err.println("error at lineno " + tk.lineno() + " in stmtException");
                ex.printStackTrace();
            }
        }
    }

    protected void nodeID(StreamTokenizer tk) throws Exception {
        if (tk.ttype == 34 || tk.ttype == -3 || tk.ttype >= 97 && tk.ttype <= 122 || tk.ttype >= 65 && tk.ttype <= 90) {
            if (this.m_nodes != null && !this.m_nodes.contains(new GraphNode(tk.sval, null))) {
                this.m_nodes.add(new GraphNode(tk.sval, tk.sval));
            }
        } else {
            throw new Exception();
        }
    }

    protected void nodeStmt(StreamTokenizer tk, int nindex) throws Exception {
        tk.nextToken();
        GraphNode temp = this.m_nodes.get(nindex);
        if (tk.ttype == 93 || tk.ttype == -1) {
            return;
        }
        if (tk.ttype == -3) {
            if (tk.sval.equalsIgnoreCase("label")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype == -3 || tk.ttype == 34) {
                        temp.lbl = tk.sval;
                    } else {
                        System.err.println("couldn't find label at line " + tk.lineno());
                        tk.pushBack();
                    }
                } else {
                    System.err.println("couldn't find label at line " + tk.lineno());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("color")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        System.err.println("couldn't find color at line " + tk.lineno());
                        tk.pushBack();
                    }
                } else {
                    System.err.println("couldn't find color at line " + tk.lineno());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("style")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        System.err.println("couldn't find style at line " + tk.lineno());
                        tk.pushBack();
                    }
                } else {
                    System.err.println("couldn't find style at line " + tk.lineno());
                    tk.pushBack();
                }
            }
        }
        this.nodeStmt(tk, nindex);
    }

    protected void edgeStmt(StreamTokenizer tk, int nindex) throws Exception {
        tk.nextToken();
        GraphEdge e = null;
        if (tk.ttype == 62) {
            tk.nextToken();
            if (tk.ttype == 123) {
                while (true) {
                    tk.nextToken();
                    if (tk.ttype != 125) {
                        this.nodeID(tk);
                        e = new GraphEdge(nindex, this.m_nodes.indexOf(new GraphNode(tk.sval, null)), 1);
                        if (this.m_edges == null || this.m_edges.contains(e)) continue;
                        this.m_edges.add(e);
                        continue;
                    }
                    break;
                }
            } else {
                this.nodeID(tk);
                e = new GraphEdge(nindex, this.m_nodes.indexOf(new GraphNode(tk.sval, null)), 1);
                if (this.m_edges != null && !this.m_edges.contains(e)) {
                    this.m_edges.add(e);
                }
            }
        } else {
            if (tk.ttype == 45) {
                System.err.println("Error at line " + tk.lineno() + ". Cannot deal with undirected edges");
                if (tk.ttype == -3) {
                    tk.pushBack();
                }
                return;
            }
            System.err.println("Error at line " + tk.lineno() + " in edgeStmt");
            if (tk.ttype == -3) {
                tk.pushBack();
            }
            return;
        }
        tk.nextToken();
        if (tk.ttype == 91) {
            this.edgeAttrib(tk, e);
        } else {
            tk.pushBack();
        }
    }

    protected void edgeAttrib(StreamTokenizer tk, GraphEdge e) throws Exception {
        tk.nextToken();
        if (tk.ttype == 93 || tk.ttype == -1) {
            return;
        }
        if (tk.ttype == -3) {
            if (tk.sval.equalsIgnoreCase("label")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype == -3 || tk.ttype == 34) {
                        System.err.println("found label " + tk.sval);
                    } else {
                        System.err.println("couldn't find label at line " + tk.lineno());
                        tk.pushBack();
                    }
                } else {
                    System.err.println("couldn't find label at line " + tk.lineno());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("color")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        System.err.println("couldn't find color at line " + tk.lineno());
                        tk.pushBack();
                    }
                } else {
                    System.err.println("couldn't find color at line " + tk.lineno());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("style")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        System.err.println("couldn't find style at line " + tk.lineno());
                        tk.pushBack();
                    }
                } else {
                    System.err.println("couldn't find style at line " + tk.lineno());
                    tk.pushBack();
                }
            }
        }
        this.edgeAttrib(tk, e);
    }

    public static void writeDOT(String filename, String graphName, ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges) {
        try {
            FileWriter os = new FileWriter(filename);
            os.write("digraph ", 0, "digraph ".length());
            if (graphName != null) {
                os.write(graphName + " ", 0, graphName.length() + 1);
            }
            os.write("{\n", 0, "{\n".length());
            for (int i2 = 0; i2 < edges.size(); ++i2) {
                GraphEdge e = edges.get(i2);
                os.write(nodes.get((int)e.src).ID, 0, nodes.get((int)e.src).ID.length());
                os.write("->", 0, "->".length());
                os.write(nodes.get((int)e.dest).ID + "\n", 0, nodes.get((int)e.dest).ID.length() + 1);
            }
            os.write("}\n", 0, "}\n".length());
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

