/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;

public class HierarchicalBCEngine
implements GraphConstants,
LayoutEngine {
    protected ArrayList<GraphNode> m_nodes;
    protected ArrayList<GraphEdge> m_edges;
    protected ArrayList<LayoutCompleteEventListener> layoutCompleteListeners;
    protected int[][] graphMatrix;
    protected int[][] nodeLevels;
    protected int m_nodeWidth;
    protected int m_nodeHeight;
    protected JRadioButton m_jRbNaiveLayout;
    protected JRadioButton m_jRbPriorityLayout;
    protected JRadioButton m_jRbTopdown;
    protected JRadioButton m_jRbBottomup;
    protected JCheckBox m_jCbEdgeConcentration;
    protected JPanel m_controlsPanel;
    protected JProgressBar m_progress;
    protected boolean m_completeReLayout = false;
    private int origNodesSize;

    public HierarchicalBCEngine(ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges, int nodeWidth, int nodeHeight) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
        this.makeGUIPanel(false);
    }

    public HierarchicalBCEngine(ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges, int nodeWidth, int nodeHeight, boolean edgeConcentration) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
        this.makeGUIPanel(edgeConcentration);
    }

    public HierarchicalBCEngine() {
    }

    protected void makeGUIPanel(boolean edgeConc) {
        this.m_jRbNaiveLayout = new JRadioButton("Naive Layout");
        this.m_jRbPriorityLayout = new JRadioButton("Priority Layout");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_jRbNaiveLayout);
        bg.add(this.m_jRbPriorityLayout);
        this.m_jRbPriorityLayout.setSelected(true);
        ActionListener a = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HierarchicalBCEngine.this.m_completeReLayout = true;
            }
        };
        this.m_jRbTopdown = new JRadioButton("Top Down");
        this.m_jRbBottomup = new JRadioButton("Bottom Up");
        this.m_jRbTopdown.addActionListener(a);
        this.m_jRbBottomup.addActionListener(a);
        bg = new ButtonGroup();
        bg.add(this.m_jRbTopdown);
        bg.add(this.m_jRbBottomup);
        this.m_jRbBottomup.setSelected(true);
        this.m_jCbEdgeConcentration = new JCheckBox("With Edge Concentration", edgeConc);
        this.m_jCbEdgeConcentration.setSelected(edgeConc);
        this.m_jCbEdgeConcentration.addActionListener(a);
        JPanel jp1 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        jp1.add((Component)this.m_jRbNaiveLayout, gbc);
        jp1.add((Component)this.m_jRbPriorityLayout, gbc);
        jp1.setBorder(BorderFactory.createTitledBorder("Layout Type"));
        JPanel jp2 = new JPanel(new GridBagLayout());
        jp2.add((Component)this.m_jRbTopdown, gbc);
        jp2.add((Component)this.m_jRbBottomup, gbc);
        jp2.setBorder(BorderFactory.createTitledBorder("Layout Method"));
        this.m_progress = new JProgressBar(0, 11);
        this.m_progress.setBorderPainted(false);
        this.m_progress.setStringPainted(true);
        this.m_progress.setString("");
        this.m_progress.setValue(0);
        this.m_controlsPanel = new JPanel(new GridBagLayout());
        this.m_controlsPanel.add((Component)jp1, gbc);
        this.m_controlsPanel.add((Component)jp2, gbc);
        this.m_controlsPanel.add((Component)this.m_jCbEdgeConcentration, gbc);
    }

    @Override
    public ArrayList<GraphNode> getNodes() {
        return this.m_nodes;
    }

    @Override
    public JPanel getControlPanel() {
        return this.m_controlsPanel;
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.m_progress;
    }

    @Override
    public void setNodesEdges(ArrayList<GraphNode> nodes, ArrayList<GraphEdge> edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
    }

    @Override
    public void setNodeSize(int nodeWidth, int nodeHeight) {
        this.m_nodeWidth = nodeWidth;
        this.m_nodeHeight = nodeHeight;
    }

    @Override
    public void addLayoutCompleteEventListener(LayoutCompleteEventListener l) {
        if (this.layoutCompleteListeners == null) {
            this.layoutCompleteListeners = new ArrayList();
        }
        this.layoutCompleteListeners.add(l);
    }

    @Override
    public void removeLayoutCompleteEventListener(LayoutCompleteEventListener e) {
        if (this.layoutCompleteListeners != null) {
            for (int i2 = 0; i2 < this.layoutCompleteListeners.size(); ++i2) {
                LayoutCompleteEventListener l = this.layoutCompleteListeners.get(i2);
                if (l != e) continue;
                this.layoutCompleteListeners.remove(i2);
                return;
            }
            System.err.println("layoutCompleteListener to be remove not present");
        } else {
            System.err.println("layoutCompleteListener to be remove not present");
        }
    }

    @Override
    public void fireLayoutCompleteEvent(LayoutCompleteEvent e) {
        if (this.layoutCompleteListeners != null && this.layoutCompleteListeners.size() != 0) {
            for (int i2 = 0; i2 < this.layoutCompleteListeners.size(); ++i2) {
                LayoutCompleteEventListener l = this.layoutCompleteListeners.get(i2);
                l.layoutCompleted(e);
            }
        }
    }

    @Override
    public void layoutGraph() {
        if (this.m_nodes == null || this.m_edges == null) {
            return;
        }
        Thread th = new Thread(){

            @Override
            public void run() {
                HierarchicalBCEngine.this.m_progress.setBorderPainted(true);
                if (HierarchicalBCEngine.this.nodeLevels == null) {
                    HierarchicalBCEngine.this.makeProperHierarchy();
                } else if (HierarchicalBCEngine.this.m_completeReLayout) {
                    HierarchicalBCEngine.this.clearTemps_and_EdgesFromNodes();
                    HierarchicalBCEngine.this.makeProperHierarchy();
                    HierarchicalBCEngine.this.m_completeReLayout = false;
                }
                if (HierarchicalBCEngine.this.m_jRbTopdown.isSelected()) {
                    int crossbefore = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int crossafter = 0;
                    int i2 = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(i2 + 4);
                        HierarchicalBCEngine.this.m_progress.setString("Minimizing Crossings: Pass" + (i2 + 1));
                        if (i2 != 0) {
                            crossbefore = crossafter;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(false, HierarchicalBCEngine.this.nodeLevels);
                    } while ((crossafter = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < crossbefore && ++i2 < 6);
                } else {
                    int crossbefore = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int crossafter = 0;
                    int i3 = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(i3 + 4);
                        HierarchicalBCEngine.this.m_progress.setString("Minimizing Crossings: Pass" + (i3 + 1));
                        if (i3 != 0) {
                            crossbefore = crossafter;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(true, HierarchicalBCEngine.this.nodeLevels);
                    } while ((crossafter = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < crossbefore && ++i3 < 6);
                }
                HierarchicalBCEngine.this.m_progress.setValue(10);
                HierarchicalBCEngine.this.m_progress.setString("Laying out vertices");
                if (HierarchicalBCEngine.this.m_jRbNaiveLayout.isSelected()) {
                    HierarchicalBCEngine.this.naiveLayout();
                } else {
                    HierarchicalBCEngine.this.priorityLayout1();
                }
                HierarchicalBCEngine.this.m_progress.setValue(11);
                HierarchicalBCEngine.this.m_progress.setString("Layout Complete");
                HierarchicalBCEngine.this.m_progress.repaint();
                HierarchicalBCEngine.this.fireLayoutCompleteEvent(new LayoutCompleteEvent(this));
                HierarchicalBCEngine.this.m_progress.setValue(0);
                HierarchicalBCEngine.this.m_progress.setString("");
                HierarchicalBCEngine.this.m_progress.setBorderPainted(false);
            }
        };
        th.start();
    }

    protected void clearTemps_and_EdgesFromNodes() {
        int curSize = this.m_nodes.size();
        for (int i2 = this.origNodesSize; i2 < curSize; ++i2) {
            this.m_nodes.remove(this.origNodesSize);
        }
        for (int j = 0; j < this.m_nodes.size(); ++j) {
            this.m_nodes.get((int)j).edges = null;
        }
        this.nodeLevels = null;
    }

    protected void processGraph() {
        this.origNodesSize = this.m_nodes.size();
        this.graphMatrix = new int[this.m_nodes.size()][this.m_nodes.size()];
        for (int i2 = 0; i2 < this.m_edges.size(); ++i2) {
            this.graphMatrix[this.m_edges.get((int)i2).src][this.m_edges.get((int)i2).dest] = this.m_edges.get((int)i2).type;
        }
    }

    protected void makeProperHierarchy() {
        int i2;
        int i3;
        this.processGraph();
        this.m_progress.setValue(1);
        this.m_progress.setString("Removing Cycles");
        this.removeCycles();
        this.m_progress.setValue(2);
        this.m_progress.setString("Assigning levels to nodes");
        int[] nodesLevel = new int[this.m_nodes.size()];
        int depth = 0;
        for (i3 = 0; i3 < this.graphMatrix.length; ++i3) {
            this.assignLevels(nodesLevel, depth, i3, 0);
        }
        for (i3 = 0; i3 < nodesLevel.length; ++i3) {
            if (nodesLevel[i3] != 0) continue;
            int min = 65536;
            for (int j = 0; j < this.graphMatrix[i3].length; ++j) {
                if (this.graphMatrix[i3][j] != 1 || min <= nodesLevel[j]) continue;
                min = nodesLevel[j];
            }
            if (min == 65536 || min <= 1) continue;
            nodesLevel[i3] = min - 1;
        }
        int maxLevel = 0;
        for (int element : nodesLevel) {
            if (element <= maxLevel) continue;
            maxLevel = element;
        }
        int[] levelCounts = new int[maxLevel + 1];
        for (int i4 = 0; i4 < nodesLevel.length; ++i4) {
            int n = nodesLevel[i4];
            levelCounts[n] = levelCounts[n] + 1;
        }
        int[] levelsCounter = new int[maxLevel + 1];
        this.nodeLevels = new int[maxLevel + 1][];
        for (i2 = 0; i2 < nodesLevel.length; ++i2) {
            if (this.nodeLevels[nodesLevel[i2]] == null) {
                this.nodeLevels[nodesLevel[i2]] = new int[levelCounts[nodesLevel[i2]]];
            }
            int n = nodesLevel[i2];
            int n2 = levelsCounter[n];
            levelsCounter[n] = n2 + 1;
            this.nodeLevels[nodesLevel[i2]][n2] = i2;
        }
        this.m_progress.setValue(3);
        this.m_progress.setString("Removing gaps by adding dummy vertices");
        if (this.m_jCbEdgeConcentration.isSelected()) {
            this.removeGapsWithEdgeConcentration(nodesLevel);
        } else {
            this.removeGaps(nodesLevel);
        }
        for (i2 = 0; i2 < this.graphMatrix.length; ++i2) {
            int j;
            GraphNode n = this.m_nodes.get(i2);
            int sum = 0;
            for (j = 0; j < this.graphMatrix[i2].length; ++j) {
                if (this.graphMatrix[i2][j] == 0) continue;
                ++sum;
            }
            n.edges = new int[sum][2];
            int k = 0;
            for (j = 0; j < this.graphMatrix[i2].length; ++j) {
                if (this.graphMatrix[i2][j] == 0) continue;
                n.edges[k][0] = j;
                n.edges[k][1] = this.graphMatrix[i2][j];
                ++k;
            }
        }
    }

    private void removeGaps(int[] nodesLevel) {
        int temp = this.m_nodes.size();
        int temp2 = this.graphMatrix[0].length;
        int tempCnt = 1;
        for (int n = 0; n < temp; ++n) {
            for (int i2 = 0; i2 < temp2; ++i2) {
                int len = this.graphMatrix.length;
                if (this.graphMatrix[n][i2] <= 0) continue;
                if (nodesLevel[i2] > nodesLevel[n] + 1) {
                    int k;
                    int[][] tempMatrix = new int[this.graphMatrix.length + (nodesLevel[i2] - nodesLevel[n] - 1)][this.graphMatrix.length + (nodesLevel[i2] - nodesLevel[n] - 1)];
                    int level = nodesLevel[n] + 1;
                    this.copyMatrix(this.graphMatrix, tempMatrix);
                    String s1 = new String("S" + tempCnt++);
                    this.m_nodes.add(new GraphNode(s1, s1, 1));
                    int[] temp3 = new int[this.nodeLevels[level].length + 1];
                    System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                    temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                    this.nodeLevels[level] = temp3;
                    ++level;
                    for (k = len; k < len + nodesLevel[i2] - nodesLevel[n] - 1 - 1; ++k) {
                        String s2 = new String("S" + tempCnt);
                        this.m_nodes.add(new GraphNode(s2, s2, 1));
                        temp3 = new int[this.nodeLevels[level].length + 1];
                        System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                        temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                        this.nodeLevels[level++] = temp3;
                        tempMatrix[k][k + 1] = tempMatrix[n][i2];
                        ++tempCnt;
                        if (k <= len) continue;
                        tempMatrix[k][k - 1] = -1 * tempMatrix[n][i2];
                    }
                    tempMatrix[k][i2] = tempMatrix[n][i2];
                    tempMatrix[n][len] = tempMatrix[n][i2];
                    tempMatrix[len][n] = -1 * tempMatrix[n][i2];
                    tempMatrix[i2][k] = -1 * tempMatrix[n][i2];
                    if (k > len) {
                        tempMatrix[k][k - 1] = -1 * tempMatrix[n][i2];
                    }
                    tempMatrix[n][i2] = 0;
                    tempMatrix[i2][n] = 0;
                    this.graphMatrix = tempMatrix;
                    continue;
                }
                this.graphMatrix[i2][n] = -1 * this.graphMatrix[n][i2];
            }
        }
    }

    private void removeGapsWithEdgeConcentration(int[] nodesLevel) {
        int temp = this.m_nodes.size();
        int temp2 = this.graphMatrix[0].length;
        int tempCnt = 1;
        for (int n = 0; n < temp; ++n) {
            for (int i2 = 0; i2 < temp2; ++i2) {
                if (this.graphMatrix[n][i2] <= 0) continue;
                if (nodesLevel[i2] > nodesLevel[n] + 1) {
                    int m;
                    boolean tempNodePresent = false;
                    int k = temp;
                    int tempnode = n;
                    for (int tempLevel = nodesLevel[n]; tempLevel < nodesLevel[i2] - 1; ++tempLevel) {
                        tempNodePresent = false;
                        while (k < this.graphMatrix.length) {
                            if (this.graphMatrix[tempnode][k] > 0) {
                                tempNodePresent = true;
                                break;
                            }
                            ++k;
                        }
                        if (tempNodePresent) {
                            tempnode = k++;
                            continue;
                        }
                        if (tempnode == n) break;
                        tempnode = k - 1;
                        break;
                    }
                    if (this.m_nodes.get((int)tempnode).nodeType == 1) {
                        this.m_nodes.get((int)tempnode).nodeType = 2;
                    }
                    if (tempNodePresent) {
                        this.graphMatrix[tempnode][i2] = this.graphMatrix[n][i2];
                        this.graphMatrix[i2][tempnode] = -this.graphMatrix[n][i2];
                        this.graphMatrix[n][i2] = 0;
                        this.graphMatrix[i2][n] = 0;
                        continue;
                    }
                    int len = this.graphMatrix.length;
                    int[][] tempMatrix = new int[this.graphMatrix.length + (nodesLevel[i2] - nodesLevel[tempnode] - 1)][this.graphMatrix.length + (nodesLevel[i2] - nodesLevel[tempnode] - 1)];
                    int level = nodesLevel[tempnode] + 1;
                    this.copyMatrix(this.graphMatrix, tempMatrix);
                    String s1 = new String("S" + tempCnt++);
                    this.m_nodes.add(new GraphNode(s1, s1, 1));
                    int[] temp3 = new int[this.nodeLevels[level].length + 1];
                    System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                    temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                    this.nodeLevels[level] = temp3;
                    temp3 = new int[this.m_nodes.size() + 1];
                    System.arraycopy(nodesLevel, 0, temp3, 0, nodesLevel.length);
                    temp3[this.m_nodes.size() - 1] = level++;
                    nodesLevel = temp3;
                    for (m = len; m < len + nodesLevel[i2] - nodesLevel[tempnode] - 1 - 1; ++m) {
                        String s2 = new String("S" + tempCnt++);
                        this.m_nodes.add(new GraphNode(s2, s2, 1));
                        temp3 = new int[this.nodeLevels[level].length + 1];
                        System.arraycopy(this.nodeLevels[level], 0, temp3, 0, this.nodeLevels[level].length);
                        temp3[temp3.length - 1] = this.m_nodes.size() - 1;
                        this.nodeLevels[level] = temp3;
                        temp3 = new int[this.m_nodes.size() + 1];
                        System.arraycopy(nodesLevel, 0, temp3, 0, nodesLevel.length);
                        temp3[this.m_nodes.size() - 1] = level++;
                        nodesLevel = temp3;
                        tempMatrix[m][m + 1] = tempMatrix[n][i2];
                        if (m <= len) continue;
                        tempMatrix[m][m - 1] = -1 * tempMatrix[n][i2];
                    }
                    tempMatrix[m][i2] = tempMatrix[n][i2];
                    tempMatrix[tempnode][len] = tempMatrix[n][i2];
                    tempMatrix[len][tempnode] = -1 * tempMatrix[n][i2];
                    tempMatrix[i2][m] = -1 * tempMatrix[n][i2];
                    if (m > len) {
                        tempMatrix[m][m - 1] = -1 * tempMatrix[n][i2];
                    }
                    tempMatrix[n][i2] = 0;
                    tempMatrix[i2][n] = 0;
                    this.graphMatrix = tempMatrix;
                    continue;
                }
                this.graphMatrix[i2][n] = -1 * this.graphMatrix[n][i2];
            }
        }
    }

    private int indexOfElementInLevel(int element, int[] level) throws Exception {
        for (int i2 = 0; i2 < level.length; ++i2) {
            if (level[i2] != element) continue;
            return i2;
        }
        throw new Exception("Error. Didn't find element " + this.m_nodes.get((int)element).ID + " in level. Inspect code for weka.gui.graphvisualizer.HierarchicalBCEngine");
    }

    protected int crossings(int[][] levels) {
        int sum = 0;
        for (int i2 = 0; i2 < levels.length - 1; ++i2) {
            MyList upper = new MyList();
            MyList lower = new MyList();
            MyListNode[] lastOcrnce = new MyListNode[this.m_nodes.size()];
            int[] edgeOcrnce = new int[this.m_nodes.size()];
            int uidx = 0;
            int lidx = 0;
            for (int j = 0; j < levels[i2].length + levels[i2 + 1].length; ++j) {
                MyListNode temp;
                int k;
                GraphNode n;
                int k3;
                int k2;
                int k1;
                if (j % 2 == 0 && uidx < levels[i2].length || lidx >= levels[i2 + 1].length) {
                    k1 = 0;
                    k2 = 0;
                    k3 = 0;
                    n = this.m_nodes.get(levels[i2][uidx]);
                    if (lastOcrnce[levels[i2][uidx]] != null) {
                        MyListNode temp2 = new MyListNode(-1);
                        temp2.next = upper.first;
                        try {
                            do {
                                temp2 = temp2.next;
                                if (levels[i2][uidx] == temp2.n) {
                                    ++k1;
                                    k3 += k2;
                                    upper.remove(temp2);
                                    continue;
                                }
                                ++k2;
                            } while (temp2 != lastOcrnce[levels[i2][uidx]]);
                        }
                        catch (NullPointerException ex) {
                            System.out.println("levels[i][uidx]: " + levels[i2][uidx] + " which is: " + this.m_nodes.get((int)levels[i2][uidx]).ID + " temp: " + temp2 + " upper.first: " + upper.first);
                            ex.printStackTrace();
                            System.exit(-1);
                        }
                        lastOcrnce[levels[i2][uidx]] = null;
                        sum = sum + k1 * lower.size() + k3;
                    }
                    for (k = 0; k < n.edges.length; ++k) {
                        if (n.edges[k][1] <= 0) continue;
                        try {
                            if (this.indexOfElementInLevel(n.edges[k][0], levels[i2 + 1]) < uidx) continue;
                            edgeOcrnce[n.edges[k][0]] = 1;
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    for (k = 0; k < levels[i2 + 1].length; ++k) {
                        if (edgeOcrnce[levels[i2 + 1][k]] != 1) continue;
                        temp = new MyListNode(levels[i2 + 1][k]);
                        lower.add(temp);
                        lastOcrnce[levels[i2 + 1][k]] = temp;
                        edgeOcrnce[levels[i2 + 1][k]] = 0;
                    }
                    ++uidx;
                    continue;
                }
                k1 = 0;
                k2 = 0;
                k3 = 0;
                n = this.m_nodes.get(levels[i2 + 1][lidx]);
                if (lastOcrnce[levels[i2 + 1][lidx]] != null) {
                    MyListNode temp3 = new MyListNode(-1);
                    temp3.next = lower.first;
                    try {
                        do {
                            temp3 = temp3.next;
                            if (levels[i2 + 1][lidx] == temp3.n) {
                                ++k1;
                                k3 += k2;
                                lower.remove(temp3);
                                continue;
                            }
                            ++k2;
                        } while (temp3 != lastOcrnce[levels[i2 + 1][lidx]]);
                    }
                    catch (NullPointerException ex) {
                        System.out.print("levels[i+1][lidx]: " + levels[i2 + 1][lidx] + " which is: " + this.m_nodes.get((int)levels[i2 + 1][lidx]).ID + " temp: " + temp3);
                        System.out.println(" lower.first: " + lower.first);
                        ex.printStackTrace();
                        System.exit(-1);
                    }
                    lastOcrnce[levels[i2 + 1][lidx]] = null;
                    sum = sum + k1 * upper.size() + k3;
                }
                for (k = 0; k < n.edges.length; ++k) {
                    if (n.edges[k][1] >= 0) continue;
                    try {
                        if (this.indexOfElementInLevel(n.edges[k][0], levels[i2]) <= lidx) continue;
                        edgeOcrnce[n.edges[k][0]] = 1;
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                for (k = 0; k < levels[i2].length; ++k) {
                    if (edgeOcrnce[levels[i2][k]] != 1) continue;
                    temp = new MyListNode(levels[i2][k]);
                    upper.add(temp);
                    lastOcrnce[levels[i2][k]] = temp;
                    edgeOcrnce[levels[i2][k]] = 0;
                }
                ++lidx;
            }
        }
        return sum;
    }

    protected void removeCycles() {
        int[] visited = new int[this.m_nodes.size()];
        for (int i2 = 0; i2 < this.graphMatrix.length; ++i2) {
            if (visited[i2] != 0) continue;
            this.removeCycles2(i2, visited);
            visited[i2] = 1;
        }
    }

    private void removeCycles2(int nindex, int[] visited) {
        visited[nindex] = 2;
        for (int i2 = 0; i2 < this.graphMatrix[nindex].length; ++i2) {
            if (this.graphMatrix[nindex][i2] != 1) continue;
            if (visited[i2] == 0) {
                this.removeCycles2(i2, visited);
                visited[i2] = 1;
                continue;
            }
            if (visited[i2] != 2) continue;
            if (nindex == i2) {
                this.graphMatrix[nindex][i2] = 0;
                continue;
            }
            if (this.graphMatrix[i2][nindex] == 1) {
                this.graphMatrix[i2][nindex] = 3;
                this.graphMatrix[nindex][i2] = -3;
                continue;
            }
            this.graphMatrix[i2][nindex] = 2;
            this.graphMatrix[nindex][i2] = -2;
        }
    }

    protected void assignLevels(int[] levels, int depth, int i2, int j) {
        if (i2 >= this.graphMatrix.length) {
            return;
        }
        if (j >= this.graphMatrix[i2].length) {
            return;
        }
        if (this.graphMatrix[i2][j] <= 0) {
            this.assignLevels(levels, depth, i2, ++j);
        } else if (this.graphMatrix[i2][j] == 1 || this.graphMatrix[i2][j] == 3) {
            if (depth + 1 > levels[j]) {
                levels[j] = depth + 1;
                this.assignLevels(levels, depth + 1, j, 0);
            }
            this.assignLevels(levels, depth, i2, ++j);
        }
    }

    private int[][] minimizeCrossings(boolean reversed, int[][] nodeLevels) {
        if (!reversed) {
            for (int times = 0; times < 1; ++times) {
                int i2;
                int[][] tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i2 = 0; i2 < ((int[][])nodeLevels).length - 1; ++i2) {
                    this.phaseID(i2, tempLevels);
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i2 = ((int[][])nodeLevels).length - 2; i2 >= 0; --i2) {
                    this.phaseIU(i2, tempLevels);
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i2 = 0; i2 < ((int[][])nodeLevels).length - 1; ++i2) {
                    this.phaseIID(i2, tempLevels);
                }
                if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                    nodeLevels = tempLevels;
                }
                tempLevels = new int[((int[][])nodeLevels).length][];
                this.copy2DArray((int[][])nodeLevels, tempLevels);
                for (i2 = ((int[][])nodeLevels).length - 2; i2 >= 0; --i2) {
                    this.phaseIIU(i2, tempLevels);
                }
                if (this.crossings(tempLevels) >= this.crossings((int[][])nodeLevels)) continue;
                nodeLevels = tempLevels;
            }
            return nodeLevels;
        }
        for (int times = 0; times < 1; ++times) {
            int i3;
            int[][] tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i3 = ((int[][])nodeLevels).length - 2; i3 >= 0; --i3) {
                this.phaseIU(i3, tempLevels);
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i3 = 0; i3 < ((int[][])nodeLevels).length - 1; ++i3) {
                this.phaseID(i3, tempLevels);
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i3 = ((int[][])nodeLevels).length - 2; i3 >= 0; --i3) {
                this.phaseIIU(i3, tempLevels);
            }
            if (this.crossings(tempLevels) < this.crossings((int[][])nodeLevels)) {
                nodeLevels = tempLevels;
            }
            tempLevels = new int[((int[][])nodeLevels).length][];
            this.copy2DArray((int[][])nodeLevels, tempLevels);
            for (i3 = 0; i3 < ((int[][])nodeLevels).length - 1; ++i3) {
                this.phaseIID(i3, tempLevels);
            }
            if (this.crossings(tempLevels) >= this.crossings((int[][])nodeLevels)) continue;
            nodeLevels = tempLevels;
        }
        return nodeLevels;
    }

    protected void phaseID(int lindex, int[][] levels) {
        float[] colBC = this.calcColBC(lindex, levels);
        HierarchicalBCEngine.isort(levels[lindex + 1], colBC);
    }

    public void phaseIU(int lindex, int[][] levels) {
        float[] rowBC = this.calcRowBC(lindex, levels);
        HierarchicalBCEngine.isort(levels[lindex], rowBC);
    }

    public void phaseIID(int lindex, int[][] levels) {
        float[] colBC = this.calcColBC(lindex, levels);
        for (int i2 = 0; i2 < colBC.length - 1; ++i2) {
            int k;
            if (colBC[i2] != colBC[i2 + 1]) continue;
            int[][] tempLevels = new int[levels.length][];
            this.copy2DArray(levels, tempLevels);
            int node1 = levels[lindex + 1][i2];
            int node2 = levels[lindex + 1][i2 + 1];
            levels[lindex + 1][i2 + 1] = node1;
            levels[lindex + 1][i2] = node2;
            for (k = lindex + 1; k < levels.length - 1; ++k) {
                this.phaseID(k, levels);
            }
            if (this.crossings(levels) <= this.crossings(tempLevels)) {
                this.copy2DArray(levels, tempLevels);
            } else {
                this.copy2DArray(tempLevels, levels);
                levels[lindex + 1][i2 + 1] = node1;
                levels[lindex + 1][i2] = node2;
            }
            for (k = levels.length - 2; k >= 0; --k) {
                this.phaseIU(k, levels);
            }
            if (this.crossings(tempLevels) >= this.crossings(levels)) continue;
            this.copy2DArray(tempLevels, levels);
        }
    }

    public void phaseIIU(int lindex, int[][] levels) {
        float[] rowBC = this.calcRowBC(lindex, levels);
        for (int i2 = 0; i2 < rowBC.length - 1; ++i2) {
            int k;
            if (rowBC[i2] != rowBC[i2 + 1]) continue;
            int[][] tempLevels = new int[levels.length][];
            this.copy2DArray(levels, tempLevels);
            int node1 = levels[lindex][i2];
            int node2 = levels[lindex][i2 + 1];
            levels[lindex][i2 + 1] = node1;
            levels[lindex][i2] = node2;
            for (k = lindex - 1; k >= 0; --k) {
                this.phaseIU(k, levels);
            }
            if (this.crossings(levels) <= this.crossings(tempLevels)) {
                this.copy2DArray(levels, tempLevels);
            } else {
                this.copy2DArray(tempLevels, levels);
                levels[lindex][i2 + 1] = node1;
                levels[lindex][i2] = node2;
            }
            for (k = 0; k < levels.length - 1; ++k) {
                this.phaseID(k, levels);
            }
            if (this.crossings(tempLevels) > this.crossings(levels)) continue;
            this.copy2DArray(tempLevels, levels);
        }
    }

    protected float[] calcRowBC(int lindex, int[][] levels) {
        float[] rowBC = new float[levels[lindex].length];
        for (int i2 = 0; i2 < levels[lindex].length; ++i2) {
            int sum = 0;
            GraphNode n = this.m_nodes.get(levels[lindex][i2]);
            for (int[] edge : n.edges) {
                if (edge[1] <= 0) continue;
                ++sum;
                try {
                    rowBC[i2] = rowBC[i2] + (float)this.indexOfElementInLevel(edge[0], levels[lindex + 1]) + 1.0f;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            if (rowBC[i2] == 0.0f) continue;
            rowBC[i2] = rowBC[i2] / (float)sum;
        }
        return rowBC;
    }

    protected float[] calcColBC(int lindex, int[][] levels) {
        float[] colBC = new float[levels[lindex + 1].length];
        for (int i2 = 0; i2 < levels[lindex + 1].length; ++i2) {
            int sum = 0;
            GraphNode n = this.m_nodes.get(levels[lindex + 1][i2]);
            for (int[] edge : n.edges) {
                if (edge[1] >= 1) continue;
                ++sum;
                try {
                    colBC[i2] = colBC[i2] + (float)this.indexOfElementInLevel(edge[0], levels[lindex]) + 1.0f;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            if (colBC[i2] == 0.0f) continue;
            colBC[i2] = colBC[i2] / (float)sum;
        }
        return colBC;
    }

    protected void printMatrices(int[][] levels) {
        int i2 = 0;
        for (i2 = 0; i2 < levels.length - 1; ++i2) {
            int j;
            float[] rowBC = null;
            float[] colBC = null;
            try {
                rowBC = this.calcRowBC(i2, levels);
                colBC = this.calcColBC(i2, levels);
            }
            catch (NullPointerException ne) {
                System.out.println("i: " + i2 + " levels.length: " + levels.length);
                ne.printStackTrace();
                return;
            }
            System.out.print("\nM" + (i2 + 1) + "\t");
            for (j = 0; j < levels[i2 + 1].length; ++j) {
                System.out.print(this.m_nodes.get((int)levels[i2 + 1][j]).ID + " ");
            }
            System.out.println("");
            for (j = 0; j < levels[i2].length; ++j) {
                System.out.print(this.m_nodes.get((int)levels[i2][j]).ID + "\t");
                for (int k = 0; k < levels[i2 + 1].length; ++k) {
                    System.out.print(this.graphMatrix[levels[i2][j]][levels[i2 + 1][k]] + " ");
                }
                System.out.println(rowBC[j]);
            }
            System.out.print("\t");
            for (int k = 0; k < levels[i2 + 1].length; ++k) {
                System.out.print(colBC[k] + " ");
            }
        }
        System.out.println("\nAt the end i: " + i2 + " levels.length: " + levels.length);
    }

    protected static void isort(int[] level, float[] BC) {
        for (int i2 = 0; i2 < BC.length - 1; ++i2) {
            int j = i2;
            float temp = BC[j + 1];
            int temp2 = level[j + 1];
            if (temp == 0.0f) continue;
            int prej = j + 1;
            while (j > -1 && (temp < BC[j] || BC[j] == 0.0f)) {
                if (BC[j] == 0.0f) {
                    --j;
                    continue;
                }
                BC[prej] = BC[j];
                level[prej] = level[j];
                prej = j--;
            }
            BC[prej] = temp;
            level[prej] = temp2;
        }
    }

    protected void copyMatrix(int[][] from, int[][] to) {
        for (int i2 = 0; i2 < from.length; ++i2) {
            for (int j = 0; j < from[i2].length; ++j) {
                to[i2][j] = from[i2][j];
            }
        }
    }

    protected void copy2DArray(int[][] from, int[][] to) {
        for (int i2 = 0; i2 < from.length; ++i2) {
            to[i2] = new int[from[i2].length];
            System.arraycopy(from[i2], 0, to[i2], 0, from[i2].length);
        }
    }

    protected void naiveLayout() {
        if (this.nodeLevels == null) {
            this.makeProperHierarchy();
        }
        int temp = 0;
        for (int i2 = 0; i2 < this.nodeLevels.length; ++i2) {
            for (int j = 0; j < this.nodeLevels[i2].length; ++j) {
                temp = this.nodeLevels[i2][j];
                GraphNode n = this.m_nodes.get(temp);
                n.x = j * this.m_nodeWidth;
                n.y = i2 * 3 * this.m_nodeHeight;
            }
        }
    }

    protected int uConnectivity(int lindex, int eindex) {
        int n = 0;
        for (int i2 = 0; i2 < this.nodeLevels[lindex - 1].length; ++i2) {
            if (this.graphMatrix[this.nodeLevels[lindex - 1][i2]][this.nodeLevels[lindex][eindex]] <= 0) continue;
            ++n;
        }
        return n;
    }

    protected int lConnectivity(int lindex, int eindex) {
        int n = 0;
        for (int i2 = 0; i2 < this.nodeLevels[lindex + 1].length; ++i2) {
            if (this.graphMatrix[this.nodeLevels[lindex][eindex]][this.nodeLevels[lindex + 1][i2]] <= 0) continue;
            ++n;
        }
        return n;
    }

    protected int uBCenter(int lindex, int eindex, int[] horPositions) {
        int sum = 0;
        for (int i2 = 0; i2 < this.nodeLevels[lindex - 1].length; ++i2) {
            if (this.graphMatrix[this.nodeLevels[lindex - 1][i2]][this.nodeLevels[lindex][eindex]] <= 0) continue;
            sum += horPositions[this.nodeLevels[lindex - 1][i2]];
        }
        if (sum != 0) {
            sum /= this.uConnectivity(lindex, eindex);
        }
        return sum;
    }

    protected int lBCenter(int lindex, int eindex, int[] horPositions) {
        int sum = 0;
        for (int i2 = 0; i2 < this.nodeLevels[lindex + 1].length; ++i2) {
            if (this.graphMatrix[this.nodeLevels[lindex][eindex]][this.nodeLevels[lindex + 1][i2]] <= 0) continue;
            sum += horPositions[this.nodeLevels[lindex + 1][i2]];
        }
        if (sum != 0) {
            sum /= this.lConnectivity(lindex, eindex);
        }
        return sum;
    }

    protected void priorityLayout1() {
        int j;
        int i2;
        int[] horPositions = new int[this.m_nodes.size()];
        int maxCount = 0;
        for (int i3 = 0; i3 < this.nodeLevels.length; ++i3) {
            int count = 0;
            for (int j2 = 0; j2 < this.nodeLevels[i3].length; ++j2) {
                horPositions[this.nodeLevels[i3][j2]] = j2;
                ++count;
            }
            if (count <= maxCount) continue;
            maxCount = count;
        }
        for (i2 = 1; i2 < this.nodeLevels.length; ++i2) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            for (j = 0; j < this.nodeLevels[i2].length; ++j) {
                priorities[j] = this.m_nodes.get((int)this.nodeLevels[i2][j]).ID.startsWith("S") ? maxCount + 1 : this.uConnectivity(i2, j);
                BC[j] = this.uBCenter(i2, j, horPositions);
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
        }
        for (i2 = this.nodeLevels.length - 2; i2 >= 0; --i2) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            for (j = 0; j < this.nodeLevels[i2].length; ++j) {
                priorities[j] = this.m_nodes.get((int)this.nodeLevels[i2][j]).ID.startsWith("S") ? maxCount + 1 : this.lConnectivity(i2, j);
                BC[j] = this.lBCenter(i2, j, horPositions);
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
        }
        for (i2 = 2; i2 < this.nodeLevels.length; ++i2) {
            int[] priorities = new int[this.nodeLevels[i2].length];
            int[] BC = new int[this.nodeLevels[i2].length];
            for (j = 0; j < this.nodeLevels[i2].length; ++j) {
                priorities[j] = this.m_nodes.get((int)this.nodeLevels[i2][j]).ID.startsWith("S") ? maxCount + 1 : this.uConnectivity(i2, j);
                BC[j] = this.uBCenter(i2, j, horPositions);
            }
            this.priorityLayout2(this.nodeLevels[i2], priorities, BC, horPositions);
        }
        int minPosition = horPositions[0];
        for (int horPosition : horPositions) {
            if (horPosition >= minPosition) continue;
            minPosition = horPosition;
        }
        if (minPosition < 0) {
            minPosition *= -1;
            int i4 = 0;
            while (i4 < horPositions.length) {
                int n = i4++;
                horPositions[n] = horPositions[n] + minPosition;
            }
        }
        int temp = 0;
        for (int i5 = 0; i5 < this.nodeLevels.length; ++i5) {
            for (int j3 = 0; j3 < this.nodeLevels[i5].length; ++j3) {
                temp = this.nodeLevels[i5][j3];
                GraphNode n = this.m_nodes.get(temp);
                n.x = horPositions[temp] * this.m_nodeWidth;
                n.y = i5 * 3 * this.m_nodeHeight;
            }
        }
    }

    private void priorityLayout2(int[] level, int[] priorities, int[] bCenters, int[] horPositions) {
        int[] descOrder = new int[priorities.length];
        descOrder[0] = 0;
        for (int i2 = 0; i2 < priorities.length - 1; ++i2) {
            int temp = i2 + 1;
            for (int j = i2; j > -1 && priorities[descOrder[j]] < priorities[temp]; --j) {
                descOrder[j + 1] = descOrder[j];
            }
            descOrder[++j] = temp;
        }
        for (int k = 0; k < descOrder.length; ++k) {
            block3: for (int i3 = 0; i3 < descOrder.length; ++i3) {
                int j;
                boolean cantMove;
                int temp;
                int j2;
                int leftCount = 0;
                int rightCount = 0;
                for (j2 = 0; j2 < priorities.length; ++j2) {
                    if (horPositions[level[descOrder[i3]]] > horPositions[level[j2]]) {
                        ++leftCount;
                        continue;
                    }
                    if (horPositions[level[descOrder[i3]]] >= horPositions[level[j2]]) continue;
                    ++rightCount;
                }
                int[] leftNodes = new int[leftCount];
                int[] rightNodes = new int[rightCount];
                int l = 0;
                int r = 0;
                for (j2 = 0; j2 < priorities.length; ++j2) {
                    if (horPositions[level[descOrder[i3]]] > horPositions[level[j2]]) {
                        leftNodes[l++] = j2;
                        continue;
                    }
                    if (horPositions[level[descOrder[i3]]] >= horPositions[level[j2]]) continue;
                    rightNodes[r++] = j2;
                }
                while (Math.abs(horPositions[level[descOrder[i3]]] - 1 - bCenters[descOrder[i3]]) < Math.abs(horPositions[level[descOrder[i3]]] - bCenters[descOrder[i3]])) {
                    temp = horPositions[level[descOrder[i3]]];
                    cantMove = false;
                    for (j = leftNodes.length - 1; j >= 0 && temp - horPositions[level[leftNodes[j]]] <= 1; --j) {
                        if (priorities[descOrder[i3]] <= priorities[leftNodes[j]]) {
                            cantMove = true;
                            break;
                        }
                        temp = horPositions[level[leftNodes[j]]];
                    }
                    if (cantMove) break;
                    temp = horPositions[level[descOrder[i3]]] - 1;
                    for (j = leftNodes.length - 1; j >= 0; --j) {
                        if (temp != horPositions[level[leftNodes[j]]]) continue;
                        horPositions[level[leftNodes[j]]] = temp = horPositions[level[leftNodes[j]]] - 1;
                    }
                    horPositions[level[descOrder[i3]]] = horPositions[level[descOrder[i3]]] - 1;
                }
                while (Math.abs(horPositions[level[descOrder[i3]]] + 1 - bCenters[descOrder[i3]]) < Math.abs(horPositions[level[descOrder[i3]]] - bCenters[descOrder[i3]])) {
                    temp = horPositions[level[descOrder[i3]]];
                    cantMove = false;
                    for (int rightNode : rightNodes) {
                        if (horPositions[level[rightNode]] - temp > 1) break;
                        if (priorities[descOrder[i3]] <= priorities[rightNode]) {
                            cantMove = true;
                            break;
                        }
                        temp = horPositions[level[rightNode]];
                    }
                    if (cantMove) continue block3;
                    temp = horPositions[level[descOrder[i3]]] + 1;
                    for (j = 0; j < rightNodes.length; ++j) {
                        if (temp != horPositions[level[rightNodes[j]]]) continue;
                        horPositions[level[rightNodes[j]]] = temp = horPositions[level[rightNodes[j]]] + 1;
                    }
                    horPositions[level[descOrder[i3]]] = horPositions[level[descOrder[i3]]] + 1;
                }
            }
        }
    }

    private class MyListNode {
        int n;
        MyListNode next;
        MyListNode previous;

        public MyListNode(int i2) {
            this.n = i2;
            this.next = null;
            this.previous = null;
        }
    }

    private class MyList {
        int size;
        MyListNode first = null;
        MyListNode last = null;

        private MyList() {
        }

        public void add(MyListNode n) {
            if (this.first == null) {
                this.first = this.last = n;
            } else if (this.last.next == null) {
                this.last.next = n;
                this.last.next.previous = this.last;
                this.last = this.last.next;
            } else {
                System.err.println("Error shouldn't be in here. Check MyList code");
                --this.size;
            }
            ++this.size;
        }

        public void remove(MyListNode n) {
            if (n.previous != null) {
                n.previous.next = n.next;
            }
            if (n.next != null) {
                n.next.previous = n.previous;
            }
            if (this.last == n) {
                this.last = n.previous;
            }
            if (this.first == n) {
                this.first = n.next;
            }
            --this.size;
        }

        public int size() {
            return this.size;
        }
    }
}

