/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.WekaException;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.Loader;
import weka.gui.Perspective;
import weka.gui.knowledgeflow.GOEStepEditorDialog;
import weka.gui.knowledgeflow.MainKFPerspectiveToolBar;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.gui.knowledgeflow.StepInteractiveViewer;
import weka.gui.knowledgeflow.StepVisual;
import weka.gui.knowledgeflow.VisibleLayout;
import weka.gui.visualize.PrintablePanel;
import weka.knowledgeflow.KFDefaults;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.Note;

public class LayoutPanel
extends PrintablePanel {
    private static final long serialVersionUID = 4988098224376217099L;
    protected int m_gridSpacing;
    protected VisibleLayout m_visLayout;
    protected int m_currentX;
    protected int m_currentY;
    protected int m_oldX;
    protected int m_oldY;
    protected Thread m_perspectiveDataLoadThread;

    public LayoutPanel(VisibleLayout vis) {
        this.m_visLayout = vis;
        this.setLayout(null);
        this.setupMouseListener();
        this.setupMouseMotionListener();
        this.m_gridSpacing = this.m_visLayout.getMainPerspective().getSetting(KFDefaults.GRID_SPACING_KEY, 40);
    }

    protected void setupMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                LayoutPanel.this.requestFocusInWindow();
                double z = (double)LayoutPanel.this.m_visLayout.getZoomSetting() / 100.0;
                double px = me.getX();
                double py = me.getY();
                py /= z;
                px /= z;
                if (LayoutPanel.this.m_visLayout.getMainPerspective().getPalleteSelectedStep() == null && (me.getModifiers() & 0x10) == 16 && LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.NONE) {
                    StepVisual step = LayoutPanel.this.m_visLayout.findStep(new Point((int)px, (int)py));
                    if (step != null) {
                        LayoutPanel.this.m_visLayout.setEditStep(step);
                        LayoutPanel.this.m_oldX = (int)px;
                        LayoutPanel.this.m_oldY = (int)py;
                        LayoutPanel.this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.MOVING);
                    }
                    if (LayoutPanel.this.m_visLayout.getFlowLayoutOperation() != VisibleLayout.LayoutOperation.MOVING) {
                        LayoutPanel.this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.SELECTING);
                        LayoutPanel.this.m_oldX = (int)px;
                        LayoutPanel.this.m_oldY = (int)py;
                        LayoutPanel.this.m_currentX = LayoutPanel.this.m_oldX;
                        LayoutPanel.this.m_currentY = LayoutPanel.this.m_oldY;
                        Graphics2D gx = (Graphics2D)LayoutPanel.this.getGraphics();
                        gx.setXORMode(Color.white);
                        gx.dispose();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                LayoutPanel.this.requestFocusInWindow();
                if (LayoutPanel.this.m_visLayout.getEditStep() != null && LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.MOVING) {
                    if (LayoutPanel.this.m_visLayout.getMainPerspective().getSnapToGrid()) {
                        int x = LayoutPanel.this.snapToGrid(LayoutPanel.this.m_visLayout.getEditStep().getX());
                        int y = LayoutPanel.this.snapToGrid(LayoutPanel.this.m_visLayout.getEditStep().getY());
                        LayoutPanel.this.m_visLayout.getEditStep().setX(x);
                        LayoutPanel.this.m_visLayout.getEditStep().setY(y);
                        LayoutPanel.this.snapSelectedToGrid();
                    }
                    LayoutPanel.this.m_visLayout.setEditStep(null);
                    LayoutPanel.this.revalidate();
                    LayoutPanel.this.repaint();
                    LayoutPanel.this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.NONE);
                }
                if (LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.SELECTING) {
                    LayoutPanel.this.revalidate();
                    LayoutPanel.this.repaint();
                    LayoutPanel.this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.NONE);
                    double z = (double)LayoutPanel.this.m_visLayout.getZoomSetting() / 100.0;
                    double px = me.getX();
                    double py = me.getY();
                    LayoutPanel.this.highlightSubFlow(LayoutPanel.this.m_currentX, LayoutPanel.this.m_currentY, (int)(px /= z), (int)(py /= z));
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void mouseClicked(MouseEvent me) {
                StepVisual step;
                double py;
                double px;
                block16: {
                    block18: {
                        block17: {
                            LayoutPanel.this.requestFocusInWindow();
                            Point p = me.getPoint();
                            Point np = new Point();
                            double z = (double)LayoutPanel.this.m_visLayout.getZoomSetting() / 100.0;
                            px = me.getX();
                            py = me.getY();
                            px /= z;
                            py /= z;
                            np.setLocation(p.getX() / z, p.getY() / z);
                            step = LayoutPanel.this.m_visLayout.findStep(np);
                            if (LayoutPanel.this.m_visLayout.getFlowLayoutOperation() != VisibleLayout.LayoutOperation.ADDING && LayoutPanel.this.m_visLayout.getFlowLayoutOperation() != VisibleLayout.LayoutOperation.NONE) break block16;
                            if (step == null) break block17;
                            if (me.getClickCount() == 2) {
                                if (!step.getStepManager().isStepBusy() && !LayoutPanel.this.m_visLayout.isExecuting()) {
                                    LayoutPanel.this.popupStepEditorDialog(step);
                                }
                                break block18;
                            } else {
                                if ((me.getModifiers() & 0x10) != 16 || me.isAltDown()) {
                                    LayoutPanel.this.stepContextualMenu(step, (int)(p.getX() / z), (int)(p.getY() / z));
                                    return;
                                }
                                List<StepVisual> v = LayoutPanel.this.m_visLayout.getSelectedSteps();
                                if (!me.isShiftDown()) {
                                    v = new ArrayList<StepVisual>();
                                }
                                v.add(step);
                                LayoutPanel.this.m_visLayout.setSelectedSteps(v);
                                return;
                            }
                        }
                        if ((me.getModifiers() & 0x10) != 16 || me.isAltDown()) {
                            if (!LayoutPanel.this.m_visLayout.isExecuting()) {
                                LayoutPanel.this.canvasContextualMenu((int)px, (int)py);
                                LayoutPanel.this.revalidate();
                                LayoutPanel.this.repaint();
                                LayoutPanel.this.m_visLayout.getMainPerspective().notifyIsDirty();
                            }
                            return;
                        }
                        if (LayoutPanel.this.m_visLayout.getMainPerspective().getPalleteSelectedStep() != null) {
                            double x = px;
                            double y = py;
                            if (LayoutPanel.this.m_visLayout.getMainPerspective().getSnapToGrid()) {
                                x = LayoutPanel.this.snapToGrid((int)x);
                                y = LayoutPanel.this.snapToGrid((int)y);
                            }
                            LayoutPanel.this.m_visLayout.addUndoPoint();
                            LayoutPanel.this.m_visLayout.addStep(LayoutPanel.this.m_visLayout.getMainPerspective().getPalleteSelectedStep(), (int)x, (int)y);
                            LayoutPanel.this.m_visLayout.getMainPerspective().clearDesignPaletteSelection();
                            LayoutPanel.this.m_visLayout.getMainPerspective().setPalleteSelectedStep(null);
                            LayoutPanel.this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.NONE);
                            LayoutPanel.this.m_visLayout.setEdited(true);
                        }
                    }
                    LayoutPanel.this.revalidate();
                    LayoutPanel.this.repaint();
                    LayoutPanel.this.m_visLayout.getMainPerspective().notifyIsDirty();
                }
                if (LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.PASTING && LayoutPanel.this.m_visLayout.getMainPerspective().getPasteBuffer().length() > 0) {
                    try {
                        LayoutPanel.this.m_visLayout.pasteFromClipboard((int)px, (int)py);
                    }
                    catch (WekaException e) {
                        LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(e);
                    }
                    LayoutPanel.this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.NONE);
                    LayoutPanel.this.m_visLayout.getMainPerspective().setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.CONNECTING) {
                    LayoutPanel.this.repaint();
                    for (StepVisual v : LayoutPanel.this.m_visLayout.getRenderGraph()) {
                        v.setDisplayConnectors(false);
                    }
                    if (step != null && step.getStepManager() != LayoutPanel.this.m_visLayout.getEditStep().getStepManager()) {
                        LayoutPanel.this.m_visLayout.addUndoPoint();
                        LayoutPanel.this.m_visLayout.connectSteps(LayoutPanel.this.m_visLayout.getEditStep().getStepManager(), step.getStepManager(), LayoutPanel.this.m_visLayout.getEditConnection());
                        LayoutPanel.this.m_visLayout.setEdited(true);
                        LayoutPanel.this.repaint();
                    }
                    LayoutPanel.this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.NONE);
                    LayoutPanel.this.m_visLayout.setEditStep(null);
                    LayoutPanel.this.m_visLayout.setEditConnection(null);
                }
                if (LayoutPanel.this.m_visLayout.getSelectedSteps().size() > 0) {
                    LayoutPanel.this.m_visLayout.setSelectedSteps(new ArrayList<StepVisual>());
                }
            }
        });
    }

    protected void setupMouseMotionListener() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                double z = (double)LayoutPanel.this.m_visLayout.getZoomSetting() / 100.0;
                double px = me.getX();
                double py = me.getY();
                px /= z;
                py /= z;
                if (LayoutPanel.this.m_visLayout.getEditStep() != null && LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.MOVING) {
                    int deltaX = (int)px - LayoutPanel.this.m_oldX;
                    int deltaY = (int)py - LayoutPanel.this.m_oldY;
                    LayoutPanel.this.m_visLayout.getEditStep().setX(LayoutPanel.this.m_visLayout.getEditStep().getX() + deltaX);
                    LayoutPanel.this.m_visLayout.getEditStep().setY(LayoutPanel.this.m_visLayout.getEditStep().getY() + deltaY);
                    for (StepVisual v : LayoutPanel.this.m_visLayout.getSelectedSteps()) {
                        if (v == LayoutPanel.this.m_visLayout.getEditStep()) continue;
                        v.setX(v.getX() + deltaX);
                        v.setY(v.getY() + deltaY);
                    }
                    LayoutPanel.this.repaint();
                    LayoutPanel.this.m_oldX = (int)px;
                    LayoutPanel.this.m_oldY = (int)py;
                    LayoutPanel.this.m_visLayout.setEdited(true);
                }
                if (LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.SELECTING) {
                    LayoutPanel.this.repaint();
                    LayoutPanel.this.m_oldX = (int)px;
                    LayoutPanel.this.m_oldY = (int)py;
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                double z = (double)LayoutPanel.this.m_visLayout.getZoomSetting() / 100.0;
                double px = me.getX();
                double py = me.getY();
                px /= z;
                py /= z;
                if (LayoutPanel.this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.CONNECTING) {
                    LayoutPanel.this.repaint();
                    LayoutPanel.this.m_oldX = (int)px;
                    LayoutPanel.this.m_oldY = (int)py;
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics gx) {
        Color backG = this.m_visLayout.getMainPerspective().getSetting(KFDefaults.LAYOUT_COLOR_KEY, KFDefaults.LAYOUT_COLOR);
        if (!backG.equals(this.getBackground())) {
            this.setBackground(backG);
        }
        double lz = (double)this.m_visLayout.getZoomSetting() / 100.0;
        ((Graphics2D)gx).scale(lz, lz);
        if (this.m_visLayout.getZoomSetting() < 100) {
            ((Graphics2D)gx).setStroke(new BasicStroke(2.0f));
        }
        super.paintComponent(gx);
        ((Graphics2D)gx).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)gx).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        this.paintStepLabels(gx);
        this.paintConnections(gx);
        if (this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.CONNECTING) {
            gx.drawLine(this.m_currentX, this.m_currentY, this.m_oldX, this.m_oldY);
        } else if (this.m_visLayout.getFlowLayoutOperation() == VisibleLayout.LayoutOperation.SELECTING) {
            gx.drawRect(this.m_currentX < this.m_oldX ? this.m_currentX : this.m_oldX, this.m_currentY < this.m_oldY ? this.m_currentY : this.m_oldY, Math.abs(this.m_oldX - this.m_currentX), Math.abs(this.m_oldY - this.m_currentY));
        }
        if (this.m_visLayout.getMainPerspective().getSetting(KFDefaults.SHOW_GRID_KEY, false).booleanValue()) {
            Color gridColor = this.m_visLayout.getMainPerspective().getSetting(KFDefaults.GRID_COLOR_KEY, KFDefaults.GRID_COLOR);
            gx.setColor(gridColor);
            int gridSpacing = this.m_visLayout.getMainPerspective().getSetting(KFDefaults.GRID_SPACING_KEY, 40);
            int layoutWidth = this.m_visLayout.getMainPerspective().getSetting(KFDefaults.LAYOUT_WIDTH_KEY, 2560);
            int layoutHeight = this.m_visLayout.getMainPerspective().getSetting(KFDefaults.LAYOUT_HEIGHT_KEY, 1440);
            Stroke original = ((Graphics2D)gx).getStroke();
            BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f);
            ((Graphics2D)gx).setStroke(dashed);
            int i2 = gridSpacing;
            while ((double)i2 < (double)layoutWidth / lz) {
                gx.drawLine(i2, 0, i2, (int)((double)layoutHeight / lz));
                i2 += gridSpacing;
            }
            i2 = gridSpacing;
            while ((double)i2 < (double)layoutHeight / lz) {
                gx.drawLine(0, i2, (int)((double)layoutWidth / lz), i2);
                i2 += gridSpacing;
            }
            ((Graphics2D)gx).setStroke(original);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        for (StepVisual v : this.m_visLayout.getRenderGraph()) {
            Dimension d = v.getPreferredSize();
            v.setBounds(v.getX(), v.getY(), d.width, d.height);
            v.revalidate();
        }
    }

    protected void paintStepLabels(Graphics gx) {
        gx.setFont(new Font(null, 0, this.m_visLayout.getMainPerspective().getSetting(KFDefaults.STEP_LABEL_FONT_SIZE_KEY, 9)));
        FontMetrics fm = gx.getFontMetrics();
        int hf = fm.getAscent();
        for (StepVisual v : this.m_visLayout.getRenderGraph()) {
            if (!v.getDisplayStepLabel()) continue;
            int cx = v.getX();
            int cy = v.getY();
            int width = v.getWidth();
            int height = v.getHeight();
            String label = v.getStepName();
            int labelwidth = fm.stringWidth(label);
            if (labelwidth < width) {
                gx.drawString(label, cx + width / 2 - labelwidth / 2, cy + height + hf + 2);
                continue;
            }
            int mid = label.length() / 2;
            int closest = label.length();
            int closestI = -1;
            for (int z = 0; z < label.length(); ++z) {
                if (label.charAt(z) >= 'a' || Math.abs(mid - z) >= closest) continue;
                closest = Math.abs(mid - z);
                closestI = z;
            }
            if (closestI != -1) {
                String left = label.substring(0, closestI);
                String right = label.substring(closestI, label.length());
                if (left.length() > 1 && right.length() > 1) {
                    gx.drawString(left, cx + width / 2 - fm.stringWidth(left) / 2, cy + height + hf * 1 + 2);
                    gx.drawString(right, cx + width / 2 - fm.stringWidth(right) / 2, cy + height + hf * 2 + 2);
                    continue;
                }
                gx.drawString(label, cx + width / 2 - fm.stringWidth(label) / 2, cy + height + hf * 1 + 2);
                continue;
            }
            gx.drawString(label, cx + width / 2 - fm.stringWidth(label) / 2, cy + height + hf * 1 + 2);
        }
    }

    protected void paintConnections(Graphics gx) {
        for (StepVisual stepVis : this.m_visLayout.getRenderGraph()) {
            Map<String, List<StepManager>> outConns = stepVis.getStepManager().getOutgoingConnections();
            if (outConns.size() <= 0) continue;
            List<String> generatableOutputConnections = stepVis.getStepManager().getStepOutgoingConnectionTypes();
            int count = 0;
            for (Map.Entry<String, List<StepManager>> e : outConns.entrySet()) {
                String connName = e.getKey();
                List<StepManager> connectedSteps = e.getValue();
                if (connectedSteps.size() > 0) {
                    int sX = stepVis.getX();
                    int sY = stepVis.getY();
                    int sWidth = stepVis.getWidth();
                    int sHeight = stepVis.getHeight();
                    for (StepManager target : connectedSteps) {
                        double angle;
                        boolean active;
                        StepManagerImpl targetI = (StepManagerImpl)target;
                        int tX = targetI.getStepVisual().getX();
                        int tY = targetI.getStepVisual().getY();
                        int tWidth = targetI.getStepVisual().getWidth();
                        int tHeight = targetI.getStepVisual().getHeight();
                        Point bestSourcePoint = stepVis.getClosestConnectorPoint(new Point(tX + tWidth / 2, tY + tHeight / 2));
                        Point bestTargetPoint = targetI.getStepVisual().getClosestConnectorPoint(new Point(sX + sWidth / 2, sY + sHeight / 2));
                        gx.setColor(Color.red);
                        boolean bl = active = generatableOutputConnections != null && generatableOutputConnections.contains(connName);
                        if (!active) {
                            gx.setColor(Color.gray);
                        }
                        gx.drawLine((int)bestSourcePoint.getX(), (int)bestSourcePoint.getY(), (int)bestTargetPoint.getX(), (int)bestTargetPoint.getY());
                        try {
                            double a = (bestSourcePoint.getY() - bestTargetPoint.getY()) / (bestSourcePoint.getX() - bestTargetPoint.getX());
                            angle = Math.atan(a);
                        }
                        catch (Exception ex) {
                            angle = 1.5707963267948966;
                        }
                        Point arrowstart = new Point(bestTargetPoint.x, bestTargetPoint.y);
                        Point arrowoffset = new Point((int)(7.0 * Math.cos(angle)), (int)(7.0 * Math.sin(angle)));
                        Point arrowend = bestSourcePoint.getX() >= bestTargetPoint.getX() ? new Point(arrowstart.x + arrowoffset.x, arrowstart.y + arrowoffset.y) : new Point(arrowstart.x - arrowoffset.x, arrowstart.y - arrowoffset.y);
                        int[] xs = new int[]{arrowstart.x, arrowend.x + (int)(7.0 * Math.cos(angle + 1.5707963267948966)), arrowend.x + (int)(7.0 * Math.cos(angle - 1.5707963267948966))};
                        int[] ys = new int[]{arrowstart.y, arrowend.y + (int)(7.0 * Math.sin(angle + 1.5707963267948966)), arrowend.y + (int)(7.0 * Math.sin(angle - 1.5707963267948966))};
                        gx.fillPolygon(xs, ys, 3);
                        int midx = (int)bestSourcePoint.getX();
                        midx += (int)((bestTargetPoint.getX() - bestSourcePoint.getX()) / 2.0);
                        int midy = (int)bestSourcePoint.getY();
                        midy += (int)((bestTargetPoint.getY() - bestSourcePoint.getY()) / 2.0) - 2;
                        gx.setColor(active ? Color.blue : Color.gray);
                        if (this.m_visLayout.previousConn(outConns, targetI, count)) {
                            midy -= 15;
                        }
                        gx.drawString(connName, midx, midy);
                    }
                }
                ++count;
            }
        }
    }

    protected void canvasContextualMenu(final int x, final int y) {
        Map<String, List<StepManagerImpl[]>> closestConnections = this.m_visLayout.findClosestConnections(new Point(x, y), 10);
        PopupMenu contextualMenu = new PopupMenu();
        int menuItemCount = 0;
        if (this.m_visLayout.getSelectedSteps().size() > 0) {
            MenuItem snapItem = new MenuItem("Snap selected to grid");
            snapItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutPanel.this.snapSelectedToGrid();
                }
            });
            contextualMenu.add(snapItem);
            ++menuItemCount;
            MenuItem copyItem = new MenuItem("Copy selected");
            copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LayoutPanel.this.m_visLayout.copySelectedStepsToClipboard();
                        LayoutPanel.this.m_visLayout.setSelectedSteps(new ArrayList<StepVisual>());
                    }
                    catch (WekaException ex) {
                        LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                    }
                }
            });
            contextualMenu.add(copyItem);
            ++menuItemCount;
            MenuItem menuItem = new MenuItem("Cut selected");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LayoutPanel.this.m_visLayout.copySelectedStepsToClipboard();
                        LayoutPanel.this.m_visLayout.removeSelectedSteps();
                    }
                    catch (WekaException ex) {
                        LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                    }
                }
            });
            contextualMenu.add(menuItem);
            ++menuItemCount;
            MenuItem deleteSelected = new MenuItem("Delete selected");
            deleteSelected.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LayoutPanel.this.m_visLayout.removeSelectedSteps();
                    }
                    catch (WekaException ex) {
                        LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                    }
                }
            });
            contextualMenu.add(deleteSelected);
            ++menuItemCount;
        }
        if (this.m_visLayout.getMainPerspective().getPasteBuffer() != null && this.m_visLayout.getMainPerspective().getPasteBuffer().length() > 0) {
            contextualMenu.addSeparator();
            ++menuItemCount;
            MenuItem pasteItem = new MenuItem("Paste");
            pasteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LayoutPanel.this.m_visLayout.pasteFromClipboard(x, y);
                    }
                    catch (WekaException ex) {
                        LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                    }
                }
            });
            contextualMenu.add(pasteItem);
            ++menuItemCount;
        }
        if (closestConnections.size() > 0) {
            contextualMenu.addSeparator();
            MenuItem deleteConnection = new MenuItem("Delete connection:");
            deleteConnection.setEnabled(false);
            int n = ++menuItemCount;
            ++menuItemCount;
            contextualMenu.insert(deleteConnection, n);
            for (Map.Entry entry : closestConnections.entrySet()) {
                final String connName = (String)entry.getKey();
                for (StepManagerImpl[] cons : (List)entry.getValue()) {
                    final StepManagerImpl source = cons[0];
                    final StepManagerImpl target = cons[1];
                    MenuItem deleteItem = new MenuItem(connName + "-->" + target.getName());
                    deleteItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutPanel.this.m_visLayout.addUndoPoint();
                            source.disconnectStepWithConnection(target.getManagedStep(), connName);
                            target.disconnectStepWithConnection(source.getManagedStep(), connName);
                            if (LayoutPanel.this.m_visLayout.getSelectedSteps().size() > 0) {
                                LayoutPanel.this.m_visLayout.setSelectedSteps(new ArrayList<StepVisual>());
                            }
                            LayoutPanel.this.m_visLayout.setEdited(true);
                            LayoutPanel.this.revalidate();
                            LayoutPanel.this.repaint();
                            LayoutPanel.this.m_visLayout.getMainPerspective().notifyIsDirty();
                        }
                    });
                    contextualMenu.add(deleteItem);
                    ++menuItemCount;
                }
            }
        }
        if (menuItemCount > 0) {
            contextualMenu.addSeparator();
            ++menuItemCount;
        }
        MenuItem noteItem = new MenuItem("New note");
        noteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutPanel.this.initiateAddNote();
            }
        });
        contextualMenu.add(noteItem);
        this.add(contextualMenu);
        double z = (double)this.m_visLayout.getZoomSetting() / 100.0;
        double px = (double)x * z;
        double py = (double)y * z;
        contextualMenu.show(this, (int)px, (int)py);
    }

    protected void initiateAddNote() {
        Note n = new Note();
        StepManagerImpl noteManager = new StepManagerImpl(n);
        StepVisual noteVisual = StepVisual.createVisual(noteManager);
        this.m_visLayout.getMainPerspective().setPalleteSelectedStep(noteVisual.getStepManager());
        this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.ADDING);
        this.m_visLayout.getMainPerspective().setCursor(Cursor.getPredefinedCursor(1));
    }

    protected void stepContextualMenu(final StepVisual step, final int x, final int y) {
        List<Perspective> perspectives;
        String command;
        PopupMenu stepContextMenu = new PopupMenu();
        boolean executing = this.m_visLayout.isExecuting();
        int menuItemCount = 0;
        MenuItem edit = new MenuItem("Edit:");
        edit.setEnabled(false);
        stepContextMenu.insert(edit, menuItemCount);
        ++menuItemCount;
        if (this.m_visLayout.getSelectedSteps().size() > 0) {
            MenuItem copyItem = new MenuItem("Copy");
            copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LayoutPanel.this.m_visLayout.copySelectedStepsToClipboard();
                    }
                    catch (WekaException ex) {
                        LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                    }
                    LayoutPanel.this.m_visLayout.setSelectedSteps(new ArrayList<StepVisual>());
                }
            });
            stepContextMenu.add(copyItem);
            copyItem.setEnabled(!executing);
            ++menuItemCount;
        }
        MenuItem deleteItem = new MenuItem("Delete");
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutPanel.this.m_visLayout.addUndoPoint();
                try {
                    LayoutPanel.this.m_visLayout.removeStep(step);
                }
                catch (WekaException ex) {
                    LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                }
                String key = step.getStepName() + "$" + step.getStepManager().getManagedStep().hashCode();
                LayoutPanel.this.m_visLayout.getLogPanel().statusMessage(key + "|remove");
                LayoutPanel.this.revalidate();
                LayoutPanel.this.repaint();
                LayoutPanel.this.m_visLayout.setEdited(true);
                LayoutPanel.this.m_visLayout.getMainPerspective().notifyIsDirty();
                LayoutPanel.this.m_visLayout.getMainPerspective().getMainToolBar().enableWidget(MainKFPerspectiveToolBar.Widgets.SELECT_ALL_BUTTON.toString(), LayoutPanel.this.m_visLayout.getSelectedSteps().size() > 0);
            }
        });
        deleteItem.setEnabled(!executing);
        stepContextMenu.add(deleteItem);
        ++menuItemCount;
        MenuItem nameItem = new MenuItem("Set name...");
        nameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String oldName = step.getStepName();
                String name = JOptionPane.showInputDialog(LayoutPanel.this.m_visLayout.getMainPerspective(), "Enter a name for this step", oldName);
                if (name != null) {
                    LayoutPanel.this.m_visLayout.renameStep(oldName, name);
                    LayoutPanel.this.m_visLayout.setEdited(true);
                    LayoutPanel.this.revalidate();
                    LayoutPanel.this.repaint();
                }
            }
        });
        nameItem.setEnabled(!executing);
        stepContextMenu.add(nameItem);
        ++menuItemCount;
        MenuItem configItem = new MenuItem("Configure...");
        configItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutPanel.this.popupStepEditorDialog(step);
                LayoutPanel.this.m_visLayout.getMainPerspective().notifyIsDirty();
            }
        });
        configItem.setEnabled(!executing);
        stepContextMenu.add(configItem);
        ++menuItemCount;
        List<String> outgoingConnTypes = step.getStepManager().getManagedStep().getOutgoingConnectionTypes();
        if (outgoingConnTypes != null && outgoingConnTypes.size() > 0) {
            MenuItem connections = new MenuItem("Connections:");
            connections.setEnabled(false);
            stepContextMenu.insert(connections, menuItemCount);
            ++menuItemCount;
            for (final String connType : outgoingConnTypes) {
                Iterator<Map.Entry<String, StepInteractiveViewer>> conItem = new MenuItem(connType);
                ((MenuItem)((Object)conItem)).setEnabled(!executing);
                ((MenuItem)((Object)conItem)).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutPanel.this.initiateConnection(connType, step, x, y);
                        LayoutPanel.this.m_visLayout.getMainPerspective().notifyIsDirty();
                    }
                });
                stepContextMenu.add((MenuItem)((Object)conItem));
                ++menuItemCount;
            }
        }
        Map<String, String> interactiveViews = step.getStepManager().getManagedStep().getInteractiveViewers();
        Map<String, StepInteractiveViewer> interactiveViewsImpls = step.getStepManager().getManagedStep().getInteractiveViewersImpls();
        if (interactiveViews != null && interactiveViews.size() > 0) {
            MenuItem actions2 = new MenuItem("Actions:");
            actions2.setEnabled(false);
            stepContextMenu.insert(actions2, menuItemCount++);
            for (Map.Entry<String, StepInteractiveViewer> entry : interactiveViews.entrySet()) {
                command = entry.getKey();
                String viewerClassName = (String)((Object)entry.getValue());
                this.addInteractiveViewMenuItem(step, entry.getKey(), !executing, (String)((Object)entry.getValue()), null, stepContextMenu);
                ++menuItemCount;
            }
        } else if (interactiveViewsImpls != null && interactiveViewsImpls.size() > 0) {
            MenuItem actions2 = new MenuItem("Actions:");
            actions2.setEnabled(false);
            stepContextMenu.insert(actions2, menuItemCount++);
            for (Map.Entry<String, StepInteractiveViewer> entry : interactiveViewsImpls.entrySet()) {
                command = entry.getKey();
                StepInteractiveViewer impl = entry.getValue();
                this.addInteractiveViewMenuItem(step, entry.getKey(), !executing, null, impl, stepContextMenu);
                ++menuItemCount;
            }
        }
        if ((perspectives = this.m_visLayout.getMainPerspective().getMainApplication().getPerspectiveManager().getVisiblePerspectives()).size() > 0 && step.getStepManager().getManagedStep() instanceof weka.knowledgeflow.steps.Loader) {
            boolean bl;
            final Loader theLoader = ((weka.knowledgeflow.steps.Loader)step.getStepManager().getManagedStep()).getLoader();
            boolean bl2 = true;
            if (theLoader instanceof FileSourcedConverter) {
                String fileName = ((FileSourcedConverter)((Object)theLoader)).retrieveFile().getPath();
                fileName = this.m_visLayout.environmentSubstitute(fileName);
                File tempF = new File(fileName);
                String fileNameFixedPathSep = fileName.replace(File.separatorChar, '/');
                if (!tempF.isFile() && this.getClass().getClassLoader().getResource(fileNameFixedPathSep) == null) {
                    bl = false;
                }
            }
            if (bl) {
                stepContextMenu.addSeparator();
                ++menuItemCount;
                if (perspectives.size() > 1) {
                    MenuItem sendToAllPerspectives = new MenuItem("Send to all perspectives");
                    ++menuItemCount;
                    sendToAllPerspectives.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutPanel.this.loadDataAndSendToPerspective(theLoader, perspectives, -1);
                        }
                    });
                    stepContextMenu.add(sendToAllPerspectives);
                }
                Menu sendToPerspective = new Menu("Send to perspective...");
                stepContextMenu.add(sendToPerspective);
                ++menuItemCount;
                for (int i2 = 0; i2 < perspectives.size(); ++i2) {
                    final int pIndex = i2;
                    if (!perspectives.get(i2).acceptsInstances() || perspectives.get(i2).getPerspectiveID().equalsIgnoreCase("knowledgeflow.main")) continue;
                    String pName = perspectives.get(i2).getPerspectiveTitle();
                    MenuItem pI = new MenuItem(pName);
                    pI.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutPanel.this.loadDataAndSendToPerspective(theLoader, perspectives, pIndex);
                        }
                    });
                    sendToPerspective.add(pI);
                }
            }
        }
        if (menuItemCount > 0) {
            double z = (double)this.m_visLayout.getZoomSetting() / 100.0;
            double px = (double)x * z;
            double py = (double)y * z;
            this.add(stepContextMenu);
            stepContextMenu.show(this, (int)px, (int)py);
        }
    }

    private synchronized void loadDataAndSendToPerspective(final Loader loader, final List<Perspective> perspectives, final int perspectiveIndex) {
        if (this.m_perspectiveDataLoadThread == null) {
            this.m_perspectiveDataLoadThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (loader instanceof EnvironmentHandler) {
                            ((EnvironmentHandler)((Object)loader)).setEnvironment(LayoutPanel.this.m_visLayout.getEnvironment());
                            loader.reset();
                        }
                        LayoutPanel.this.m_visLayout.getLogPanel().statusMessage("@!@[KnowledgeFlow]|Sending data to perspective(s)...");
                        Instances data = loader.getDataSet();
                        if (data != null) {
                            LayoutPanel.this.m_visLayout.getMainPerspective().getMainApplication().showPerspectivesToolBar();
                            if (perspectiveIndex < 0) {
                                for (Perspective p : perspectives) {
                                    if (!p.acceptsInstances()) continue;
                                    p.setInstances(data);
                                    LayoutPanel.this.m_visLayout.getMainPerspective().getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(p.getPerspectiveID(), true);
                                }
                            } else {
                                ((Perspective)perspectives.get(perspectiveIndex)).setInstances(data);
                                LayoutPanel.this.m_visLayout.getMainPerspective().getMainApplication().getPerspectiveManager().setActivePerspective(((Perspective)perspectives.get(perspectiveIndex)).getPerspectiveID());
                                LayoutPanel.this.m_visLayout.getMainPerspective().getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(((Perspective)perspectives.get(perspectiveIndex)).getPerspectiveID(), true);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LayoutPanel.this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                    }
                    finally {
                        LayoutPanel.this.m_perspectiveDataLoadThread = null;
                        LayoutPanel.this.m_visLayout.getLogPanel().statusMessage("@!@[KnowledgeFlow]|OK");
                    }
                }
            };
            this.m_perspectiveDataLoadThread.setPriority(1);
            this.m_perspectiveDataLoadThread.start();
        }
    }

    protected void initiateConnection(String connType, StepVisual source, int x, int y) {
        if (this.m_visLayout.getSelectedSteps().size() > 0) {
            this.m_visLayout.setSelectedSteps(new ArrayList<StepVisual>());
        }
        List<StepManagerImpl> connectableForConnType = this.m_visLayout.findStepsThatCanAcceptConnection(connType);
        for (StepManagerImpl sm : connectableForConnType) {
            sm.getStepVisual().setDisplayConnectors(true);
        }
        if (connectableForConnType.size() > 0) {
            source.setDisplayConnectors(true);
            this.m_visLayout.setEditStep(source);
            this.m_visLayout.setEditConnection(connType);
            Point closest = source.getClosestConnectorPoint(new Point(x, y));
            this.m_currentX = (int)closest.getX();
            this.m_currentY = (int)closest.getY();
            this.m_oldX = this.m_currentX;
            this.m_oldY = this.m_currentY;
            Graphics2D gx = (Graphics2D)this.getGraphics();
            gx.setXORMode(Color.white);
            gx.drawLine(this.m_currentX, this.m_currentY, this.m_currentX, this.m_currentY);
            gx.dispose();
            this.m_visLayout.setFlowLayoutOperation(VisibleLayout.LayoutOperation.CONNECTING);
        }
        this.revalidate();
        this.repaint();
        this.m_visLayout.getMainPerspective().notifyIsDirty();
    }

    protected void addInteractiveViewMenuItem(final StepVisual step, String entryText, boolean enabled, final String viewerClassName, final StepInteractiveViewer viewerImpl, PopupMenu stepContextMenu) {
        MenuItem viewItem = new MenuItem(entryText);
        viewItem.setEnabled(enabled);
        viewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutPanel.this.popupStepInteractiveViewer(step, viewerClassName, viewerImpl);
            }
        });
        stepContextMenu.add(viewItem);
    }

    protected void popupStepInteractiveViewer(StepVisual step, String viewerClassName, StepInteractiveViewer viewerImpl) {
        try {
            Object viewer;
            Object object = viewer = viewerClassName != null ? WekaPackageClassLoaderManager.objectForName(viewerClassName) : viewerImpl;
            if (!(viewer instanceof StepInteractiveViewer)) {
                throw new WekaException("Interactive step viewer component " + viewerClassName + " must implement StepInteractiveViewer");
            }
            if (!(viewer instanceof JComponent)) {
                throw new WekaException("Interactive step viewer component " + viewerClassName + " must be a JComponent");
            }
            String viewerName = ((StepInteractiveViewer)viewer).getViewerName();
            ((StepInteractiveViewer)viewer).setStep(step.getStepManager().getManagedStep());
            ((StepInteractiveViewer)viewer).setMainKFPerspective(this.m_visLayout.getMainPerspective());
            JFrame jf = new JFrame(viewerName);
            ((StepInteractiveViewer)viewer).setParentWindow(jf);
            ((StepInteractiveViewer)viewer).init();
            jf.setLayout(new BorderLayout());
            jf.add((Component)((JComponent)viewer), "Center");
            jf.pack();
            jf.setVisible(true);
            ((StepInteractiveViewer)viewer).nowVisible();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.m_visLayout.getMainPerspective().showErrorDialog(e);
        }
    }

    protected void popupStepEditorDialog(StepVisual step) {
        String custEditor = step.getStepManager().getManagedStep().getCustomEditorForStep();
        StepEditorDialog toPopup = null;
        if (custEditor != null && custEditor.length() > 0) {
            try {
                Object custPanel = WekaPackageClassLoaderManager.objectForName(custEditor);
                if (!(custPanel instanceof StepEditorDialog)) {
                    throw new WekaException("Custom editor must be a subclass of StepEditorDialog");
                }
                toPopup = (StepEditorDialog)custPanel;
            }
            catch (Exception ex) {
                this.m_visLayout.getMainPerspective().showErrorDialog(ex);
                ex.printStackTrace();
            }
        } else {
            toPopup = new GOEStepEditorDialog();
            toPopup.setMainPerspective(this.m_visLayout.getMainPerspective());
        }
        final JDialog d = new JDialog((Window)((Frame)this.getTopLevelAncestor()), Dialog.ModalityType.DOCUMENT_MODAL);
        d.setLayout(new BorderLayout());
        d.getContentPane().add((Component)toPopup, "Center");
        final StepEditorDialog toPopupC = toPopup;
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                d.dispose();
            }
        });
        toPopup.setParentWindow(d);
        toPopup.setEnvironment(this.m_visLayout.getEnvironment());
        toPopup.setMainPerspective(this.m_visLayout.getMainPerspective());
        toPopup.setStepToEdit(step.getStepManager().getManagedStep());
        toPopup.setClosingListener(new StepEditorDialog.ClosingListener(){

            @Override
            public void closing() {
                if (toPopupC.isEdited()) {
                    LayoutPanel.this.m_visLayout.setEdited(true);
                }
            }
        });
        d.pack();
        d.setLocationRelativeTo(this.m_visLayout.getMainPerspective());
        d.setVisible(true);
    }

    private int snapToGrid(int val) {
        int r = val % this.m_gridSpacing;
        val /= this.m_gridSpacing;
        if (r > this.m_gridSpacing / 2) {
            ++val;
        }
        return val *= this.m_gridSpacing;
    }

    protected void snapSelectedToGrid() {
        List<StepVisual> selected = this.m_visLayout.getSelectedSteps();
        for (StepVisual s : selected) {
            int x = s.getX();
            int y = s.getY();
            s.setX(this.snapToGrid(x));
            s.setY(this.snapToGrid(y));
        }
        this.revalidate();
        this.repaint();
        this.m_visLayout.setEdited(true);
        this.m_visLayout.getMainPerspective().notifyIsDirty();
    }

    private void highlightSubFlow(int startX, int startY, int endX, int endY) {
        Rectangle r = new Rectangle(startX < endX ? startX : endX, startY < endY ? startY : endY, Math.abs(startX - endX), Math.abs(startY - endY));
        List<StepVisual> selected = this.m_visLayout.findSteps(r);
        this.m_visLayout.setSelectedSteps(selected);
    }
}

