/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Defaults;
import weka.core.Instances;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.ResultHistoryPanel;
import weka.gui.knowledgeflow.AttributeSummaryPerspective;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.AttributeSummarizer;

public class AttributeSummarizerInteractiveView
extends BaseInteractiveViewer {
    private static final long serialVersionUID = -8080574605631027263L;
    protected ResultHistoryPanel m_history;
    protected AttributeSummaryPerspective m_summarizer = new AttributeSummaryPerspective();
    protected JButton m_clearButton = new JButton("Clear results");
    protected JSplitPane m_splitPane;
    protected Instances m_currentInstances;

    @Override
    public String getViewerName() {
        return "Attribute Summarizer";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.m_history = new ResultHistoryPanel(null);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.setDeleteListener(new ResultHistoryPanel.RDeleteListener(){

            @Override
            public void entryDeleted(String name, int index) {
                ((AttributeSummarizer)AttributeSummarizerInteractiveView.this.getStep()).getDatasets().remove(index);
            }

            @Override
            public void entriesDeleted(List<String> names, List<Integer> indexes) {
                List<Data> ds = ((AttributeSummarizer)AttributeSummarizerInteractiveView.this.getStep()).getDatasets();
                ArrayList<Data> toRemove = new ArrayList<Data>();
                for (int i2 : indexes) {
                    toRemove.add(ds.get(i2));
                }
                ds.removeAll(toRemove);
            }
        });
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -5174882230278923704L;

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                Object inst;
                int index = AttributeSummarizerInteractiveView.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1 && (inst = AttributeSummarizerInteractiveView.this.m_history.getNamedObject(name = AttributeSummarizerInteractiveView.this.m_history.getNameAtIndex(index))) instanceof Instances) {
                    AttributeSummarizerInteractiveView.this.m_currentInstances = (Instances)inst;
                    AttributeSummarizerInteractiveView.this.m_summarizer.setInstances((Instances)inst, AttributeSummarizerInteractiveView.this.getSettings());
                    AttributeSummarizerInteractiveView.this.m_summarizer.repaint();
                    AttributeSummarizerInteractiveView.this.m_parent.revalidate();
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i2 = e.getFirstIndex(); i2 <= e.getLastIndex(); ++i2) {
                        String name;
                        Object inst;
                        if (!lm.isSelectedIndex(i2)) continue;
                        if (i2 == -1 || (inst = AttributeSummarizerInteractiveView.this.m_history.getNamedObject(name = AttributeSummarizerInteractiveView.this.m_history.getNameAtIndex(i2))) == null || !(inst instanceof Instances)) break;
                        AttributeSummarizerInteractiveView.this.m_currentInstances = (Instances)inst;
                        AttributeSummarizerInteractiveView.this.m_summarizer.setInstances((Instances)inst, AttributeSummarizerInteractiveView.this.getSettings());
                        AttributeSummarizerInteractiveView.this.m_summarizer.repaint();
                        AttributeSummarizerInteractiveView.this.m_parent.revalidate();
                        break;
                    }
                }
            }
        });
        this.m_summarizer.setPreferredSize(new Dimension(800, 600));
        this.m_splitPane = new JSplitPane(1, this.m_history, this.m_summarizer);
        this.add((Component)this.m_splitPane, "Center");
        boolean first = true;
        for (Data d : ((AttributeSummarizer)this.getStep()).getDatasets()) {
            String title = d.getPayloadElement("aux_textTitle").toString();
            this.m_history.addResult(title, new StringBuffer());
            Instances instances = (Instances)d.getPrimaryPayload();
            this.m_history.addObject(title, instances);
            if (!first) continue;
            this.m_summarizer.setInstances(instances, this.getSettings());
            this.m_summarizer.repaint();
            first = false;
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSummarizerInteractiveView.this.m_history.clearResults();
                ((AttributeSummarizer)AttributeSummarizerInteractiveView.this.getStep()).getDatasets().clear();
                AttributeSummarizerInteractiveView.this.m_splitPane.remove(AttributeSummarizerInteractiveView.this.m_summarizer);
            }
        });
    }

    @Override
    public Defaults getDefaultSettings() {
        return new AttributeSummaryPerspective().getDefaultSettings();
    }

    @Override
    public void applySettings(Settings settings) {
        this.m_summarizer.setInstances(this.m_currentInstances, this.getSettings());
        this.m_summarizer.repaint();
        this.m_parent.revalidate();
    }
}

