/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.WekaException;
import weka.gui.ResultHistoryPanel;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.gui.knowledgeflow.steps.ImageViewerInteractiveView;
import weka.knowledgeflow.steps.BoundaryPlotter;

public class BoundaryPlotterInteractiveView
extends BaseInteractiveViewer
implements BoundaryPlotter.RenderingUpdateListener {
    private static final long serialVersionUID = 5567187861739468636L;
    protected JButton m_clearButton = new JButton("Clear results");
    protected ResultHistoryPanel m_history;
    protected ImageViewerInteractiveView.ImageDisplayer m_plotter;

    @Override
    public String getViewerName() {
        return "Boundary Visualizer";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.m_plotter = new ImageViewerInteractiveView.ImageDisplayer();
        this.m_plotter.setMinimumSize(new Dimension(810, 610));
        this.m_plotter.setPreferredSize(new Dimension(810, 610));
        this.m_history = new ResultHistoryPanel(null);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Image list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -4984130887963944249L;

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                Object pic;
                int index = BoundaryPlotterInteractiveView.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1 && (pic = BoundaryPlotterInteractiveView.this.m_history.getNamedObject(name = BoundaryPlotterInteractiveView.this.m_history.getNameAtIndex(index))) instanceof BufferedImage) {
                    BoundaryPlotterInteractiveView.this.m_plotter.setImage((BufferedImage)pic);
                    BoundaryPlotterInteractiveView.this.m_plotter.repaint();
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i2 = e.getFirstIndex(); i2 <= e.getLastIndex(); ++i2) {
                        String name;
                        Object pic;
                        if (!lm.isSelectedIndex(i2)) continue;
                        if (i2 == -1 || (pic = BoundaryPlotterInteractiveView.this.m_history.getNamedObject(name = BoundaryPlotterInteractiveView.this.m_history.getNameAtIndex(i2))) == null || !(pic instanceof BufferedImage)) break;
                        BoundaryPlotterInteractiveView.this.m_plotter.setImage((BufferedImage)pic);
                        BoundaryPlotterInteractiveView.this.m_plotter.repaint();
                        break;
                    }
                }
            }
        });
        ImageViewerInteractiveView.MainPanel mainPanel = new ImageViewerInteractiveView.MainPanel(this.m_history, this.m_plotter);
        this.add((Component)mainPanel, "Center");
        boolean first = true;
        Map<String, BufferedImage> images = ((BoundaryPlotter)this.getStep()).getImages();
        if (images != null) {
            for (Map.Entry<String, BufferedImage> e : images.entrySet()) {
                this.m_history.addResult(e.getKey(), new StringBuffer());
                this.m_history.addObject(e.getKey(), e.getValue());
                if (!first) continue;
                this.m_plotter.setImage(e.getValue());
                this.m_plotter.repaint();
                first = false;
            }
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoundaryPlotterInteractiveView.this.m_history.clearResults();
                ((BoundaryPlotter)BoundaryPlotterInteractiveView.this.getStep()).getImages().clear();
                BoundaryPlotterInteractiveView.this.m_plotter.setImage(null);
                BoundaryPlotterInteractiveView.this.m_plotter.repaint();
            }
        });
        ((BoundaryPlotter)this.getStep()).setRenderingListener(this);
    }

    @Override
    public void renderingImageUpdate() {
        this.m_plotter.repaint();
    }

    @Override
    public void newPlotStarted(String description) {
        BufferedImage currentImage = ((BoundaryPlotter)this.getStep()).getCurrentImage();
        if (currentImage != null) {
            this.m_history.addResult(description, new StringBuffer());
            this.m_history.addObject(description, currentImage);
            this.m_history.setSelectedListValue(description);
            this.m_plotter.setImage(currentImage);
            this.m_plotter.repaint();
        }
    }

    @Override
    public void currentPlotRowCompleted(int row) {
        this.m_plotter.repaint();
    }

    @Override
    public void closePressed() {
        ((BoundaryPlotter)this.getStep()).removeRenderingListener(this);
    }
}

