/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.EnvironmentField;
import weka.gui.knowledgeflow.GOEStepEditorDialog;
import weka.knowledgeflow.steps.BoundaryPlotter;

public class BoundaryPlotterStepEditorDialog
extends GOEStepEditorDialog {
    private static final long serialVersionUID = 4351742205211273840L;
    protected JComboBox<String> m_xCombo = new JComboBox();
    protected JComboBox<String> m_yCombo = new JComboBox();
    protected EnvironmentField m_xEnviro = new EnvironmentField();
    protected EnvironmentField m_yEnviro = new EnvironmentField();

    @Override
    public void layoutEditor() {
        this.m_xCombo.setEditable(true);
        this.m_yCombo.setEditable(true);
        BoundaryPlotter step = (BoundaryPlotter)this.getStepToEdit();
        Instances incomingStructure = null;
        try {
            incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("dataSet");
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("trainingSet");
            }
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("testSet");
            }
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("instance");
            }
        }
        catch (WekaException ex) {
            this.showErrorDialog(ex);
        }
        JPanel attPan = new JPanel(new GridLayout(1, 2));
        JPanel xHolder = new JPanel(new BorderLayout());
        JPanel yHolder = new JPanel(new BorderLayout());
        xHolder.setBorder(new TitledBorder("X axis"));
        yHolder.setBorder(new TitledBorder("Y axis"));
        attPan.add(xHolder);
        attPan.add(yHolder);
        if (incomingStructure != null) {
            this.m_xEnviro = null;
            this.m_yEnviro = null;
            xHolder.add(this.m_xCombo, "Center");
            yHolder.add(this.m_yCombo, "Center");
            String xAttN = step.getXAttName();
            String yAttN = step.getYAttName();
            int numAdded = 0;
            for (int i2 = 0; i2 < incomingStructure.numAttributes(); ++i2) {
                Attribute att = incomingStructure.attribute(i2);
                if (!att.isNumeric()) continue;
                this.m_xCombo.addItem(att.name());
                this.m_yCombo.addItem(att.name());
                ++numAdded;
            }
            attPan.add(xHolder);
            attPan.add(yHolder);
            if (numAdded < 2) {
                this.showInfoDialog("There are not enough numeric attributes in the incoming data to visualize with", "Not enough attributes available", true);
            } else {
                if (xAttN != null && xAttN.length() > 0) {
                    this.m_xCombo.setSelectedItem(xAttN);
                }
                if (yAttN != null && yAttN.length() > 0) {
                    this.m_yCombo.setSelectedItem(yAttN);
                }
            }
        } else {
            this.m_xCombo = null;
            this.m_yCombo = null;
            xHolder.add((Component)this.m_xEnviro, "Center");
            yHolder.add((Component)this.m_yEnviro, "Center");
            this.m_xEnviro.setText(step.getXAttName());
            this.m_yEnviro.setText(step.getYAttName());
        }
        this.m_editorHolder.add((Component)attPan, "South");
    }

    @Override
    public void okPressed() {
        String xName = this.m_xCombo != null ? this.m_xCombo.getSelectedItem().toString() : this.m_xEnviro.getText();
        String yName = this.m_yCombo != null ? this.m_yCombo.getSelectedItem().toString() : this.m_yEnviro.getText();
        ((BoundaryPlotter)this.getStepToEdit()).setXAttName(xName);
        ((BoundaryPlotter)this.getStepToEdit()).setYAttName(yName);
    }
}

