/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.EnvironmentField;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.FlowByExpression;

public class FlowByExpressionStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = 1545740909421963983L;
    protected JComboBox m_lhsField = new EnvironmentField.WideComboBox();
    protected JComboBox<String> m_operatorCombo = new JComboBox();
    protected JComboBox m_rhsField = new EnvironmentField.WideComboBox();
    protected JCheckBox m_rhsIsAttribute = new JCheckBox("RHS is attribute");
    protected JLabel m_expressionLab = new JLabel();
    protected JComboBox<String> m_trueData = new JComboBox();
    protected JComboBox<String> m_falseData = new JComboBox();
    protected JTree m_expressionTree;
    protected DefaultMutableTreeNode m_treeRoot;
    protected JButton m_addExpressionNode = new JButton("Add Expression node");
    protected JButton m_addBracketNode = new JButton("Add bracket node");
    protected JButton m_toggleNegation = new JButton("Toggle negation");
    protected JButton m_andOr = new JButton("And/Or");
    protected JButton m_deleteNode = new JButton("Delete node");

    @Override
    protected void layoutEditor() {
        JPanel outerP = new JPanel(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        this.setupTree(outerP);
        JPanel fieldHolder = new JPanel();
        fieldHolder.setLayout(new GridLayout(0, 4));
        JPanel lhsP = new JPanel();
        lhsP.setLayout(new BorderLayout());
        lhsP.setBorder(BorderFactory.createTitledBorder("Attribute"));
        this.m_lhsField.setEditable(true);
        lhsP.add((Component)this.m_lhsField, "Center");
        lhsP.setToolTipText("<html>Name or index of attribute. also accepts<br>the special labels \"/first\" and \"/last\" to indicate<br>the first and last attribute respecitively</html>");
        this.m_lhsField.setToolTipText("<html>Name or index of attribute. also accepts<br>the special labels \"/first\" and \"/last\" to indicate<br>the first and last attribute respecitively</html>");
        JPanel operatorP = new JPanel();
        operatorP.setLayout(new BorderLayout());
        operatorP.setBorder(BorderFactory.createTitledBorder("Operator"));
        this.m_operatorCombo.addItem(" = ");
        this.m_operatorCombo.addItem(" != ");
        this.m_operatorCombo.addItem(" < ");
        this.m_operatorCombo.addItem(" <= ");
        this.m_operatorCombo.addItem(" > ");
        this.m_operatorCombo.addItem(" >= ");
        this.m_operatorCombo.addItem(" isMissing ");
        this.m_operatorCombo.addItem(" contains ");
        this.m_operatorCombo.addItem(" startsWith ");
        this.m_operatorCombo.addItem(" endsWith ");
        this.m_operatorCombo.addItem(" regex ");
        operatorP.add(this.m_operatorCombo, "Center");
        JPanel rhsP = new JPanel();
        rhsP.setLayout(new BorderLayout());
        rhsP.setBorder(BorderFactory.createTitledBorder("Constant or attribute"));
        rhsP.setToolTipText("<html>Constant value to test/check for. If testing<br>against an attribute, then this specifiesan attribute index or name</html>");
        this.m_rhsField.setEditable(true);
        rhsP.add((Component)this.m_rhsField, "Center");
        fieldHolder.add(lhsP);
        fieldHolder.add(operatorP);
        fieldHolder.add(rhsP);
        fieldHolder.add(this.m_rhsIsAttribute);
        controlHolder.add((Component)fieldHolder, "South");
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BorderLayout());
        JPanel expressionP = new JPanel();
        expressionP.setLayout(new BorderLayout());
        expressionP.setBorder(BorderFactory.createTitledBorder("Expression"));
        JPanel tempE = new JPanel();
        tempE.setLayout(new BorderLayout());
        tempE.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        tempE.add((Component)this.m_expressionLab, "Center");
        JScrollPane expressionScroller = new JScrollPane(tempE);
        expressionP.add((Component)expressionScroller, "Center");
        tempPanel.add((Component)expressionP, "South");
        JPanel flowControlP = new JPanel();
        flowControlP.setLayout(new GridLayout(2, 2));
        flowControlP.add(new JLabel("Send true instances to node", 4));
        flowControlP.add(this.m_trueData);
        flowControlP.add(new JLabel("Send false instances to node", 4));
        flowControlP.add(this.m_falseData);
        tempPanel.add((Component)flowControlP, "North");
        String falseStepN = ((FlowByExpression)this.getStepToEdit()).getFalseStepName();
        String trueStepN = ((FlowByExpression)this.getStepToEdit()).getTrueStepName();
        List<String> connectedSteps = ((FlowByExpression)this.getStepToEdit()).getDownstreamStepNames();
        this.m_trueData.addItem("<none>");
        this.m_falseData.addItem("<none>");
        for (String s : connectedSteps) {
            this.m_trueData.addItem(s);
            this.m_falseData.addItem(s);
        }
        if (falseStepN != null && falseStepN.length() > 0) {
            this.m_falseData.setSelectedItem(falseStepN);
        }
        if (trueStepN != null && trueStepN.length() > 0) {
            this.m_trueData.setSelectedItem(trueStepN);
        }
        controlHolder.add((Component)tempPanel, "North");
        outerP.add((Component)controlHolder, "North");
        this.add((Component)outerP, "Center");
        this.m_rhsIsAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionStepEditorDialog.this.m_expressionTree != null && (p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    ((FlowByExpression.ExpressionClause)thisNode).setRHSIsAnAttribute(FlowByExpressionStepEditorDialog.this.m_rhsIsAttribute.isSelected());
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                }
            }
        });
        this.m_operatorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionStepEditorDialog.this.m_operatorCombo.getSelectedIndex() > 5) {
                    FlowByExpressionStepEditorDialog.this.m_rhsIsAttribute.setSelected(false);
                    FlowByExpressionStepEditorDialog.this.m_rhsIsAttribute.setEnabled(false);
                } else {
                    FlowByExpressionStepEditorDialog.this.m_rhsIsAttribute.setEnabled(true);
                }
                if (FlowByExpressionStepEditorDialog.this.m_expressionTree != null && (p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    String selection = FlowByExpressionStepEditorDialog.this.m_operatorCombo.getSelectedItem().toString();
                    FlowByExpression.ExpressionClause.ExpressionType t = FlowByExpression.ExpressionClause.ExpressionType.EQUALS;
                    for (FlowByExpression.ExpressionClause.ExpressionType et : FlowByExpression.ExpressionClause.ExpressionType.values()) {
                        if (!et.toString().equals(selection)) continue;
                        t = et;
                        break;
                    }
                    ((FlowByExpression.ExpressionClause)thisNode).setOperator(t);
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                }
            }
        });
        this.m_lhsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object text;
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionStepEditorDialog.this.m_expressionTree != null && (p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause && (text = FlowByExpressionStepEditorDialog.this.m_lhsField.getSelectedItem()) != null) {
                    ((FlowByExpression.ExpressionClause)thisNode).setLHSAttName(text.toString());
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                }
            }
        });
        this.m_lhsField.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionStepEditorDialog.this.m_expressionTree != null && (p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    Component theEditor;
                    String text = "";
                    if (FlowByExpressionStepEditorDialog.this.m_lhsField.getSelectedItem() != null) {
                        text = FlowByExpressionStepEditorDialog.this.m_lhsField.getSelectedItem().toString();
                    }
                    if ((theEditor = FlowByExpressionStepEditorDialog.this.m_lhsField.getEditor().getEditorComponent()) instanceof JTextField) {
                        text = ((JTextField)theEditor).getText();
                    }
                    ((FlowByExpression.ExpressionClause)thisNode).setLHSAttName(text);
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                }
            }
        });
        this.m_rhsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object text;
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionStepEditorDialog.this.m_expressionTree != null && (p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause && (text = FlowByExpressionStepEditorDialog.this.m_rhsField.getSelectedItem()) != null) {
                    ((FlowByExpression.ExpressionClause)thisNode).setRHSOperand(text.toString());
                    DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                    tmodel.nodeStructureChanged(tNode);
                    FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                }
            }
        });
        this.m_rhsField.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p;
                if (FlowByExpressionStepEditorDialog.this.m_expressionTree != null && (p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    Component theEditor;
                    String text = "";
                    if (FlowByExpressionStepEditorDialog.this.m_rhsField.getSelectedItem() != null) {
                        text = FlowByExpressionStepEditorDialog.this.m_rhsField.getSelectedItem().toString();
                    }
                    if ((theEditor = FlowByExpressionStepEditorDialog.this.m_rhsField.getEditor().getEditorComponent()) instanceof JTextField) {
                        text = ((JTextField)theEditor).getText();
                    }
                    if (FlowByExpressionStepEditorDialog.this.m_rhsField.getSelectedItem() != null) {
                        ((FlowByExpression.ExpressionClause)thisNode).setRHSOperand(text);
                        DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                        tmodel.nodeStructureChanged(tNode);
                        FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                    }
                }
            }
        });
        try {
            Instances incomingStructure = this.getStepToEdit().getStepManager().getIncomingStructureForConnectionType("instance");
            if (incomingStructure == null) {
                incomingStructure = this.getStepToEdit().getStepManager().getIncomingStructureForConnectionType("dataSet");
            }
            if (incomingStructure == null) {
                incomingStructure = this.getStepToEdit().getStepManager().getIncomingStructureForConnectionType("trainingSet");
            }
            if (incomingStructure == null) {
                incomingStructure = this.getStepToEdit().getStepManager().getIncomingStructureForConnectionType("testSet");
            }
            if (incomingStructure != null) {
                this.m_lhsField.removeAllItems();
                this.m_rhsField.removeAllItems();
                for (int i2 = 0; i2 < incomingStructure.numAttributes(); ++i2) {
                    this.m_lhsField.addItem(incomingStructure.attribute(i2).name());
                    this.m_rhsField.addItem(incomingStructure.attribute(i2).name());
                }
            }
        }
        catch (WekaException ex) {
            this.showErrorDialog(ex);
        }
    }

    private void setExpressionEditor(FlowByExpression.ExpressionClause node) {
        String rhs;
        String lhs = node.getLHSAttName();
        if (lhs != null) {
            this.m_lhsField.setSelectedItem(lhs);
        }
        if ((rhs = node.getRHSOperand()) != null) {
            this.m_rhsField.setSelectedItem(rhs);
        }
        FlowByExpression.ExpressionClause.ExpressionType opp = node.getOperator();
        int oppIndex = opp.ordinal();
        this.m_operatorCombo.setSelectedIndex(oppIndex);
        this.m_rhsIsAttribute.setSelected(node.isRHSAnAttribute());
    }

    private void updateExpressionLabel() {
        StringBuffer buff = new StringBuffer();
        FlowByExpression.ExpressionNode root = (FlowByExpression.ExpressionNode)this.m_treeRoot.getUserObject();
        root.toStringDisplay(buff);
        this.m_expressionLab.setText(buff.toString());
    }

    private void setupTree(JPanel holder) {
        JPanel treeHolder = new JPanel();
        treeHolder.setLayout(new BorderLayout());
        treeHolder.setBorder(BorderFactory.createTitledBorder("Expression tree"));
        String expressionString = ((FlowByExpression)this.getStepToEdit()).getExpressionString();
        if (expressionString == null || expressionString.length() == 0) {
            expressionString = "()";
        }
        FlowByExpression.BracketNode root = new FlowByExpression.BracketNode();
        root.parseFromInternal(expressionString);
        root.setShowAndOr(false);
        this.m_treeRoot = root.toJTree(null);
        DefaultTreeModel model = new DefaultTreeModel(this.m_treeRoot);
        this.m_expressionTree = new JTree(model);
        this.m_expressionTree.setEnabled(true);
        this.m_expressionTree.setRootVisible(true);
        this.m_expressionTree.setShowsRootHandles(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.m_expressionTree.setSelectionModel(selectionModel);
        this.m_expressionTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode tNode;
                FlowByExpression.ExpressionNode thisNode;
                TreePath p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath();
                if (p != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (thisNode = (FlowByExpression.ExpressionNode)(tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) instanceof FlowByExpression.ExpressionClause) {
                    FlowByExpressionStepEditorDialog.this.setExpressionEditor((FlowByExpression.ExpressionClause)thisNode);
                }
            }
        });
        this.updateExpressionLabel();
        JScrollPane treeView = new JScrollPane(this.m_expressionTree);
        treeHolder.add((Component)treeView, "Center");
        JPanel butHolder = new JPanel();
        butHolder.add(this.m_addExpressionNode);
        butHolder.add(this.m_addBracketNode);
        butHolder.add(this.m_toggleNegation);
        butHolder.add(this.m_andOr);
        butHolder.add(this.m_deleteNode);
        treeHolder.add((Component)butHolder, "North");
        holder.add((Component)treeHolder, "Center");
        Dimension d = treeHolder.getPreferredSize();
        treeHolder.setPreferredSize(new Dimension(d.width, d.height / 2));
        this.m_andOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        FlowByExpression.ExpressionNode thisNode;
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        thisNode.setIsOr(!(thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject()).isOr());
                        DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                        tmodel.nodeStructureChanged(tNode);
                        FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                    }
                } else {
                    FlowByExpressionStepEditorDialog.this.showInfoDialog("Please select a node in the tree to alter the boolean operator of", "And/Or", false);
                }
            }
        });
        this.m_toggleNegation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        FlowByExpression.ExpressionNode thisNode;
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        thisNode.setNegated(!(thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject()).isNegated());
                        DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                        tmodel.nodeStructureChanged(tNode);
                        FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                    }
                } else {
                    FlowByExpressionStepEditorDialog.this.showInfoDialog("Please select a node in the tree to toggle its negation", "Toggle negation", false);
                }
            }
        });
        this.m_deleteNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        if (tNode == FlowByExpressionStepEditorDialog.this.m_treeRoot) {
                            FlowByExpressionStepEditorDialog.this.showInfoDialog("You can't delete the root of the tree!", "Delete node", true);
                        } else {
                            FlowByExpression.ExpressionNode thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject();
                            FlowByExpression.BracketNode parentNode = (FlowByExpression.BracketNode)((DefaultMutableTreeNode)tNode.getParent()).getUserObject();
                            parentNode.removeChild(thisNode);
                            DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                            tmodel.removeNodeFromParent(tNode);
                            FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                        }
                    }
                } else {
                    FlowByExpressionStepEditorDialog.this.showInfoDialog("Please select a node in the tree to delete.", "Delete node", false);
                }
            }
        });
        this.m_addExpressionNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        FlowByExpression.ExpressionNode thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject();
                        if (thisNode instanceof FlowByExpression.BracketNode) {
                            FlowByExpression.ExpressionClause newNode = new FlowByExpression.ExpressionClause(FlowByExpression.ExpressionClause.ExpressionType.EQUALS, "<att name>", "<value>", false, false);
                            ((FlowByExpression.BracketNode)thisNode).addChild(newNode);
                            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newNode);
                            DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                            tNode.add(childNode);
                            tmodel.nodeStructureChanged(tNode);
                            FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                        } else {
                            FlowByExpressionStepEditorDialog.this.showInfoDialog("An expression can only be added to a bracket node.", "Add expression", false);
                        }
                    }
                } else {
                    FlowByExpressionStepEditorDialog.this.showInfoDialog("You must select a bracket node in the tree view to add a new expression to.", "Add expression", false);
                }
            }
        });
        this.m_addBracketNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath p = FlowByExpressionStepEditorDialog.this.m_expressionTree.getSelectionPath();
                if (p != null) {
                    if (p.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)p.getLastPathComponent();
                        FlowByExpression.ExpressionNode thisNode = (FlowByExpression.ExpressionNode)tNode.getUserObject();
                        if (thisNode instanceof FlowByExpression.BracketNode) {
                            FlowByExpression.BracketNode newNode = new FlowByExpression.BracketNode();
                            ((FlowByExpression.BracketNode)thisNode).addChild(newNode);
                            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newNode);
                            DefaultTreeModel tmodel = (DefaultTreeModel)FlowByExpressionStepEditorDialog.this.m_expressionTree.getModel();
                            tNode.add(childNode);
                            tmodel.nodeStructureChanged(tNode);
                            FlowByExpressionStepEditorDialog.this.updateExpressionLabel();
                        } else {
                            FlowByExpressionStepEditorDialog.this.showInfoDialog("An new bracket node can only be added to an existing bracket node.", "Add bracket", false);
                        }
                    }
                } else {
                    FlowByExpressionStepEditorDialog.this.showInfoDialog("You must select an existing bracket node in the tree in order to add a new bracket node.", "Add bracket", false);
                }
            }
        });
    }

    @Override
    protected void okPressed() {
        if (this.m_treeRoot != null) {
            FlowByExpression.ExpressionNode en = (FlowByExpression.ExpressionNode)this.m_treeRoot.getUserObject();
            StringBuffer buff = new StringBuffer();
            en.toStringInternal(buff);
            ((FlowByExpression)this.getStepToEdit()).setExpressionString(buff.toString());
            if (this.m_trueData.getSelectedItem() != null && this.m_trueData.getSelectedItem().toString().length() > 0) {
                ((FlowByExpression)this.getStepToEdit()).setTrueStepName(this.m_trueData.getSelectedItem().toString());
            }
            if (this.m_falseData.getSelectedItem() != null && this.m_falseData.getSelectedItem().toString().length() > 0) {
                ((FlowByExpression)this.getStepToEdit()).setFalseStepName(this.m_falseData.getSelectedItem().toString());
            }
        }
    }
}

