/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import weka.core.Defaults;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.VisualizeUtils;
import weka.knowledgeflow.steps.ModelPerformanceChart;

public class ModelPerformanceChartInteractiveView
extends BaseInteractiveViewer {
    private static final long serialVersionUID = 8818417648798221980L;
    protected JButton m_clearButton = new JButton("Clear results");
    protected VisualizePanel m_visPanel = new VisualizePanel();
    protected static final String ID = "weka.gui.knowledgeflow.steps.ModelPerformanceChartInteractiveView";

    @Override
    public String getViewerName() {
        return "Model Performance Chart";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.add((Component)this.m_visPanel, "Center");
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelPerformanceChartInteractiveView.this.m_visPanel.removeAllPlots();
                ModelPerformanceChartInteractiveView.this.m_visPanel.validate();
                ModelPerformanceChartInteractiveView.this.m_visPanel.repaint();
                ((ModelPerformanceChart)ModelPerformanceChartInteractiveView.this.getStep()).clearPlotData();
            }
        });
        List<PlotData2D> plotData = ((ModelPerformanceChart)this.getStep()).getPlots();
        try {
            this.m_visPanel.setMasterPlot(plotData.get(0));
            for (int i2 = 1; i2 < plotData.size(); ++i2) {
                this.m_visPanel.addPlot(plotData.get(i2));
            }
            if (((ModelPerformanceChart)this.getStep()).isDataIsThresholdData()) {
                this.m_visPanel.setXIndex(4);
                this.m_visPanel.setYIndex(5);
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        this.m_visPanel.setPreferredSize(new Dimension(800, 600));
        this.applySettings(this.getSettings());
    }

    @Override
    public Defaults getDefaultSettings() {
        VisualizeUtils.VisualizeDefaults d = new VisualizeUtils.VisualizeDefaults();
        d.setID(ID);
        return d;
    }

    @Override
    public void applySettings(Settings settings) {
        this.m_visPanel.applySettings(settings, ID);
    }
}

