/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import weka.gui.InteractiveTableModel;
import weka.gui.InteractiveTablePanel;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.SetVariables;

public class SetVariablesStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = 5747505623497131129L;
    protected VariablesPanel m_vp;
    protected DynamicVariablesPanel m_dvp;

    @Override
    protected void layoutEditor() {
        String internalRep = ((SetVariables)this.getStepToEdit()).getVarsInternalRep();
        String dynamicInternalRep = ((SetVariables)this.getStepToEdit()).getDynamicVarsInternalRep();
        Map<String, String> vars = SetVariables.internalToMap(internalRep);
        Map<String, List<String>> dynamicVars = SetVariables.internalDynamicToMap(dynamicInternalRep);
        this.m_vp = new VariablesPanel(vars);
        this.m_dvp = new DynamicVariablesPanel(dynamicVars);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Static", this.m_vp);
        tabbedPane.add("Dynamic", this.m_dvp);
        this.add((Component)tabbedPane, "Center");
    }

    @Override
    protected void okPressed() {
        String vi = this.m_vp.getVariablesInternal();
        String dvi = this.m_dvp.getVariablesInternal();
        ((SetVariables)this.getStepToEdit()).setVarsInternalRep(this.m_vp.getVariablesInternal());
        ((SetVariables)this.getStepToEdit()).setDynamicVarsInternalRep(this.m_dvp.getVariablesInternal());
    }

    protected static class VariablesPanel
    extends JPanel {
        private static final long serialVersionUID = 5188290550108775006L;
        protected InteractiveTablePanel m_table = new InteractiveTablePanel(new String[]{"Variable name", "Value", ""});

        public VariablesPanel(Map<String, String> vars) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder("Static variables to set"));
            this.add((Component)this.m_table, "Center");
            int row = 0;
            JTable table = this.m_table.getTable();
            for (Map.Entry<String, String> e : vars.entrySet()) {
                String varName = e.getKey();
                String varVal = e.getValue();
                if (varVal == null || varVal.length() <= 0) continue;
                table.getModel().setValueAt(varName, row, 0);
                table.getModel().setValueAt(varVal, row, 1);
                ((InteractiveTableModel)table.getModel()).addEmptyRow();
                ++row;
            }
        }

        public String getVariablesInternal() {
            StringBuilder b = new StringBuilder();
            JTable table = this.m_table.getTable();
            int numRows = table.getModel().getRowCount();
            for (int i2 = 0; i2 < numRows; ++i2) {
                String paramName = table.getValueAt(i2, 0).toString();
                String paramValue = table.getValueAt(i2, 1).toString();
                if (paramName.length() > 0 && paramValue.length() > 0) {
                    b.append(paramName).append("@v@v").append(paramValue);
                }
                if (i2 >= numRows - 1) continue;
                b.append("@@vv@@");
            }
            return b.toString();
        }
    }

    protected static class DynamicVariablesPanel
    extends JPanel {
        private static final long serialVersionUID = -280047347103350039L;
        protected InteractiveTablePanel m_table = new InteractiveTablePanel(new String[]{"Attribute name/index", "Variable name", "Default value", ""});

        public DynamicVariablesPanel(Map<String, List<String>> vars) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder("Variables to set from incoming instances"));
            this.add((Component)this.m_table, "Center");
            int row = 0;
            JTable table = this.m_table.getTable();
            for (Map.Entry<String, List<String>> e : vars.entrySet()) {
                String attName = e.getKey();
                String varName = e.getValue().get(0);
                String defaultVal = e.getValue().get(1);
                if (attName == null || attName.length() <= 0 || varName == null || varName.length() <= 0) continue;
                table.getModel().setValueAt(attName, row, 0);
                table.getModel().setValueAt(varName, row, 1);
                table.getModel().setValueAt(defaultVal, row, 2);
                ((InteractiveTableModel)table.getModel()).addEmptyRow();
                ++row;
            }
        }

        public String getVariablesInternal() {
            StringBuilder b = new StringBuilder();
            JTable table = this.m_table.getTable();
            int numRows = table.getModel().getRowCount();
            for (int i2 = 0; i2 < numRows; ++i2) {
                String attName = table.getValueAt(i2, 0).toString();
                String varName = table.getValueAt(i2, 1).toString();
                String defVal = table.getValueAt(i2, 2).toString();
                if (attName.trim().length() > 0 && varName.trim().length() > 0) {
                    if (defVal.length() == 0) {
                        defVal = " ";
                    }
                    b.append(attName).append("@a@a").append(varName).append("@v@v").append(defVal);
                }
                if (i2 >= numRows - 1) continue;
                b.append("@@vv@@");
            }
            return b.toString();
        }
    }
}

