/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.JListHelper;
import weka.gui.PropertySheetPanel;
import weka.gui.knowledgeflow.GOEStepEditorDialog;
import weka.knowledgeflow.steps.Sorter;
import weka.knowledgeflow.steps.Step;

public class SorterStepEditorDialog
extends GOEStepEditorDialog {
    private static final long serialVersionUID = -1258170590422372948L;
    protected JComboBox<String> m_attCombo = new JComboBox();
    protected JComboBox<String> m_descending = new JComboBox();
    protected JList<Sorter.SortRule> m_list = new JList();
    protected DefaultListModel<Sorter.SortRule> m_listModel;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JButton m_upBut = new JButton("Move up");
    protected JButton m_downBut = new JButton("Move down");

    @Override
    protected void setStepToEdit(Step step) {
        this.copyOriginal(step);
        this.createAboutPanel(step);
        this.m_editor = new PropertySheetPanel(false);
        this.m_editor.setUseEnvironmentPropertyEditors(true);
        this.m_editor.setEnvironment(this.m_env);
        this.m_editor.setTarget(this.m_stepToEdit);
        this.m_primaryEditorHolder.setLayout(new BorderLayout());
        this.m_primaryEditorHolder.add((Component)this.m_editor, "Center");
        this.m_editorHolder.setLayout(new BorderLayout());
        this.m_editorHolder.add((Component)this.m_primaryEditorHolder, "North");
        this.m_editorHolder.add((Component)this.createSorterPanel(), "Center");
        this.add((Component)this.m_editorHolder, "Center");
        String sString = ((Sorter)this.getStepToEdit()).getSortDetails();
        this.m_listModel = new DefaultListModel();
        this.m_list.setModel(this.m_listModel);
        if (sString != null && sString.length() > 0) {
            String[] parts = sString.split("@@sort-rule@@");
            if (parts.length > 0) {
                this.m_upBut.setEnabled(true);
                this.m_downBut.setEnabled(true);
                for (String sPart : parts) {
                    Sorter.SortRule s = new Sorter.SortRule(sPart);
                    this.m_listModel.addElement(s);
                }
            }
            this.m_list.repaint();
        }
        if (((Sorter)this.getStepToEdit()).getStepManager().numIncomingConnections() > 0) {
            String incomingConnName = ((Sorter)this.getStepToEdit()).getStepManager().getIncomingConnections().keySet().iterator().next();
            try {
                Instances connectedFormat = ((Sorter)this.getStepToEdit()).getStepManager().getIncomingStructureForConnectionType(incomingConnName);
                if (connectedFormat != null) {
                    for (int i2 = 0; i2 < connectedFormat.numAttributes(); ++i2) {
                        this.m_attCombo.addItem(connectedFormat.attribute(i2).name());
                    }
                }
            }
            catch (WekaException ex) {
                this.showErrorDialog(ex);
            }
        }
    }

    protected JPanel createSorterPanel() {
        JPanel sorterPanel = new JPanel(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        fieldHolder.setLayout(new GridLayout(0, 2));
        JPanel attListP = new JPanel();
        attListP.setLayout(new BorderLayout());
        attListP.setBorder(BorderFactory.createTitledBorder("Sort on attribute"));
        attListP.add(this.m_attCombo, "Center");
        this.m_attCombo.setEditable(true);
        this.m_attCombo.setToolTipText("<html>Accepts an attribute name, index or <br> the special string \"/first\" and \"/last\"</html>");
        this.m_descending.addItem("No");
        this.m_descending.addItem("Yes");
        JPanel descendingP = new JPanel();
        descendingP.setLayout(new BorderLayout());
        descendingP.setBorder(BorderFactory.createTitledBorder("Sort descending"));
        descendingP.add(this.m_descending, "Center");
        fieldHolder.add(attListP);
        fieldHolder.add(descendingP);
        sorterPanel.add((Component)fieldHolder, "North");
        this.m_list.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 0));
        butHolder.add(this.m_newBut);
        butHolder.add(this.m_deleteBut);
        butHolder.add(this.m_upBut);
        butHolder.add(this.m_downBut);
        this.m_upBut.setEnabled(false);
        this.m_downBut.setEnabled(false);
        listPanel.add((Component)butHolder, "North");
        JScrollPane js = new JScrollPane(this.m_list);
        js.setBorder(BorderFactory.createTitledBorder("Sort-by list (rows applied in order)"));
        listPanel.add((Component)js, "Center");
        sorterPanel.add((Component)listPanel, "Center");
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Sorter.SortRule entry;
                    if (!SorterStepEditorDialog.this.m_deleteBut.isEnabled()) {
                        SorterStepEditorDialog.this.m_deleteBut.setEnabled(true);
                    }
                    if ((entry = SorterStepEditorDialog.this.m_list.getSelectedValue()) != null) {
                        Sorter.SortRule m = entry;
                        SorterStepEditorDialog.this.m_attCombo.setSelectedItem(m.getAttribute());
                        if (m.getDescending()) {
                            SorterStepEditorDialog.this.m_descending.setSelectedIndex(1);
                        } else {
                            SorterStepEditorDialog.this.m_descending.setSelectedIndex(0);
                        }
                    }
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sorter.SortRule m = new Sorter.SortRule();
                String att = SorterStepEditorDialog.this.m_attCombo.getSelectedItem() != null ? SorterStepEditorDialog.this.m_attCombo.getSelectedItem().toString() : "";
                m.setAttribute(att);
                m.setDescending(SorterStepEditorDialog.this.m_descending.getSelectedIndex() == 1);
                SorterStepEditorDialog.this.m_listModel.addElement(m);
                if (SorterStepEditorDialog.this.m_listModel.size() > 1) {
                    SorterStepEditorDialog.this.m_upBut.setEnabled(true);
                    SorterStepEditorDialog.this.m_downBut.setEnabled(true);
                }
                SorterStepEditorDialog.this.m_list.setSelectedIndex(SorterStepEditorDialog.this.m_listModel.size() - 1);
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = SorterStepEditorDialog.this.m_list.getSelectedIndex();
                if (selected >= 0) {
                    SorterStepEditorDialog.this.m_listModel.removeElementAt(selected);
                    if (SorterStepEditorDialog.this.m_listModel.size() <= 1) {
                        SorterStepEditorDialog.this.m_upBut.setEnabled(false);
                        SorterStepEditorDialog.this.m_downBut.setEnabled(false);
                    }
                }
            }
        });
        this.m_upBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(SorterStepEditorDialog.this.m_list);
            }
        });
        this.m_downBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(SorterStepEditorDialog.this.m_list);
            }
        });
        this.m_attCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Component theEditor;
                Sorter.SortRule m = SorterStepEditorDialog.this.m_list.getSelectedValue();
                String text = "";
                if (SorterStepEditorDialog.this.m_attCombo.getSelectedItem() != null) {
                    text = SorterStepEditorDialog.this.m_attCombo.getSelectedItem().toString();
                }
                if ((theEditor = SorterStepEditorDialog.this.m_attCombo.getEditor().getEditorComponent()) instanceof JTextField) {
                    text = ((JTextField)theEditor).getText();
                }
                if (m != null) {
                    m.setAttribute(text);
                    SorterStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_attCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sorter.SortRule m = SorterStepEditorDialog.this.m_list.getSelectedValue();
                Object selected = SorterStepEditorDialog.this.m_attCombo.getSelectedItem();
                if (m != null && selected != null) {
                    m.setAttribute(selected.toString());
                    SorterStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_descending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sorter.SortRule m = SorterStepEditorDialog.this.m_list.getSelectedValue();
                if (m != null) {
                    m.setDescending(SorterStepEditorDialog.this.m_descending.getSelectedIndex() == 1);
                    SorterStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        return sorterPanel;
    }

    @Override
    public void okPressed() {
        StringBuilder buff = new StringBuilder();
        for (int i2 = 0; i2 < this.m_listModel.size(); ++i2) {
            Sorter.SortRule m = this.m_listModel.elementAt(i2);
            buff.append(m.toStringInternal());
            if (i2 >= this.m_listModel.size() - 1) continue;
            buff.append("@@sort-rule@@");
        }
        ((Sorter)this.getStepToEdit()).setSortDetails(buff.toString());
    }
}

