/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import weka.core.Utils;
import weka.gui.ComponentHelper;
import weka.gui.DocumentPrinting;
import weka.gui.ExtensionFileFilter;
import weka.gui.PropertyDialog;
import weka.gui.scripting.Script;
import weka.gui.scripting.ScriptingPanel;
import weka.gui.scripting.event.ScriptExecutionEvent;
import weka.gui.scripting.event.ScriptExecutionListener;
import weka.gui.scripting.event.TitleUpdatedEvent;

public abstract class FileScriptingPanel
extends ScriptingPanel
implements ScriptExecutionListener {
    private static final long serialVersionUID = 1583670545010241816L;
    public static final String IMAGES_DIR = "weka/gui/scripting/images";
    protected JFileChooser m_FileChooser;
    protected Script m_Script;
    protected JTextArea m_ScriptArea;
    protected JTextArea m_OutputArea;
    protected JLabel m_LabelInfo;
    protected HashMap<Object, Action> m_Actions;
    protected NewAction m_NewAction;
    protected OpenAction m_OpenAction;
    protected SaveAction m_SaveAction;
    protected SaveAction m_SaveAsAction;
    protected PrintAction m_PrintAction;
    protected ClearOutputAction m_ClearOutputAction;
    protected ExitAction m_ExitAction;
    protected UndoAction m_UndoAction;
    protected RedoAction m_RedoAction;
    protected Action m_CutAction;
    protected Action m_CopyAction;
    protected Action m_PasteAction;
    protected StartAction m_StartAction;
    protected StopAction m_StopAction;
    protected CommandlineArgsAction m_ArgsAction;
    protected AboutAction m_AboutAction;
    protected UndoManager m_Undo;
    protected JTextPane m_TextCode;
    protected JTextPane m_TextOutput;
    protected String[] m_Args;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new JFileChooser();
        this.m_FileChooser.setAcceptAllFileFilterUsed(true);
        this.m_FileChooser.setMultiSelectionEnabled(false);
        this.m_Undo = new UndoManager();
        this.m_Args = new String[0];
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout(0, 5));
        this.m_TextCode = this.newCodePane();
        this.m_TextCode.setFont(new Font("monospaced", 0, 12));
        this.m_TextCode.getDocument().addUndoableEditListener(new ScriptUndoableEditListener());
        this.m_TextCode.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            protected void update() {
                Document doc = FileScriptingPanel.this.m_TextCode.getDocument();
                FileScriptingPanel.this.m_StartAction.setEnabled(doc.getLength() > 0 && FileScriptingPanel.this.m_Script.canExecuteScripts());
                FileScriptingPanel.this.m_SaveAction.setEnabled(true);
                FileScriptingPanel.this.notifyTitleUpdatedListeners(new TitleUpdatedEvent(FileScriptingPanel.this));
            }
        });
        this.add((Component)new JScrollPane(this.m_TextCode), "Center");
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setPreferredSize(new Dimension(50, 200));
        this.add((Component)panel, "South");
        this.m_TextOutput = new JTextPane();
        panel.add((Component)new JScrollPane(this.m_TextOutput), "Center");
        this.m_LabelInfo = new JLabel(" ");
        this.m_LabelInfo.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)this.m_LabelInfo, "South");
    }

    @Override
    protected void initFinish() {
        super.initFinish();
        this.m_Script = this.newScript(this.m_TextCode.getDocument());
        this.m_Script.addScriptFinishedListener(this);
        ExtensionFileFilter[] filters = this.m_Script.getFilters();
        for (int i2 = filters.length - 1; i2 >= 0; --i2) {
            this.m_FileChooser.addChoosableFileFilter(filters[i2]);
        }
        this.m_Actions = this.createActionTable(this.m_TextCode);
        this.m_NewAction = new NewAction();
        this.m_OpenAction = new OpenAction();
        this.m_SaveAction = new SaveAction("Save", false);
        this.m_SaveAsAction = new SaveAction("Save As...", true);
        this.m_PrintAction = new PrintAction();
        this.m_ClearOutputAction = new ClearOutputAction();
        this.m_ExitAction = new ExitAction();
        this.m_UndoAction = new UndoAction();
        this.m_RedoAction = new RedoAction();
        this.m_CutAction = this.updateAction(this.m_Actions.get("cut-to-clipboard"), "Cut", "cut.gif", "ctrl X", Character.valueOf('C'));
        this.m_CopyAction = this.updateAction(this.m_Actions.get("copy-to-clipboard"), "Copy", "copy.gif", "ctrl C", Character.valueOf('o'));
        this.m_PasteAction = this.updateAction(this.m_Actions.get("paste-from-clipboard"), "Paste", "paste.gif", "ctrl V", Character.valueOf('P'));
        this.m_StartAction = new StartAction();
        this.m_StopAction = new StopAction();
        this.m_ArgsAction = new CommandlineArgsAction();
        this.m_AboutAction = new AboutAction();
    }

    protected Action updateAction(Action action, String name, String icon, String accel, Character mnemonic) {
        if (action == null) {
            Action result = this.m_Actions.get(name);
            return result;
        }
        Action result = action;
        if (name != null && name.length() > 0) {
            result.putValue("Name", name);
        }
        if (icon != null && icon.length() > 0) {
            result.putValue("SmallIcon", ComponentHelper.getImageIcon(icon));
        }
        if (accel != null && accel.length() > 0) {
            result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel));
        }
        if (mnemonic != null) {
            result.putValue("MnemonicKey", new Integer(mnemonic.charValue()));
        }
        return result;
    }

    protected abstract JTextPane newCodePane();

    protected abstract Script newScript(Document var1);

    @Override
    public void scriptFinished(ScriptExecutionEvent e) {
        if (e.getType() == ScriptExecutionEvent.Type.FINISHED) {
            this.showInfo("Script execution finished");
        } else if (e.getType() == ScriptExecutionEvent.Type.STOPPED) {
            this.showInfo("Script execution stopped by user");
        } else if (e.getType() == ScriptExecutionEvent.Type.ERROR) {
            this.showInfo("Script execution failed" + (e.hasAdditional() ? ": " + e.getAdditional() : ""));
        }
        if (e.getType() != ScriptExecutionEvent.Type.STARTED) {
            this.m_NewAction.setEnabled(true);
            this.m_OpenAction.setEnabled(true);
            this.m_SaveAction.setEnabled(true);
            this.m_SaveAsAction.setEnabled(true);
            this.m_CutAction.setEnabled(true);
            this.m_CopyAction.setEnabled(true);
            this.m_PasteAction.setEnabled(true);
            this.m_StartAction.setEnabled(true);
            this.m_StopAction.setEnabled(false);
        } else {
            this.m_NewAction.setEnabled(false);
            this.m_OpenAction.setEnabled(false);
            this.m_SaveAction.setEnabled(false);
            this.m_SaveAsAction.setEnabled(false);
            this.m_CutAction.setEnabled(false);
            this.m_CopyAction.setEnabled(false);
            this.m_PasteAction.setEnabled(false);
            this.m_StartAction.setEnabled(false);
            this.m_StopAction.setEnabled(true);
        }
    }

    protected HashMap<Object, Action> createActionTable(JTextComponent comp) {
        HashMap<Object, Action> result = new HashMap<Object, Action>();
        Action[] actions2 = comp.getActions();
        for (int i2 = 0; i2 < actions2.length; ++i2) {
            Action action = actions2[i2];
            result.put(action.getValue("Name"), action);
        }
        return result;
    }

    protected abstract JPanel getAboutPanel();

    public abstract String getPlainTitle();

    @Override
    public String getTitle() {
        String result = this.getPlainTitle();
        if (this.m_Script.isModified()) {
            result = "*" + result;
        }
        if (this.m_Script.getFilename() != null) {
            result = result + " [" + this.m_Script.getFilename() + "]";
        }
        return result;
    }

    @Override
    public JTextPane getOutput() {
        return this.m_TextOutput;
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        result.add(menu);
        JMenuItem menuitem = new JMenuItem(this.m_NewAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_OpenAction);
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_SaveAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_SaveAsAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_PrintAction);
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ClearOutputAction);
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ExitAction);
        menu.addSeparator();
        menu.add(menuitem);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        result.add(menu);
        menuitem = new JMenuItem(this.m_UndoAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_RedoAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_CutAction);
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_CopyAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_PasteAction);
        menu.add(menuitem);
        menu = new JMenu("Script");
        menu.setMnemonic('S');
        result.add(menu);
        menuitem = new JMenuItem(this.m_StartAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_StopAction);
        menu.add(menuitem);
        menuitem = new JMenuItem(this.m_ArgsAction);
        menu.add(menuitem);
        menu = new JMenu("Help");
        menu.setMnemonic('H');
        result.add(menu);
        menuitem = new JMenuItem(this.m_AboutAction);
        menu.add(menuitem);
        return result;
    }

    protected void showInfo(String msg) {
        if (msg == null) {
            msg = " ";
        }
        this.m_LabelInfo.setText(msg);
    }

    public void open(File file) {
        this.m_Script.open(file);
    }

    protected boolean checkModified() {
        boolean result = true;
        if (this.m_Script.isModified()) {
            int retVal = JOptionPane.showConfirmDialog(this, "Script not saved - save it now?", "Confirm", 1);
            if (retVal == 0) {
                if (this.m_Script.getFilename() != null) {
                    this.m_Script.save();
                } else {
                    this.m_SaveAsAction.actionPerformed(null);
                }
                result = !this.m_Script.isModified();
            } else if (retVal == 2) {
                result = false;
            }
        }
        return result;
    }

    protected class ScriptUndoableEditListener
    implements UndoableEditListener {
        protected ScriptUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            FileScriptingPanel.this.m_Undo.addEdit(e.getEdit());
            FileScriptingPanel.this.m_UndoAction.updateUndoState();
            FileScriptingPanel.this.m_RedoAction.updateRedoState();
        }
    }

    protected class AboutAction
    extends BasicAction {
        private static final long serialVersionUID = -6420463480569171227L;

        public AboutAction() {
            super("About...", "", "F1", Character.valueOf('A'));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog dialog = PropertyDialog.getParentDialog(FileScriptingPanel.this) != null ? new JDialog(PropertyDialog.getParentDialog(FileScriptingPanel.this), FileScriptingPanel.this.getName()) : new JDialog(PropertyDialog.getParentFrame(FileScriptingPanel.this), FileScriptingPanel.this.getName());
            dialog.setTitle((String)this.getValue("Name"));
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add(FileScriptingPanel.this.getAboutPanel());
            dialog.pack();
            dialog.setLocationRelativeTo(FileScriptingPanel.this);
            dialog.setVisible(true);
        }
    }

    protected class StopAction
    extends BasicAction {
        private static final long serialVersionUID = 8764023289575718872L;

        public StopAction() {
            super("Stop", "stop.gif", "ctrl shift R", Character.valueOf('o'));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FileScriptingPanel.this.m_Script.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class StartAction
    extends BasicAction {
        private static final long serialVersionUID = -7936456072955996220L;

        public StartAction() {
            super(FileScriptingPanel.this.m_Script.canExecuteScripts() ? "Start" : "Start (missing classes?)", "run.gif", "ctrl R", Character.valueOf('S'));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FileScriptingPanel.this.checkModified()) {
                return;
            }
            if (FileScriptingPanel.this.m_Script.getFilename() == null) {
                return;
            }
            try {
                FileScriptingPanel.this.m_Script.start(FileScriptingPanel.this.m_Args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(FileScriptingPanel.this, "Error running script:\n" + ex, "Error", 0);
            }
        }
    }

    protected class CommandlineArgsAction
    extends BasicAction {
        private static final long serialVersionUID = -3183470039010826204L;

        public CommandlineArgsAction() {
            super("Arguments...", "properties.gif", "", Character.valueOf('g'));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String retVal = JOptionPane.showInputDialog(FileScriptingPanel.this, "Please enter the command-line arguments", Utils.joinOptions(FileScriptingPanel.this.m_Args));
            if (retVal == null) {
                return;
            }
            try {
                FileScriptingPanel.this.m_Args = Utils.splitOptions(retVal);
            }
            catch (Exception ex) {
                FileScriptingPanel.this.m_Args = new String[0];
                ex.printStackTrace();
                JOptionPane.showMessageDialog(FileScriptingPanel.this, "Error setting command-line arguments:\n" + ex, "Error", 0);
            }
        }
    }

    protected class RedoAction
    extends BasicAction {
        private static final long serialVersionUID = 4533966901523279350L;

        public RedoAction() {
            super("Redo", "redo.gif", "ctrl Y", Character.valueOf('R'));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FileScriptingPanel.this.m_Undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.updateRedoState();
            FileScriptingPanel.this.m_UndoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (FileScriptingPanel.this.m_Undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", FileScriptingPanel.this.m_Undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    protected class UndoAction
    extends BasicAction {
        private static final long serialVersionUID = 4298096648424808522L;

        public UndoAction() {
            super("Undo", "undo.gif", "ctrl Z", Character.valueOf('U'));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FileScriptingPanel.this.m_Undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.updateUndoState();
            FileScriptingPanel.this.m_RedoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (FileScriptingPanel.this.m_Undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", FileScriptingPanel.this.m_Undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    protected class ExitAction
    extends BasicAction {
        private static final long serialVersionUID = -5884709836238884180L;

        public ExitAction() {
            super("Exit", "", "", Character.valueOf('x'));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FileScriptingPanel.this.checkModified()) {
                return;
            }
            if (PropertyDialog.getParentDialog(FileScriptingPanel.this) != null) {
                Dialog dialog = PropertyDialog.getParentDialog(FileScriptingPanel.this);
                dialog.setVisible(false);
            } else if (PropertyDialog.getParentFrame(FileScriptingPanel.this) != null) {
                JInternalFrame jintframe = PropertyDialog.getParentInternalFrame(FileScriptingPanel.this);
                if (jintframe != null) {
                    jintframe.doDefaultCloseAction();
                } else {
                    Frame frame = PropertyDialog.getParentFrame(FileScriptingPanel.this);
                    if (frame instanceof JFrame) {
                        JFrame jframe = (JFrame)frame;
                        if (jframe.getDefaultCloseOperation() == 1) {
                            jframe.setVisible(false);
                        } else if (jframe.getDefaultCloseOperation() == 2) {
                            jframe.dispose();
                        } else if (jframe.getDefaultCloseOperation() == 3) {
                            System.exit(0);
                        }
                        WindowListener[] listeners = jframe.getWindowListeners();
                        WindowEvent event = new WindowEvent(jframe, 202);
                        for (int i2 = 0; i2 < listeners.length; ++i2) {
                            listeners[i2].windowClosed(event);
                        }
                    } else {
                        frame.dispose();
                    }
                }
            }
        }
    }

    protected class ClearOutputAction
    extends BasicAction {
        private static final long serialVersionUID = 47986890456997211L;

        public ClearOutputAction() {
            super("Clear output", "", "F2", Character.valueOf('C'));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileScriptingPanel.this.m_TextOutput.setText("");
        }
    }

    protected class PrintAction
    extends BasicAction {
        private static final long serialVersionUID = -6246539539545724632L;

        public PrintAction() {
            super("Print...", "print.gif", "ctrl P", Character.valueOf('P'));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane pane = FileScriptingPanel.this.newCodePane();
            pane.setText(FileScriptingPanel.this.m_TextCode.getText());
            DocumentPrinting doc = new DocumentPrinting();
            doc.print(pane);
        }
    }

    protected class SaveAction
    extends BasicAction {
        private static final long serialVersionUID = -74651145892063975L;
        protected boolean m_ShowDialog;

        public SaveAction(String name, boolean showDialog) {
            super(name, showDialog ? "" : "save.gif", showDialog ? "ctrl shift S" : "ctrl S", Character.valueOf(showDialog ? (char)'a' : 'S'));
            this.m_ShowDialog = showDialog;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean ok;
            if (this.m_ShowDialog || FileScriptingPanel.this.m_Script.getFilename() == null) {
                int retVal = FileScriptingPanel.this.m_FileChooser.showSaveDialog(FileScriptingPanel.this);
                if (retVal != 0) {
                    return;
                }
                ok = FileScriptingPanel.this.m_Script.saveAs(FileScriptingPanel.this.m_FileChooser.getSelectedFile());
            } else {
                ok = FileScriptingPanel.this.m_Script.save();
            }
            if (!ok) {
                if (FileScriptingPanel.this.m_Script.getFilename() != null) {
                    JOptionPane.showMessageDialog(FileScriptingPanel.this, "Failed to save file '" + FileScriptingPanel.this.m_FileChooser.getSelectedFile() + "'!");
                } else {
                    JOptionPane.showMessageDialog(FileScriptingPanel.this, "Failed to save file!");
                }
            } else {
                FileScriptingPanel.this.m_SaveAction.setEnabled(false);
            }
            FileScriptingPanel.this.notifyTitleUpdatedListeners(new TitleUpdatedEvent(FileScriptingPanel.this));
        }
    }

    protected class OpenAction
    extends BasicAction {
        private static final long serialVersionUID = -4496148485267789162L;

        public OpenAction() {
            super("Open...", "open.gif", "ctrl O", Character.valueOf('O'));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FileScriptingPanel.this.checkModified()) {
                return;
            }
            int retVal = FileScriptingPanel.this.m_FileChooser.showOpenDialog(FileScriptingPanel.this);
            if (retVal != 0) {
                return;
            }
            boolean ok = FileScriptingPanel.this.m_Script.open(FileScriptingPanel.this.m_FileChooser.getSelectedFile());
            FileScriptingPanel.this.m_TextCode.setCaretPosition(0);
            if (!ok) {
                JOptionPane.showMessageDialog(FileScriptingPanel.this, "Couldn't open file '" + FileScriptingPanel.this.m_FileChooser.getSelectedFile() + "'!");
            }
            FileScriptingPanel.this.notifyTitleUpdatedListeners(new TitleUpdatedEvent(FileScriptingPanel.this));
        }
    }

    protected class NewAction
    extends BasicAction {
        private static final long serialVersionUID = -8665722554539726090L;

        public NewAction() {
            super("New", "new.gif", "ctrl N", Character.valueOf('N'));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileScriptingPanel.this.m_Script.empty();
            FileScriptingPanel.this.notifyTitleUpdatedListeners(new TitleUpdatedEvent(FileScriptingPanel.this));
        }
    }

    public abstract class BasicAction
    extends AbstractAction {
        private static final long serialVersionUID = 2821117985661550385L;

        public BasicAction(String name, String icon, String accel, Character mnemonic) {
            super(name);
            if (icon != null && icon.length() > 0) {
                this.putValue("SmallIcon", ComponentHelper.getImageIcon(icon));
            }
            if (accel != null && accel.length() > 0) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel));
            }
            if (mnemonic != null) {
                this.putValue("MnemonicKey", new Integer(mnemonic.charValue()));
            }
        }
    }
}

