/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import weka.gui.ListSelectorDialog;
import weka.gui.sql.DbUtils;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;
import weka.gui.sql.event.HistoryChangedEvent;
import weka.gui.sql.event.HistoryChangedListener;
import weka.gui.sql.event.QueryExecuteEvent;
import weka.gui.sql.event.QueryExecuteListener;

public class QueryPanel
extends JPanel
implements ConnectionListener,
CaretListener {
    private static final long serialVersionUID = 4348967824619706636L;
    public static final String HISTORY_NAME = "query";
    public static final String MAX_ROWS = "max_rows";
    protected JFrame m_Parent;
    protected JTextArea m_TextQuery;
    protected JButton m_ButtonExecute = new JButton("Execute");
    protected JButton m_ButtonClear = new JButton("Clear");
    protected JButton m_ButtonHistory = new JButton("History...");
    protected JSpinner m_SpinnerMaxRows = new JSpinner();
    protected HashSet<QueryExecuteListener> m_QueryExecuteListeners;
    protected HashSet<HistoryChangedListener> m_HistoryChangedListeners;
    protected DbUtils m_DbUtils;
    protected boolean m_Connected;
    protected DefaultListModel m_History = new DefaultListModel();

    public QueryPanel(JFrame parent) {
        this.m_Parent = parent;
        this.m_QueryExecuteListeners = new HashSet();
        this.m_HistoryChangedListeners = new HashSet();
        this.m_DbUtils = null;
        this.m_Connected = false;
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.m_TextQuery = new JTextArea();
        this.m_TextQuery.addCaretListener(this);
        this.m_TextQuery.setFont(new Font("Monospaced", 0, this.m_TextQuery.getFont().getSize()));
        this.add((Component)new JScrollPane(this.m_TextQuery), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "East");
        this.m_ButtonExecute.setMnemonic('E');
        this.m_ButtonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPanel.this.execute();
            }
        });
        panel.add((Component)this.m_ButtonExecute, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel2, "Center");
        this.m_ButtonClear.setMnemonic('r');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPanel.this.clear();
            }
        });
        panel2.add((Component)this.m_ButtonClear, "North");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel2.add((Component)panel3, "Center");
        this.m_ButtonHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPanel.this.showHistory();
            }
        });
        panel3.add((Component)this.m_ButtonHistory, "North");
        panel3 = new JPanel(new FlowLayout());
        panel3.add(new JLabel("max. rows"));
        panel3.add(this.m_SpinnerMaxRows);
        panel2.add((Component)panel3, "South");
        SpinnerNumberModel model = (SpinnerNumberModel)this.m_SpinnerMaxRows.getModel();
        model.setMaximum(new Integer(Integer.MAX_VALUE));
        model.setMinimum(new Integer(0));
        model.setValue(new Integer(100));
        model.setStepSize(new Integer(100));
        this.m_SpinnerMaxRows.setMinimumSize(new Dimension(50, this.m_SpinnerMaxRows.getHeight()));
        this.m_SpinnerMaxRows.setToolTipText("with 0 all rows are retrieved");
        this.setButtons();
    }

    public void setFocus() {
        this.m_TextQuery.requestFocus();
    }

    protected void setButtons() {
        boolean isEmpty = this.m_TextQuery.getText().trim().equals("");
        this.m_ButtonExecute.setEnabled(this.m_Connected && !isEmpty);
        this.m_ButtonClear.setEnabled(!isEmpty);
        this.m_ButtonHistory.setEnabled(this.m_History.size() > 0);
    }

    @Override
    public void connectionChange(ConnectionEvent evt) {
        this.m_Connected = evt.isConnected();
        this.m_DbUtils = evt.getDbUtils();
        this.setButtons();
    }

    public void execute() {
        if (!this.m_ButtonExecute.isEnabled()) {
            return;
        }
        if (this.m_TextQuery.getText().trim().equals("")) {
            return;
        }
        try {
            if (this.m_DbUtils.getResultSet() != null) {
                this.m_DbUtils.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Exception ex = null;
        ResultSet rs = null;
        try {
            if (this.m_DbUtils.execute(this.getQuery())) {
                rs = this.m_DbUtils.getResultSet();
                this.addHistory(this.getQuery());
            }
        }
        catch (Exception e) {
            ex = new Exception(e.getMessage());
        }
        this.notifyQueryExecuteListeners(rs, ex);
        this.setButtons();
    }

    public void clear() {
        this.m_TextQuery.setText("");
        this.m_SpinnerMaxRows.setValue(new Integer(100));
    }

    protected void addHistory(String s) {
        if (s.equals("")) {
            return;
        }
        if (this.m_History.contains(s)) {
            this.m_History.removeElement(s);
        }
        this.m_History.add(0, s);
        this.notifyHistoryChangedListeners();
    }

    public void setHistory(DefaultListModel history) {
        this.m_History.clear();
        for (int i2 = 0; i2 < history.size(); ++i2) {
            this.m_History.addElement(history.get(i2));
        }
        this.setButtons();
    }

    public DefaultListModel getHistory() {
        return this.m_History;
    }

    public void showHistory() {
        JList list = new JList(this.m_History);
        ListSelectorDialog dialog = new ListSelectorDialog((Frame)this.m_Parent, list);
        if (dialog.showDialog() == 0 && list.getSelectedValue() != null) {
            this.setQuery(list.getSelectedValue().toString());
        }
        this.setButtons();
    }

    public void setQuery(String query) {
        this.m_TextQuery.setText(query);
    }

    public String getQuery() {
        return this.m_TextQuery.getText();
    }

    public void setMaxRows(int rows) {
        if (rows >= 0) {
            this.m_SpinnerMaxRows.setValue(new Integer(rows));
        }
    }

    public int getMaxRows() {
        return (Integer)this.m_SpinnerMaxRows.getValue();
    }

    public void addQueryExecuteListener(QueryExecuteListener l) {
        this.m_QueryExecuteListeners.add(l);
    }

    public void removeQueryExecuteListener(QueryExecuteListener l) {
        this.m_QueryExecuteListeners.remove(l);
    }

    protected void notifyQueryExecuteListeners(ResultSet rs, Exception ex) {
        for (QueryExecuteListener l : this.m_QueryExecuteListeners) {
            l.queryExecuted(new QueryExecuteEvent(this, this.m_DbUtils, this.getQuery(), this.getMaxRows(), rs, ex));
        }
    }

    public void addHistoryChangedListener(HistoryChangedListener l) {
        this.m_HistoryChangedListeners.add(l);
    }

    public void removeHistoryChangedListener(HistoryChangedListener l) {
        this.m_HistoryChangedListeners.remove(l);
    }

    protected void notifyHistoryChangedListeners() {
        for (HistoryChangedListener l : this.m_HistoryChangedListeners) {
            l.historyChanged(new HistoryChangedEvent(this, HISTORY_NAME, this.getHistory()));
        }
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        this.setButtons();
    }
}

