/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;
import weka.gui.treevisualizer.Colors;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.NamedColor;
import weka.gui.treevisualizer.Node;

public class TreeBuild {
    private Vector<Node> m_aNodes;
    private Vector<Edge> m_aEdges;
    private Vector<InfoObject> m_nodes;
    private Vector<InfoObject> m_edges;
    private InfoObject m_grObj;
    private InfoObject m_noObj;
    private InfoObject m_edObj;
    private StreamTokenizer m_st;
    private final Hashtable<String, Color> m_colorTable = new Hashtable();

    public TreeBuild() {
        Colors ab = new Colors();
        for (NamedColor m_col : ab.m_cols) {
            this.m_colorTable.put(m_col.m_name, m_col.m_col);
        }
    }

    public Node create(Reader t) {
        this.m_nodes = new Vector(50, 50);
        this.m_edges = new Vector(50, 50);
        this.m_grObj = new InfoObject("graph");
        this.m_noObj = new InfoObject("node");
        this.m_edObj = new InfoObject("edge");
        this.m_st = new StreamTokenizer(new BufferedReader(t));
        this.setSyntax();
        this.graph();
        Node top = this.generateStructures();
        return top;
    }

    private Node generateStructures() {
        int noa;
        Color color;
        Color fontcolor;
        Integer style;
        Integer shape;
        String label;
        String id;
        InfoObject t;
        int noa2;
        this.m_aNodes = new Vector(50, 50);
        this.m_aEdges = new Vector(50, 50);
        for (noa2 = 0; noa2 < this.m_nodes.size(); ++noa2) {
            t = this.m_nodes.elementAt(noa2);
            id = t.m_id;
            label = t.m_label == null ? (this.m_noObj.m_label == null ? "" : this.m_noObj.m_label) : t.m_label;
            shape = t.m_shape == null ? (this.m_noObj.m_shape == null ? new Integer(2) : this.getShape(this.m_noObj.m_shape)) : this.getShape(t.m_shape);
            if (shape == null) {
                shape = new Integer(2);
            }
            style = t.m_style == null ? (this.m_noObj.m_style == null ? new Integer(1) : this.getStyle(this.m_noObj.m_style)) : this.getStyle(t.m_style);
            if (style == null) {
                style = new Integer(1);
            }
            fontcolor = t.m_fontColor == null ? (this.m_noObj.m_fontColor == null ? Color.black : this.m_colorTable.get(this.m_noObj.m_fontColor.toLowerCase())) : this.m_colorTable.get(t.m_fontColor.toLowerCase());
            if (fontcolor == null) {
                fontcolor = Color.black;
            }
            color = t.m_color == null ? (this.m_noObj.m_color == null ? Color.gray : this.m_colorTable.get(this.m_noObj.m_color.toLowerCase())) : this.m_colorTable.get(t.m_color.toLowerCase());
            if (color == null) {
                color = Color.gray;
            }
            this.m_aNodes.addElement(new Node(label, id, style, shape, color, t.m_data));
        }
        for (noa2 = 0; noa2 < this.m_edges.size(); ++noa2) {
            t = this.m_edges.elementAt(noa2);
            id = t.m_id;
            label = t.m_label == null ? (this.m_noObj.m_label == null ? "" : this.m_noObj.m_label) : t.m_label;
            shape = t.m_shape == null ? (this.m_noObj.m_shape == null ? new Integer(2) : this.getShape(this.m_noObj.m_shape)) : this.getShape(t.m_shape);
            if (shape == null) {
                shape = new Integer(2);
            }
            style = t.m_style == null ? (this.m_noObj.m_style == null ? new Integer(1) : this.getStyle(this.m_noObj.m_style)) : this.getStyle(t.m_style);
            if (style == null) {
                style = new Integer(1);
            }
            fontcolor = t.m_fontColor == null ? (this.m_noObj.m_fontColor == null ? Color.black : this.m_colorTable.get(this.m_noObj.m_fontColor.toLowerCase())) : this.m_colorTable.get(t.m_fontColor.toLowerCase());
            if (fontcolor == null) {
                fontcolor = Color.black;
            }
            color = t.m_color == null ? (this.m_noObj.m_color == null ? Color.white : this.m_colorTable.get(this.m_noObj.m_color.toLowerCase())) : this.m_colorTable.get(t.m_color.toLowerCase());
            if (color == null) {
                color = Color.white;
            }
            this.m_aEdges.addElement(new Edge(label, t.m_source, t.m_target));
        }
        Node sour = null;
        Node targ = null;
        for (noa = 0; noa < this.m_aEdges.size(); ++noa) {
            boolean f_set = false;
            boolean s_set = false;
            Edge y = this.m_aEdges.elementAt(noa);
            for (int nob = 0; nob < this.m_aNodes.size(); ++nob) {
                Node x = this.m_aNodes.elementAt(nob);
                if (x.getRefer().equals(y.getRtarget())) {
                    f_set = true;
                    targ = x;
                }
                if (x.getRefer().equals(y.getRsource())) {
                    s_set = true;
                    sour = x;
                }
                if (f_set && s_set) break;
            }
            if (targ != sour) {
                y.setTarget(targ);
                y.setSource(sour);
                continue;
            }
            System.out.println("logic error");
        }
        for (noa = 0; noa < this.m_aNodes.size(); ++noa) {
            if (this.m_aNodes.elementAt(noa).getParent(0) != null) continue;
            sour = this.m_aNodes.elementAt(noa);
        }
        return sour;
    }

    private Integer getShape(String sh) {
        if (sh.equalsIgnoreCase("box") || sh.equalsIgnoreCase("rectangle")) {
            return new Integer(1);
        }
        if (sh.equalsIgnoreCase("oval")) {
            return new Integer(2);
        }
        if (sh.equalsIgnoreCase("diamond")) {
            return new Integer(3);
        }
        return null;
    }

    private Integer getStyle(String sty) {
        if (sty.equalsIgnoreCase("filled")) {
            return new Integer(1);
        }
        return null;
    }

    private void setSyntax() {
        this.m_st.resetSyntax();
        this.m_st.eolIsSignificant(false);
        this.m_st.slashStarComments(true);
        this.m_st.slashSlashComments(true);
        this.m_st.whitespaceChars(0, 32);
        this.m_st.wordChars(33, 255);
        this.m_st.ordinaryChar(91);
        this.m_st.ordinaryChar(93);
        this.m_st.ordinaryChar(123);
        this.m_st.ordinaryChar(125);
        this.m_st.ordinaryChar(45);
        this.m_st.ordinaryChar(62);
        this.m_st.ordinaryChar(47);
        this.m_st.ordinaryChar(42);
        this.m_st.quoteChar(34);
        this.m_st.whitespaceChars(59, 59);
        this.m_st.ordinaryChar(61);
    }

    private void alterSyntax() {
        this.m_st.resetSyntax();
        this.m_st.wordChars(0, 255);
        this.m_st.slashStarComments(false);
        this.m_st.slashSlashComments(false);
        this.m_st.ordinaryChar(10);
        this.m_st.ordinaryChar(13);
    }

    private void nextToken(String r) {
        int t = 0;
        try {
            t = this.m_st.nextToken();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (t == -1) {
            System.out.println("eof , " + r);
        } else if (t == -2) {
            System.out.println("got a number , " + r);
        }
    }

    private void graph() {
        this.nextToken("expected 'digraph'");
        if (!this.m_st.sval.equalsIgnoreCase("digraph")) {
            System.out.println("expected 'digraph'");
        }
        this.nextToken("expected a Graph Name");
        if (this.m_st.sval == null) {
            System.out.println("expected a Graph Name");
        }
        this.nextToken("expected '{'");
        if (this.m_st.ttype == 123) {
            this.stmtList();
        } else {
            System.out.println("expected '{'");
        }
    }

    private void stmtList() {
        boolean flag = true;
        while (flag) {
            this.nextToken("expects a STMT_LIST item or '}'");
            if (this.m_st.ttype == 125) {
                flag = false;
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("graph") || this.m_st.sval.equalsIgnoreCase("node") || this.m_st.sval.equalsIgnoreCase("edge")) {
                this.m_st.pushBack();
                this.attrStmt();
                continue;
            }
            this.nodeId(this.m_st.sval, 0);
        }
    }

    private void attrStmt() {
        this.nextToken("expected 'graph' or 'node' or 'edge'");
        if (this.m_st.sval.equalsIgnoreCase("graph")) {
            this.nextToken("expected a '['");
            if (this.m_st.ttype == 91) {
                this.attrList(this.m_grObj);
            } else {
                System.out.println("expected a '['");
            }
        } else if (this.m_st.sval.equalsIgnoreCase("node")) {
            this.nextToken("expected a '['");
            if (this.m_st.ttype == 91) {
                this.attrList(this.m_noObj);
            } else {
                System.out.println("expected a '['");
            }
        } else if (this.m_st.sval.equalsIgnoreCase("edge")) {
            this.nextToken("expected a '['");
            if (this.m_st.ttype == 91) {
                this.attrList(this.m_edObj);
            } else {
                System.out.println("expected a '['");
            }
        } else {
            System.out.println("expected 'graph' or 'node' or 'edge'");
        }
    }

    private void nodeId(String s, int t) {
        this.nextToken("error occurred in node_id");
        if (this.m_st.ttype == 125) {
            if (t == 0) {
                this.m_nodes.addElement(new InfoObject(s));
            }
            this.m_st.pushBack();
        } else if (this.m_st.ttype == 45) {
            this.nextToken("error occurred checking for an edge");
            if (this.m_st.ttype == 62) {
                this.edgeStmt(s);
            } else {
                System.out.println("error occurred checking for an edge");
            }
        } else if (this.m_st.ttype == 91) {
            if (t == 0) {
                this.m_nodes.addElement(new InfoObject(s));
                this.attrList(this.m_nodes.lastElement());
            } else {
                this.attrList(this.m_edges.lastElement());
            }
        } else if (this.m_st.sval != null) {
            if (t == 0) {
                this.m_nodes.addElement(new InfoObject(s));
            }
            this.m_st.pushBack();
        } else {
            System.out.println("error occurred in node_id");
        }
    }

    private void edgeStmt(String i2) {
        this.nextToken("error getting target of edge");
        if (this.m_st.sval != null) {
            this.m_edges.addElement(new InfoObject("an edge ,no id"));
            this.m_edges.lastElement().m_source = i2;
            this.m_edges.lastElement().m_target = this.m_st.sval;
            this.nodeId(this.m_st.sval, 1);
        } else {
            System.out.println("error getting target of edge");
        }
    }

    private void attrList(InfoObject a) {
        boolean flag = true;
        while (flag) {
            this.nextToken("error in attr_list");
            if (this.m_st.ttype == 93) {
                flag = false;
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("color")) {
                this.nextToken("error getting color");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting color");
                    if (this.m_st.sval != null) {
                        a.m_color = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting color");
                    continue;
                }
                System.out.println("error getting color");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("fontcolor")) {
                this.nextToken("error getting font color");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting font color");
                    if (this.m_st.sval != null) {
                        a.m_fontColor = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting font color");
                    continue;
                }
                System.out.println("error getting font color");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("fontsize")) {
                this.nextToken("error getting font size");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting font size");
                    if (this.m_st.sval != null) continue;
                    System.out.println("error getting font size");
                    continue;
                }
                System.out.println("error getting font size");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("label")) {
                this.nextToken("error getting label");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting label");
                    if (this.m_st.sval != null) {
                        a.m_label = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting label");
                    continue;
                }
                System.out.println("error getting label");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("shape")) {
                this.nextToken("error getting shape");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting shape");
                    if (this.m_st.sval != null) {
                        a.m_shape = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting shape");
                    continue;
                }
                System.out.println("error getting shape");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("style")) {
                this.nextToken("error getting style");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting style");
                    if (this.m_st.sval != null) {
                        a.m_style = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting style");
                    continue;
                }
                System.out.println("error getting style");
                continue;
            }
            if (!this.m_st.sval.equalsIgnoreCase("data")) continue;
            this.nextToken("error getting data");
            if (this.m_st.ttype == 61) {
                this.alterSyntax();
                a.m_data = new String("");
                while (true) {
                    this.nextToken("error getting data");
                    if (this.m_st.sval != null && a.m_data != null && this.m_st.sval.equals(",")) break;
                    if (this.m_st.sval != null) {
                        a.m_data = a.m_data.concat(this.m_st.sval);
                        continue;
                    }
                    if (this.m_st.ttype == 13) {
                        a.m_data = a.m_data.concat("\r");
                        continue;
                    }
                    if (this.m_st.ttype == 10) {
                        a.m_data = a.m_data.concat("\n");
                        continue;
                    }
                    System.out.println("error getting data");
                }
                this.setSyntax();
                continue;
            }
            System.out.println("error getting data");
        }
    }

    private class InfoObject {
        public String m_id;
        public String m_color;
        public String m_fontColor;
        public String m_label;
        public String m_shape;
        public String m_style;
        public String m_source;
        public String m_target;
        public String m_data;

        public InfoObject(String i2) {
            this.m_id = i2;
            this.m_color = null;
            this.m_fontColor = null;
            this.m_label = null;
            this.m_shape = null;
            this.m_style = null;
            this.m_source = null;
            this.m_target = null;
            this.m_data = null;
        }
    }
}

