/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.OptionMetadata;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.ASSearchStrategy;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="ASEvaluator", category="AttSelection", toolTipText="Weka attribute selection evaluator wrapper", iconPath="", resourceIntensive=true)
public class ASEvaluator
extends WekaAlgorithmWrapper {
    private static final long serialVersionUID = -1280208826860871742L;
    protected ASEvaluation m_evaluatorTemplate;
    protected ASSearch m_searchTemplate;
    protected Map<Integer, Instances> m_waitingTestData = new HashMap<Integer, Instances>();
    protected Map<Integer, int[]> m_selectedAttsStore = new HashMap<Integer, int[]>();
    protected Map<Integer, Integer> m_numToSelectStore = new HashMap<Integer, Integer>();
    protected Map<Integer, AttributeTransformer> m_transformerStore = new HashMap<Integer, AttributeTransformer>();
    protected boolean m_isReset;
    protected boolean m_isDoingXVal;
    protected AtomicInteger m_setCount;
    protected boolean m_treatXValFoldsSeparately;
    protected boolean m_isRanking;
    protected AttributeSelection m_eval;

    @Override
    public Class getWrappedAlgorithmClass() {
        return ASEvaluation.class;
    }

    @Override
    public void setWrappedAlgorithm(Object algo) {
        super.setWrappedAlgorithm(algo);
        this.m_defaultIconPath = "weka/gui/knowledgeflow/icons/filters.supervised.attribute.AttributeSelection.gif";
    }

    public ASEvaluation getEvaluator() {
        return (ASEvaluation)this.getWrappedAlgorithm();
    }

    @ProgrammaticProperty
    public void setEvaluator(ASEvaluation eval) {
        this.setWrappedAlgorithm(eval);
    }

    @OptionMetadata(displayName="Treat x-val folds separately", description="Output separate attribute selection results for each fold of a cross-validation (rather than averaging across folds)")
    public void setTreatXValFoldsSeparately(boolean treatSeparately) {
        this.m_treatXValFoldsSeparately = treatSeparately;
    }

    public boolean getTreatXValFoldsSeparately() {
        return this.m_treatXValFoldsSeparately;
    }

    @Override
    public void stepInit() throws WekaException {
        if (!(this.getWrappedAlgorithm() instanceof ASEvaluation)) {
            throw new WekaException("Incorrect type of algorithm");
        }
        try {
            this.m_evaluatorTemplate = ASEvaluation.makeCopies((ASEvaluation)this.getWrappedAlgorithm(), 1)[0];
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        List<StepManager> infos = this.getStepManager().getIncomingConnectedStepsOfConnectionType("info");
        if (infos.size() == 0) {
            throw new WekaException("A search strategy needs to be supplied via an 'info' connection type");
        }
        ASSearchStrategy searchStrategy = (ASSearchStrategy)infos.get(0).getInfoStep(ASSearchStrategy.class);
        this.m_searchTemplate = searchStrategy.getSearchStrategy();
        if (this.m_searchTemplate instanceof RankedOutputSearch) {
            this.m_isRanking = ((RankedOutputSearch)((Object)this.m_searchTemplate)).getGenerateRanking();
        }
        if (this.m_evaluatorTemplate instanceof SubsetEvaluator && this.m_searchTemplate instanceof Ranker) {
            throw new WekaException("The Ranker search strategy cannot be used with a subset evaluator");
        }
        if (this.m_evaluatorTemplate instanceof AttributeEvaluator && !(this.m_searchTemplate instanceof Ranker)) {
            throw new WekaException("The Ranker search strategy must be used in conjunction with an attribute evaluator");
        }
        this.m_isReset = true;
        this.m_waitingTestData.clear();
        this.m_selectedAttsStore.clear();
        this.m_numToSelectStore.clear();
        this.m_transformerStore.clear();
        this.m_eval = new AttributeSelection();
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        Instances train = (Instances)data.getPayloadElement("trainingSet");
        Instances test = (Instances)data.getPayloadElement("testSet");
        Integer setNum = (Integer)data.getPayloadElement("aux_set_num");
        Integer maxSetNum = (Integer)data.getPayloadElement("aux_max_set_num");
        if (this.m_isReset) {
            this.m_isReset = false;
            this.getStepManager().processing();
            this.m_setCount = new AtomicInteger(maxSetNum != null ? maxSetNum : 1);
            if (setNum != null && maxSetNum != null) {
                boolean bl = this.m_isDoingXVal = maxSetNum > 1 && !this.m_treatXValFoldsSeparately;
                if (this.m_evaluatorTemplate instanceof AttributeTransformer && this.m_isDoingXVal && !this.m_treatXValFoldsSeparately) {
                    throw new WekaException("Can't cross-validate an attribute transformer");
                }
                if (this.m_isDoingXVal) {
                    this.m_eval.setFolds(maxSetNum);
                }
                if (this.m_isRanking) {
                    this.m_eval.setRanking(this.m_isRanking);
                }
            }
        }
        if (this.m_isDoingXVal) {
            this.processXVal(train, test, setNum, maxSetNum);
        } else {
            this.processNonXVal(train, test, setNum, maxSetNum);
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
        } else if (this.m_setCount.get() == 0) {
            if (this.m_isDoingXVal) {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Search method: ");
                    String evalS = this.m_evaluatorTemplate.getClass().getCanonicalName();
                    evalS = evalS.substring(evalS.lastIndexOf(46) + 1, evalS.length());
                    builder.append(evalS).append(" ").append(this.m_evaluatorTemplate instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_evaluatorTemplate)).getOptions()) : "").append("\nEvaluator: ");
                    String searchS = this.m_searchTemplate.getClass().getCanonicalName();
                    searchS = searchS.substring(searchS.lastIndexOf(46) + 1, searchS.length());
                    builder.append(searchS).append(" ").append(this.m_searchTemplate instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_searchTemplate)).getOptions()) : "").append("\n");
                    builder.append(this.m_eval.CVResultsString());
                    this.outputTextData(builder.toString(), null);
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
            this.getStepManager().finished();
            this.m_waitingTestData.clear();
            this.m_selectedAttsStore.clear();
            this.m_numToSelectStore.clear();
        }
    }

    protected void outputTextData(String text, Integer setNum) throws WekaException {
        if (this.isStopRequested()) {
            return;
        }
        if (this.getStepManager().numOutgoingConnectionsOfType("text") == 0) {
            return;
        }
        Data textData = new Data("text", text);
        String titleString = this.m_evaluatorTemplate.getClass().getCanonicalName();
        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
        String searchString = this.m_searchTemplate.getClass().getCanonicalName();
        searchString = searchString.substring(searchString.lastIndexOf(46) + 1, searchString.length());
        titleString = titleString + " (" + searchString + ")";
        textData.setPayloadElement("aux_textTitle", titleString);
        if (setNum != null) {
            textData.setPayloadElement("aux_set_num", setNum);
        }
        this.getStepManager().outputData(textData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processNonXVal(Instances train, Instances test, Integer setNum, Integer maxSetNum) throws WekaException {
        if (train != null) {
            try {
                AttributeSelection eval = new AttributeSelection();
                ASEvaluation evalCopy = ASEvaluation.makeCopies(this.m_evaluatorTemplate, 1)[0];
                ASSearch searchCopy = ASSearch.makeCopies(this.m_searchTemplate, 1)[0];
                eval.setEvaluator(evalCopy);
                eval.setSearch(searchCopy);
                eval.setRanking(this.m_isRanking);
                if (this.isStopRequested()) return;
                String message = "Selecting attributes (" + train.relationName();
                if (setNum != null && maxSetNum != null) {
                    message = message + ", set " + setNum + " of " + maxSetNum;
                }
                message = message + ")";
                this.getStepManager().statusMessage(message);
                this.getStepManager().logBasic(message);
                eval.SelectAttributes(train);
                if (evalCopy instanceof AttributeTransformer) {
                    this.m_transformerStore.put(setNum != null ? setNum : -1, (AttributeTransformer)((Object)evalCopy));
                }
                int[] selectedAtts = eval.selectedAttributes();
                if (this.m_isRanking) {
                    this.m_numToSelectStore.put(setNum != null ? setNum : -1, ((RankedOutputSearch)((Object)searchCopy)).getCalculatedNumToSelect());
                }
                if (this.getStepManager().numIncomingConnections() > 2) {
                    this.m_selectedAttsStore.put(setNum != null ? setNum : -1, selectedAtts);
                }
                String results = eval.toResultsString();
                this.outputTextData(results, setNum);
                this.applyFiltering("trainingSet", selectedAtts, train, setNum, maxSetNum);
                if (this.getStepManager().numIncomingConnections() > 2) {
                    Instances waitingTest = this.m_waitingTestData.get(setNum != null ? setNum : -1);
                    if (waitingTest != null) {
                        this.checkTestFiltering(waitingTest, setNum != null ? setNum : -1, maxSetNum);
                    }
                } else {
                    this.m_setCount.decrementAndGet();
                }
                evalCopy.clean();
                return;
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        } else {
            this.checkTestFiltering(test, setNum != null ? setNum : -1, maxSetNum);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processXVal(Instances train, Instances test, Integer setNum, Integer maxSetNum) throws WekaException {
        if (train != null) {
            try {
                ASEvaluation evalCopy = ASEvaluation.makeCopies(this.m_evaluatorTemplate, 1)[0];
                ASSearch searchCopy = ASSearch.makeCopies(this.m_searchTemplate, 1)[0];
                if (this.isStopRequested()) return;
                String message = "Selecting attributes x-val mode (" + train.relationName();
                if (setNum != null && maxSetNum != null) {
                    message = message + ", set " + setNum + " of " + maxSetNum;
                }
                message = message + ")";
                this.getStepManager().statusMessage(message);
                this.getStepManager().logBasic(message);
                evalCopy.buildEvaluator(train);
                if (evalCopy instanceof AttributeTransformer) {
                    this.m_transformerStore.put(setNum != null ? setNum : -1, (AttributeTransformer)((Object)evalCopy));
                }
                int[] selectedAtts = searchCopy.search(evalCopy, train);
                selectedAtts = evalCopy.postProcess(selectedAtts);
                if (this.m_isRanking) {
                    double[][] ranked = ((RankedOutputSearch)((Object)searchCopy)).rankedAttributes();
                    selectedAtts = new int[ranked.length];
                    for (int i2 = 0; i2 < ranked.length; ++i2) {
                        selectedAtts[i2] = (int)ranked[i2][0];
                    }
                }
                this.updateXValStats(train, evalCopy, searchCopy, selectedAtts);
                if (this.getStepManager().numIncomingConnections() > 2) {
                    this.m_selectedAttsStore.put(setNum, selectedAtts);
                }
                if (this.m_isRanking) {
                    this.m_numToSelectStore.put(setNum, ((RankedOutputSearch)((Object)searchCopy)).getCalculatedNumToSelect());
                }
                this.applyFiltering("trainingSet", selectedAtts, train, setNum, maxSetNum);
                if (this.getStepManager().numIncomingConnections() > 2) {
                    Instances waitingTest = this.m_waitingTestData.get(setNum);
                    if (waitingTest != null) {
                        this.checkTestFiltering(waitingTest, setNum, maxSetNum);
                    }
                } else {
                    this.m_setCount.decrementAndGet();
                }
                evalCopy.clean();
                return;
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        } else {
            this.checkTestFiltering(test, setNum, maxSetNum);
        }
    }

    protected synchronized void checkTestFiltering(Instances test, Integer setNum, Integer maxSetNum) throws WekaException {
        if (this.isStopRequested()) {
            return;
        }
        int[] selectedForSet = this.m_selectedAttsStore.get(setNum);
        if (selectedForSet == null) {
            this.m_waitingTestData.put(setNum, test);
        } else {
            this.applyFiltering("testSet", selectedForSet, test, setNum, maxSetNum);
            this.m_setCount.decrementAndGet();
        }
    }

    protected void applyFiltering(String connType, int[] selectedAtts, Instances data, Integer setNum, Integer maxSetNum) throws WekaException {
        boolean adjust;
        if (this.isStopRequested()) {
            return;
        }
        if (this.getStepManager().numOutgoingConnectionsOfType(connType) == 0) {
            return;
        }
        int[] finalSet = new int[selectedAtts.length];
        boolean bl = adjust = (this.m_isDoingXVal || this.m_isRanking) && (!(this.m_evaluatorTemplate instanceof UnsupervisedSubsetEvaluator) && !(this.m_evaluatorTemplate instanceof UnsupervisedAttributeEvaluator) || this.m_evaluatorTemplate instanceof AttributeTransformer);
        if (this.m_isRanking) {
            int numToSelect = this.m_numToSelectStore.get(setNum != null ? setNum : -1);
            finalSet = new int[numToSelect];
            if (data.classIndex() >= 0) {
                if (adjust) {
                    finalSet = new int[numToSelect + 1];
                    finalSet[numToSelect] = data.classIndex();
                } else {
                    finalSet = new int[numToSelect];
                }
            }
            for (int i2 = 0; i2 < numToSelect; ++i2) {
                finalSet[i2] = selectedAtts[i2];
            }
        } else {
            if (adjust) {
                finalSet = new int[selectedAtts.length + 1];
                finalSet[selectedAtts.length] = data.classIndex();
            }
            for (int i3 = 0; i3 < selectedAtts.length; ++i3) {
                finalSet[i3] = selectedAtts[i3];
            }
        }
        try {
            Instances reduced = null;
            AttributeTransformer transformer = this.m_transformerStore.get(setNum != null ? setNum : -1);
            if (transformer != null) {
                reduced = new Instances(transformer.transformedHeader(), data.numInstances());
                for (int i4 = 0; i4 < data.numInstances(); ++i4) {
                    reduced.add(transformer.convertInstance(data.instance(i4)));
                }
            } else {
                Remove r = new Remove();
                r.setAttributeIndicesArray(finalSet);
                r.setInvertSelection(true);
                r.setInputFormat(data);
                reduced = Filter.useFilter(data, r);
            }
            if (!this.isStopRequested()) {
                String message = "Filtering " + connType + " (" + data.relationName();
                if (setNum != null && maxSetNum != null) {
                    message = message + ", set " + setNum + " of " + maxSetNum;
                }
                message = message + ")";
                this.getStepManager().statusMessage(message);
                this.getStepManager().logBasic(message);
                Data output = new Data(connType, reduced);
                output.setPayloadElement("aux_set_num", setNum);
                output.setPayloadElement("aux_max_set_num", maxSetNum);
                this.getStepManager().outputData(output);
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected synchronized void updateXValStats(Instances train, ASEvaluation evaluator, ASSearch search, int[] selectedAtts) throws Exception {
        this.m_eval.updateStatsForModelCVSplit(train, evaluator, search, selectedAtts, this.m_isRanking);
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") == 0) {
            result.add("trainingSet");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("testSet") == 0 && this.getStepManager().numIncomingConnectionsOfType("trainingSet") == 1) {
            result.add("testSet");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("info") == 0) {
            result.add("info");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() > 1 && this.getStepManager().numIncomingConnectionsOfType("info") == 1) {
            result.add("text");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") == 1 && this.getStepManager().numIncomingConnectionsOfType("info") == 1) {
            result.add("trainingSet");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("testSet") == 1 && this.getStepManager().numIncomingConnectionsOfType("info") == 1) {
            result.add("testSet");
        }
        return result;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.ASEvaluatorStepEditorDialog";
    }
}

