/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.converters.SerializedInstancesLoader;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;

@KFStep(name="Appender", category="Flow", toolTipText="Append multiple sets of instances", iconPath="weka/gui/knowledgeflow/icons/Appender.png")
public class Appender
extends BaseStep {
    private static final long serialVersionUID = -3003135257112845998L;
    protected Map<Step, Instances> m_completed;
    protected Map<Step, File> m_tempBatchFiles;
    protected Instances m_completeHeader;
    protected AtomicInteger m_streamingCountDown;
    protected transient Map<Step, ObjectOutputStream> m_incrementalSavers;
    protected transient Map<Step, File> m_incrementalFiles;
    protected Data m_streamingData;
    protected boolean m_isReset;

    @Override
    public void stepInit() throws WekaException {
        this.m_isReset = true;
        this.m_completed = new HashMap<Step, Instances>();
        this.m_tempBatchFiles = new HashMap<Step, File>();
        this.m_completeHeader = null;
        this.m_incrementalSavers = new HashMap<Step, ObjectOutputStream>();
        this.m_incrementalFiles = new HashMap<Step, File>();
        this.m_streamingCountDown = new AtomicInteger(this.getStepManager().numIncomingConnectionsOfType("instance"));
        this.m_streamingData = new Data("instance");
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() == 0 || this.getStepManager().numIncomingConnectionsOfType("instance") == 0) {
            result.addAll(Arrays.asList("dataSet", "trainingSet", "testSet"));
        }
        if (this.getStepManager().numIncomingConnections() == 0 || this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
            result.add("instance");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
            result.add("instance");
        } else {
            result.addAll(Arrays.asList("dataSet", "trainingSet", "testSet"));
        }
        return result;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_isReset && !data.getConnectionName().equals("instance")) {
            this.getStepManager().processing();
            this.m_isReset = false;
        }
        if (data.getConnectionName().equals("instance")) {
            this.processStreaming(data);
            if (this.m_streamingCountDown.get() == 0) {
                this.m_streamingData.clearPayload();
                this.getStepManager().throughputFinished(this.m_streamingData);
            }
        } else {
            this.processBatch(data);
            if (this.m_completed.size() == this.getStepManager().numIncomingConnections()) {
                this.getStepManager().finished();
                this.m_completed.clear();
                this.m_tempBatchFiles.clear();
            }
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
            this.m_completed.clear();
            this.m_tempBatchFiles.clear();
            this.m_incrementalSavers.clear();
            this.m_incrementalFiles.clear();
        }
    }

    protected synchronized void processBatch(Data data) throws WekaException {
        Integer setNum = data.getPayloadElement("aux_set_num", 1);
        Integer maxSetNum = data.getPayloadElement("aux_max_set_num", 1);
        Instances insts = (Instances)data.getPrimaryPayload();
        if (setNum > 1 || maxSetNum > 1) {
            throw new WekaException("Source " + data.getSourceStep().getName() + " is generating more than one " + data.getConnectionName() + " in a batch");
        }
        Instances header = new Instances(insts, 0);
        this.m_completed.put(data.getSourceStep(), header);
        try {
            File tmpF = File.createTempFile("weka", SerializedInstancesLoader.FILE_EXTENSION);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tmpF)));
            oos.writeObject(insts);
            oos.flush();
            oos.close();
            this.m_tempBatchFiles.put(data.getSourceStep(), tmpF);
        }
        catch (IOException e1) {
            throw new WekaException(e1);
        }
        if (this.isStopRequested()) {
            return;
        }
        if (this.m_completed.size() == this.getStepManager().numIncomingConnections()) {
            Instances output = this.makeOutputHeader();
            this.getStepManager().logDetailed("Making output header structure");
            try {
                for (File f : this.m_tempBatchFiles.values()) {
                    ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
                    Instances temp = (Instances)ois.readObject();
                    ois.close();
                    for (int i2 = 0; i2 < temp.numInstances(); ++i2) {
                        Instance converted = this.makeOutputInstance(output, temp.instance(i2));
                        output.add(converted);
                    }
                }
                Data outputD = new Data(data.getConnectionName(), output);
                outputD.setPayloadElement("aux_set_num", 1);
                outputD.setPayloadElement("aux_max_set_num", 1);
                this.getStepManager().outputData(outputD);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        }
    }

    protected synchronized void processStreaming(Data data) throws WekaException {
        if (this.isStopRequested()) {
            return;
        }
        Step source = data.getSourceStep();
        Instance inst = (Instance)data.getPrimaryPayload();
        if (!this.m_completed.containsKey(source)) {
            this.m_completed.put(source, inst.dataset());
        }
        if (this.m_completed.size() == this.getStepManager().numIncomingConnections() && this.m_completeHeader == null) {
            this.getStepManager().logDetailed("Creating output header structure");
            this.m_completeHeader = this.makeOutputHeader();
            if (this.m_incrementalSavers.size() > 0) {
                block8: for (Map.Entry<Step, ObjectOutputStream> e : this.m_incrementalSavers.entrySet()) {
                    ObjectOutputStream s = e.getValue();
                    try {
                        s.flush();
                        s.close();
                        File tmpFile = this.m_incrementalFiles.get(e.getKey());
                        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tmpFile)));
                        Instance tmpLoaded = null;
                        do {
                            try {
                                tmpLoaded = (Instance)ois.readObject();
                                Instance converted = this.makeOutputInstance(this.m_completeHeader, tmpLoaded);
                                this.m_streamingData.setPayloadElement("instance", converted);
                                this.getStepManager().outputData(this.m_streamingData);
                            }
                            catch (Exception ex) {
                                ois.close();
                                continue block8;
                            }
                        } while (tmpLoaded != null);
                    }
                    catch (Exception ex) {
                        throw new WekaException(ex);
                    }
                }
                this.m_incrementalSavers.clear();
                this.m_incrementalFiles.clear();
            }
        }
        if (this.isStopRequested()) {
            return;
        }
        if (this.getStepManager().isStreamFinished(data)) {
            this.m_streamingCountDown.decrementAndGet();
            return;
        }
        if (this.m_completeHeader == null) {
            ObjectOutputStream saver = this.m_incrementalSavers.get(data.getSourceStep());
            if (saver == null) {
                try {
                    File tmpFile = File.createTempFile("weka", ".arff");
                    saver = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
                    this.m_incrementalSavers.put(data.getSourceStep(), saver);
                    this.m_incrementalFiles.put(data.getSourceStep(), tmpFile);
                }
                catch (IOException ex) {
                    throw new WekaException(ex);
                }
            }
            try {
                saver.writeObject(inst);
            }
            catch (IOException e1) {
                throw new WekaException(e1);
            }
        }
        Instance newI = this.makeOutputInstance(this.m_completeHeader, inst);
        this.m_streamingData.setPayloadElement("instance", newI);
        this.getStepManager().outputData(this.m_streamingData);
    }

    private Instance makeOutputInstance(Instances output, Instance source) {
        int i2;
        double[] newVals = new double[output.numAttributes()];
        for (i2 = 0; i2 < newVals.length; ++i2) {
            newVals[i2] = Utils.missingValue();
        }
        for (i2 = 0; i2 < source.numAttributes(); ++i2) {
            if (source.isMissing(i2)) continue;
            Attribute s = source.attribute(i2);
            int outputIndex = output.attribute(s.name()).index();
            if (s.isNumeric()) {
                newVals[outputIndex] = source.value(s);
                continue;
            }
            if (s.isString()) {
                String sVal = source.stringValue(s);
                newVals[outputIndex] = output.attribute(outputIndex).addStringValue(sVal);
                continue;
            }
            if (s.isRelationValued()) {
                Instances rVal = source.relationalValue(s);
                newVals[outputIndex] = output.attribute(outputIndex).addRelation(rVal);
                continue;
            }
            if (!s.isNominal()) continue;
            String nomVal = source.stringValue(s);
            newVals[outputIndex] = output.attribute(outputIndex).indexOfValue(nomVal);
        }
        DenseInstance newInst = new DenseInstance(source.weight(), newVals);
        newInst.setDataset(output);
        return newInst;
    }

    protected Instances makeOutputHeader() throws WekaException {
        return this.makeOutputHeader(this.m_completed.values());
    }

    protected Instances makeOutputHeader(Collection<Instances> headers) throws WekaException {
        HashMap<String, Attribute> attLookup = new HashMap<String, Attribute>();
        ArrayList<Attribute> attList = new ArrayList<Attribute>();
        HashMap nominalLookups = new HashMap();
        for (Instances h : headers) {
            for (int i2 = 0; i2 < h.numAttributes(); ++i2) {
                Attribute a = h.attribute(i2);
                if (!attLookup.containsKey(a.name())) {
                    attLookup.put(a.name(), a);
                    attList.add(a);
                    if (!a.isNominal()) continue;
                    TreeSet<String> nVals = new TreeSet<String>();
                    for (int j = 0; j < a.numValues(); ++j) {
                        nVals.add(a.value(j));
                    }
                    nominalLookups.put(a.name(), nVals);
                    continue;
                }
                Attribute storedVersion = (Attribute)attLookup.get(a.name());
                if (storedVersion.type() != a.type()) {
                    throw new WekaException("Conflicting types for attribute name '" + a.name() + "' between incoming instance sets");
                }
                if (!storedVersion.isNominal()) continue;
                Set storedVals = (Set)nominalLookups.get(a.name());
                for (int j = 0; j < a.numValues(); ++j) {
                    storedVals.add(a.value(j));
                }
            }
        }
        ArrayList<Attribute> finalAttList = new ArrayList<Attribute>();
        for (Attribute a : attList) {
            Attribute newAtt = null;
            if (a.isDate()) {
                newAtt = new Attribute(a.name(), a.getDateFormat());
            } else if (a.isNumeric()) {
                newAtt = new Attribute(a.name());
            } else if (a.isRelationValued()) {
                newAtt = new Attribute(a.name(), a.relation());
            } else if (a.isNominal()) {
                Set vals = (Set)nominalLookups.get(a.name());
                ArrayList<String> newVals = new ArrayList<String>();
                for (String v : vals) {
                    newVals.add(v);
                }
                newAtt = new Attribute(a.name(), newVals);
            } else if (a.isString()) {
                newAtt = new Attribute(a.name(), (List<String>)null);
            }
            finalAttList.add(newAtt);
        }
        return new Instances("Appended_" + this.getStepManager().numIncomingConnections() + "_sets", finalAttList, 0);
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().numIncomingConnections() > 0) {
            ArrayList<Instances> incomingHeaders = new ArrayList<Instances>();
            for (Map.Entry<String, List<StepManager>> e : this.getStepManager().getIncomingConnections().entrySet()) {
                if (e.getValue().size() <= 0) continue;
                String incomingConType = e.getKey();
                for (StepManager sm : e.getValue()) {
                    Instances incomingStruc = this.getStepManager().getIncomingStructureFromStep(sm, incomingConType);
                    if (incomingStruc == null) {
                        return null;
                    }
                    incomingHeaders.add(incomingStruc);
                }
            }
            if (incomingHeaders.size() > 0) {
                return this.makeOutputHeader(incomingHeaders);
            }
        }
        return null;
    }
}

