/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.StreamThroughput;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="DataGenerator", category="DataGenerators", toolTipText="Weka data generator wrapper", iconPath="")
public class DataGenerator
extends WekaAlgorithmWrapper {
    private static final long serialVersionUID = -7716707145987484527L;
    protected Data m_incrementalData;
    protected StreamThroughput m_flowThroughput;

    @Override
    public Class getWrappedAlgorithmClass() {
        return weka.datagenerators.DataGenerator.class;
    }

    @Override
    public void setWrappedAlgorithm(Object algo) {
        super.setWrappedAlgorithm(algo);
        this.m_defaultIconPath = "weka/gui/knowledgeflow/icons/DefaultDataSource.gif";
    }

    public weka.datagenerators.DataGenerator getDataGenerator() {
        return (weka.datagenerators.DataGenerator)this.getWrappedAlgorithm();
    }

    @ProgrammaticProperty
    public void setDataGenerator(weka.datagenerators.DataGenerator dataGenerator) {
        this.setWrappedAlgorithm(dataGenerator);
    }

    @Override
    public void stepInit() {
        if (this.getStepManager().numOutgoingConnectionsOfType("instance") > 0) {
            this.m_incrementalData = new Data("instance");
        } else {
            this.m_incrementalData = null;
            this.m_flowThroughput = null;
        }
    }

    @Override
    public void start() throws WekaException {
        if (this.getStepManager().numOutgoingConnections() > 0) {
            weka.datagenerators.DataGenerator generator = this.getDataGenerator();
            if (this.getStepManager().numOutgoingConnectionsOfType("dataSet") > 0) {
                this.getStepManager().processing();
                StringWriter output = new StringWriter();
                try {
                    generator.setOutput(new PrintWriter(output));
                    this.getStepManager().statusMessage("Generating...");
                    this.getStepManager().logBasic("Generating data");
                    weka.datagenerators.DataGenerator.makeData(generator, generator.getOptions());
                    Instances instances = new Instances(new StringReader(output.toString()));
                    if (!this.isStopRequested()) {
                        Data outputData = new Data("dataSet", instances);
                        this.getStepManager().outputData(outputData);
                    }
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
                if (this.isStopRequested()) {
                    this.getStepManager().interrupted();
                } else {
                    this.getStepManager().finished();
                }
            } else {
                try {
                    if (!generator.getSingleModeFlag()) {
                        throw new WekaException("Generator does not support incremental generation, so cannot be used with outgoing 'instance' connections");
                    }
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
                String stm = this.getName() + "$" + this.hashCode() + 99 + "| overall flow throughput -|";
                this.m_flowThroughput = new StreamThroughput(stm, "Starting flow...", ((StepManagerImpl)this.getStepManager()).getLog());
                try {
                    this.getStepManager().logBasic("Generating...");
                    generator.setDatasetFormat(generator.defineDataFormat());
                    for (int i2 = 0; i2 < generator.getNumExamplesAct(); ++i2) {
                        this.m_flowThroughput.updateStart();
                        this.getStepManager().throughputUpdateStart();
                        if (this.isStopRequested()) {
                            this.getStepManager().interrupted();
                            return;
                        }
                        Instance inst = generator.generateExample();
                        this.m_incrementalData.setPayloadElement("instance", inst);
                        this.getStepManager().throughputUpdateEnd();
                        this.getStepManager().outputData(this.m_incrementalData);
                        this.m_flowThroughput.updateEnd(((StepManagerImpl)this.getStepManager()).getLog());
                    }
                    if (this.isStopRequested()) {
                        ((StepManagerImpl)this.getStepManager()).getLog().statusMessage(stm + "remove");
                        this.getStepManager().interrupted();
                        return;
                    }
                    this.m_flowThroughput.finished(((StepManagerImpl)this.getStepManager()).getLog());
                    this.m_incrementalData.clearPayload();
                    this.getStepManager().throughputFinished(this.m_incrementalData);
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
        }
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().isStepBusy()) {
            return null;
        }
        weka.datagenerators.DataGenerator generator = this.getDataGenerator();
        try {
            return generator.defineDataFormat();
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numOutgoingConnections() == 0) {
            result.add("dataSet");
            try {
                if (this.getDataGenerator().getSingleModeFlag()) {
                    result.add("instance");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (this.getStepManager().numOutgoingConnectionsOfType("dataSet") > 0) {
            result.add("dataSet");
        } else {
            result.add("instance");
        }
        return result;
    }
}

