/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.StreamThroughput;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="DataGrid", category="DataSources", toolTipText="Specify a grid of data to turn into instances", iconPath="weka/gui/knowledgeflow/icons/ArffLoader.gif")
public class DataGrid
extends BaseStep {
    private static final long serialVersionUID = 1318159328875458847L;
    protected String m_data = "";
    protected Data m_incrementalData;
    protected StreamThroughput m_flowThroughput;

    @ProgrammaticProperty
    public void setData(String data) {
        this.m_data = data;
    }

    public String getData() {
        return this.m_data;
    }

    @Override
    public void stepInit() throws WekaException {
        if (this.getStepManager().numOutgoingConnectionsOfType("instance") > 0) {
            this.m_incrementalData = new Data("instance");
        } else {
            this.m_incrementalData = null;
            this.m_flowThroughput = null;
        }
    }

    @Override
    public void start() throws WekaException {
        if (this.getStepManager().numOutgoingConnections() > 0) {
            if (this.m_data.length() == 0) {
                this.getStepManager().logWarning("No data to output!");
            } else {
                try {
                    String data = this.environmentSubstitute(this.m_data);
                    Instances toOutput = new Instances(new StringReader(data));
                    if (this.getStepManager().numOutgoingConnectionsOfType("dataSet") > 0) {
                        this.getStepManager().processing();
                        Data batch = new Data("dataSet", toOutput);
                        this.getStepManager().outputData(batch);
                        this.getStepManager().finished();
                    }
                    String stm = this.getName() + "$" + this.hashCode() + 99 + "| overall flow throughput -|";
                    this.m_flowThroughput = new StreamThroughput(stm, "Starting flow...", ((StepManagerImpl)this.getStepManager()).getLog());
                    Instances structure = toOutput.stringFreeStructure();
                    Instances structureCopy = null;
                    Instances currentStructure = structure;
                    boolean containsStrings = toOutput.checkForStringAttributes();
                    if (containsStrings) {
                        structureCopy = (Instances)new SerializedObject(structure).getObject();
                    }
                    if (this.isStopRequested()) {
                        this.getStepManager().interrupted();
                        return;
                    }
                    for (int i2 = 0; i2 < toOutput.numInstances() && !this.isStopRequested(); ++i2) {
                        Instance nextInst = toOutput.instance(i2);
                        this.m_flowThroughput.updateStart();
                        this.getStepManager().throughputUpdateStart();
                        if (containsStrings) {
                            currentStructure = currentStructure == structure ? structureCopy : structure;
                            for (int j = 0; j < toOutput.numAttributes(); ++j) {
                                if (!toOutput.attribute(j).isString() || nextInst.isMissing(j)) continue;
                                currentStructure.attribute(j).setStringValue(nextInst.stringValue(j));
                                nextInst.setValue(j, 0.0);
                            }
                        }
                        nextInst.setDataset(currentStructure);
                        this.m_incrementalData.setPayloadElement("instance", nextInst);
                        this.getStepManager().throughputUpdateEnd();
                        this.getStepManager().outputData(this.m_incrementalData);
                        this.m_flowThroughput.updateEnd(((StepManagerImpl)this.getStepManager()).getLog());
                    }
                    if (this.isStopRequested()) {
                        ((StepManagerImpl)this.getStepManager()).getLog().statusMessage(stm + "remove");
                        this.getStepManager().interrupted();
                        return;
                    }
                    this.m_flowThroughput.finished(((StepManagerImpl)this.getStepManager()).getLog());
                    this.m_incrementalData.clearPayload();
                    this.getStepManager().throughputFinished(this.m_incrementalData);
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
        } else {
            this.getStepManager().logWarning("No connected outputs");
        }
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().isStepBusy()) {
            return null;
        }
        if (this.getStepManager().numOutgoingConnectionsOfType("dataSet") == 0 && this.getStepManager().numOutgoingConnectionsOfType("instance") == 0) {
            return null;
        }
        try {
            return new Instances(new StringReader(this.m_data)).stringFreeStructure();
        }
        catch (IOException e) {
            throw new WekaException(e);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numOutgoingConnections() == 0) {
            result.add("dataSet");
            result.add("instance");
        } else if (this.getStepManager().numOutgoingConnectionsOfType("dataSet") > 0) {
            result.add("dataSet");
        } else {
            result.add("instance");
        }
        return result;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.DataGridStepEditorDialog";
    }
}

